---
date: "2022-11-01T00:00:00+00:00"
title: "存储"
slug: "storage"
sidebar_position: 5
draft: false
toc: false
menu:
  sidebar:
    parent: "packages"
    name: "Storage"
    sidebar_position: 2
    identifier: "storage"
---

# 存储

本文档描述了软件包注册表的存储方式以及如何管理存储。

## 去重

软件包注册表具有内置的去重功能，可以对上传的 Blob 进行去重处理。
如果上传了两个相同的文件，只会在文件系统上保存一个 Blob。
这样可以确保不会浪费空间用于重复的文件。

如果上传了两个具有相同文件的软件包，这两个软件包将显示相同的大小，但在文件系统上，它们只需要一半的大小。
每当删除一个软件包时，只会删除对底层 Blob 的引用。
此时，Blob 不会被删除，因此它们仍然占用文件系统上的空间。
当上传新的软件包时，现有的 Blob 可能会再次被引用。

这些无引用的 Blob 会在一个清理任务中被删除。
配置设置 `OLDER_THAN` 可以配置无引用的 Blob 在被删除之前保留的时间。

## 清理规则

软件包注册表可能会随着时间的推移而变得很大，如果不进行清理的话。
建议删除不必要的软件包并设置清理规则以自动管理软件包注册表的使用情况。
每个软件包所有者（用户或组织）都可以管理应用于其软件包的清理规则。

| 设置                         | 描述                                                                                                                                     |
| ---------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------- |
| 启用                         | 打开或关闭清理规则。                                                                                                                     |
| 类型                         | 每个规则管理特定的软件包类型。                                                                                                           |
| 将模式应用于完整的软件包名称 | 如果启用，则应用以下模式到完整的软件包名称（`package/version`），否则只使用版本号（`version`）。                                         |
| 保留最近的版本数             | 对于每个软件包要始终保留的版本数量。                                                                                                     |
| 保留与以下模式匹配的版本     | 确定要保留哪些版本的正则表达式模式。空模式表示不保留任何版本，而 `.+` 表示保留所有版本。即使未配置，容器注册表也始终保留 `latest` 版本。 |
| 删除早于多少天的版本         | 仅删除早于所选天数的版本。                                                                                                               |
| 删除与以下模式匹配的版本     | 确定要删除哪些版本的正则表达式模式。空模式或 `.+` 表示如果没有其他设置指定，则删除所有软件包。                                           |

每个清理规则都可以显示受影响的软件包的预览。
这可以用来检查清理规则是否正确配置。

### 正则表达式示例

正则表达式模式会自动使用 `\A` 和 `\z` 锚点进行包围。
不要在正则表达式模式中包含任何 `\A`、`\z`、`^` 或 `$` 标记，因为它们不是必要的。
模式是不区分大小写的，与 Gitea 中的软件包注册表的行为相匹配。

| Pattern                      | Description                                                                                                   |
| ---------------------------- | ------------------------------------------------------------------------------------------------------------- |
| `.*`                         | 匹配任何可能的版本。                                                                                          |
| `v.+`                        | 匹配以 `v` 开头的版本。                                                                                       |
| `release`                    | 仅匹配版本号为 `release`。                                                                                    |
| `release.*`                  | 匹配以 `release` 命名或以 `release` 开头的版本。                                                              |
| `.+-temp-.+`                 | 匹配包含 `-temp-` 的版本。                                                                                    |
| `v.+\|release`               | 匹配以 `v` 开头的版本或版本号为 `release`。                                                                   |
| `package/v.+\|other/release` | 匹配以 `v` 开头的 package 的版本或 `other` 的版本号为 `release`。需要启用*将模式应用于完整的软件包名称*设置。 |

### 清理规则的工作原理

清理规则是清理任务的一部分，定期运行。

清理规则：

1. 收集所有属于所有者注册表的特定软件包类型的软件包。
2. 对于每个软件包，收集所有版本。
3. 根据 *保留最近的版本数* 的值，从列表中排除版本。
4. 根据 *保留与以下模式匹配的版本* 的值，从列表中排除任何版本。
5. 根据 *删除早于多少天的版本* 的值，从列表中排除比这个值更近的版本。
6. 根据 *删除与以下模式匹配的版本* 的值，从列表中排除任何不匹配的版本。
7. 删除剩余的版本。
