---
date: "2023-05-25T00:00:00+00:00"
title: "重构指南"
slug: "guidelines-refactoring"
sidebar_position: 20
toc: false
draft: false
aliases:
  - /zh-cn/guidelines-refactoring
menu:
  sidebar:
    parent: "contributing"
    name: "重构指南"
    sidebar_position: 20
    identifier: "guidelines-refactoring"
---

# 重构指南

## 背景

自2014年2月12日编写了第一行代码以来，Gitea已经发展成为一个庞大的项目。
因此，代码库变得越来越大。代码库越大，维护就越困难。
存在许多过时的机制，许多框架混合在一起，一些遗留代码可能会导致错误并阻碍新功能的开发。
为了使代码库更易于维护，使Gitea变得更好，开发人员应牢记使用现代机制来重构旧代码。

本文档是关于重构代码库的指南集合。

## 重构建议

* 设计更多关于未来的内容，而不仅仅解决当前问题。
* 减少模糊性，减少冲突，提高可维护性。
* 描述重构，例如：
  * 为什么需要重构。
  * 如何解决旧问题。
  * 重构的优点/缺点是什么。
* 只做必要的更改，尽量保留旧逻辑。
* 引入一些中间步骤，使重构更容易审查，完整的重构计划可以在几个PR中完成。
* 如果存在分歧，应该请TOC（技术监督委员会）参与决策。
* 添加必要的测试以确保重构的正确性。
* 非错误重构优先在里程碑的开始时进行，这样可以更容易地在发布之前发现问题。

## 审查和合并建议

* 重构的PR不应该长时间保持打开状态（通常为7天），应尽快进行审查。
* 重构的PR应尽快合并，不应被其他PR阻塞。
* 如果TOC没有异议，重构的PR可以在7天后由一名核心成员（非作者）批准后合并。
* 如果最终结果良好，容忍一些不完美/临时的步骤。
* 如果重构是必要的，容忍一些回归错误，并尽快修复错误。
