#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Jul 19 14:09:57 2018 by generateDS.py version 2.29.17.
# Python 2.7.15 |Anaconda custom (64-bit)| (default, May  1 2018, 23:32:55)  [GCC 7.2.0]
#
# Command line options:
#   ('-f', '')
#   ('-m', '')
#   ('--namespacedef', 'xmlns:pl="http://kuhlman.com/people.xsd"')
#   ('--super', 'peoplesup')
#   ('-o', 'peoplesup.py')
#   ('-s', 'peoplesub.py')
#   ('--member-specs', 'dict')
#   ('-m', '')
#   ('--export', 'write etree literal')
#   ('-c', 'people_catalog.xml')
#
# Command line arguments:
#   people.xsd
#
# Command line:
#   ../../generateDS.py -f -m --namespacedef="xmlns:pl="http://kuhlman.com/people.xsd"" --super="peoplesup" -o "peoplesup.py" -s "peoplesub.py" --member-specs="dict" -m --export="write etree literal" -c "people_catalog.xml" people.xsd
#
# Current working directory (os.getcwd()):
#   People
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for a example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:
    
    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            if type(self) != type(other):
                return False
            return self.__dict__ == other.__dict__
        def __ne__(self, other):
            return not self.__eq__(other)
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class ArrayTypes(object):
    float_='float'
    int='int'
    Name='Name'
    token='token'


class peopleType(GeneratedsSuper):
    member_data_items_ = {
        'comments': MemberSpec_('comments', 'commentsType', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'commentsType', u'name': u'comments'}, None),
        'person': MemberSpec_('person', 'personType', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'personType', u'name': u'person'}, None),
        'specialperson': MemberSpec_('specialperson', 'specialperson', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'specialperson', u'name': u'specialperson'}, None),
        'programmer': MemberSpec_('programmer', 'programmerType', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'programmerType', u'name': u'programmer'}, None),
        'python_programmer': MemberSpec_('python_programmer', 'python-programmerType', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'python-programmerType', u'name': u'python-programmer'}, None),
        'java_programmer': MemberSpec_('java_programmer', 'java-programmerType', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'java-programmerType', u'name': u'java-programmer'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, comments=None, person=None, specialperson=None, programmer=None, python_programmer=None, java_programmer=None):
        self.original_tagname_ = None
        if comments is None:
            self.comments = []
        else:
            self.comments = comments
        if person is None:
            self.person = []
        else:
            self.person = person
        if specialperson is None:
            self.specialperson = []
        else:
            self.specialperson = specialperson
        if programmer is None:
            self.programmer = []
        else:
            self.programmer = programmer
        if python_programmer is None:
            self.python_programmer = []
        else:
            self.python_programmer = python_programmer
        if java_programmer is None:
            self.java_programmer = []
        else:
            self.java_programmer = java_programmer
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, peopleType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if peopleType.subclass:
            return peopleType.subclass(*args_, **kwargs_)
        else:
            return peopleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_comments(self): return self.comments
    def set_comments(self, comments): self.comments = comments
    def add_comments(self, value): self.comments.append(value)
    def insert_comments_at(self, index, value): self.comments.insert(index, value)
    def replace_comments_at(self, index, value): self.comments[index] = value
    commentsProp = property(get_comments, set_comments)
    def get_person(self): return self.person
    def set_person(self, person): self.person = person
    def add_person(self, value): self.person.append(value)
    def insert_person_at(self, index, value): self.person.insert(index, value)
    def replace_person_at(self, index, value): self.person[index] = value
    personProp = property(get_person, set_person)
    def get_specialperson(self): return self.specialperson
    def set_specialperson(self, specialperson): self.specialperson = specialperson
    def add_specialperson(self, value): self.specialperson.append(value)
    def insert_specialperson_at(self, index, value): self.specialperson.insert(index, value)
    def replace_specialperson_at(self, index, value): self.specialperson[index] = value
    specialpersonProp = property(get_specialperson, set_specialperson)
    def get_programmer(self): return self.programmer
    def set_programmer(self, programmer): self.programmer = programmer
    def add_programmer(self, value): self.programmer.append(value)
    def insert_programmer_at(self, index, value): self.programmer.insert(index, value)
    def replace_programmer_at(self, index, value): self.programmer[index] = value
    programmerProp = property(get_programmer, set_programmer)
    def get_python_programmer(self): return self.python_programmer
    def set_python_programmer(self, python_programmer): self.python_programmer = python_programmer
    def add_python_programmer(self, value): self.python_programmer.append(value)
    def insert_python_programmer_at(self, index, value): self.python_programmer.insert(index, value)
    def replace_python_programmer_at(self, index, value): self.python_programmer[index] = value
    python_programmerProp = property(get_python_programmer, set_python_programmer)
    def get_java_programmer(self): return self.java_programmer
    def set_java_programmer(self, java_programmer): self.java_programmer = java_programmer
    def add_java_programmer(self, value): self.java_programmer.append(value)
    def insert_java_programmer_at(self, index, value): self.java_programmer.insert(index, value)
    def replace_java_programmer_at(self, index, value): self.java_programmer[index] = value
    java_programmerProp = property(get_java_programmer, set_java_programmer)
    def hasContent_(self):
        if (
            self.comments or
            self.person or
            self.specialperson or
            self.programmer or
            self.python_programmer or
            self.java_programmer
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='peopleType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('peopleType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='peopleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='peopleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='peopleType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='peopleType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for comments_ in self.comments:
            comments_.export(outfile, level, namespace_, name_='comments', pretty_print=pretty_print)
        for person_ in self.person:
            person_.export(outfile, level, namespace_, name_='person', pretty_print=pretty_print)
        for specialperson_ in self.specialperson:
            specialperson_.export(outfile, level, namespace_, name_='specialperson', pretty_print=pretty_print)
        for programmer_ in self.programmer:
            programmer_.export(outfile, level, namespace_, name_='programmer', pretty_print=pretty_print)
        for python_programmer_ in self.python_programmer:
            python_programmer_.export(outfile, level, namespace_, name_='python-programmer', pretty_print=pretty_print)
        for java_programmer_ in self.java_programmer:
            java_programmer_.export(outfile, level, namespace_, name_='java-programmer', pretty_print=pretty_print)
    def to_etree(self, parent_element=None, name_='peopleType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        for comments_ in self.comments:
            comments_.to_etree(element, name_='comments', mapping_=mapping_)
        for person_ in self.person:
            person_.to_etree(element, name_='person', mapping_=mapping_)
        for specialperson_ in self.specialperson:
            specialperson_.to_etree(element, name_='specialperson', mapping_=mapping_)
        for programmer_ in self.programmer:
            programmer_.to_etree(element, name_='programmer', mapping_=mapping_)
        for python_programmer_ in self.python_programmer:
            python_programmer_.to_etree(element, name_='python-programmer', mapping_=mapping_)
        for java_programmer_ in self.java_programmer:
            java_programmer_.to_etree(element, name_='java-programmer', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='peopleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('comments=[\n')
        level += 1
        for comments_ in self.comments:
            showIndent(outfile, level)
            outfile.write('model_.commentsType(\n')
            comments_.exportLiteral(outfile, level, name_='commentsType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('person=[\n')
        level += 1
        for person_ in self.person:
            showIndent(outfile, level)
            outfile.write('model_.personType(\n')
            person_.exportLiteral(outfile, level, name_='personType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('specialperson=[\n')
        level += 1
        for specialperson_ in self.specialperson:
            showIndent(outfile, level)
            outfile.write('model_.specialperson(\n')
            specialperson_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('programmer=[\n')
        level += 1
        for programmer_ in self.programmer:
            showIndent(outfile, level)
            outfile.write('model_.programmerType(\n')
            programmer_.exportLiteral(outfile, level, name_='programmerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('python_programmer=[\n')
        level += 1
        for python_programmer_ in self.python_programmer:
            showIndent(outfile, level)
            outfile.write('model_.python_programmerType(\n')
            python_programmer_.exportLiteral(outfile, level, name_='python-programmerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('java_programmer=[\n')
        level += 1
        for java_programmer_ in self.java_programmer:
            showIndent(outfile, level)
            outfile.write('model_.java_programmerType(\n')
            java_programmer_.exportLiteral(outfile, level, name_='java-programmerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'comments':
            obj_ = commentsType.factory()
            obj_.build(child_)
            self.comments.append(obj_)
            obj_.original_tagname_ = 'comments'
        elif nodeName_ == 'person':
            class_obj_ = self.get_class_obj_(child_, personType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.person.append(obj_)
            obj_.original_tagname_ = 'person'
        elif nodeName_ == 'specialperson':
            obj_ = specialperson.factory()
            obj_.build(child_)
            self.specialperson.append(obj_)
            obj_.original_tagname_ = 'specialperson'
        elif nodeName_ == 'programmer':
            class_obj_ = self.get_class_obj_(child_, programmerType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.programmer.append(obj_)
            obj_.original_tagname_ = 'programmer'
        elif nodeName_ == 'python-programmer':
            obj_ = python_programmerType.factory()
            obj_.build(child_)
            self.python_programmer.append(obj_)
            obj_.original_tagname_ = 'python-programmer'
        elif nodeName_ == 'java-programmer':
            obj_ = java_programmerType.factory()
            obj_.build(child_)
            self.java_programmer.append(obj_)
            obj_.original_tagname_ = 'java-programmer'
# end class peopleType


class commentsType(GeneratedsSuper):
    member_data_items_ = {
        'emp': MemberSpec_('emp', 'xs:string', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'xs:string', u'name': u'emp'}, None),
        'bold': MemberSpec_('bold', 'xs:string', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'xs:string', u'name': u'bold'}, None),
        'valueOf_': MemberSpec_('valueOf_', [], 0),
    }
    subclass = None
    superclass = None
    def __init__(self, emp=None, bold=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        if emp is None:
            self.emp = []
        else:
            self.emp = emp
        if bold is None:
            self.bold = []
        else:
            self.bold = bold
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, commentsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if commentsType.subclass:
            return commentsType.subclass(*args_, **kwargs_)
        else:
            return commentsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_emp(self): return self.emp
    def set_emp(self, emp): self.emp = emp
    def add_emp(self, value): self.emp.append(value)
    def insert_emp_at(self, index, value): self.emp.insert(index, value)
    def replace_emp_at(self, index, value): self.emp[index] = value
    empProp = property(get_emp, set_emp)
    def get_bold(self): return self.bold
    def set_bold(self, bold): self.bold = bold
    def add_bold(self, value): self.bold.append(value)
    def insert_bold_at(self, index, value): self.bold.insert(index, value)
    def replace_bold_at(self, index, value): self.bold[index] = value
    boldProp = property(get_bold, set_bold)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.emp or
            self.bold or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='commentsType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('commentsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='commentsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='commentsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='commentsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='commentsType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for emp_ in self.emp:
            showIndent(outfile, level, pretty_print)
            outfile.write('<emp>%s</emp>%s' % (self.gds_encode(self.gds_format_string(quote_xml(emp_), input_name='emp')), eol_))
        for bold_ in self.bold:
            showIndent(outfile, level, pretty_print)
            outfile.write('<bold>%s</bold>%s' % (self.gds_encode(self.gds_format_string(quote_xml(bold_), input_name='bold')), eol_))
    def to_etree(self, parent_element=None, name_='commentsType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        for item_ in self.content_:
            item_.to_etree(element)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='commentsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('content_ = [\n')
        for item_ in self.content_:
            item_.exportLiteral(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('content_ = [\n')
        for item_ in self.content_:
            item_.exportLiteral(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('],\n')
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'emp' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'emp', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'bold' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'bold', valuestr_)
            self.content_.append(obj_)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class commentsType


class personType(GeneratedsSuper):
    member_data_items_ = {
        'value': MemberSpec_('value', 'xs:string', 0, 1, {'use': 'optional'}),
        'id': MemberSpec_('id', 'xs:integer', 0, 1, {'use': 'optional'}),
        'ratio': MemberSpec_('ratio', 'xs:float', 0, 1, {'use': 'optional'}),
        'fruit': MemberSpec_('fruit', 'xs:string', 0, 1, {'use': 'optional'}),
        'vegetable': MemberSpec_('vegetable', 'xs:string', 0, 1, {'use': 'optional'}),
        'name': MemberSpec_('name', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'name'}, None),
        'interest': MemberSpec_('interest', 'xs:string', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'xs:string', u'name': u'interest'}, None),
        'category': MemberSpec_('category', 'xs:integer', 0, 1, {u'type': u'xs:integer', u'name': u'category', u'minOccurs': u'0'}, None),
        'hot_agent': MemberSpec_('hot_agent', 'hot.agent', 0, 0, {u'type': u'hot.agent', u'name': u'hot.agent'}, None),
        'agent': MemberSpec_('agent', 'agentType', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'agentType', u'name': u'agent'}, None),
        'promoter': MemberSpec_('promoter', 'boosterType', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'boosterType', u'name': u'promoter'}, None),
        'description': MemberSpec_('description', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'description'}, None),
        'range_': MemberSpec_('range_', ['RangeType', 'xs:integer'], 0, 0, {u'type': u'xs:integer', u'name': u'range'}, None),
        'with_': MemberSpec_('with_', 'boosterType', 0, 0, {u'type': u'boosterType', u'name': u'with'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, value=None, id=None, ratio=None, fruit=None, vegetable=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None, with_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.value = _cast(None, value)
        self.id = _cast(int, id)
        self.ratio = _cast(float, ratio)
        self.fruit = _cast(None, fruit)
        self.vegetable = _cast(None, vegetable)
        self.name = name
        if interest is None:
            self.interest = []
        else:
            self.interest = interest
        self.category = category
        self.hot_agent = hot_agent
        if agent is None:
            self.agent = []
        else:
            self.agent = agent
        if promoter is None:
            self.promoter = []
        else:
            self.promoter = promoter
        self.description = description
        self.range_ = range_
        self.validate_RangeType(self.range_)
        self.with_ = with_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, personType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if personType.subclass:
            return personType.subclass(*args_, **kwargs_)
        else:
            return personType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_interest(self): return self.interest
    def set_interest(self, interest): self.interest = interest
    def add_interest(self, value): self.interest.append(value)
    def insert_interest_at(self, index, value): self.interest.insert(index, value)
    def replace_interest_at(self, index, value): self.interest[index] = value
    interestProp = property(get_interest, set_interest)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    categoryProp = property(get_category, set_category)
    def get_hot_agent(self): return self.hot_agent
    def set_hot_agent(self, hot_agent): self.hot_agent = hot_agent
    hot_agentProp = property(get_hot_agent, set_hot_agent)
    def get_agent(self): return self.agent
    def set_agent(self, agent): self.agent = agent
    def add_agent(self, value): self.agent.append(value)
    def insert_agent_at(self, index, value): self.agent.insert(index, value)
    def replace_agent_at(self, index, value): self.agent[index] = value
    agentProp = property(get_agent, set_agent)
    def get_promoter(self): return self.promoter
    def set_promoter(self, promoter): self.promoter = promoter
    def add_promoter(self, value): self.promoter.append(value)
    def insert_promoter_at(self, index, value): self.promoter.insert(index, value)
    def replace_promoter_at(self, index, value): self.promoter[index] = value
    promoterProp = property(get_promoter, set_promoter)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    descriptionProp = property(get_description, set_description)
    def get_range(self): return self.range_
    def set_range(self, range_): self.range_ = range_
    rangeProp = property(get_range, set_range)
    def get_with(self): return self.with_
    def set_with(self, with_): self.with_ = with_
    withProp = property(get_with, set_with)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    idProp = property(get_id, set_id)
    def get_ratio(self): return self.ratio
    def set_ratio(self, ratio): self.ratio = ratio
    ratioProp = property(get_ratio, set_ratio)
    def get_fruit(self): return self.fruit
    def set_fruit(self, fruit): self.fruit = fruit
    fruitProp = property(get_fruit, set_fruit)
    def get_vegetable(self): return self.vegetable
    def set_vegetable(self, vegetable): self.vegetable = vegetable
    vegetableProp = property(get_vegetable, set_vegetable)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_RangeType(self, value):
        # Validate type RangeType, a restriction on xs:integer.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.interest or
            self.category is not None or
            self.hot_agent is not None or
            self.agent or
            self.promoter or
            self.description is not None or
            self.range_ is not None or
            self.with_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='personType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('personType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='personType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='personType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='personType'):
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.ratio is not None and 'ratio' not in already_processed:
            already_processed.add('ratio')
            outfile.write(' ratio="%s"' % self.gds_format_float(self.ratio, input_name='ratio'))
        if self.fruit is not None and 'fruit' not in already_processed:
            already_processed.add('fruit')
            outfile.write(' fruit=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.fruit), input_name='fruit')), ))
        if self.vegetable is not None and 'vegetable' not in already_processed:
            already_processed.add('vegetable')
            outfile.write(' vegetable=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.vegetable), input_name='vegetable')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='personType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<name>%s</name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), eol_))
        for interest_ in self.interest:
            showIndent(outfile, level, pretty_print)
            outfile.write('<interest>%s</interest>%s' % (self.gds_encode(self.gds_format_string(quote_xml(interest_), input_name='interest')), eol_))
        if self.category is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<category>%s</category>%s' % (self.gds_format_integer(self.category, input_name='category'), eol_))
        if self.hot_agent is not None:
            self.hot_agent.export(outfile, level, namespace_, name_='hot.agent', pretty_print=pretty_print)
        for agent_ in self.agent:
            agent_.export(outfile, level, namespace_, name_='agent', pretty_print=pretty_print)
        for promoter_ in self.promoter:
            promoter_.export(outfile, level, namespace_, name_='promoter', pretty_print=pretty_print)
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<description>%s</description>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), eol_))
        if self.range_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<range>%s</range>%s' % (self.gds_format_integer(self.range_, input_name='range'), eol_))
        if self.with_ is not None:
            self.with_.export(outfile, level, namespace_, name_='with', pretty_print=pretty_print)
    def to_etree(self, parent_element=None, name_='personType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.extensiontype_ is not None:
            element.set('{http://www.w3.org/2001/XMLSchema-instance}type', self.extensiontype_)
        if self.value is not None:
            element.set('value', self.gds_format_string(self.value))
        if self.id is not None:
            element.set('id', self.gds_format_integer(self.id))
        if self.ratio is not None:
            element.set('ratio', self.gds_format_float(self.ratio))
        if self.fruit is not None:
            element.set('fruit', self.gds_format_string(self.fruit))
        if self.vegetable is not None:
            element.set('vegetable', self.gds_format_string(self.vegetable))
        if self.name is not None:
            name_ = self.name
            etree_.SubElement(element, '{}name').text = self.gds_format_string(name_)
        for interest_ in self.interest:
            etree_.SubElement(element, '{}interest').text = self.gds_format_string(interest_)
        if self.category is not None:
            category_ = self.category
            etree_.SubElement(element, '{}category').text = self.gds_format_integer(category_)
        if self.hot_agent is not None:
            hot_agent_ = self.hot_agent
            hot_agent_.to_etree(element, name_='hot.agent', mapping_=mapping_)
        for agent_ in self.agent:
            agent_.to_etree(element, name_='agent', mapping_=mapping_)
        for promoter_ in self.promoter:
            promoter_.to_etree(element, name_='promoter', mapping_=mapping_)
        if self.description is not None:
            description_ = self.description
            etree_.SubElement(element, '{}description').text = self.gds_format_string(description_)
        if self.range_ is not None:
            range__ = self.range_
            etree_.SubElement(element, '{}range').text = self.gds_format_integer(range__)
        if self.with_ is not None:
            with__ = self.with_
            with__.to_etree(element, name_='with', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='personType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value="%s",\n' % (self.value,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id=%d,\n' % (self.id,))
        if self.ratio is not None and 'ratio' not in already_processed:
            already_processed.add('ratio')
            showIndent(outfile, level)
            outfile.write('ratio=%f,\n' % (self.ratio,))
        if self.fruit is not None and 'fruit' not in already_processed:
            already_processed.add('fruit')
            showIndent(outfile, level)
            outfile.write('fruit="%s",\n' % (self.fruit,))
        if self.vegetable is not None and 'vegetable' not in already_processed:
            already_processed.add('vegetable')
            showIndent(outfile, level)
            outfile.write('vegetable="%s",\n' % (self.vegetable,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % self.gds_encode(quote_python(self.name)))
        showIndent(outfile, level)
        outfile.write('interest=[\n')
        level += 1
        for interest_ in self.interest:
            showIndent(outfile, level)
            outfile.write('%s,\n' % self.gds_encode(quote_python(interest_)))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%d,\n' % self.category)
        if self.hot_agent is not None:
            showIndent(outfile, level)
            outfile.write('hot_agent=model_.hot_agent(\n')
            self.hot_agent.exportLiteral(outfile, level, name_='hot_agent')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('agent=[\n')
        level += 1
        for agent_ in self.agent:
            showIndent(outfile, level)
            outfile.write('model_.agentType(\n')
            agent_.exportLiteral(outfile, level, name_='agentType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('promoter=[\n')
        level += 1
        for promoter_ in self.promoter:
            showIndent(outfile, level)
            outfile.write('model_.boosterType(\n')
            promoter_.exportLiteral(outfile, level, name_='boosterType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % self.gds_encode(quote_python(self.description)))
        if self.range_ is not None:
            showIndent(outfile, level)
            outfile.write('range_=%d,\n' % self.range_)
        if self.with_ is not None:
            showIndent(outfile, level)
            outfile.write('with_=model_.boosterType(\n')
            self.with_.exportLiteral(outfile, level, name_='with')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('ratio', node)
        if value is not None and 'ratio' not in already_processed:
            already_processed.add('ratio')
            try:
                self.ratio = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (ratio): %s' % exp)
        value = find_attr_value_('fruit', node)
        if value is not None and 'fruit' not in already_processed:
            already_processed.add('fruit')
            self.fruit = value
        value = find_attr_value_('vegetable', node)
        if value is not None and 'vegetable' not in already_processed:
            already_processed.add('vegetable')
            self.vegetable = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'interest':
            interest_ = child_.text
            interest_ = self.gds_validate_string(interest_, node, 'interest')
            self.interest.append(interest_)
        elif nodeName_ == 'category':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'category')
            self.category = ival_
        elif nodeName_ == 'hot.agent':
            obj_ = hot_agent.factory()
            obj_.build(child_)
            self.hot_agent = obj_
            obj_.original_tagname_ = 'hot.agent'
        elif nodeName_ == 'agent':
            class_obj_ = self.get_class_obj_(child_, agentType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.agent.append(obj_)
            obj_.original_tagname_ = 'agent'
        elif nodeName_ == 'promoter':
            obj_ = boosterType.factory()
            obj_.build(child_)
            self.promoter.append(obj_)
            obj_.original_tagname_ = 'promoter'
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'range':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'range')
            self.range_ = ival_
            # validate type RangeType
            self.validate_RangeType(self.range_)
        elif nodeName_ == 'with':
            obj_ = boosterType.factory()
            obj_.build(child_)
            self.with_ = obj_
            obj_.original_tagname_ = 'with'
# end class personType


class specialperson(personType):
    member_data_items_ = {
    }
    subclass = None
    superclass = personType
    def __init__(self, value=None, id=None, ratio=None, fruit=None, vegetable=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None, with_=None):
        self.original_tagname_ = None
        super(specialperson, self).__init__(value, id, ratio, fruit, vegetable, name, interest, category, hot_agent, agent, promoter, description, range_, with_, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, specialperson)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if specialperson.subclass:
            return specialperson.subclass(*args_, **kwargs_)
        else:
            return specialperson(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(specialperson, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='specialperson', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('specialperson')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='specialperson')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='specialperson', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='specialperson'):
        super(specialperson, self).exportAttributes(outfile, level, already_processed, namespace_, name_='specialperson')
    def exportChildren(self, outfile, level, namespace_='', name_='specialperson', fromsubclass_=False, pretty_print=True):
        super(specialperson, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def to_etree(self, parent_element=None, name_='specialperson', mapping_=None):
        element = super(specialperson, self).to_etree(parent_element, name_, mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='specialperson'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(specialperson, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(specialperson, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(specialperson, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(specialperson, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class specialperson


class programmerType(personType):
    member_data_items_ = {
        'language': MemberSpec_('language', 'xs:string', 0, 1, {'use': 'optional'}),
        'area': MemberSpec_('area', 'xs:string', 0, 1, {'use': 'optional'}),
        'attrposint': MemberSpec_('attrposint', 'xs:positiveInteger', 0, 1, {'use': 'optional'}),
        'attrnonposint': MemberSpec_('attrnonposint', 'xs:nonPositiveInteger', 0, 1, {'use': 'optional'}),
        'attrnegint': MemberSpec_('attrnegint', 'xs:negativeInteger', 0, 1, {'use': 'optional'}),
        'attrnonnegint': MemberSpec_('attrnonnegint', 'xs:nonNegativeInteger', 0, 1, {'use': 'optional'}),
        'email': MemberSpec_('email', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'email'}, None),
        'elposint': MemberSpec_('elposint', 'xs:positiveInteger', 0, 0, {u'type': u'xs:positiveInteger', u'name': u'elposint'}, None),
        'elnonposint': MemberSpec_('elnonposint', 'xs:nonPositiveInteger', 0, 0, {u'type': u'xs:nonPositiveInteger', u'name': u'elnonposint'}, None),
        'elnegint': MemberSpec_('elnegint', 'xs:negativeInteger', 0, 0, {u'type': u'xs:negativeInteger', u'name': u'elnegint'}, None),
        'elnonnegint': MemberSpec_('elnonnegint', 'xs:nonNegativeInteger', 0, 0, {u'type': u'xs:nonNegativeInteger', u'name': u'elnonnegint'}, None),
        'eldate': MemberSpec_('eldate', 'xs:date', 0, 0, {u'type': u'xs:date', u'name': u'eldate'}, None),
        'eldatetime': MemberSpec_('eldatetime', 'xs:dateTime', 0, 0, {u'type': u'xs:dateTime', u'name': u'eldatetime'}, None),
        'eldatetime1': MemberSpec_('eldatetime1', 'xs:dateTime', 0, 0, {u'type': u'xs:dateTime', u'name': u'eldatetime1'}, None),
        'eltoken': MemberSpec_('eltoken', 'xs:token', 0, 0, {u'type': u'xs:token', u'name': u'eltoken'}, None),
        'elshort': MemberSpec_('elshort', 'xs:short', 0, 0, {u'type': u'xs:short', u'name': u'elshort'}, None),
        'ellong': MemberSpec_('ellong', 'xs:long', 0, 0, {u'type': u'xs:long', u'name': u'ellong'}, None),
        'elparam': MemberSpec_('elparam', 'paramType', 0, 0, {u'type': u'paramType', u'name': u'elparam'}, None),
        'elarraytypes': MemberSpec_('elarraytypes', ['ArrayTypes', 'xs:NMTOKEN'], 0, 0, {u'type': u'xs:NMTOKEN', u'name': u'elarraytypes'}, None),
    }
    subclass = None
    superclass = personType
    def __init__(self, value=None, id=None, ratio=None, fruit=None, vegetable=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None, with_=None, language=None, area=None, attrposint=None, attrnonposint=None, attrnegint=None, attrnonnegint=None, email=None, elposint=None, elnonposint=None, elnegint=None, elnonnegint=None, eldate=None, eldatetime=None, eldatetime1=None, eltoken=None, elshort=None, ellong=None, elparam=None, elarraytypes=None, extensiontype_=None):
        self.original_tagname_ = None
        super(programmerType, self).__init__(value, id, ratio, fruit, vegetable, name, interest, category, hot_agent, agent, promoter, description, range_, with_, extensiontype_, )
        self.language = _cast(None, language)
        self.area = _cast(None, area)
        self.attrposint = _cast(int, attrposint)
        self.attrnonposint = _cast(int, attrnonposint)
        self.attrnegint = _cast(int, attrnegint)
        self.attrnonnegint = _cast(int, attrnonnegint)
        self.email = email
        self.elposint = elposint
        self.elnonposint = elnonposint
        self.elnegint = elnegint
        self.elnonnegint = elnonnegint
        if isinstance(eldate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(eldate, '%Y-%m-%d').date()
        else:
            initvalue_ = eldate
        self.eldate = initvalue_
        if isinstance(eldatetime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(eldatetime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = eldatetime
        self.eldatetime = initvalue_
        if isinstance(eldatetime1, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(eldatetime1, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = eldatetime1
        self.eldatetime1 = initvalue_
        self.eltoken = eltoken
        self.elshort = elshort
        self.ellong = ellong
        self.elparam = elparam
        self.elarraytypes = elarraytypes
        self.validate_ArrayTypes(self.elarraytypes)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, programmerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if programmerType.subclass:
            return programmerType.subclass(*args_, **kwargs_)
        else:
            return programmerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    emailProp = property(get_email, set_email)
    def get_elposint(self): return self.elposint
    def set_elposint(self, elposint): self.elposint = elposint
    elposintProp = property(get_elposint, set_elposint)
    def get_elnonposint(self): return self.elnonposint
    def set_elnonposint(self, elnonposint): self.elnonposint = elnonposint
    elnonposintProp = property(get_elnonposint, set_elnonposint)
    def get_elnegint(self): return self.elnegint
    def set_elnegint(self, elnegint): self.elnegint = elnegint
    elnegintProp = property(get_elnegint, set_elnegint)
    def get_elnonnegint(self): return self.elnonnegint
    def set_elnonnegint(self, elnonnegint): self.elnonnegint = elnonnegint
    elnonnegintProp = property(get_elnonnegint, set_elnonnegint)
    def get_eldate(self): return self.eldate
    def set_eldate(self, eldate): self.eldate = eldate
    eldateProp = property(get_eldate, set_eldate)
    def get_eldatetime(self): return self.eldatetime
    def set_eldatetime(self, eldatetime): self.eldatetime = eldatetime
    eldatetimeProp = property(get_eldatetime, set_eldatetime)
    def get_eldatetime1(self): return self.eldatetime1
    def set_eldatetime1(self, eldatetime1): self.eldatetime1 = eldatetime1
    eldatetime1Prop = property(get_eldatetime1, set_eldatetime1)
    def get_eltoken(self): return self.eltoken
    def set_eltoken(self, eltoken): self.eltoken = eltoken
    eltokenProp = property(get_eltoken, set_eltoken)
    def get_elshort(self): return self.elshort
    def set_elshort(self, elshort): self.elshort = elshort
    elshortProp = property(get_elshort, set_elshort)
    def get_ellong(self): return self.ellong
    def set_ellong(self, ellong): self.ellong = ellong
    ellongProp = property(get_ellong, set_ellong)
    def get_elparam(self): return self.elparam
    def set_elparam(self, elparam): self.elparam = elparam
    elparamProp = property(get_elparam, set_elparam)
    def get_elarraytypes(self): return self.elarraytypes
    def set_elarraytypes(self, elarraytypes): self.elarraytypes = elarraytypes
    elarraytypesProp = property(get_elarraytypes, set_elarraytypes)
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    languageProp = property(get_language, set_language)
    def get_area(self): return self.area
    def set_area(self, area): self.area = area
    areaProp = property(get_area, set_area)
    def get_attrposint(self): return self.attrposint
    def set_attrposint(self, attrposint): self.attrposint = attrposint
    attrposintProp = property(get_attrposint, set_attrposint)
    def get_attrnonposint(self): return self.attrnonposint
    def set_attrnonposint(self, attrnonposint): self.attrnonposint = attrnonposint
    attrnonposintProp = property(get_attrnonposint, set_attrnonposint)
    def get_attrnegint(self): return self.attrnegint
    def set_attrnegint(self, attrnegint): self.attrnegint = attrnegint
    attrnegintProp = property(get_attrnegint, set_attrnegint)
    def get_attrnonnegint(self): return self.attrnonnegint
    def set_attrnonnegint(self, attrnonnegint): self.attrnonnegint = attrnonnegint
    attrnonnegintProp = property(get_attrnonnegint, set_attrnonnegint)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_ArrayTypes(self, value):
        # Validate type ArrayTypes, a restriction on xs:NMTOKEN.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['float', 'int', 'Name', 'token']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ArrayTypes' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.email is not None or
            self.elposint is not None or
            self.elnonposint is not None or
            self.elnegint is not None or
            self.elnonnegint is not None or
            self.eldate is not None or
            self.eldatetime is not None or
            self.eldatetime1 is not None or
            self.eltoken is not None or
            self.elshort is not None or
            self.ellong is not None or
            self.elparam is not None or
            self.elarraytypes is not None or
            super(programmerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='programmerType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('programmerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='programmerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='programmerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='programmerType'):
        super(programmerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='programmerType')
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.area is not None and 'area' not in already_processed:
            already_processed.add('area')
            outfile.write(' area=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.area), input_name='area')), ))
        if self.attrposint is not None and 'attrposint' not in already_processed:
            already_processed.add('attrposint')
            outfile.write(' attrposint="%s"' % self.gds_format_integer(self.attrposint, input_name='attrposint'))
        if self.attrnonposint is not None and 'attrnonposint' not in already_processed:
            already_processed.add('attrnonposint')
            outfile.write(' attrnonposint="%s"' % self.gds_format_integer(self.attrnonposint, input_name='attrnonposint'))
        if self.attrnegint is not None and 'attrnegint' not in already_processed:
            already_processed.add('attrnegint')
            outfile.write(' attrnegint="%s"' % self.gds_format_integer(self.attrnegint, input_name='attrnegint'))
        if self.attrnonnegint is not None and 'attrnonnegint' not in already_processed:
            already_processed.add('attrnonnegint')
            outfile.write(' attrnonnegint="%s"' % self.gds_format_integer(self.attrnonnegint, input_name='attrnonnegint'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='programmerType', fromsubclass_=False, pretty_print=True):
        super(programmerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<email>%s</email>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), eol_))
        if self.elposint is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<elposint>%s</elposint>%s' % (self.gds_format_integer(self.elposint, input_name='elposint'), eol_))
        if self.elnonposint is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<elnonposint>%s</elnonposint>%s' % (self.gds_format_integer(self.elnonposint, input_name='elnonposint'), eol_))
        if self.elnegint is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<elnegint>%s</elnegint>%s' % (self.gds_format_integer(self.elnegint, input_name='elnegint'), eol_))
        if self.elnonnegint is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<elnonnegint>%s</elnonnegint>%s' % (self.gds_format_integer(self.elnonnegint, input_name='elnonnegint'), eol_))
        if self.eldate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<eldate>%s</eldate>%s' % (self.gds_format_date(self.eldate, input_name='eldate'), eol_))
        if self.eldatetime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<eldatetime>%s</eldatetime>%s' % (self.gds_format_datetime(self.eldatetime, input_name='eldatetime'), eol_))
        if self.eldatetime1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<eldatetime1>%s</eldatetime1>%s' % (self.gds_format_datetime(self.eldatetime1, input_name='eldatetime1'), eol_))
        if self.eltoken is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<eltoken>%s</eltoken>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.eltoken), input_name='eltoken')), eol_))
        if self.elshort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<elshort>%s</elshort>%s' % (self.gds_format_integer(self.elshort, input_name='elshort'), eol_))
        if self.ellong is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<ellong>%s</ellong>%s' % (self.gds_format_integer(self.ellong, input_name='ellong'), eol_))
        if self.elparam is not None:
            self.elparam.export(outfile, level, namespace_, name_='elparam', pretty_print=pretty_print)
        if self.elarraytypes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<elarraytypes>%s</elarraytypes>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.elarraytypes), input_name='elarraytypes')), eol_))
    def to_etree(self, parent_element=None, name_='programmerType', mapping_=None):
        element = super(programmerType, self).to_etree(parent_element, name_, mapping_)
        if self.extensiontype_ is not None:
            element.set('{http://www.w3.org/2001/XMLSchema-instance}type', self.extensiontype_)
        if self.language is not None:
            element.set('language', self.gds_format_string(self.language))
        if self.area is not None:
            element.set('area', self.gds_format_string(self.area))
        if self.attrposint is not None:
            element.set('attrposint', self.gds_format_integer(self.attrposint))
        if self.attrnonposint is not None:
            element.set('attrnonposint', self.gds_format_integer(self.attrnonposint))
        if self.attrnegint is not None:
            element.set('attrnegint', self.gds_format_integer(self.attrnegint))
        if self.attrnonnegint is not None:
            element.set('attrnonnegint', self.gds_format_integer(self.attrnonnegint))
        if self.email is not None:
            email_ = self.email
            etree_.SubElement(element, '{}email').text = self.gds_format_string(email_)
        if self.elposint is not None:
            elposint_ = self.elposint
            etree_.SubElement(element, '{}elposint').text = self.gds_format_integer(elposint_)
        if self.elnonposint is not None:
            elnonposint_ = self.elnonposint
            etree_.SubElement(element, '{}elnonposint').text = self.gds_format_integer(elnonposint_)
        if self.elnegint is not None:
            elnegint_ = self.elnegint
            etree_.SubElement(element, '{}elnegint').text = self.gds_format_integer(elnegint_)
        if self.elnonnegint is not None:
            elnonnegint_ = self.elnonnegint
            etree_.SubElement(element, '{}elnonnegint').text = self.gds_format_integer(elnonnegint_)
        if self.eldate is not None:
            eldate_ = self.eldate
            etree_.SubElement(element, '{}eldate').text = self.gds_format_date(eldate_)
        if self.eldatetime is not None:
            eldatetime_ = self.eldatetime
            etree_.SubElement(element, '{}eldatetime').text = self.gds_format_datetime(eldatetime_)
        if self.eldatetime1 is not None:
            eldatetime1_ = self.eldatetime1
            etree_.SubElement(element, '{}eldatetime1').text = self.gds_format_datetime(eldatetime1_)
        if self.eltoken is not None:
            eltoken_ = self.eltoken
            etree_.SubElement(element, '{}eltoken').text = self.gds_format_string(eltoken_)
        if self.elshort is not None:
            elshort_ = self.elshort
            etree_.SubElement(element, '{}elshort').text = self.gds_format_integer(elshort_)
        if self.ellong is not None:
            ellong_ = self.ellong
            etree_.SubElement(element, '{}ellong').text = self.gds_format_integer(ellong_)
        if self.elparam is not None:
            elparam_ = self.elparam
            elparam_.to_etree(element, name_='elparam', mapping_=mapping_)
        if self.elarraytypes is not None:
            elarraytypes_ = self.elarraytypes
            etree_.SubElement(element, '{}elarraytypes').text = self.gds_format_string(elarraytypes_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='programmerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            showIndent(outfile, level)
            outfile.write('language="%s",\n' % (self.language,))
        if self.area is not None and 'area' not in already_processed:
            already_processed.add('area')
            showIndent(outfile, level)
            outfile.write('area="%s",\n' % (self.area,))
        if self.attrposint is not None and 'attrposint' not in already_processed:
            already_processed.add('attrposint')
            showIndent(outfile, level)
            outfile.write('attrposint=%d,\n' % (self.attrposint,))
        if self.attrnonposint is not None and 'attrnonposint' not in already_processed:
            already_processed.add('attrnonposint')
            showIndent(outfile, level)
            outfile.write('attrnonposint=%d,\n' % (self.attrnonposint,))
        if self.attrnegint is not None and 'attrnegint' not in already_processed:
            already_processed.add('attrnegint')
            showIndent(outfile, level)
            outfile.write('attrnegint=%d,\n' % (self.attrnegint,))
        if self.attrnonnegint is not None and 'attrnonnegint' not in already_processed:
            already_processed.add('attrnonnegint')
            showIndent(outfile, level)
            outfile.write('attrnonnegint=%d,\n' % (self.attrnonnegint,))
        super(programmerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(programmerType, self).exportLiteralChildren(outfile, level, name_)
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % self.gds_encode(quote_python(self.email)))
        if self.elposint is not None:
            showIndent(outfile, level)
            outfile.write('elposint=%d,\n' % self.elposint)
        if self.elnonposint is not None:
            showIndent(outfile, level)
            outfile.write('elnonposint=%d,\n' % self.elnonposint)
        if self.elnegint is not None:
            showIndent(outfile, level)
            outfile.write('elnegint=%d,\n' % self.elnegint)
        if self.elnonnegint is not None:
            showIndent(outfile, level)
            outfile.write('elnonnegint=%d,\n' % self.elnonnegint)
        if self.eldate is not None:
            showIndent(outfile, level)
            outfile.write('eldate=model_.GeneratedsSuper.gds_parse_date("%s"),\n' % self.gds_format_date(self.eldate, input_name='eldate'))
        if self.eldatetime is not None:
            showIndent(outfile, level)
            outfile.write('eldatetime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.eldatetime, input_name='eldatetime'))
        if self.eldatetime1 is not None:
            showIndent(outfile, level)
            outfile.write('eldatetime1=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.eldatetime1, input_name='eldatetime1'))
        if self.eltoken is not None:
            showIndent(outfile, level)
            outfile.write('eltoken=%s,\n' % self.gds_encode(quote_python(self.eltoken)))
        if self.elshort is not None:
            showIndent(outfile, level)
            outfile.write('elshort=%d,\n' % self.elshort)
        if self.ellong is not None:
            showIndent(outfile, level)
            outfile.write('ellong=%d,\n' % self.ellong)
        if self.elparam is not None:
            showIndent(outfile, level)
            outfile.write('elparam=model_.paramType(\n')
            self.elparam.exportLiteral(outfile, level, name_='elparam')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.elarraytypes is not None:
            showIndent(outfile, level)
            outfile.write('elarraytypes=%s,\n' % self.gds_encode(quote_python(self.elarraytypes)))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('area', node)
        if value is not None and 'area' not in already_processed:
            already_processed.add('area')
            self.area = value
        value = find_attr_value_('attrposint', node)
        if value is not None and 'attrposint' not in already_processed:
            already_processed.add('attrposint')
            try:
                self.attrposint = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrposint <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('attrnonposint', node)
        if value is not None and 'attrnonposint' not in already_processed:
            already_processed.add('attrnonposint')
            try:
                self.attrnonposint = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrnonposint > 0:
                raise_parse_error(node, 'Invalid NonPositiveInteger')
        value = find_attr_value_('attrnegint', node)
        if value is not None and 'attrnegint' not in already_processed:
            already_processed.add('attrnegint')
            try:
                self.attrnegint = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrnegint >= 0:
                raise_parse_error(node, 'Invalid NegativeInteger')
        value = find_attr_value_('attrnonnegint', node)
        if value is not None and 'attrnonnegint' not in already_processed:
            already_processed.add('attrnonnegint')
            try:
                self.attrnonnegint = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrnonnegint < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(programmerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'elposint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'elposint')
            self.elposint = ival_
        elif nodeName_ == 'elnonposint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ > 0:
                raise_parse_error(child_, 'requires nonPositiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'elnonposint')
            self.elnonposint = ival_
        elif nodeName_ == 'elnegint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ >= 0:
                raise_parse_error(child_, 'requires negativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'elnegint')
            self.elnegint = ival_
        elif nodeName_ == 'elnonnegint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'elnonnegint')
            self.elnonnegint = ival_
        elif nodeName_ == 'eldate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.eldate = dval_
        elif nodeName_ == 'eldatetime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.eldatetime = dval_
        elif nodeName_ == 'eldatetime1':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.eldatetime1 = dval_
        elif nodeName_ == 'eltoken':
            eltoken_ = child_.text
            if eltoken_:
                eltoken_ = re_.sub(String_cleanup_pat_, " ", eltoken_).strip()
            else:
                eltoken_ = ""
            eltoken_ = self.gds_validate_string(eltoken_, node, 'eltoken')
            self.eltoken = eltoken_
        elif nodeName_ == 'elshort':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'elshort')
            self.elshort = ival_
        elif nodeName_ == 'ellong':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ellong')
            self.ellong = ival_
        elif nodeName_ == 'elparam':
            obj_ = paramType.factory()
            obj_.build(child_)
            self.elparam = obj_
            obj_.original_tagname_ = 'elparam'
        elif nodeName_ == 'elarraytypes':
            elarraytypes_ = child_.text
            elarraytypes_ = self.gds_validate_string(elarraytypes_, node, 'elarraytypes')
            self.elarraytypes = elarraytypes_
            # validate type ArrayTypes
            self.validate_ArrayTypes(self.elarraytypes)
        super(programmerType, self).buildChildren(child_, node, nodeName_, True)
# end class programmerType


class paramType(GeneratedsSuper):
    member_data_items_ = {
        'id': MemberSpec_('id', 'xs:string', 0, 1, {'use': 'optional'}),
        'name': MemberSpec_('name', 'xs:NCName', 0, 1, {'use': 'optional'}),
        'sid': MemberSpec_('sid', 'xs:NCName', 0, 1, {'use': 'optional'}),
        'flow': MemberSpec_('flow', 'FlowType', 0, 1, {'use': 'optional'}),
        'semantic': MemberSpec_('semantic', 'xs:token', 0, 1, {'use': 'optional'}),
        'type_': MemberSpec_('type_', 'xs:NMTOKEN', 0, 0, {'use': u'required'}),
        'valueOf_': MemberSpec_('valueOf_', 'xs:string', 0),
    }
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, sid=None, flow=None, semantic=None, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.sid = _cast(None, sid)
        self.flow = _cast(int, flow)
        self.semantic = _cast(None, semantic)
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, paramType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if paramType.subclass:
            return paramType.subclass(*args_, **kwargs_)
        else:
            return paramType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    idProp = property(get_id, set_id)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_sid(self): return self.sid
    def set_sid(self, sid): self.sid = sid
    sidProp = property(get_sid, set_sid)
    def get_flow(self): return self.flow
    def set_flow(self, flow): self.flow = flow
    flowProp = property(get_flow, set_flow)
    def get_semantic(self): return self.semantic
    def set_semantic(self, semantic): self.semantic = semantic
    semanticProp = property(get_semantic, set_semantic)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    typeProp = property(get_type, set_type)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_FlowType(self, value):
        # Validate type FlowType, a restriction on xs:integer.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='paramType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('paramType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='paramType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='paramType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='paramType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
        if self.sid is not None and 'sid' not in already_processed:
            already_processed.add('sid')
            outfile.write(' sid=%s' % (quote_attrib(self.sid), ))
        if self.flow is not None and 'flow' not in already_processed:
            already_processed.add('flow')
            outfile.write(' flow=%s' % (quote_attrib(self.flow), ))
        if self.semantic is not None and 'semantic' not in already_processed:
            already_processed.add('semantic')
            outfile.write(' semantic=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.semantic), input_name='semantic')), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='paramType', fromsubclass_=False, pretty_print=True):
        pass
    def to_etree(self, parent_element=None, name_='paramType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.id is not None:
            element.set('id', self.gds_format_string(self.id))
        if self.name is not None:
            element.set('name', self.name)
        if self.sid is not None:
            element.set('sid', self.sid)
        if self.flow is not None:
            element.set('flow', self.flow)
        if self.semantic is not None:
            element.set('semantic', self.gds_format_string(self.semantic))
        if self.type_ is not None:
            element.set('type', self.gds_format_string(self.type_))
        if self.hasContent_():
            element.text = self.gds_format_string(self.get_valueOf_())
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='paramType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.sid is not None and 'sid' not in already_processed:
            already_processed.add('sid')
            showIndent(outfile, level)
            outfile.write('sid="%s",\n' % (self.sid,))
        if self.flow is not None and 'flow' not in already_processed:
            already_processed.add('flow')
            showIndent(outfile, level)
            outfile.write('flow=%d,\n' % (self.flow,))
        if self.semantic is not None and 'semantic' not in already_processed:
            already_processed.add('semantic')
            showIndent(outfile, level)
            outfile.write('semantic="%s",\n' % (self.semantic,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('sid', node)
        if value is not None and 'sid' not in already_processed:
            already_processed.add('sid')
            self.sid = value
        value = find_attr_value_('flow', node)
        if value is not None and 'flow' not in already_processed:
            already_processed.add('flow')
            try:
                self.flow = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_FlowType(self.flow)    # validate type FlowType
        value = find_attr_value_('semantic', node)
        if value is not None and 'semantic' not in already_processed:
            already_processed.add('semantic')
            self.semantic = value
            self.semantic = ' '.join(self.semantic.split())
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class paramType


class python_programmerType(programmerType):
    member_data_items_ = {
        'nick-name': MemberSpec_('nick-name', 'xs:string', 0, 1, {'use': 'optional'}),
        'drcs_attr': MemberSpec_('drcs_attr', 'xs:string', 0, 1, {'use': 'optional'}),
        'gui_developer': MemberSpec_('gui_developer', 'xs:boolean', 0, 1, {'use': 'optional'}),
        'favorite_editor': MemberSpec_('favorite_editor', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'favorite-editor'}, None),
        'flowvalue': MemberSpec_('flowvalue', ['FlowType', 'xs:integer'], 0, 0, {u'type': u'xs:integer', u'name': u'flowvalue'}, None),
        'drcs': MemberSpec_('drcs', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'drcs'}, None),
    }
    subclass = None
    superclass = programmerType
    def __init__(self, value=None, id=None, ratio=None, fruit=None, vegetable=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None, with_=None, language=None, area=None, attrposint=None, attrnonposint=None, attrnegint=None, attrnonnegint=None, email=None, elposint=None, elnonposint=None, elnegint=None, elnonnegint=None, eldate=None, eldatetime=None, eldatetime1=None, eltoken=None, elshort=None, ellong=None, elparam=None, elarraytypes=None, nick_name=None, drcs_attr=None, gui_developer=None, favorite_editor=None, flowvalue=None, drcs=None):
        self.original_tagname_ = None
        super(python_programmerType, self).__init__(value, id, ratio, fruit, vegetable, name, interest, category, hot_agent, agent, promoter, description, range_, with_, language, area, attrposint, attrnonposint, attrnegint, attrnonnegint, email, elposint, elnonposint, elnegint, elnonnegint, eldate, eldatetime, eldatetime1, eltoken, elshort, ellong, elparam, elarraytypes, )
        self.nick_name = _cast(None, nick_name)
        self.drcs_attr = _cast(None, drcs_attr)
        self.gui_developer = _cast(bool, gui_developer)
        self.favorite_editor = favorite_editor
        self.flowvalue = flowvalue
        self.validate_FlowType(self.flowvalue)
        self.drcs = drcs
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, python_programmerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if python_programmerType.subclass:
            return python_programmerType.subclass(*args_, **kwargs_)
        else:
            return python_programmerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_favorite_editor(self): return self.favorite_editor
    def set_favorite_editor(self, favorite_editor): self.favorite_editor = favorite_editor
    favorite_editorProp = property(get_favorite_editor, set_favorite_editor)
    def get_flowvalue(self): return self.flowvalue
    def set_flowvalue(self, flowvalue): self.flowvalue = flowvalue
    flowvalueProp = property(get_flowvalue, set_flowvalue)
    def get_drcs(self): return self.drcs
    def set_drcs(self, drcs): self.drcs = drcs
    drcsProp = property(get_drcs, set_drcs)
    def get_nick_name(self): return self.nick_name
    def set_nick_name(self, nick_name): self.nick_name = nick_name
    nick_nameProp = property(get_nick_name, set_nick_name)
    def get_drcs_attr(self): return self.drcs_attr
    def set_drcs_attr(self, drcs_attr): self.drcs_attr = drcs_attr
    drcs_attrProp = property(get_drcs_attr, set_drcs_attr)
    def get_gui_developer(self): return self.gui_developer
    def set_gui_developer(self, gui_developer): self.gui_developer = gui_developer
    gui_developerProp = property(get_gui_developer, set_gui_developer)
    def validate_FlowType(self, value):
        # Validate type FlowType, a restriction on xs:integer.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.favorite_editor is not None or
            self.flowvalue is not None or
            self.drcs is not None or
            super(python_programmerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='python-programmerType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('python-programmerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='python-programmerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='python-programmerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='python-programmerType'):
        super(python_programmerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='python-programmerType')
        if self.nick_name is not None and 'nick_name' not in already_processed:
            already_processed.add('nick_name')
            outfile.write(' nick-name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.nick_name), input_name='nick-name')), ))
        if self.drcs_attr is not None and 'drcs_attr' not in already_processed:
            already_processed.add('drcs_attr')
            outfile.write(' drcs=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.drcs_attr), input_name='drcs_attr')), ))
        if self.gui_developer is not None and 'gui_developer' not in already_processed:
            already_processed.add('gui_developer')
            outfile.write(' gui_developer="%s"' % self.gds_format_boolean(self.gui_developer, input_name='gui_developer'))
    def exportChildren(self, outfile, level, namespace_='', name_='python-programmerType', fromsubclass_=False, pretty_print=True):
        super(python_programmerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.favorite_editor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<favorite-editor>%s</favorite-editor>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.favorite_editor), input_name='favorite-editor')), eol_))
        if self.flowvalue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<flowvalue>%s</flowvalue>%s' % (self.gds_format_integer(self.flowvalue, input_name='flowvalue'), eol_))
        if self.drcs is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<drcs>%s</drcs>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.drcs), input_name='drcs')), eol_))
    def to_etree(self, parent_element=None, name_='python-programmerType', mapping_=None):
        element = super(python_programmerType, self).to_etree(parent_element, name_, mapping_)
        if self.nick_name is not None:
            element.set('nick-name', self.gds_format_string(self.nick_name))
        if self.drcs_attr is not None:
            element.set('drcs_attr', self.gds_format_string(self.drcs_attr))
        if self.gui_developer is not None:
            element.set('gui_developer', self.gds_format_boolean(self.gui_developer))
        if self.favorite_editor is not None:
            favorite_editor_ = self.favorite_editor
            etree_.SubElement(element, '{}favorite-editor').text = self.gds_format_string(favorite_editor_)
        if self.flowvalue is not None:
            flowvalue_ = self.flowvalue
            etree_.SubElement(element, '{}flowvalue').text = self.gds_format_integer(flowvalue_)
        if self.drcs is not None:
            drcs_ = self.drcs
            etree_.SubElement(element, '{}drcs').text = self.gds_format_string(drcs_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='python-programmerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.nick_name is not None and 'nick_name' not in already_processed:
            already_processed.add('nick_name')
            showIndent(outfile, level)
            outfile.write('nick_name="%s",\n' % (self.nick_name,))
        if self.drcs_attr is not None and 'drcs_attr' not in already_processed:
            already_processed.add('drcs_attr')
            showIndent(outfile, level)
            outfile.write('drcs_attr="%s",\n' % (self.drcs_attr,))
        if self.gui_developer is not None and 'gui_developer' not in already_processed:
            already_processed.add('gui_developer')
            showIndent(outfile, level)
            outfile.write('gui_developer=%s,\n' % (self.gui_developer,))
        super(python_programmerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(python_programmerType, self).exportLiteralChildren(outfile, level, name_)
        if self.favorite_editor is not None:
            showIndent(outfile, level)
            outfile.write('favorite_editor=%s,\n' % self.gds_encode(quote_python(self.favorite_editor)))
        if self.flowvalue is not None:
            showIndent(outfile, level)
            outfile.write('flowvalue=%d,\n' % self.flowvalue)
        if self.drcs is not None:
            showIndent(outfile, level)
            outfile.write('drcs=%s,\n' % self.gds_encode(quote_python(self.drcs)))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nick-name', node)
        if value is not None and 'nick-name' not in already_processed:
            already_processed.add('nick-name')
            self.nick_name = value
        value = find_attr_value_('drcs', node)
        if value is not None and 'drcs_attr' not in already_processed:
            already_processed.add('drcs_attr')
            self.drcs_attr = value
        value = find_attr_value_('gui_developer', node)
        if value is not None and 'gui_developer' not in already_processed:
            already_processed.add('gui_developer')
            if value in ('true', '1'):
                self.gui_developer = True
            elif value in ('false', '0'):
                self.gui_developer = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(python_programmerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'favorite-editor':
            favorite_editor_ = child_.text
            favorite_editor_ = self.gds_validate_string(favorite_editor_, node, 'favorite_editor')
            self.favorite_editor = favorite_editor_
        elif nodeName_ == 'flowvalue':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'flowvalue')
            self.flowvalue = ival_
            # validate type FlowType
            self.validate_FlowType(self.flowvalue)
        elif nodeName_ == 'drcs':
            drcs_ = child_.text
            drcs_ = self.gds_validate_string(drcs_, node, 'drcs')
            self.drcs = drcs_
        super(python_programmerType, self).buildChildren(child_, node, nodeName_, True)
# end class python_programmerType


class java_programmerType(programmerType):
    member_data_items_ = {
        'nick-name': MemberSpec_('nick-name', 'xs:string', 0, 1, {'use': 'optional'}),
        'status': MemberSpec_('status', 'xs:string', 0, 1, {'use': 'optional'}),
        'favorite_editor': MemberSpec_('favorite_editor', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'favorite-editor'}, None),
        'datetime1': MemberSpec_('datetime1', 'xs:gYear', 0, 0, {u'type': u'xs:gYear', u'name': u'datetime1'}, None),
        'datetime2': MemberSpec_('datetime2', 'xs:gYearMonth', 0, 0, {u'type': u'xs:gYearMonth', u'name': u'datetime2'}, None),
        'datetime3': MemberSpec_('datetime3', 'xs:gMonth', 0, 0, {u'type': u'xs:gMonth', u'name': u'datetime3'}, None),
        'datetime4': MemberSpec_('datetime4', 'xs:gMonthDay', 0, 0, {u'type': u'xs:gMonthDay', u'name': u'datetime4'}, None),
        'datetime5': MemberSpec_('datetime5', 'xs:gDay', 0, 0, {u'type': u'xs:gDay', u'name': u'datetime5'}, None),
    }
    subclass = None
    superclass = programmerType
    def __init__(self, value=None, id=None, ratio=None, fruit=None, vegetable=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None, with_=None, language=None, area=None, attrposint=None, attrnonposint=None, attrnegint=None, attrnonnegint=None, email=None, elposint=None, elnonposint=None, elnegint=None, elnonnegint=None, eldate=None, eldatetime=None, eldatetime1=None, eltoken=None, elshort=None, ellong=None, elparam=None, elarraytypes=None, nick_name=None, status=None, favorite_editor=None, datetime1=None, datetime2=None, datetime3=None, datetime4=None, datetime5=None):
        self.original_tagname_ = None
        super(java_programmerType, self).__init__(value, id, ratio, fruit, vegetable, name, interest, category, hot_agent, agent, promoter, description, range_, with_, language, area, attrposint, attrnonposint, attrnegint, attrnonnegint, email, elposint, elnonposint, elnegint, elnonnegint, eldate, eldatetime, eldatetime1, eltoken, elshort, ellong, elparam, elarraytypes, )
        self.nick_name = _cast(None, nick_name)
        self.status = _cast(None, status)
        self.favorite_editor = favorite_editor
        self.datetime1 = datetime1
        self.datetime2 = datetime2
        self.datetime3 = datetime3
        self.datetime4 = datetime4
        self.datetime5 = datetime5
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, java_programmerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if java_programmerType.subclass:
            return java_programmerType.subclass(*args_, **kwargs_)
        else:
            return java_programmerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_favorite_editor(self): return self.favorite_editor
    def set_favorite_editor(self, favorite_editor): self.favorite_editor = favorite_editor
    favorite_editorProp = property(get_favorite_editor, set_favorite_editor)
    def get_datetime1(self): return self.datetime1
    def set_datetime1(self, datetime1): self.datetime1 = datetime1
    datetime1Prop = property(get_datetime1, set_datetime1)
    def get_datetime2(self): return self.datetime2
    def set_datetime2(self, datetime2): self.datetime2 = datetime2
    datetime2Prop = property(get_datetime2, set_datetime2)
    def get_datetime3(self): return self.datetime3
    def set_datetime3(self, datetime3): self.datetime3 = datetime3
    datetime3Prop = property(get_datetime3, set_datetime3)
    def get_datetime4(self): return self.datetime4
    def set_datetime4(self, datetime4): self.datetime4 = datetime4
    datetime4Prop = property(get_datetime4, set_datetime4)
    def get_datetime5(self): return self.datetime5
    def set_datetime5(self, datetime5): self.datetime5 = datetime5
    datetime5Prop = property(get_datetime5, set_datetime5)
    def get_nick_name(self): return self.nick_name
    def set_nick_name(self, nick_name): self.nick_name = nick_name
    nick_nameProp = property(get_nick_name, set_nick_name)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    statusProp = property(get_status, set_status)
    def hasContent_(self):
        if (
            self.favorite_editor is not None or
            self.datetime1 is not None or
            self.datetime2 is not None or
            self.datetime3 is not None or
            self.datetime4 is not None or
            self.datetime5 is not None or
            super(java_programmerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='java-programmerType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('java-programmerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='java-programmerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='java-programmerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='java-programmerType'):
        super(java_programmerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='java-programmerType')
        if self.nick_name is not None and 'nick_name' not in already_processed:
            already_processed.add('nick_name')
            outfile.write(' nick-name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.nick_name), input_name='nick-name')), ))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.status), input_name='status')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='java-programmerType', fromsubclass_=False, pretty_print=True):
        super(java_programmerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.favorite_editor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<favorite-editor>%s</favorite-editor>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.favorite_editor), input_name='favorite-editor')), eol_))
        if self.datetime1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<datetime1>%s</datetime1>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.datetime1), input_name='datetime1')), eol_))
        if self.datetime2 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<datetime2>%s</datetime2>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.datetime2), input_name='datetime2')), eol_))
        if self.datetime3 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<datetime3>%s</datetime3>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.datetime3), input_name='datetime3')), eol_))
        if self.datetime4 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<datetime4>%s</datetime4>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.datetime4), input_name='datetime4')), eol_))
        if self.datetime5 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<datetime5>%s</datetime5>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.datetime5), input_name='datetime5')), eol_))
    def to_etree(self, parent_element=None, name_='java-programmerType', mapping_=None):
        element = super(java_programmerType, self).to_etree(parent_element, name_, mapping_)
        if self.nick_name is not None:
            element.set('nick-name', self.gds_format_string(self.nick_name))
        if self.status is not None:
            element.set('status', self.gds_format_string(self.status))
        if self.favorite_editor is not None:
            favorite_editor_ = self.favorite_editor
            etree_.SubElement(element, '{}favorite-editor').text = self.gds_format_string(favorite_editor_)
        if self.datetime1 is not None:
            datetime1_ = self.datetime1
            etree_.SubElement(element, '{}datetime1').text = self.gds_format_string(datetime1_)
        if self.datetime2 is not None:
            datetime2_ = self.datetime2
            etree_.SubElement(element, '{}datetime2').text = self.gds_format_string(datetime2_)
        if self.datetime3 is not None:
            datetime3_ = self.datetime3
            etree_.SubElement(element, '{}datetime3').text = self.gds_format_string(datetime3_)
        if self.datetime4 is not None:
            datetime4_ = self.datetime4
            etree_.SubElement(element, '{}datetime4').text = self.gds_format_string(datetime4_)
        if self.datetime5 is not None:
            datetime5_ = self.datetime5
            etree_.SubElement(element, '{}datetime5').text = self.gds_format_string(datetime5_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='java-programmerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.nick_name is not None and 'nick_name' not in already_processed:
            already_processed.add('nick_name')
            showIndent(outfile, level)
            outfile.write('nick_name="%s",\n' % (self.nick_name,))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        super(java_programmerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(java_programmerType, self).exportLiteralChildren(outfile, level, name_)
        if self.favorite_editor is not None:
            showIndent(outfile, level)
            outfile.write('favorite_editor=%s,\n' % self.gds_encode(quote_python(self.favorite_editor)))
        if self.datetime1 is not None:
            showIndent(outfile, level)
            outfile.write('datetime1=%s,\n' % self.gds_encode(quote_python(self.datetime1)))
        if self.datetime2 is not None:
            showIndent(outfile, level)
            outfile.write('datetime2=%s,\n' % self.gds_encode(quote_python(self.datetime2)))
        if self.datetime3 is not None:
            showIndent(outfile, level)
            outfile.write('datetime3=%s,\n' % self.gds_encode(quote_python(self.datetime3)))
        if self.datetime4 is not None:
            showIndent(outfile, level)
            outfile.write('datetime4=%s,\n' % self.gds_encode(quote_python(self.datetime4)))
        if self.datetime5 is not None:
            showIndent(outfile, level)
            outfile.write('datetime5=%s,\n' % self.gds_encode(quote_python(self.datetime5)))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nick-name', node)
        if value is not None and 'nick-name' not in already_processed:
            already_processed.add('nick-name')
            self.nick_name = value
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        super(java_programmerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'favorite-editor':
            favorite_editor_ = child_.text
            favorite_editor_ = self.gds_validate_string(favorite_editor_, node, 'favorite_editor')
            self.favorite_editor = favorite_editor_
        elif nodeName_ == 'datetime1':
            datetime1_ = child_.text
            datetime1_ = self.gds_validate_string(datetime1_, node, 'datetime1')
            self.datetime1 = datetime1_
        elif nodeName_ == 'datetime2':
            datetime2_ = child_.text
            datetime2_ = self.gds_validate_string(datetime2_, node, 'datetime2')
            self.datetime2 = datetime2_
        elif nodeName_ == 'datetime3':
            datetime3_ = child_.text
            datetime3_ = self.gds_validate_string(datetime3_, node, 'datetime3')
            self.datetime3 = datetime3_
        elif nodeName_ == 'datetime4':
            datetime4_ = child_.text
            datetime4_ = self.gds_validate_string(datetime4_, node, 'datetime4')
            self.datetime4 = datetime4_
        elif nodeName_ == 'datetime5':
            datetime5_ = child_.text
            datetime5_ = self.gds_validate_string(datetime5_, node, 'datetime5')
            self.datetime5 = datetime5_
        super(java_programmerType, self).buildChildren(child_, node, nodeName_, True)
# end class java_programmerType


class agentType(GeneratedsSuper):
    member_data_items_ = {
        'firstname': MemberSpec_('firstname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'firstname'}, None),
        'lastname': MemberSpec_('lastname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'lastname'}, None),
        'priority': MemberSpec_('priority', 'xs:float', 0, 1, {u'type': u'xs:float', u'name': u'priority', u'minOccurs': u'0'}, None),
        'info': MemberSpec_('info', 'infoType', 0, 0, {u'type': u'infoType', u'name': u'info'}, None),
        'vehicle': MemberSpec_('vehicle', 'vehicleType', 1, 1, {u'maxOccurs': u'unbounded', 'type': u'vehicle', u'ref': u'vehicle', 'name': u'vehicle', u'minOccurs': u'0'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, firstname=None, lastname=None, priority=None, info=None, vehicle=None, extensiontype_=None):
        self.original_tagname_ = None
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        self.info = info
        if vehicle is None:
            self.vehicle = []
        else:
            self.vehicle = vehicle
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, agentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if agentType.subclass:
            return agentType.subclass(*args_, **kwargs_)
        else:
            return agentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    firstnameProp = property(get_firstname, set_firstname)
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    lastnameProp = property(get_lastname, set_lastname)
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    priorityProp = property(get_priority, set_priority)
    def get_info(self): return self.info
    def set_info(self, info): self.info = info
    infoProp = property(get_info, set_info)
    def get_vehicle(self): return self.vehicle
    def set_vehicle(self, vehicle): self.vehicle = vehicle
    def add_vehicle(self, value): self.vehicle.append(value)
    def insert_vehicle_at(self, index, value): self.vehicle.insert(index, value)
    def replace_vehicle_at(self, index, value): self.vehicle[index] = value
    vehicleProp = property(get_vehicle, set_vehicle)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None or
            self.info is not None or
            self.vehicle
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='agentType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('agentType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='agentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='agentType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='agentType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='agentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.firstname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstname>%s</firstname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstname), input_name='firstname')), eol_))
        if self.lastname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastname>%s</lastname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastname), input_name='lastname')), eol_))
        if self.priority is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<priority>%s</priority>%s' % (self.gds_format_float(self.priority, input_name='priority'), eol_))
        if self.info is not None:
            self.info.export(outfile, level, namespace_, name_='info', pretty_print=pretty_print)
        for vehicle_ in self.vehicle:
            vehicle_.export(outfile, level, namespace_, name_='vehicle', pretty_print=pretty_print)
    def to_etree(self, parent_element=None, name_='agentType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.extensiontype_ is not None:
            element.set('{http://www.w3.org/2001/XMLSchema-instance}type', self.extensiontype_)
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.priority is not None:
            priority_ = self.priority
            etree_.SubElement(element, '{}priority').text = self.gds_format_float(priority_)
        if self.info is not None:
            info_ = self.info
            info_.to_etree(element, name_='info', mapping_=mapping_)
        for vehicle_ in self.vehicle:
            vehicle_.to_etree(element, name_='vehicle', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='agentType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('firstname=%s,\n' % self.gds_encode(quote_python(self.firstname)))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('lastname=%s,\n' % self.gds_encode(quote_python(self.lastname)))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority=%f,\n' % self.priority)
        if self.info is not None:
            showIndent(outfile, level)
            outfile.write('info=model_.infoType(\n')
            self.info.exportLiteral(outfile, level, name_='info')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('vehicle=[\n')
        level += 1
        for vehicle_ in self.vehicle:
            showIndent(outfile, level)
            outfile.write('model_.vehicle(\n')
            vehicle_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'priority')
            self.priority = fval_
        elif nodeName_ == 'info':
            obj_ = infoType.factory()
            obj_.build(child_)
            self.info = obj_
            obj_.original_tagname_ = 'info'
        elif nodeName_ == 'vehicle':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <vehicle> element')
            self.vehicle.append(obj_)
            obj_.original_tagname_ = 'vehicle'
# end class agentType


class special_agentType(agentType):
    """This is a good kind of agent for testing the generation of Python
    bindings for an XML schema."""
    member_data_items_ = {
        'firstname': MemberSpec_('firstname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'firstname'}, None),
        'lastname': MemberSpec_('lastname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'lastname'}, None),
        'priority': MemberSpec_('priority', 'xs:float', 0, 0, {u'type': u'xs:float', u'name': u'priority'}, None),
        'info': MemberSpec_('info', 'infoType', 0, 0, {u'type': u'infoType', u'name': u'info'}, None),
    }
    subclass = None
    superclass = agentType
    def __init__(self, firstname=None, lastname=None, priority=None, info=None, vehicle=None):
        self.original_tagname_ = None
        super(special_agentType, self).__init__(firstname, lastname, priority, info, vehicle, )
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        self.info = info
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, special_agentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if special_agentType.subclass:
            return special_agentType.subclass(*args_, **kwargs_)
        else:
            return special_agentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    firstnameProp = property(get_firstname, set_firstname)
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    lastnameProp = property(get_lastname, set_lastname)
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    priorityProp = property(get_priority, set_priority)
    def get_info(self): return self.info
    def set_info(self, info): self.info = info
    infoProp = property(get_info, set_info)
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None or
            self.info is not None or
            super(special_agentType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='special-agentType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('special-agentType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='special-agentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='special-agentType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='special-agentType'):
        super(special_agentType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='special-agentType')
    def exportChildren(self, outfile, level, namespace_='', name_='special-agentType', fromsubclass_=False, pretty_print=True):
        super(special_agentType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.firstname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstname>%s</firstname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstname), input_name='firstname')), eol_))
        if self.lastname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastname>%s</lastname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastname), input_name='lastname')), eol_))
        if self.priority is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<priority>%s</priority>%s' % (self.gds_format_float(self.priority, input_name='priority'), eol_))
        if self.info is not None:
            self.info.export(outfile, level, namespace_, name_='info', pretty_print=pretty_print)
    def to_etree(self, parent_element=None, name_='special-agentType', mapping_=None):
        element = super(special_agentType, self).to_etree(parent_element, name_, mapping_)
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.priority is not None:
            priority_ = self.priority
            etree_.SubElement(element, '{}priority').text = self.gds_format_float(priority_)
        if self.info is not None:
            info_ = self.info
            info_.to_etree(element, name_='info', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='special-agentType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(special_agentType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(special_agentType, self).exportLiteralChildren(outfile, level, name_)
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('firstname=%s,\n' % self.gds_encode(quote_python(self.firstname)))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('lastname=%s,\n' % self.gds_encode(quote_python(self.lastname)))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority=%f,\n' % self.priority)
        if self.info is not None:
            showIndent(outfile, level)
            outfile.write('info=model_.infoType(\n')
            self.info.exportLiteral(outfile, level, name_='info')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(special_agentType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'priority')
            self.priority = fval_
        elif nodeName_ == 'info':
            obj_ = infoType.factory()
            obj_.build(child_)
            self.info = obj_
            obj_.original_tagname_ = 'info'
        super(special_agentType, self).buildChildren(child_, node, nodeName_, True)
# end class special_agentType


class weird_agentType(agentType):
    """This is a good kind of agent for testing the generation of Python
    bindings for an XML schema."""
    member_data_items_ = {
        'firstname': MemberSpec_('firstname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'firstname'}, None),
        'lastname': MemberSpec_('lastname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'lastname'}, None),
        'priority': MemberSpec_('priority', 'xs:float', 0, 0, {u'type': u'xs:float', u'name': u'priority'}, None),
        'info': MemberSpec_('info', 'infoType', 0, 0, {u'type': u'infoType', u'name': u'info'}, None),
    }
    subclass = None
    superclass = agentType
    def __init__(self, firstname=None, lastname=None, priority=None, info=None, vehicle=None):
        self.original_tagname_ = None
        super(weird_agentType, self).__init__(firstname, lastname, priority, info, vehicle, )
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        self.info = info
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, weird_agentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if weird_agentType.subclass:
            return weird_agentType.subclass(*args_, **kwargs_)
        else:
            return weird_agentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    firstnameProp = property(get_firstname, set_firstname)
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    lastnameProp = property(get_lastname, set_lastname)
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    priorityProp = property(get_priority, set_priority)
    def get_info(self): return self.info
    def set_info(self, info): self.info = info
    infoProp = property(get_info, set_info)
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None or
            self.info is not None or
            super(weird_agentType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='weird-agentType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('weird-agentType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='weird-agentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='weird-agentType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='weird-agentType'):
        super(weird_agentType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='weird-agentType')
    def exportChildren(self, outfile, level, namespace_='', name_='weird-agentType', fromsubclass_=False, pretty_print=True):
        super(weird_agentType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.firstname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstname>%s</firstname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstname), input_name='firstname')), eol_))
        if self.lastname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastname>%s</lastname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastname), input_name='lastname')), eol_))
        if self.priority is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<priority>%s</priority>%s' % (self.gds_format_float(self.priority, input_name='priority'), eol_))
        if self.info is not None:
            self.info.export(outfile, level, namespace_, name_='info', pretty_print=pretty_print)
    def to_etree(self, parent_element=None, name_='weird-agentType', mapping_=None):
        element = super(weird_agentType, self).to_etree(parent_element, name_, mapping_)
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.priority is not None:
            priority_ = self.priority
            etree_.SubElement(element, '{}priority').text = self.gds_format_float(priority_)
        if self.info is not None:
            info_ = self.info
            info_.to_etree(element, name_='info', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='weird-agentType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(weird_agentType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(weird_agentType, self).exportLiteralChildren(outfile, level, name_)
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('firstname=%s,\n' % self.gds_encode(quote_python(self.firstname)))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('lastname=%s,\n' % self.gds_encode(quote_python(self.lastname)))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority=%f,\n' % self.priority)
        if self.info is not None:
            showIndent(outfile, level)
            outfile.write('info=model_.infoType(\n')
            self.info.exportLiteral(outfile, level, name_='info')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(weird_agentType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'priority')
            self.priority = fval_
        elif nodeName_ == 'info':
            obj_ = infoType.factory()
            obj_.build(child_)
            self.info = obj_
            obj_.original_tagname_ = 'info'
        super(weird_agentType, self).buildChildren(child_, node, nodeName_, True)
# end class weird_agentType


class boosterType(GeneratedsSuper):
    member_data_items_ = {
        'member-id': MemberSpec_('member-id', 'xs:string', 0, 1, {'use': 'optional'}),
        'firstname': MemberSpec_('firstname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'firstname'}, None),
        'lastname': MemberSpec_('lastname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'lastname'}, None),
        'other_name': MemberSpec_('other_name', 'xs:float', 0, 0, {u'type': u'xs:float', u'name': u'other-name'}, None),
        'class_': MemberSpec_('class_', 'xs:float', 0, 0, {u'type': u'xs:float', u'name': u'class'}, None),
        'other_value': MemberSpec_('other_value', 'xs:float', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'xs:float', u'name': u'other-value'}, None),
        'type_': MemberSpec_('type_', 'xs:float', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'xs:float', u'name': u'type'}, None),
        'client_handler': MemberSpec_('client_handler', 'client-handlerType', 1, 0, {u'maxOccurs': u'unbounded', u'type': u'client-handlerType', u'name': u'client-handler'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, member_id=None, firstname=None, lastname=None, other_name=None, class_=None, other_value=None, type_=None, client_handler=None):
        self.original_tagname_ = None
        self.member_id = _cast(None, member_id)
        self.firstname = firstname
        self.lastname = lastname
        self.other_name = other_name
        self.class_ = class_
        if other_value is None:
            self.other_value = []
        else:
            self.other_value = other_value
        if type_ is None:
            self.type_ = []
        else:
            self.type_ = type_
        if client_handler is None:
            self.client_handler = []
        else:
            self.client_handler = client_handler
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, boosterType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if boosterType.subclass:
            return boosterType.subclass(*args_, **kwargs_)
        else:
            return boosterType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    firstnameProp = property(get_firstname, set_firstname)
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    lastnameProp = property(get_lastname, set_lastname)
    def get_other_name(self): return self.other_name
    def set_other_name(self, other_name): self.other_name = other_name
    other_nameProp = property(get_other_name, set_other_name)
    def get_class(self): return self.class_
    def set_class(self, class_): self.class_ = class_
    classProp = property(get_class, set_class)
    def get_other_value(self): return self.other_value
    def set_other_value(self, other_value): self.other_value = other_value
    def add_other_value(self, value): self.other_value.append(value)
    def insert_other_value_at(self, index, value): self.other_value.insert(index, value)
    def replace_other_value_at(self, index, value): self.other_value[index] = value
    other_valueProp = property(get_other_value, set_other_value)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def add_type(self, value): self.type_.append(value)
    def insert_type_at(self, index, value): self.type_.insert(index, value)
    def replace_type_at(self, index, value): self.type_[index] = value
    typeProp = property(get_type, set_type)
    def get_client_handler(self): return self.client_handler
    def set_client_handler(self, client_handler): self.client_handler = client_handler
    def add_client_handler(self, value): self.client_handler.append(value)
    def insert_client_handler_at(self, index, value): self.client_handler.insert(index, value)
    def replace_client_handler_at(self, index, value): self.client_handler[index] = value
    client_handlerProp = property(get_client_handler, set_client_handler)
    def get_member_id(self): return self.member_id
    def set_member_id(self, member_id): self.member_id = member_id
    member_idProp = property(get_member_id, set_member_id)
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.other_name is not None or
            self.class_ is not None or
            self.other_value or
            self.type_ or
            self.client_handler
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='boosterType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('boosterType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='boosterType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='boosterType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='boosterType'):
        if self.member_id is not None and 'member_id' not in already_processed:
            already_processed.add('member_id')
            outfile.write(' member-id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.member_id), input_name='member-id')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='boosterType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.firstname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstname>%s</firstname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstname), input_name='firstname')), eol_))
        if self.lastname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastname>%s</lastname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastname), input_name='lastname')), eol_))
        if self.other_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<other-name>%s</other-name>%s' % (self.gds_format_float(self.other_name, input_name='other-name'), eol_))
        if self.class_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<class>%s</class>%s' % (self.gds_format_float(self.class_, input_name='class'), eol_))
        for other_value_ in self.other_value:
            showIndent(outfile, level, pretty_print)
            outfile.write('<other-value>%s</other-value>%s' % (self.gds_format_float(other_value_, input_name='other-value'), eol_))
        for type_ in self.type_:
            showIndent(outfile, level, pretty_print)
            outfile.write('<type>%s</type>%s' % (self.gds_format_float(type_, input_name='type'), eol_))
        for client_handler_ in self.client_handler:
            client_handler_.export(outfile, level, namespace_, name_='client-handler', pretty_print=pretty_print)
    def to_etree(self, parent_element=None, name_='boosterType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.member_id is not None:
            element.set('member-id', self.gds_format_string(self.member_id))
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.other_name is not None:
            other_name_ = self.other_name
            etree_.SubElement(element, '{}other-name').text = self.gds_format_float(other_name_)
        if self.class_ is not None:
            class__ = self.class_
            etree_.SubElement(element, '{}class').text = self.gds_format_float(class__)
        for other_value_ in self.other_value:
            etree_.SubElement(element, '{}other-value').text = self.gds_format_float(other_value_)
        for type__ in self.type_:
            etree_.SubElement(element, '{}type').text = self.gds_format_float(type__)
        for client_handler_ in self.client_handler:
            client_handler_.to_etree(element, name_='client-handler', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='boosterType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.member_id is not None and 'member_id' not in already_processed:
            already_processed.add('member_id')
            showIndent(outfile, level)
            outfile.write('member_id="%s",\n' % (self.member_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('firstname=%s,\n' % self.gds_encode(quote_python(self.firstname)))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('lastname=%s,\n' % self.gds_encode(quote_python(self.lastname)))
        if self.other_name is not None:
            showIndent(outfile, level)
            outfile.write('other_name=%f,\n' % self.other_name)
        if self.class_ is not None:
            showIndent(outfile, level)
            outfile.write('class_=%f,\n' % self.class_)
        showIndent(outfile, level)
        outfile.write('other_value=[\n')
        level += 1
        for other_value_ in self.other_value:
            showIndent(outfile, level)
            outfile.write('%f,\n' % other_value_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('type_=[\n')
        level += 1
        for type_ in self.type_:
            showIndent(outfile, level)
            outfile.write('%f,\n' % type_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('client_handler=[\n')
        level += 1
        for client_handler_ in self.client_handler:
            showIndent(outfile, level)
            outfile.write('model_.client_handlerType(\n')
            client_handler_.exportLiteral(outfile, level, name_='client-handlerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('member-id', node)
        if value is not None and 'member-id' not in already_processed:
            already_processed.add('member-id')
            self.member_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'other-name':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'other_name')
            self.other_name = fval_
        elif nodeName_ == 'class':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'class')
            self.class_ = fval_
        elif nodeName_ == 'other-value':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'other_value')
            self.other_value.append(fval_)
        elif nodeName_ == 'type':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'type')
            self.type_.append(fval_)
        elif nodeName_ == 'client-handler':
            obj_ = client_handlerType.factory()
            obj_.build(child_)
            self.client_handler.append(obj_)
            obj_.original_tagname_ = 'client-handler'
# end class boosterType


class infoType(GeneratedsSuper):
    member_data_items_ = {
        'name': MemberSpec_('name', 'xs:string', 0, 1, {'use': 'optional'}),
        'type_': MemberSpec_('type_', 'xs:integer', 0, 1, {'use': 'optional'}),
        'rating': MemberSpec_('rating', 'xs:float', 0, 1, {'use': 'optional'}),
    }
    subclass = None
    superclass = None
    def __init__(self, name=None, type_=None, rating=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.type_ = _cast(int, type_)
        self.rating = _cast(float, rating)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, infoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if infoType.subclass:
            return infoType.subclass(*args_, **kwargs_)
        else:
            return infoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    typeProp = property(get_type, set_type)
    def get_rating(self): return self.rating
    def set_rating(self, rating): self.rating = rating
    ratingProp = property(get_rating, set_rating)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='infoType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('infoType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='infoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='infoType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='infoType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type="%s"' % self.gds_format_integer(self.type_, input_name='type'))
        if self.rating is not None and 'rating' not in already_processed:
            already_processed.add('rating')
            outfile.write(' rating="%s"' % self.gds_format_float(self.rating, input_name='rating'))
    def exportChildren(self, outfile, level, namespace_='', name_='infoType', fromsubclass_=False, pretty_print=True):
        pass
    def to_etree(self, parent_element=None, name_='infoType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.name is not None:
            element.set('name', self.gds_format_string(self.name))
        if self.type_ is not None:
            element.set('type', self.gds_format_integer(self.type_))
        if self.rating is not None:
            element.set('rating', self.gds_format_float(self.rating))
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='infoType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_=%d,\n' % (self.type_,))
        if self.rating is not None and 'rating' not in already_processed:
            already_processed.add('rating')
            showIndent(outfile, level)
            outfile.write('rating=%f,\n' % (self.rating,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            try:
                self.type_ = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('rating', node)
        if value is not None and 'rating' not in already_processed:
            already_processed.add('rating')
            try:
                self.rating = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (rating): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class infoType


class vehicleType(GeneratedsSuper):
    member_data_items_ = {
        'wheelcount': MemberSpec_('wheelcount', 'xs:integer', 0, 0, {u'type': u'xs:integer', u'name': u'wheelcount'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, wheelcount=None, extensiontype_=None):
        self.original_tagname_ = None
        self.wheelcount = wheelcount
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, vehicleType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if vehicleType.subclass:
            return vehicleType.subclass(*args_, **kwargs_)
        else:
            return vehicleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_wheelcount(self): return self.wheelcount
    def set_wheelcount(self, wheelcount): self.wheelcount = wheelcount
    wheelcountProp = property(get_wheelcount, set_wheelcount)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.wheelcount is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='vehicleType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('vehicleType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='vehicleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='vehicleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='vehicleType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='vehicleType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.wheelcount is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<wheelcount>%s</wheelcount>%s' % (self.gds_format_integer(self.wheelcount, input_name='wheelcount'), eol_))
    def to_etree(self, parent_element=None, name_='vehicleType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.extensiontype_ is not None:
            element.set('{http://www.w3.org/2001/XMLSchema-instance}type', self.extensiontype_)
        if self.wheelcount is not None:
            wheelcount_ = self.wheelcount
            etree_.SubElement(element, '{}wheelcount').text = self.gds_format_integer(wheelcount_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='vehicleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.wheelcount is not None:
            showIndent(outfile, level)
            outfile.write('wheelcount=%d,\n' % self.wheelcount)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'wheelcount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'wheelcount')
            self.wheelcount = ival_
# end class vehicleType


class automobile(vehicleType):
    member_data_items_ = {
        'drivername': MemberSpec_('drivername', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'drivername'}, None),
    }
    subclass = None
    superclass = vehicleType
    def __init__(self, wheelcount=None, drivername=None):
        self.original_tagname_ = None
        super(automobile, self).__init__(wheelcount, )
        self.drivername = drivername
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, automobile)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if automobile.subclass:
            return automobile.subclass(*args_, **kwargs_)
        else:
            return automobile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_drivername(self): return self.drivername
    def set_drivername(self, drivername): self.drivername = drivername
    drivernameProp = property(get_drivername, set_drivername)
    def hasContent_(self):
        if (
            self.drivername is not None or
            super(automobile, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='automobile', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('automobile')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='automobile')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='automobile', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='automobile'):
        super(automobile, self).exportAttributes(outfile, level, already_processed, namespace_, name_='automobile')
    def exportChildren(self, outfile, level, namespace_='', name_='automobile', fromsubclass_=False, pretty_print=True):
        super(automobile, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.drivername is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<drivername>%s</drivername>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.drivername), input_name='drivername')), eol_))
    def to_etree(self, parent_element=None, name_='automobile', mapping_=None):
        element = super(automobile, self).to_etree(parent_element, name_, mapping_)
        if self.drivername is not None:
            drivername_ = self.drivername
            etree_.SubElement(element, '{}drivername').text = self.gds_format_string(drivername_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='automobile'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(automobile, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(automobile, self).exportLiteralChildren(outfile, level, name_)
        if self.drivername is not None:
            showIndent(outfile, level)
            outfile.write('drivername=%s,\n' % self.gds_encode(quote_python(self.drivername)))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(automobile, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'drivername':
            drivername_ = child_.text
            drivername_ = self.gds_validate_string(drivername_, node, 'drivername')
            self.drivername = drivername_
        super(automobile, self).buildChildren(child_, node, nodeName_, True)
# end class automobile


class hot_agent(GeneratedsSuper):
    member_data_items_ = {
        'firstname': MemberSpec_('firstname', 'xs:string', 0, 0, {u'default': u'empty\\name', u'type': u'xs:string', u'name': u'firstname'}, None),
        'lastname': MemberSpec_('lastname', 'xs:string', 0, 0, {u'default': u"no 'last' name", u'type': u'xs:string', u'name': u'lastname'}, None),
        'priority': MemberSpec_('priority', 'xs:float', 0, 0, {u'type': u'xs:float', u'name': u'priority'}, None),
        'startDate': MemberSpec_('startDate', 'xs:date', 0, 0, {u'type': u'xs:date', u'name': u'startDate'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, firstname='empty\\name', lastname='no \'last\' name', priority=None, startDate=None):
        self.original_tagname_ = None
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        if isinstance(startDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(startDate, '%Y-%m-%d').date()
        else:
            initvalue_ = startDate
        self.startDate = initvalue_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, hot_agent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if hot_agent.subclass:
            return hot_agent.subclass(*args_, **kwargs_)
        else:
            return hot_agent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    firstnameProp = property(get_firstname, set_firstname)
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    lastnameProp = property(get_lastname, set_lastname)
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    priorityProp = property(get_priority, set_priority)
    def get_startDate(self): return self.startDate
    def set_startDate(self, startDate): self.startDate = startDate
    startDateProp = property(get_startDate, set_startDate)
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.firstname != "empty\name" or
            self.lastname != "no 'last' name" or
            self.priority is not None or
            self.startDate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='hot.agent', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('hot.agent')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='hot.agent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='hot.agent', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='hot.agent'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' %d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='hot.agent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.firstname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstname>%s</firstname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstname), input_name='firstname')), eol_))
        if self.lastname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastname>%s</lastname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastname), input_name='lastname')), eol_))
        if self.priority is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<priority>%s</priority>%s' % (self.gds_format_float(self.priority, input_name='priority'), eol_))
        if self.startDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<startDate>%s</startDate>%s' % (self.gds_format_date(self.startDate, input_name='startDate'), eol_))
    def to_etree(self, parent_element=None, name_='hot.agent', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.priority is not None:
            priority_ = self.priority
            etree_.SubElement(element, '{}priority').text = self.gds_format_float(priority_)
        if self.startDate is not None:
            startDate_ = self.startDate
            etree_.SubElement(element, '{}startDate').text = self.gds_format_date(startDate_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='hot.agent'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('firstname=%s,\n' % self.gds_encode(quote_python(self.firstname)))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('lastname=%s,\n' % self.gds_encode(quote_python(self.lastname)))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority=%f,\n' % self.priority)
        if self.startDate is not None:
            showIndent(outfile, level)
            outfile.write('startDate=model_.GeneratedsSuper.gds_parse_date("%s"),\n' % self.gds_format_date(self.startDate, input_name='startDate'))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'priority')
            self.priority = fval_
        elif nodeName_ == 'startDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.startDate = dval_
# end class hot_agent


class airplane(vehicleType):
    member_data_items_ = {
        'pilotname': MemberSpec_('pilotname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'pilotname'}, None),
    }
    subclass = None
    superclass = vehicleType
    def __init__(self, wheelcount=None, pilotname=None):
        self.original_tagname_ = None
        super(airplane, self).__init__(wheelcount, )
        self.pilotname = pilotname
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, airplane)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if airplane.subclass:
            return airplane.subclass(*args_, **kwargs_)
        else:
            return airplane(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_pilotname(self): return self.pilotname
    def set_pilotname(self, pilotname): self.pilotname = pilotname
    pilotnameProp = property(get_pilotname, set_pilotname)
    def hasContent_(self):
        if (
            self.pilotname is not None or
            super(airplane, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='airplane', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('airplane')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='airplane')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='airplane', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='airplane'):
        super(airplane, self).exportAttributes(outfile, level, already_processed, namespace_, name_='airplane')
    def exportChildren(self, outfile, level, namespace_='', name_='airplane', fromsubclass_=False, pretty_print=True):
        super(airplane, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.pilotname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<pilotname>%s</pilotname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.pilotname), input_name='pilotname')), eol_))
    def to_etree(self, parent_element=None, name_='airplane', mapping_=None):
        element = super(airplane, self).to_etree(parent_element, name_, mapping_)
        if self.pilotname is not None:
            pilotname_ = self.pilotname
            etree_.SubElement(element, '{}pilotname').text = self.gds_format_string(pilotname_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='airplane'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(airplane, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(airplane, self).exportLiteralChildren(outfile, level, name_)
        if self.pilotname is not None:
            showIndent(outfile, level)
            outfile.write('pilotname=%s,\n' % self.gds_encode(quote_python(self.pilotname)))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(airplane, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pilotname':
            pilotname_ = child_.text
            pilotname_ = self.gds_validate_string(pilotname_, node, 'pilotname')
            self.pilotname = pilotname_
        super(airplane, self).buildChildren(child_, node, nodeName_, True)
# end class airplane


class client_handlerType(GeneratedsSuper):
    member_data_items_ = {
        'fullname': MemberSpec_('fullname', 'xs:string', 0, 0, {u'type': u'xs:string', u'name': u'fullname'}, None),
        'refid': MemberSpec_('refid', 'xs:integer', 0, 0, {u'type': u'xs:integer', u'name': u'refid'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, fullname=None, refid=None):
        self.original_tagname_ = None
        self.fullname = fullname
        self.refid = refid
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, client_handlerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if client_handlerType.subclass:
            return client_handlerType.subclass(*args_, **kwargs_)
        else:
            return client_handlerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fullname(self): return self.fullname
    def set_fullname(self, fullname): self.fullname = fullname
    fullnameProp = property(get_fullname, set_fullname)
    def get_refid(self): return self.refid
    def set_refid(self, refid): self.refid = refid
    refidProp = property(get_refid, set_refid)
    def hasContent_(self):
        if (
            self.fullname is not None or
            self.refid is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='client-handlerType', namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('client-handlerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='client-handlerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='client-handlerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='client-handlerType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='client-handlerType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.fullname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<fullname>%s</fullname>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.fullname), input_name='fullname')), eol_))
        if self.refid is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<refid>%s</refid>%s' % (self.gds_format_integer(self.refid, input_name='refid'), eol_))
    def to_etree(self, parent_element=None, name_='client-handlerType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.fullname is not None:
            fullname_ = self.fullname
            etree_.SubElement(element, '{}fullname').text = self.gds_format_string(fullname_)
        if self.refid is not None:
            refid_ = self.refid
            etree_.SubElement(element, '{}refid').text = self.gds_format_integer(refid_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def exportLiteral(self, outfile, level, name_='client-handlerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.fullname is not None:
            showIndent(outfile, level)
            outfile.write('fullname=%s,\n' % self.gds_encode(quote_python(self.fullname)))
        if self.refid is not None:
            showIndent(outfile, level)
            outfile.write('refid=%d,\n' % self.refid)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fullname':
            fullname_ = child_.text
            fullname_ = self.gds_validate_string(fullname_, node, 'fullname')
            self.fullname = fullname_
        elif nodeName_ == 'refid':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'refid')
            self.refid = ival_
# end class client_handlerType


GDSClassesMapping = {
    'agent': agentType,
    'booster': boosterType,
    'comments': commentsType,
    'info': infoType,
    'java-programmer': java_programmerType,
    'param': paramType,
    'people': peopleType,
    'person': personType,
    'programmer': programmerType,
    'python-programmer': python_programmerType,
    'special-agent': special_agentType,
    'vehicle': vehicleType,
    'weird-agent': weird_agentType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'peopleType'
        rootClass = peopleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'peopleType'
        rootClass = peopleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    '''Parse a string, create the object tree, and export it.

    Arguments:
    - inString -- A string.  This XML fragment should not start
      with an XML declaration containing an encoding.
    - silence -- A boolean.  If False, export the object.
    Returns -- The root object in the tree.
    '''
    parser = None
    rootNode= parsexmlstring_(inString, parser)
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'peopleType'
        rootClass = peopleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:pl="http://kuhlman.com/people.xsd"')
    return rootObj


def parseLiteral(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'peopleType'
        rootClass = peopleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from peoplesup import *\n\n')
        sys.stdout.write('import peoplesup as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "agentType",
    "airplane",
    "automobile",
    "boosterType",
    "client_handlerType",
    "commentsType",
    "hot_agent",
    "infoType",
    "java_programmerType",
    "paramType",
    "peopleType",
    "personType",
    "programmerType",
    "python_programmerType",
    "special_agentType",
    "specialperson",
    "vehicleType",
    "weird_agentType"
]
