/*
 * Gearsystem - Sega Master System / Game Gear Emulator
 * Copyright (C) 2013  Ignacio Sanchez

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/ 
 * 
 */

#ifndef OPCODEXX_NAMES_H
#define	OPCODEXX_NAMES_H

static stOPCodeInfo kOPCodeNames[256] = {
    { "NOP", 1, 0 },
    { "LD BC,$%04X", 3, 3 },
    { "LD (BC),A", 1, 0 },
    { "INC BC", 1, 0 },
    { "INC B", 1, 0 },
    { "DEC B", 1, 0 },
    { "LD B,$%02X", 2, 2 },
    { "RLCA", 1, 0 },
    { "EX AF,AF'", 1, 0 },
    { "ADD HL,BC", 1, 0 },
    { "LD A,(BC)", 1, 0 },
    { "DEC BC", 1, 0 },
    { "INC C", 1, 0 },
    { "DEC C", 1, 0 },
    { "LD C,$%02X", 2, 2 },
    { "RRCA", 1, 0 },

    { "DJNZ $%04X  [%+d]", 2, 5 },
    { "LD DE,$%04X", 3, 3 },
    { "LD (DE),A", 1, 0 },
    { "INC DE", 1, 0 },
    { "INC D", 1, 0 },
    { "DEC D", 1, 0 },
    { "LD D,$%02X", 2, 2 },
    { "RLA", 1, 0 },
    { "JR $%04X  [%+d]", 2, 5 },
    { "ADD HL,DE", 1, 0 },
    { "LD A,(DE)", 1, 0 },
    { "DEC DE", 1, 0 },
    { "INC E", 1, 0 },
    { "DEC E", 1, 0 },
    { "LD E,$%02X", 2, 2 },
    { "RRA", 1, 0 },

    { "JR NZ,$%04X  [%+d]", 2, 5 },
    { "LD HL,$%04X", 3, 3 },
    { "LD ($%04X),HL", 3, 3 },
    { "INC HL", 1, 0 },
    { "INC H", 1, 0 },
    { "DEC H", 1, 0 },
    { "LD H,$%02X", 2, 2 },
    { "DAA", 1, 0 },
    { "JR Z,$%04X  [%+d]", 2, 5 },
    { "ADD HL,HL", 1, 0 },
    { "LD HL,($%04X)", 3, 3 },
    { "DEC HL", 1, 0 },
    { "INC L", 1, 0 },
    { "DEC L", 1, 0 },
    { "LD L,$%02X", 2, 2 },
    { "CPL", 1, 0 },

    { "JR NC,$%04X  [%+d]", 2, 5 },
    { "LD SP,$%04X", 3, 3 },
    { "LD ($%04X),A", 3, 3 },
    { "INC SP", 1, 0 },
    { "INC (HL)", 1, 0 },
    { "DEC (HL)", 1, 0 },
    { "LD (HL),$%02X", 2, 2 },
    { "SCF", 1, 0 },
    { "JR C,$%04X  [%+d]", 2, 5 },
    { "ADD HL,SP", 1, 0 },
    { "LD A,($%04X)", 3, 3 },
    { "DEC SP", 1, 0 },
    { "INC A", 1, 0 },
    { "DEC A", 1, 0 },
    { "LD A,$%02X", 2, 2 },
    { "CCF", 1, 0 },

    { "LD B,B", 1, 0 },
    { "LD B,C", 1, 0 },
    { "LD B,D", 1, 0 },
    { "LD B,E", 1, 0 },
    { "LD B,H", 1, 0 },
    { "LD B,L", 1, 0 },
    { "LD B,(HL)", 1, 0 },
    { "LD B,A", 1, 0 },
    { "LD C,B", 1, 0 },
    { "LD C,C", 1, 0 },
    { "LD C,D", 1, 0 },
    { "LD C,E", 1, 0 },
    { "LD C,H", 1, 0 },
    { "LD C,L", 1, 0 },
    { "LD C,(HL)", 1, 0 },
    { "LD C,A", 1, 0 },

    { "LD D,B", 1, 0 },
    { "LD D,C", 1, 0 },
    { "LD D,D", 1, 0 },
    { "LD D,E", 1, 0 },
    { "LD D,H", 1, 0 },
    { "LD D,L", 1, 0 },
    { "LD D,(HL)", 1, 0 },
    { "LD D,A", 1, 0 },
    { "LD E,B", 1, 0 },
    { "LD E,C", 1, 0 },
    { "LD E,D", 1, 0 },
    { "LD E,E", 1, 0 },
    { "LD E,H", 1, 0 },
    { "LD E,L", 1, 0 },
    { "LD E,(HL)", 1, 0 },
    { "LD E,A", 1, 0 },

    { "LD H,B", 1, 0 },
    { "LD H,C", 1, 0 },
    { "LD H,D", 1, 0 },
    { "LD H,E", 1, 0 },
    { "LD H,H", 1, 0 },
    { "LD H,L", 1, 0 },
    { "LD H,(HL)", 1, 0 },
    { "LD H,A", 1, 0 },
    { "LD L,B", 1, 0 },
    { "LD L,C", 1, 0 },
    { "LD L,D", 1, 0 },
    { "LD L,E", 1, 0 },
    { "LD L,H", 1, 0 },
    { "LD L,L", 1, 0 },
    { "LD L,(HL)", 1, 0 },
    { "LD L,A", 1, 0 },

    { "LD (HL),B", 1, 0 },
    { "LD (HL),C", 1, 0 },
    { "LD (HL),D", 1, 0 },
    { "LD (HL),E", 1, 0 },
    { "LD (HL),H", 1, 0 },
    { "LD (HL),L", 1, 0 },
    { "HALT", 1, 0 },
    { "LD (HL),A", 1, 0 },
    { "LD A,B", 1, 0 },
    { "LD A,C", 1, 0 },
    { "LD A,D", 1, 0 },
    { "LD A,E", 1, 0 },
    { "LD A,H", 1, 0 },
    { "LD A,L", 1, 0 },
    { "LD A,(HL)", 1, 0 },
    { "LD A,A", 1, 0 },

    { "ADD A,B", 1, 0 },
    { "ADD A,C", 1, 0 },
    { "ADD A,D", 1, 0 },
    { "ADD A,E", 1, 0 },
    { "ADD A,H", 1, 0 },
    { "ADD A,L", 1, 0 },
    { "ADD A,(HL)", 1, 0 },
    { "ADD A,A", 1, 0 },
    { "ADC A,B", 1, 0 },
    { "ADC A,C", 1, 0 },
    { "ADC A,D", 1, 0 },
    { "ADC A,E", 1, 0 },
    { "ADC A,H", 1, 0 },
    { "ADC A,L", 1, 0 },
    { "ADC A,(HL)", 1, 0 },
    { "ADC A,A", 1, 0 },

    { "SUB B", 1, 0 },
    { "SUB C", 1, 0 },
    { "SUB D", 1, 0 },
    { "SUB E", 1, 0 },
    { "SUB H", 1, 0 },
    { "SUB L", 1, 0 },
    { "SUB (HL)", 1, 0 },
    { "SUB A", 1, 0 },
    { "SBC A,B", 1, 0 },
    { "SBC A,C", 1, 0 },
    { "SBC A,D", 1, 0 },
    { "SBC A,E", 1, 0 },
    { "SBC A,H", 1, 0 },
    { "SBC A,L", 1, 0 },
    { "SBC A,(HL)", 1, 0 },
    { "SBC A,A", 1, 0 },

    { "AND B", 1, 0 },
    { "AND C", 1, 0 },
    { "AND D", 1, 0 },
    { "AND E", 1, 0 },
    { "AND H", 1, 0 },
    { "AND L", 1, 0 },
    { "AND (HL)", 1, 0 },
    { "AND A", 1, 0 },
    { "XOR B", 1, 0 },
    { "XOR C", 1, 0 },
    { "XOR D", 1, 0 },
    { "XOR E", 1, 0 },
    { "XOR H", 1, 0 },
    { "XOR L", 1, 0 },
    { "XOR (HL)", 1, 0 },
    { "XOR A", 1, 0 },

    { "OR B", 1, 0 },
    { "OR C", 1, 0 },
    { "OR D", 1, 0 },
    { "OR E", 1, 0 },
    { "OR H", 1, 0 },
    { "OR L", 1, 0 },
    { "OR (HL)", 1, 0 },
    { "OR A", 1, 0 },
    { "CP B", 1, 0 },
    { "CP C", 1, 0 },
    { "CP D", 1, 0 },
    { "CP E", 1, 0 },
    { "CP H", 1, 0 },
    { "CP L", 1, 0 },
    { "CP (HL)", 1, 0 },
    { "CP A", 1, 0 },

    { "RET NZ", 1, 0 },
    { "POP BC", 1, 0 },
    { "JP NZ,$%04X", 3, 3 },
    { "JP $%04X", 3, 3 },
    { "CALL NZ,$%04X", 3, 3 },
    { "PUSH BC", 1, 0 },
    { "ADD A,$%02X", 2, 2 },
    { "RST ", 1, 0 },
    { "RET Z", 1, 0 },
    { "RET", 1, 0 },
    { "JP Z,$%04X", 3, 3 },
    { "CB PREFIX", 1, 0 },
    { "CALL Z,$%04X", 3, 3 },
    { "CALL $%04X", 3, 3 },
    { "ADC A,$%02X", 2, 2 },
    { "RST 08H", 1, 0 },

    { "RET NC", 1, 0 },
    { "POP DE", 1, 0 },
    { "JP NC,$%04X", 3, 3 },
    { "OUT ($%02X),A", 2, 2 },
    { "CALL NC,$%04X", 3, 3 },
    { "PUSH DE", 1, 0 },
    { "SUB $%02X", 2, 2 },
    { "RST 10H", 1, 0 },
    { "RET C", 1, 0 },
    { "EXX", 1, 0 },
    { "JP C,$%04X", 3, 3 },
    { "IN A,($%02X)", 2, 2 },
    { "CALL C,$%04X", 3, 3 },
    { "DD PREFIX", 1, 0 },
    { "SBC A,$%02X", 2, 2 },
    { "RST 18H", 1, 0 },

    { "RET PO", 1, 0 },
    { "POP HL", 1, 0 },
    { "JP PO,$%04X", 3, 3 },
    { "EX (SP),HL", 1, 0 },
    { "CALL PO,$%04X", 3, 3 },
    { "PUSH HL", 1, 0 },
    { "AND $%02X", 2, 2 },
    { "RST 20H", 1, 0 },
    { "RET PE", 1, 0 },
    { "JP (HL)", 1, 0 },
    { "JP PE,$%04X", 3, 3 },
    { "EX DE,HL", 1, 0 },
    { "CALL PE,$%04X", 3, 3 },
    { "ED PREFIX", 1, 0 },
    { "XOR $%02X", 2, 2 },
    { "RST 28H", 1, 0 },

    { "RET P", 1, 0 },
    { "POP AF", 1, 0 },
    { "JP P,$%04X", 3, 3 },
    { "DI", 1, 0 },
    { "CALL P,$%04X", 3, 3 },
    { "PUSH AF", 1, 0 },
    { "OR $%02X", 2, 2 },
    { "RST 30H", 1, 0 },
    { "RET M", 1, 0 },
    { "LD SP,HL", 1, 0 },
    { "JP M,$%04X", 3, 3 },
    { "EI", 1, 0 },
    { "CALL M,$%04X", 3, 3 },
    { "FD PREFIX", 1, 0 },
    { "CP $%02X", 2, 2 },
    { "RST 38H", 1, 0 }
};

#endif	/* OPCODEXX_NAMES_H */

