/*
 * Gearsystem - Sega Master System / Game Gear Emulator
 * Copyright (C) 2013  Ignacio Sanchez

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/ 
 * 
 */

#ifndef OPCODEDDCB_NAMES_H
#define	OPCODEDDCB_NAMES_H

static stOPCodeInfo kOPCodeDDCBNames[256] = {
    { "RLC (IX%+d),B [UNDOC]", 4, 1 },
    { "RLC (IX%+d),C [UNDOC]", 4, 1 },
    { "RLC (IX%+d),D [UNDOC]", 4, 1 },
    { "RLC (IX%+d),E [UNDOC]", 4, 1 },
    { "RLC (IX%+d),H [UNDOC]", 4, 1 },
    { "RLC (IX%+d),L [UNDOC]", 4, 1 },
    { "RLC (IX%+d)", 4, 1 },
    { "RLC (IX%+d),A [UNDOC]", 4, 1 },
    { "RRC (IX%+d),B [UNDOC]", 4, 1 },
    { "RRC (IX%+d),C [UNDOC]", 4, 1 },
    { "RRC (IX%+d),D [UNDOC]", 4, 1 },
    { "RRC (IX%+d),E [UNDOC]", 4, 1 },
    { "RRC (IX%+d),H [UNDOC]", 4, 1 },
    { "RRC (IX%+d),L [UNDOC]", 4, 1 },
    { "RRC (IX%+d)", 4, 1 },
    { "RRC (IX%+d),A [UNDOC]", 4, 1 },

    { "RL (IX%+d),B [UNDOC]", 4, 1 },
    { "RL (IX%+d),C [UNDOC]", 4, 1 },
    { "RL (IX%+d),D [UNDOC]", 4, 1 },
    { "RL (IX%+d),E [UNDOC]", 4, 1 },
    { "RL (IX%+d),H [UNDOC]", 4, 1 },
    { "RL (IX%+d),L [UNDOC]", 4, 1 },
    { "RL (IX%+d)", 4, 1 },
    { "RL (IX%+d),A [UNDOC]", 4, 1 },
    { "RR (IX%+d),B [UNDOC]", 4, 1 },
    { "RR (IX%+d),C [UNDOC]", 4, 1 },
    { "RR (IX%+d),D [UNDOC]", 4, 1 },
    { "RR (IX%+d),E [UNDOC]", 4, 1 },
    { "RR (IX%+d),H [UNDOC]", 4, 1 },
    { "RR (IX%+d),L [UNDOC]", 4, 1 },
    { "RR (IX%+d)", 4, 1 },
    { "RR (IX%+d),A [UNDOC]", 4, 1 },

    { "SLA (IX%+d),B [UNDOC]", 4, 1 },
    { "SLA (IX%+d),C [UNDOC]", 4, 1 },
    { "SLA (IX%+d),D [UNDOC]", 4, 1 },
    { "SLA (IX%+d),E [UNDOC]", 4, 1 },
    { "SLA (IX%+d),H [UNDOC]", 4, 1 },
    { "SLA (IX%+d),L [UNDOC]", 4, 1 },
    { "SLA (IX%+d)", 4, 1 },
    { "SLA (IX%+d),A [UNDOC]", 4, 1 },
    { "SRA (IX%+d),B [UNDOC]", 4, 1 },
    { "SRA (IX%+d),C [UNDOC]", 4, 1 },
    { "SRA (IX%+d),D [UNDOC]", 4, 1 },
    { "SRA (IX%+d),E [UNDOC]", 4, 1 },
    { "SRA (IX%+d),H [UNDOC]", 4, 1 },
    { "SRA (IX%+d),L [UNDOC]", 4, 1 },
    { "SRA (IX%+d)", 4, 1 },
    { "SRA (IX%+d),A [UNDOC]", 4, 1 },

    { "SLL (IX%+d),B [UNDOC]", 4, 1 },
    { "SLL (IX%+d),C [UNDOC]", 4, 1 },
    { "SLL (IX%+d),D [UNDOC]", 4, 1 },
    { "SLL (IX%+d),E [UNDOC]", 4, 1 },
    { "SLL (IX%+d),H [UNDOC]", 4, 1 },
    { "SLL (IX%+d),L [UNDOC]", 4, 1 },
    { "SLL (IX%+d) [UNDOC]", 4, 1 },
    { "SLL (IX%+d),A [UNDOC]", 4, 1 },
    { "SRL (IX%+d),B [UNDOC]", 4, 1 },
    { "SRL (IX%+d),C [UNDOC]", 4, 1 },
    { "SRL (IX%+d),D [UNDOC]", 4, 1 },
    { "SRL (IX%+d),E [UNDOC]", 4, 1 },
    { "SRL (IX%+d),H [UNDOC]", 4, 1 },
    { "SRL (IX%+d),L [UNDOC]", 4, 1 },
    { "SRL (IX%+d)", 4, 1 },
    { "SRL (IX%+d),A [UNDOC]", 4, 1 },

    { "BIT 0,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IX%+d)", 4, 1 },
    { "BIT 0,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IX%+d)", 4, 1 },
    { "BIT 1,(IX%+d) [UNDOC]", 4, 1 },

    { "BIT 2,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IX%+d)", 4, 1 },
    { "BIT 2,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IX%+d)", 4, 1 },
    { "BIT 3,(IX%+d) [UNDOC]", 4, 1 },

    { "BIT 4,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IX%+d)", 4, 1 },
    { "BIT 4,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IX%+d)", 4, 1 },
    { "BIT 5,(IX%+d) [UNDOC]", 4, 1 },

    { "BIT 6,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IX%+d)", 4, 1 },
    { "BIT 6,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IX%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IX%+d)", 4, 1 },
    { "BIT 7,(IX%+d) [UNDOC]", 4, 1 },

    { "RES 0,(IX%+d),B [UNDOC]", 4, 1 },
    { "RES 0,(IX%+d),C [UNDOC]", 4, 1 },
    { "RES 0,(IX%+d),D [UNDOC]", 4, 1 },
    { "RES 0,(IX%+d),E [UNDOC]", 4, 1 },
    { "RES 0,(IX%+d),H [UNDOC]", 4, 1 },
    { "RES 0,(IX%+d),L [UNDOC]", 4, 1 },
    { "RES 0,(IX%+d)", 4, 1 },
    { "RES 0,(IX%+d),A [UNDOC]", 4, 1 },
    { "RES 1,(IX%+d),B [UNDOC]", 4, 1 },
    { "RES 1,(IX%+d),C [UNDOC]", 4, 1 },
    { "RES 1,(IX%+d),D [UNDOC]", 4, 1 },
    { "RES 1,(IX%+d),E [UNDOC]", 4, 1 },
    { "RES 1,(IX%+d),H [UNDOC]", 4, 1 },
    { "RES 1,(IX%+d),L [UNDOC]", 4, 1 },
    { "RES 1,(IX%+d)", 4, 1 },
    { "RES 1,(IX%+d),A [UNDOC]", 4, 1 },

    { "RES 2,(IX%+d),B [UNDOC]", 4, 1 },
    { "RES 2,(IX%+d),C [UNDOC]", 4, 1 },
    { "RES 2,(IX%+d),D [UNDOC]", 4, 1 },
    { "RES 2,(IX%+d),E [UNDOC]", 4, 1 },
    { "RES 2,(IX%+d),H [UNDOC]", 4, 1 },
    { "RES 2,(IX%+d),L [UNDOC]", 4, 1 },
    { "RES 2,(IX%+d)", 4, 1 },
    { "RES 2,(IX%+d),A [UNDOC]", 4, 1 },
    { "RES 3,(IX%+d),B [UNDOC]", 4, 1 },
    { "RES 3,(IX%+d),C [UNDOC]", 4, 1 },
    { "RES 3,(IX%+d),D [UNDOC]", 4, 1 },
    { "RES 3,(IX%+d),E [UNDOC]", 4, 1 },
    { "RES 3,(IX%+d),H [UNDOC]", 4, 1 },
    { "RES 3,(IX%+d),L [UNDOC]", 4, 1 },
    { "RES 3,(IX%+d)", 4, 1 },
    { "RES 3,(IX%+d),A [UNDOC]", 4, 1 },

    { "RES 4,(IX%+d),B [UNDOC]", 4, 1 },
    { "RES 4,(IX%+d),C [UNDOC]", 4, 1 },
    { "RES 4,(IX%+d),D [UNDOC]", 4, 1 },
    { "RES 4,(IX%+d),E [UNDOC]", 4, 1 },
    { "RES 4,(IX%+d),H [UNDOC]", 4, 1 },
    { "RES 4,(IX%+d),L [UNDOC]", 4, 1 },
    { "RES 4,(IX%+d)", 4, 1 },
    { "RES 4,(IX%+d),A [UNDOC]", 4, 1 },
    { "RES 5,(IX%+d),B [UNDOC]", 4, 1 },
    { "RES 5,(IX%+d),C [UNDOC]", 4, 1 },
    { "RES 5,(IX%+d),D [UNDOC]", 4, 1 },
    { "RES 5,(IX%+d),E [UNDOC]", 4, 1 },
    { "RES 5,(IX%+d),H [UNDOC]", 4, 1 },
    { "RES 5,(IX%+d),L [UNDOC]", 4, 1 },
    { "RES 5,(IX%+d)", 4, 1 },
    { "RES 5,(IX%+d),A [UNDOC]", 4, 1 },

    { "RES 6,(IX%+d),B [UNDOC]", 4, 1 },
    { "RES 6,(IX%+d),C [UNDOC]", 4, 1 },
    { "RES 6,(IX%+d),D [UNDOC]", 4, 1 },
    { "RES 6,(IX%+d),E [UNDOC]", 4, 1 },
    { "RES 6,(IX%+d),H [UNDOC]", 4, 1 },
    { "RES 6,(IX%+d),L [UNDOC]", 4, 1 },
    { "RES 6,(IX%+d)", 4, 1 },
    { "RES 6,(IX%+d),A [UNDOC]", 4, 1 },
    { "RES 7,(IX%+d),B [UNDOC]", 4, 1 },
    { "RES 7,(IX%+d),C [UNDOC]", 4, 1 },
    { "RES 7,(IX%+d),D [UNDOC]", 4, 1 },
    { "RES 7,(IX%+d),E [UNDOC]", 4, 1 },
    { "RES 7,(IX%+d),H [UNDOC]", 4, 1 },
    { "RES 7,(IX%+d),L [UNDOC]", 4, 1 },
    { "RES 7,(IX%+d)", 4, 1 },
    { "RES 7,(IX%+d),A [UNDOC]", 4, 1 },

    { "SET 0,(IX%+d),B [UNDOC]", 4, 1 },
    { "SET 0,(IX%+d),C [UNDOC]", 4, 1 },
    { "SET 0,(IX%+d),D [UNDOC]", 4, 1 },
    { "SET 0,(IX%+d),E [UNDOC]", 4, 1 },
    { "SET 0,(IX%+d),H [UNDOC]", 4, 1 },
    { "SET 0,(IX%+d),L [UNDOC]", 4, 1 },
    { "SET 0,(IX%+d)", 4, 1 },
    { "SET 0,(IX%+d),A [UNDOC]", 4, 1 },
    { "SET 1,(IX%+d),B [UNDOC]", 4, 1 },
    { "SET 1,(IX%+d),C [UNDOC]", 4, 1 },
    { "SET 1,(IX%+d),D [UNDOC]", 4, 1 },
    { "SET 1,(IX%+d),E [UNDOC]", 4, 1 },
    { "SET 1,(IX%+d),H [UNDOC]", 4, 1 },
    { "SET 1,(IX%+d),L [UNDOC]", 4, 1 },
    { "SET 1,(IX%+d)", 4, 1 },
    { "SET 1,(IX%+d),A [UNDOC]", 4, 1 },

    { "SET 2,(IX%+d),B [UNDOC]", 4, 1 },
    { "SET 2,(IX%+d),C [UNDOC]", 4, 1 },
    { "SET 2,(IX%+d),D [UNDOC]", 4, 1 },
    { "SET 2,(IX%+d),E [UNDOC]", 4, 1 },
    { "SET 2,(IX%+d),H [UNDOC]", 4, 1 },
    { "SET 2,(IX%+d),L [UNDOC]", 4, 1 },
    { "SET 2,(IX%+d)", 4, 1 },
    { "SET 2,(IX%+d),A [UNDOC]", 4, 1 },
    { "SET 3,(IX%+d),B [UNDOC]", 4, 1 },
    { "SET 3,(IX%+d),C [UNDOC]", 4, 1 },
    { "SET 3,(IX%+d),D [UNDOC]", 4, 1 },
    { "SET 3,(IX%+d),E [UNDOC]", 4, 1 },
    { "SET 3,(IX%+d),H [UNDOC]", 4, 1 },
    { "SET 3,(IX%+d),L [UNDOC]", 4, 1 },
    { "SET 3,(IX%+d)", 4, 1 },
    { "SET 3,(IX%+d),A [UNDOC]", 4, 1 },

    { "SET 4,(IX%+d),B [UNDOC]", 4, 1 },
    { "SET 4,(IX%+d),C [UNDOC]", 4, 1 },
    { "SET 4,(IX%+d),D [UNDOC]", 4, 1 },
    { "SET 4,(IX%+d),E [UNDOC]", 4, 1 },
    { "SET 4,(IX%+d),H [UNDOC]", 4, 1 },
    { "SET 4,(IX%+d),L [UNDOC]", 4, 1 },
    { "SET 4,(IX%+d)", 4, 1 },
    { "SET 4,(IX%+d),A [UNDOC]", 4, 1 },
    { "SET 5,(IX%+d),B [UNDOC]", 4, 1 },
    { "SET 5,(IX%+d),C [UNDOC]", 4, 1 },
    { "SET 5,(IX%+d),D [UNDOC]", 4, 1 },
    { "SET 5,(IX%+d),E [UNDOC]", 4, 1 },
    { "SET 5,(IX%+d),H [UNDOC]", 4, 1 },
    { "SET 5,(IX%+d),L [UNDOC]", 4, 1 },
    { "SET 5,(IX%+d)", 4, 1 },
    { "SET 5,(IX%+d),A [UNDOC]", 4, 1 },

    { "SET 6,(IX%+d),B [UNDOC]", 4, 1 },
    { "SET 6,(IX%+d),C [UNDOC]", 4, 1 },
    { "SET 6,(IX%+d),D [UNDOC]", 4, 1 },
    { "SET 6,(IX%+d),E [UNDOC]", 4, 1 },
    { "SET 6,(IX%+d),H [UNDOC]", 4, 1 },
    { "SET 6,(IX%+d),L [UNDOC]", 4, 1 },
    { "SET 6,(IX%+d)", 4, 1 },
    { "SET 6,(IX%+d),A [UNDOC]", 4, 1 },
    { "SET 7,(IX%+d),B [UNDOC]", 4, 1 },
    { "SET 7,(IX%+d),C [UNDOC]", 4, 1 },
    { "SET 7,(IX%+d),D [UNDOC]", 4, 1 },
    { "SET 7,(IX%+d),E [UNDOC]", 4, 1 },
    { "SET 7,(IX%+d),H [UNDOC]", 4, 1 },
    { "SET 7,(IX%+d),L [UNDOC]", 4, 1 },
    { "SET 7,(IX%+d)", 4, 1 },
    { "SET 7,(IX%+d),A [UNDOC]", 4, 1 }
};

#endif	/* OPCODEDDCB_NAMES_H */
