(include "#.scm")

(check-tail-exn type-exception? (lambda () (gcd 1 'a)))
(check-tail-exn type-exception? (lambda () (gcd 'a 1)))
(check-tail-exn type-exception? (lambda () (gcd 3/2 1)))
(check-tail-exn type-exception? (lambda () (gcd 1 3/2)))
(check-eqv? (gcd (expt 3 100) (expt 5 100)) 1)
(if (##use-fast-bignum-algorithms?)
    (begin
      (check-eqv? (gcd (expt 3 10000) (expt 5 10000)) 1)
      (check-eqv? (gcd (expt 3 100000) (expt 5 100000)) 1)))
(check-eqv? (gcd (expt 3. 30) (expt 5. 30)) 1.)
(check-eqv? (gcd (expt 3 30) (expt 5. 30)) 1.)
(check-eqv? (gcd (expt 3. 30) (expt 5 30)) 1.)

;; fixnum-fixnum
(check-eqv? (gcd (expt 3 10) (expt 5 10)) 1)
;; fixnum-bignum
(check-eqv? (gcd (expt 3 10) (expt 5 50)) 1)
;; bignum-fixnum
(check-eqv? (gcd (expt 3 60) (expt 5 10)) 1)

;;; Tickled a previous bug

(check-eqv? (gcd 6521908912666391553 9223372036854775808) 1)

#|

The following tests were generated as part of a new version of gcd.
The code that generated them is as follows.  Correctness was checked
by visual examination.

(define exact-arguments
  (list 0 1 -1
        ##min-fixnum ##max-fixnum
        (* ##min-fixnum 2) (* ##max-fixnum 2)))

(define all-arguments
  (append exact-arguments (cons -0. (map exact->inexact exact-arguments))))

(for-each (lambda (x)
            (for-each (lambda (y)
                        (let ((expr `(my-gcd2 ,x ,y)))
                          (display "(check-eqv? ")
                          (display (cons 'gcd (cdr expr)))
                          (display " ")
                          (display (eval expr))
                          (display ")")
                          (newline)))
                      all-arguments))
          all-arguments)
|#

(check-eqv? (gcd 0 0) 0)
(check-eqv? (gcd 0 1) 1)
(check-eqv? (gcd 0 -1) 1)
(check-eqv? (gcd 0 -2305843009213693952) 2305843009213693952)
(check-eqv? (gcd 0 2305843009213693951) 2305843009213693951)
(check-eqv? (gcd 0 -4611686018427387904) 4611686018427387904)
(check-eqv? (gcd 0 4611686018427387902) 4611686018427387902)
(check-eqv? (gcd 0 -0.) 0.)
(check-eqv? (gcd 0 0.) 0.)
(check-eqv? (gcd 0 1.) 1.)
(check-eqv? (gcd 0 -1.) 1.)
(check-eqv? (gcd 0 -2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd 0 2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd 0 -4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd 0 4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd 1 0) 1)
(check-eqv? (gcd 1 1) 1)
(check-eqv? (gcd 1 -1) 1)
(check-eqv? (gcd 1 -2305843009213693952) 1)
(check-eqv? (gcd 1 2305843009213693951) 1)
(check-eqv? (gcd 1 -4611686018427387904) 1)
(check-eqv? (gcd 1 4611686018427387902) 1)
(check-eqv? (gcd 1 -0.) 1.)
(check-eqv? (gcd 1 0.) 1.)
(check-eqv? (gcd 1 1.) 1.)
(check-eqv? (gcd 1 -1.) 1.)
(check-eqv? (gcd 1 -2.305843009213694e18) 1.)
(check-eqv? (gcd 1 2.305843009213694e18) 1.)
(check-eqv? (gcd 1 -4.611686018427388e18) 1.)
(check-eqv? (gcd 1 4.611686018427388e18) 1.)
(check-eqv? (gcd -1 0) 1)
(check-eqv? (gcd -1 1) 1)
(check-eqv? (gcd -1 -1) 1)
(check-eqv? (gcd -1 -2305843009213693952) 1)
(check-eqv? (gcd -1 2305843009213693951) 1)
(check-eqv? (gcd -1 -4611686018427387904) 1)
(check-eqv? (gcd -1 4611686018427387902) 1)
(check-eqv? (gcd -1 -0.) 1.)
(check-eqv? (gcd -1 0.) 1.)
(check-eqv? (gcd -1 1.) 1.)
(check-eqv? (gcd -1 -1.) 1.)
(check-eqv? (gcd -1 -2.305843009213694e18) 1.)
(check-eqv? (gcd -1 2.305843009213694e18) 1.)
(check-eqv? (gcd -1 -4.611686018427388e18) 1.)
(check-eqv? (gcd -1 4.611686018427388e18) 1.)
(check-eqv? (gcd -2305843009213693952 0) 2305843009213693952)
(check-eqv? (gcd -2305843009213693952 1) 1)
(check-eqv? (gcd -2305843009213693952 -1) 1)
(check-eqv? (gcd -2305843009213693952 -2305843009213693952) 2305843009213693952)
(check-eqv? (gcd -2305843009213693952 2305843009213693951) 1)
(check-eqv? (gcd -2305843009213693952 -4611686018427387904) 2305843009213693952)
(check-eqv? (gcd -2305843009213693952 4611686018427387902) 2)
(check-eqv? (gcd -2305843009213693952 -0.) 2.305843009213694e18)
(check-eqv? (gcd -2305843009213693952 0.) 2.305843009213694e18)
(check-eqv? (gcd -2305843009213693952 1.) 1.)
(check-eqv? (gcd -2305843009213693952 -1.) 1.)
(check-eqv? (gcd -2305843009213693952 -2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -2305843009213693952 2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -2305843009213693952 -4.611686018427388e18) 2.305843009213694e18)
(check-eqv? (gcd -2305843009213693952 4.611686018427388e18) 2.305843009213694e18)
(check-eqv? (gcd 2305843009213693951 0) 2305843009213693951)
(check-eqv? (gcd 2305843009213693951 1) 1)
(check-eqv? (gcd 2305843009213693951 -1) 1)
(check-eqv? (gcd 2305843009213693951 -2305843009213693952) 1)
(check-eqv? (gcd 2305843009213693951 2305843009213693951) 2305843009213693951)
(check-eqv? (gcd 2305843009213693951 -4611686018427387904) 1)
(check-eqv? (gcd 2305843009213693951 4611686018427387902) 2305843009213693951)
(check-eqv? (gcd 2305843009213693951 -0.) 2.305843009213694e18)
(check-eqv? (gcd 2305843009213693951 0.) 2.305843009213694e18)
(check-eqv? (gcd 2305843009213693951 1.) 1.)
(check-eqv? (gcd 2305843009213693951 -1.) 1.)
(check-eqv? (gcd 2305843009213693951 -2.305843009213694e18) 1.)
(check-eqv? (gcd 2305843009213693951 2.305843009213694e18) 1.)
(check-eqv? (gcd 2305843009213693951 -4.611686018427388e18) 1.)
(check-eqv? (gcd 2305843009213693951 4.611686018427388e18) 1.)
(check-eqv? (gcd -4611686018427387904 0) 4611686018427387904)
(check-eqv? (gcd -4611686018427387904 1) 1)
(check-eqv? (gcd -4611686018427387904 -1) 1)
(check-eqv? (gcd -4611686018427387904 -2305843009213693952) 2305843009213693952)
(check-eqv? (gcd -4611686018427387904 2305843009213693951) 1)
(check-eqv? (gcd -4611686018427387904 -4611686018427387904) 4611686018427387904)
(check-eqv? (gcd -4611686018427387904 4611686018427387902) 2)
(check-eqv? (gcd -4611686018427387904 -0.) 4.611686018427388e18)
(check-eqv? (gcd -4611686018427387904 0.) 4.611686018427388e18)
(check-eqv? (gcd -4611686018427387904 1.) 1.)
(check-eqv? (gcd -4611686018427387904 -1.) 1.)
(check-eqv? (gcd -4611686018427387904 -2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -4611686018427387904 2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -4611686018427387904 -4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd -4611686018427387904 4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd 4611686018427387902 0) 4611686018427387902)
(check-eqv? (gcd 4611686018427387902 1) 1)
(check-eqv? (gcd 4611686018427387902 -1) 1)
(check-eqv? (gcd 4611686018427387902 -2305843009213693952) 2)
(check-eqv? (gcd 4611686018427387902 2305843009213693951) 2305843009213693951)
(check-eqv? (gcd 4611686018427387902 -4611686018427387904) 2)
(check-eqv? (gcd 4611686018427387902 4611686018427387902) 4611686018427387902)
(check-eqv? (gcd 4611686018427387902 -0.) 4.611686018427388e18)
(check-eqv? (gcd 4611686018427387902 0.) 4.611686018427388e18)
(check-eqv? (gcd 4611686018427387902 1.) 1.)
(check-eqv? (gcd 4611686018427387902 -1.) 1.)
(check-eqv? (gcd 4611686018427387902 -2.305843009213694e18) 2.)
(check-eqv? (gcd 4611686018427387902 2.305843009213694e18) 2.)
(check-eqv? (gcd 4611686018427387902 -4.611686018427388e18) 2.)
(check-eqv? (gcd 4611686018427387902 4.611686018427388e18) 2.)
(check-eqv? (gcd -0. 0) 0.)
(check-eqv? (gcd -0. 1) 1.)
(check-eqv? (gcd -0. -1) 1.)
(check-eqv? (gcd -0. -2305843009213693952) 2.305843009213694e18)
(check-eqv? (gcd -0. 2305843009213693951) 2.305843009213694e18)
(check-eqv? (gcd -0. -4611686018427387904) 4.611686018427388e18)
(check-eqv? (gcd -0. 4611686018427387902) 4.611686018427388e18)
(check-eqv? (gcd -0. -0.) 0.)
(check-eqv? (gcd -0. 0.) 0.)
(check-eqv? (gcd -0. 1.) 1.)
(check-eqv? (gcd -0. -1.) 1.)
(check-eqv? (gcd -0. -2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -0. 2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -0. -4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd -0. 4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd 0. 0) 0.)
(check-eqv? (gcd 0. 1) 1.)
(check-eqv? (gcd 0. -1) 1.)
(check-eqv? (gcd 0. -2305843009213693952) 2.305843009213694e18)
(check-eqv? (gcd 0. 2305843009213693951) 2.305843009213694e18)
(check-eqv? (gcd 0. -4611686018427387904) 4.611686018427388e18)
(check-eqv? (gcd 0. 4611686018427387902) 4.611686018427388e18)
(check-eqv? (gcd 0. -0.) 0.)
(check-eqv? (gcd 0. 0.) 0.)
(check-eqv? (gcd 0. 1.) 1.)
(check-eqv? (gcd 0. -1.) 1.)
(check-eqv? (gcd 0. -2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd 0. 2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd 0. -4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd 0. 4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd 1. 0) 1.)
(check-eqv? (gcd 1. 1) 1.)
(check-eqv? (gcd 1. -1) 1.)
(check-eqv? (gcd 1. -2305843009213693952) 1.)
(check-eqv? (gcd 1. 2305843009213693951) 1.)
(check-eqv? (gcd 1. -4611686018427387904) 1.)
(check-eqv? (gcd 1. 4611686018427387902) 1.)
(check-eqv? (gcd 1. -0.) 1.)
(check-eqv? (gcd 1. 0.) 1.)
(check-eqv? (gcd 1. 1.) 1.)
(check-eqv? (gcd 1. -1.) 1.)
(check-eqv? (gcd 1. -2.305843009213694e18) 1.)
(check-eqv? (gcd 1. 2.305843009213694e18) 1.)
(check-eqv? (gcd 1. -4.611686018427388e18) 1.)
(check-eqv? (gcd 1. 4.611686018427388e18) 1.)
(check-eqv? (gcd -1. 0) 1.)
(check-eqv? (gcd -1. 1) 1.)
(check-eqv? (gcd -1. -1) 1.)
(check-eqv? (gcd -1. -2305843009213693952) 1.)
(check-eqv? (gcd -1. 2305843009213693951) 1.)
(check-eqv? (gcd -1. -4611686018427387904) 1.)
(check-eqv? (gcd -1. 4611686018427387902) 1.)
(check-eqv? (gcd -1. -0.) 1.)
(check-eqv? (gcd -1. 0.) 1.)
(check-eqv? (gcd -1. 1.) 1.)
(check-eqv? (gcd -1. -1.) 1.)
(check-eqv? (gcd -1. -2.305843009213694e18) 1.)
(check-eqv? (gcd -1. 2.305843009213694e18) 1.)
(check-eqv? (gcd -1. -4.611686018427388e18) 1.)
(check-eqv? (gcd -1. 4.611686018427388e18) 1.)
(check-eqv? (gcd -2.305843009213694e18 0) 2.305843009213694e18)
(check-eqv? (gcd -2.305843009213694e18 1) 1.)
(check-eqv? (gcd -2.305843009213694e18 -1) 1.)
(check-eqv? (gcd -2.305843009213694e18 -2305843009213693952) 2.305843009213694e18)
(check-eqv? (gcd -2.305843009213694e18 2305843009213693951) 1.)
(check-eqv? (gcd -2.305843009213694e18 -4611686018427387904) 2.305843009213694e18)
(check-eqv? (gcd -2.305843009213694e18 4611686018427387902) 2.)
(check-eqv? (gcd -2.305843009213694e18 -0.) 2.305843009213694e18)
(check-eqv? (gcd -2.305843009213694e18 0.) 2.305843009213694e18)
(check-eqv? (gcd -2.305843009213694e18 1.) 1.)
(check-eqv? (gcd -2.305843009213694e18 -1.) 1.)
(check-eqv? (gcd -2.305843009213694e18 -2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -2.305843009213694e18 2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -2.305843009213694e18 -4.611686018427388e18) 2.305843009213694e18)
(check-eqv? (gcd -2.305843009213694e18 4.611686018427388e18) 2.305843009213694e18)
(check-eqv? (gcd 2.305843009213694e18 0) 2.305843009213694e18)
(check-eqv? (gcd 2.305843009213694e18 1) 1.)
(check-eqv? (gcd 2.305843009213694e18 -1) 1.)
(check-eqv? (gcd 2.305843009213694e18 -2305843009213693952) 2.305843009213694e18)
(check-eqv? (gcd 2.305843009213694e18 2305843009213693951) 1.)
(check-eqv? (gcd 2.305843009213694e18 -4611686018427387904) 2.305843009213694e18)
(check-eqv? (gcd 2.305843009213694e18 4611686018427387902) 2.)
(check-eqv? (gcd 2.305843009213694e18 -0.) 2.305843009213694e18)
(check-eqv? (gcd 2.305843009213694e18 0.) 2.305843009213694e18)
(check-eqv? (gcd 2.305843009213694e18 1.) 1.)
(check-eqv? (gcd 2.305843009213694e18 -1.) 1.)
(check-eqv? (gcd 2.305843009213694e18 -2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd 2.305843009213694e18 2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd 2.305843009213694e18 -4.611686018427388e18) 2.305843009213694e18)
(check-eqv? (gcd 2.305843009213694e18 4.611686018427388e18) 2.305843009213694e18)
(check-eqv? (gcd -4.611686018427388e18 0) 4.611686018427388e18)
(check-eqv? (gcd -4.611686018427388e18 1) 1.)
(check-eqv? (gcd -4.611686018427388e18 -1) 1.)
(check-eqv? (gcd -4.611686018427388e18 -2305843009213693952) 2.305843009213694e18)
(check-eqv? (gcd -4.611686018427388e18 2305843009213693951) 1.)
(check-eqv? (gcd -4.611686018427388e18 -4611686018427387904) 4.611686018427388e18)
(check-eqv? (gcd -4.611686018427388e18 4611686018427387902) 2.)
(check-eqv? (gcd -4.611686018427388e18 -0.) 4.611686018427388e18)
(check-eqv? (gcd -4.611686018427388e18 0.) 4.611686018427388e18)
(check-eqv? (gcd -4.611686018427388e18 1.) 1.)
(check-eqv? (gcd -4.611686018427388e18 -1.) 1.)
(check-eqv? (gcd -4.611686018427388e18 -2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -4.611686018427388e18 2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd -4.611686018427388e18 -4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd -4.611686018427388e18 4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd 4.611686018427388e18 0) 4.611686018427388e18)
(check-eqv? (gcd 4.611686018427388e18 1) 1.)
(check-eqv? (gcd 4.611686018427388e18 -1) 1.)
(check-eqv? (gcd 4.611686018427388e18 -2305843009213693952) 2.305843009213694e18)
(check-eqv? (gcd 4.611686018427388e18 2305843009213693951) 1.)
(check-eqv? (gcd 4.611686018427388e18 -4611686018427387904) 4.611686018427388e18)
(check-eqv? (gcd 4.611686018427388e18 4611686018427387902) 2.)
(check-eqv? (gcd 4.611686018427388e18 -0.) 4.611686018427388e18)
(check-eqv? (gcd 4.611686018427388e18 0.) 4.611686018427388e18)
(check-eqv? (gcd 4.611686018427388e18 1.) 1.)
(check-eqv? (gcd 4.611686018427388e18 -1.) 1.)
(check-eqv? (gcd 4.611686018427388e18 -2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd 4.611686018427388e18 2.305843009213694e18) 2.305843009213694e18)
(check-eqv? (gcd 4.611686018427388e18 -4.611686018427388e18) 4.611686018427388e18)
(check-eqv? (gcd 4.611686018427388e18 4.611686018427388e18) 4.611686018427388e18)
