.\" Automatically generated from an mdoc input file.  Do not edit.
.\" ZIP_SOURCE_GET_ARGS -- validate and cast arguments to source callback
.\" Copyright (C) 2014-2017 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_SOURCE_GET_ARGS" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBZIP_SOURCE_GET_ARGS\fR
\- validate and cast arguments to source callback
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fItype *\fR
.br
.PD 0
.HP 4n
\fBZIP_SOURCE_GET_ARGS\fR(\fItype\fR, \fIvoid\ *data\fR, \fIzip_uint64_t\ len\fR, \fIzip_error_t\ *error\fR);
.PD
.SH "DESCRIPTION"
The
\fBZIP_SOURCE_GET_ARGS\fR()
macro casts
\fIdata\fR
to a pointer to
\fItype\fR.
.SH "RETURN VALUES"
On success,
\fBZIP_SOURCE_GET_ARGS\fR()
returns
\fIdata\fR.
In case of error, it returns
\fRNULL\fR
and sets
\fIerror\fR.
.SH "ERRORS"
\fBZIP_SOURCE_GET_ARGS\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIlen\fR
is less than the size of
\fItype\fR
.SH "SEE ALSO"
libzip(3),
zip_source_function(3)
.SH "HISTORY"
\fBZIP_SOURCE_GET_ARGS\fR()
was added in libzip 1.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
