#include <stdio.h>
#include <stdlib.h>

typedef long   longer[3];
extern longer seed;
extern long inseed;

double randum()
/* Mary's version--faster but needs 32 bits.  Loops have been unrolled
   for speed. */
{
  long newseed0, newseed1, newseed2;

  newseed0 = 1549*seed[0];
    newseed1 = newseed0/2048;
    newseed0 &= 2047;
    newseed2 = newseed1/2048;
    newseed1 &= 2047;
  newseed1 += 1549*seed[1] 
              + 812*seed[0];
    newseed2 += newseed1/2048;
    newseed1 &= 2047;
  newseed2 += 1549*seed[2]
              + 812*seed[1];

  seed[0] = newseed0;
  seed[1] = newseed1;
  seed[2] = newseed2 & 1023;
  return (((seed[0]/2048.0 + seed[1])/2048.0 + seed[2])/1024.0);
}  /* randum */

#if 0
void main ()
{
  long i;

  /*scanf("%ld",&inseed);  */
  inseed=105;
  for (i = 0; i <= 2; i++)
    seed[i] = 0;
  i = 0;
  do {
    seed[i] = inseed & 2047;
    inseed /= 2048;
    i++;
  } while (inseed != 0);

  for (i=0;i<100;i++) printf("%f\n",randum());
}
#endif
