#define FLUC_MODELLIKE_INCLUDE

typedef struct treerec {
   long *kk;
   double *kend;
} treerec;

typedef struct derivlist {
   double *firstd, *secondd;
   long *fplus, *splus;
} derivlist;

boolean zerocheck(double value);
long whatsign(double value);
void truthmod(double th, double g, long chain, long lowcus);

void model_alloc(void);
void scoretree(long chain);

double fluc_interval_llike(double theta, double linv_theta, double growth, 
   double starttyme, double endtyme, long kk);
double fluc_lliketree(long tr, long chain, double theta, double otheta,
   double linv_theta, double linv_otheta, double growth, double ogrowth, 
   long lowcus);
double fluc_locus_llike(double theta, double growth);

double model_llike(double thgiven, double grgiven, long chain, long lowcus);
double model_likelihood(double theta, double growth, long firstlong,
   long lastlong, long lowcus, double **lthetai);

double fexp1(long kk, double thgiven, double grgiven, double expend,
   double expstart);
double fexp2(long kk, double thgiven, double grgiven, double endtyme,
   double starttyme, double expstart, double expend);

double fluc_theta_lderiv(long chain, double thgiven, double grgiven,
   double *fx, double *dfx, long *fxplus, long *dfxplus, long lowcus,
   derivlist *d);
double fluc_growth_lderiv(long chain, double thgiven, double grgiven,
   double *fx, double *dfx, long *fxplus, long *dfxplus, long lowcus,
   derivlist *d);
double fluc_locus_theta_lderiv(double theta, double growth, double *fx,
   double *dfx, long *fxplus, long *dfxplus, derivlist *d);
double fluc_locus_growth_lderiv(double theta, double growth, double *fx,
   double *dfx, long *fxplus, long *dfxplus, derivlist *d);
double fluc_partial_lderiv(long chain, double theta, double growth,
   double *df, long *dfplus, long lowcus);
double fluc_locus_partial_lderiv(double theta, double growth, double *df,
   long *dfplus, derivlist *d);

void init_matrix(double *fx, double **dfx, double g, double theta,
   long *fxplus, long **dfxplus, long chain, derivlist *d, 
   boolean multilocus);

boolean check_curvature(double *fx, double **dfx, long *fxplus,
   long **dfxplus);
boolean calc_change_denom(double **dfx, long **dfxplus, double *denom,
   long *denomsign);
void calc_change_contrib(double *fx, double **dfx, long *fxplus,
   long **dfxplus, double denom, long denomsign,
   double *locus_contrib);
boolean calc_change(double *fx, double **dfx, long *fxplus, long **dfxplus,
   double *answ);

boolean check_MAX(double *g);

void matrixpoint(long chain, double *thetaresult, double *gresult, 
   derivlist *d, boolean multilocus);
void fluc_locus_estimate(void);
void fluc_estimate(long chain, boolean locusend);

void init_mutations(double **mutation_rates);
void fluc_printout(double theta, double growth, double *rates);
void fluc_printtable(double theta, double growth);
void fluc_liketable(double th, double gr, long chain, long lowcus,
  boolean to_screen);
void print_covariance(double theta, double g, long chain, long lowcus);

void modelfree(void);

/* function donated by plot.h */

extern void print_locusplot(long lowcus);

