#include "multipsklog.h"
#include <FL/fl_ask.H>


char *date_to_adif(char *s) {
static char date[9];
  if (atoi(&s[6]) < 50)
    strcpy(date,"20");
  else
    strcpy(date,"19");
  for (int i = 0; i < 2; i++) {
    date[i+2] = s[i+6];
    date[i+4] = s[i];
    date[i+6] = s[i+3];
  }
  date[8] = 0; 
  return date;   
}

char *adif_to_date( char *s) {
static char date[9];
  strcpy(date, "  /  /  ");
  for (int i = 0; i < 2; i++) {
    date[i+6] = s[i+2];
    date[i] = s[i+4];
    date[i+3] = s[i+6];
  }
  return date;
}

char *time_to_adif(char *s) {
static char time[7];
  for (int i = 0; i < 2; i++) {
    time[i] = s[i];
    time[i+2] = s[i+3];
//    time[i+4] = s[i+6];
  }
//  time[6] = 0;
  time[4] = 0;
  return time;
}

char *adif_to_time( char *s) {
static char time[9];
  strcpy(time, "  :  :00");
  for (int i = 0; i < 2; i++) {
    time[i] = s[i];
    time[i+3] = s[i+2];
    if (strlen(s)>4)
      time[i+6] = s[i+4];
  }
  return time;
}

void cMultipskFile::parseLine (char *line)
{
  char *p1 = line;
  char *p2;
  
  mrec.clearRec();
  p2 = strchr (p1,' '); if (!p2) return;
  *p2 = 0;
  mrec.putField (QSO_DATE, date_to_adif(p1)); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
  mrec.putField (TIME_ON, time_to_adif(p1)); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0;
  mrec.putField (CALL, p1); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
  mrec.putField (NAME, p1); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
  mrec.putField (FREQ, p1); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
  mrec.putField (MODE, p1); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
  mrec.putField (RST_SENT, p1); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
  mrec.putField (RST_RCVD, p1); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
  mrec.putField (QSL_RCVD, p1); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
  mrec.putField (QSL_SENT, p1); 
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
//  Wkg fields ignored
  p1 = ++p2; 
  p2 = strchr (p1, '|'); if (!p2) return;
  *p2 = 0; 
  mrec.putField (QTH, p1);
  p1 = ++p2;
  p2 = strchr (p1, '\n'); if (!p2) return; 
  *p2 = 0; 
  mrec.putField (COMMENT, (const char *)p1);
}

int cMultipskFile::readLOFile (char *fname, cQsoDb *db)
{
  int  buffsize = 1024;
  char *line = new char[buffsize + 1];
  char *str;
  
  pskFile = fopen (fname, "r");
  if (pskFile) {
    str = fgets (line, buffsize, pskFile);
    if (!strstr (line, "LOG")) {
      fl_message("%s not a valid LO file", fname);
      fclose (pskFile);
      return 0;
    }
    do {
      memset (line, buffsize + 1, 0);
      str = fgets (line, buffsize, pskFile);
      if (str) {
        parseLine (str);
        db->qsoNewRec (&mrec);
      }
    } while (str);
    fclose (pskFile);
    return 1;
  }
  return 0;
}

int cMultipskFile::writeLOFile(char *fname, cQsoDb *db) {
  pskFile = fopen (fname, "w");
  cQsoRec *pRec;
  char dummy[36];
  memset (dummy, ' ', 35);
  dummy[35] = 0;
  if (pskFile) {
    fprintf (pskFile, "LOG\n");
    for (int i = 0; i < db->nbrRecs(); i++) {
      pRec = db->getRec(i),
      fprintf (pskFile, RECFMT,
        adif_to_date (pRec->getField(QSO_DATE)),
        adif_to_time (pRec->getField(TIME_ON)),
        pRec->getField(CALL),
        pRec->getField(NAME),
        pRec->getField(FREQ),
        pRec->getField(MODE),
        pRec->getField(RST_SENT),
        pRec->getField(RST_RCVD),
        pRec->getField(QSL_RCVD),
        pRec->getField(QSL_SENT),
        dummy,
        pRec->getField(QTH),
        pRec->getField(COMMENT));
      }
    fclose (pskFile);
  }
  return 0;
}

static char header [] = 
"     UTC/GMT     |     CALL      |     NAME         | FREQ (MHz) |   MODE   |UR RST |MY RST |R|S|WKD CONDITIONS (OM) / STATION (SWL)|             QTH + LOCATOR              |      NOTES/COMMENT\n";

int cMultipskFile::readTextFile (char *fname, cQsoDb *db)
{
  int  buffsize = 1024;
  char *line = new char[buffsize + 1];
  char *str;
  
  pskFile = fopen (fname, "r");
  if (pskFile) {
    str = fgets (line, buffsize, pskFile);
    if (!strstr (line, "UTC/GMT     |     CALL")) {
      fl_message("%s not a valid MultiPsk text file", fname);
      fclose (pskFile);
      return 0;
    }
    do {
      memset (line, buffsize + 1, 0);
      str = fgets (line, buffsize, pskFile);
      if (str) {
        parseLine (str);
        db->qsoNewRec (&mrec);
      }
    } while (str);
    fclose (pskFile);
    return 1;
  }
  return 0;
}

int cMultipskFile::writeTextFile (char *fname, cQsoDb *db) {
  pskFile = fopen (fname, "w");
  cQsoRec *pRec;
  char dummy[36];
  memset (dummy, ' ', 35);
  dummy[35] = 0;
  if (pskFile) {
    fprintf (pskFile, header);
    for (int i = 0; i < db->nbrRecs(); i++) {
      pRec = db->getRec(i),
      fprintf (pskFile, RECFMT,
        adif_to_date (pRec->getField(QSO_DATE)),
        adif_to_time (pRec->getField(TIME_ON)),
        pRec->getField(CALL),
        pRec->getField(NAME),
        pRec->getField(FREQ),
        pRec->getField(MODE),
        pRec->getField(RST_SENT),
        pRec->getField(RST_RCVD),
        pRec->getField(QSL_RCVD),
        pRec->getField(QSL_SENT),
        dummy,
        pRec->getField(QTH),
        pRec->getField(COMMENT));
      }
    fclose (pskFile);
  }
  return 0;
}

