/*
 * fl_logbook intercepts messages that are in the same format as those
 * sent to xlog and should consist of fields, separated by the '\1' character.
 * Fields are started with a descriptor, followed by a colon (':'). Possible fields are:
 *
 ****************************************************************************
 * program:<name of program which sends the QSO information>
 * version:<version string for the message queue, must be '1' for now>
 * date:<date of QSO, preferable 'dd mmm yyyy'>
 * time:<start time of QSO, preferably in GMT >
 * endtime:<end time of QSO, preferably GMT (mandatory in some countries)>
 * call:<callsign of your contact (will be converted to uppercase)>
 * mhz:<frequency in MHz>
 * mode:<any one of CW,SSB,RTTY,PSK31,etc (will be converted to uppercase)>
 * tx:<report (RST) which you have sent>
 * rx:<report (RST) which you have received>
 * name:<name of the operator you have contacted>
 * qth:<town of the operator you have contacted>
 * notes:<additional notes>
 * power:<power you have used (mandatory in some countries)>
 * locator:<QRA locator, as used in VHF QSO's>
 * free1: <information to put in freefield1>
 * free2: <information to put in freefield2>
 ****************************************************************************
*/

#include "ipcdata.h"
#include "qso_db.h"
#include "field_def.h"

int  msgid = -1;
long msgtyp = 0;
msgtype msgbuf;


void setup_ipc_data (void)
{
	msgid = msgget ((key_t) 1238, 0666 | IPC_CREAT);
	if (msgid != -1) { /* check for a message twice a second */
		Fl::add_timeout (0.5, get_ipc_data);
	}
}

void get_ipc_data (void *)
{
	ssize_t status = -1;
	long msgtyp = 0;

	status = msgrcv (msgid, (void *) &msgbuf, 1024, msgtyp,
			 MSG_NOERROR | IPC_NOWAIT);
	if (status != -1)
		add_ipc_data (msgbuf.mtype, msgbuf.mtext);
	Fl::repeat_timeout (0.5, get_ipc_data);
}

char *months[] = {
	"jan","feb","mar","apr","may","jun",
	"jul","aug","sep","oct","nov","dec"};
	
void parse_ipc_data (char *s, cQsoRec *rec)
{
	char *p = strchr(s,':');
	if (!p) return;
	p++;
	if (strstr(s, "date:") == s) {
		int d, y, i;
		char mon[8], date[12];
		sscanf(p,"%d %s %d", &d, mon, &y);
		for (i = 0; i < 12; i++)
			if (strncasecmp (mon, months[i],3) == 0)
				break;
		sprintf(date,"%04d%02d%02d", y, i+1, d);
		rec->putField(QSO_DATE, date);
		return;
	}
	if (strstr(s, "time:") == s) {
		rec->putField(TIME_ON, p);
		return;
	}
	if (strstr(s, "endtime:") == s) {
		rec->putField(TIME_OFF, p);
		return;
	}
	if (strstr(s, "call:") == s) {
		rec->putField(CALL, p);
		return;
	}
	if (strstr(s, "mhz:") == s) {
		rec->putField(FREQ, p);
		return;
	}
	if (strstr(s, "khz:") == s) {
		rec->putField(FREQ, p);
		return;
	}
	if (strstr(s, "mode:") == s) {
		rec->putField(MODE, p);
		return;
	}
	if (strstr(s, "tx:") == s) {
		rec->putField(RST_SENT,p);
		return;
	}
	if (strstr(s, "rx:") == s) {
		rec->putField(RST_RCVD,p);
		return;
	}
	if (strstr(s, "name:") == s) {
		rec->putField(NAME, p);
		return;
	}
	if ((strstr(s, "qth:") == s) && *p) {
		rec->addtoField(QTH, p);
		return;
	}
	if (strstr(s, "notes:") == s) {
		rec->addtoField(COMMENT,p);
		return;
	}
	if (strstr(s, "power:") == s) {
		char *power = new char[strlen(p) + 10];
		sprintf(power," Pwr: %s", p);
		rec->addtoField(COMMENT, power);
		return;
	}
	if ((strstr(s, "locator:") == s) && *p) {
		rec->addtoField(QTH," Loc: ");
		rec->addtoField(QTH,p);
		return;
	}
	return;
}

void add_ipc_data (int type, char * entry)
{
extern cQsoDb        qsodb;
extern void cb_SortByDate(void);
	if (type == 88 && entry && (strlen (entry) > 0)) {
		cQsoRec *ipc_rec = new cQsoRec;
		char *p = entry, *p1, *p2 = entry + strlen(entry);
		while (1) {
			p1 = strchr(p, 1);
			if (p1 && p < p2) {
				*p1 = 0;
				parse_ipc_data (p, ipc_rec);
				p = p1 + 1;
			} else {
				if (p < p2)
					parse_ipc_data (p, ipc_rec);
				break;
			}
		}
		if (ipc_rec->validRec() == 0) {
			qsodb.qsoNewRec (ipc_rec);
			cb_SortByDate();
		}
	}
}
