#include <FL/fl_file_chooser.H>

#include <stdlib.h>

#include "support.h"

cQsoDb        qsodb;
cMultipskFile mpFile;
cAdifIO       adifFile;

char logfile[256];

void cb_mnuNew(Fl_Menu_* m, void* d){
	if (qsodb.isdirty()) {
		if (fl_choice("Database change, Save?", "No", "Yes", NULL))
			if (qsodb.qsoWriteFile(logfile))
				fl_message ("Could not update file %s", logfile);
	}
	strcpy(logfile,"newlog.lgb");
	qsodb.deleteRecs();
	qsodb.isdirty(0);
	wBrowser->clear();
}

void cb_mnuOpen(Fl_Menu_* m, void* d){
	if (qsodb.isdirty()) {
		if (fl_choice("Database change, Save?", "No", "Yes", NULL))
			if (qsodb.qsoWriteFile(logfile))
				fl_message ("Could not update file %s", logfile);
		qsodb.deleteRecs();
		qsodb.isdirty(0);
	}
	char *p = fl_file_chooser("Open logbook file", "*.lgb", "");
	if (p) {
		if (qsodb.qsoReadFile (p))
			fl_message ("%s invalid database", p);
		else {
			strcpy(logfile,p);
			loadBrowser();
			qsodb.isdirty(0);
		}
	}
}

void cb_mnuSave(Fl_Menu_*m, void* d) {
	if (qsodb.nbrRecs() == 0) return;
	char *p = fl_file_chooser("Save logbook file", "*.lgb", logfile);
	if (p) {
		if (qsodb.qsoWriteFile (p))
			fl_message ("Could not write to %s", p);
		qsodb.isdirty(0);
	}
}

void cb_mnuSaveAsTXT(Fl_Menu_* m, void* d) {
	if (qsodb.nbrRecs() == 0) return;
	char *p = fl_file_chooser("Save As text file", "*.txt", "");
	if (p) {
		mpFile.writeTextFile (p, &qsodb);
	}
}

void cb_mnuSaveAsLO(Fl_Menu_* m, void* d) {
	if (qsodb.nbrRecs() == 0) return;
	char *p = fl_file_chooser("Save As Multipsk(LO) file", "*.LO", "");
	if (p) {
		mpFile.writeLOFile (p, &qsodb);
	}
}

void cb_mnuSaveAsADIF(Fl_Menu_* m, void* d) {
	if (qsodb.nbrRecs() == 0) return;
	char *p = fl_file_chooser("Save As ADif file", "*.adi", "LOGBOOK.ADI");
	if (p) {
		adifFile.writeFile (p, &qsodb);
	}
}

void cb_mnuMergeLog(Fl_Menu_ *m, void * d) {
	char *p = fl_file_chooser("Open logbook file", "*.lgb", "");
	if (p) {
		if (qsodb.qsoReadFile (p))
			fl_message ("%s invalid database", p);
		else {
//			strcpy(logfile,p);
			loadBrowser();
			qsodb.qsoWriteFile(logfile);
//			qsodb.isdirty(1);
		}
	}
}

void cb_mnuMergeADIF(Fl_Menu_* m, void* d) {
	char *p = fl_file_chooser("Select ADIF merge file", "*.adif", "");
	if (p) {
		adifFile.readFile (p, &qsodb);
		loadBrowser();
	}
}

void cb_mnuMergeMultipskLO(Fl_Menu_* m, void* d) {
	char *p = fl_file_chooser("Select LO merge file", "*.LO", "");
	if (p) {
		mpFile.readLOFile (p, &qsodb);
		loadBrowser();
	}
}

void cb_mnuMergeMultipskTXT(Fl_Menu_* m, void* d) {
	char *p = fl_file_chooser("Select TXT merge file", "*.txt", "");
	if (p) {
		mpFile.readTextFile (p, &qsodb);
		loadBrowser();
	}
}

void cleanExit()
{
  if (qsodb.isdirty()) {
    if (fl_choice ("Database changed, save (y/n)?", "no","yes",NULL))
      if (qsodb.qsoWriteFile(logfile))
        fl_message ("Could not update file %s", logfile);
  }
  exit(0);
}

void cb_mnuExit(Fl_Menu_* m, void* d){
	cleanExit();
}

enum State {VIEWREC, NEWREC};
static State pgmState = VIEWREC;

void activateButtons() {
	if (pgmState == NEWREC) {
		bNewSave->label ("Save");
		bUpdateCancel->label ("Cancel");
		bDelete->deactivate ();
		bSearchFirst->deactivate ();
		bSearchNext->deactivate ();
		inpDate->take_focus();
		return;
	}
	bNewSave->label("New");
	bUpdateCancel->label("Update");
	bDelete->activate();
	bSearchFirst->activate ();
	bSearchNext->activate ();
}

void cb_btnNewSave(Fl_Button* b, void* d) {
	if (pgmState == VIEWREC) {
		pgmState = NEWREC;
		clearRecord();
		activateButtons();
	} else {
		saveRecord();
		loadBrowser();
		pgmState = VIEWREC;
		activateButtons();
		wBrowser->LastRow ();
	}	   
}

void cb_btnUpdateCancel(Fl_Button* b, void* d) {
	if (pgmState == NEWREC) {
		pgmState = VIEWREC;
		activateButtons ();
		wBrowser->LastRow ();
	} else
		updateRecord();
}

void cb_btnDelete(Fl_Button* b, void* d) {
	deleteRecord();
}

void cb_SortByCall (void) {
	qsodb.SortByCall();
	loadBrowser();
	wBrowser->LastRow ();
}

void cb_SortByDate (void) {
	qsodb.SortByDate();
	loadBrowser();
	wBrowser->LastRow ();
}

void cb_SortByMode (void) {
	qsodb.SortByMode();
	loadBrowser();
	wBrowser->LastRow ();
}

static int lastfind = -1;

void cb_btnSearchFirst (Fl_Button* b, void* d) {
	char *srchstr = new char[strlen(inpSearchString->value())+ 1];
	int i;
	strcpy(srchstr, inpSearchString->value());
	char *p = srchstr + strlen(srchstr) - 1;
	while (p > srchstr && *p == ' ') *p-- = 0;
	while (srchstr[0] == ' ') strcpy(srchstr, &srchstr[1]);
	p = srchstr;
	while (*p) {*p = toupper(*p); p++;}
	lastfind = -1;
	size_t len = strlen(srchstr);
	for (i = 0; i < wBrowser->rows(); i++) {
		if (strncmp(srchstr, wBrowser->valueAt(i, 2), len ) == 0) {
			lastfind = i;
			wBrowser->GotoRow(i);
			return;
		}
	}
}

void cb_btnSearchNext (Fl_Button *b, void *d) {
	if (lastfind == -1)
		return;
	char *srchstr = new char[strlen(inpSearchString->value())+ 1];
	int i;
	strcpy(srchstr, inpSearchString->value());
	char *p = srchstr + strlen(srchstr) - 1;
	while (p > srchstr && *p == ' ') *p-- = 0;
	while (srchstr[0] == ' ') strcpy(srchstr, &srchstr[1]);
	p = srchstr;
	size_t len = strlen(srchstr);
	while (*p) {*p = toupper(*p); p++;}
	for (i = lastfind + 1; i < wBrowser->rows(); i++) {
		if (strncmp(srchstr, wBrowser->valueAt(i, 2), len) == 0) {
			lastfind = i;
			wBrowser->GotoRow(i);
			return;
		}
	}
}

int editNbr = 0;

void clearRecord() {
	Date tdy;
	inpCall->value ("");
	inpName->value ("");
	inpDate->value (tdy.szDate(2));
	inpTime->value ("0000");
	inpRstR->value ("599");
	inpRstS->value ("599");
	inpFreq->value ("");
	inpMode->value ("");
	inpQth->value ("");
	inpQSLrcvddate->value ("");
	chkQSLR->clear();
	chkQSLS->clear();
	inpComment->value ("");
	editGroup->show();
}

void saveRecord() {
cQsoRec rec;
	rec.putField(CALL, inpCall->value());
	rec.putField(NAME, inpName->value());
	rec.putField(QSO_DATE, inpDate->value());
	rec.putField(TIME_ON, inpTime->value());
	rec.putField(RST_RCVD, inpRstR->value());
	rec.putField(RST_SENT, inpRstS->value());
	rec.putField(FREQ, inpFreq->value());
	rec.putField(MODE, inpMode->value());
	rec.putField(QTH, inpQth->value());
	rec.putField(COMMENT, inpComment->value());
	rec.putField(QSLRDATE, inpQSLrcvddate->value());
	rec.putField(QSLSDATE, inpQSLsentdate->value());
	rec.putField(QSL_RCVD, chkQSLR->value() == 1 ? "R" : "");  
	rec.putField(QSL_SENT, chkQSLS->value() == 1 ? "S" : "");
	qsodb.qsoNewRec (&rec);
}

void updateRecord() {
cQsoRec rec;
	if (qsodb.nbrRecs() == 0) return;
	rec.putField(CALL, inpCall->value());
	rec.putField(NAME, inpName->value());
	rec.putField(QSO_DATE, inpDate->value());
	rec.putField(TIME_ON, inpTime->value());
	rec.putField(RST_RCVD, inpRstR->value());
	rec.putField(RST_SENT, inpRstS->value());
	rec.putField(FREQ, inpFreq->value());
	rec.putField(MODE, inpMode->value());
	rec.putField(QTH, inpQth->value());
	rec.putField(COMMENT, inpComment->value());
	rec.putField(QSLRDATE, inpQSLrcvddate->value());
	rec.putField(QSLSDATE, inpQSLsentdate->value());
	rec.putField(QSL_RCVD, chkQSLR->value() == 1 ? "R" : "");  
	rec.putField(QSL_SENT, chkQSLS->value() == 1 ? "S" : "");
	qsodb.qsoUpdRec (editNbr, &rec);
	qsodb.isdirty(1);
	qsodb.qsoWriteFile(logfile);
	qsodb.isdirty(0);
}

void deleteRecord () {
	if (qsodb.nbrRecs() == 0) return;
	if (fl_choice("Confirm Delete", "No", "Yes", NULL)) {
		qsodb.qsoDelRec(editNbr);
		loadBrowser();
		qsodb.isdirty(1);
		qsodb.qsoWriteFile(logfile);
		qsodb.isdirty(0);
	}
}

void EditRecord( int i )
{
	cQsoRec *editQSO = qsodb.getRec (i);
	if( !editQSO ) 
		return;

	inpCall->value (editQSO->getField(CALL));
	inpName->value (editQSO->getField(NAME));
	inpDate->value (editQSO->getField(QSO_DATE));
	inpTime->value (editQSO->getField(TIME_ON));
	inpRstR->value (editQSO->getField(RST_RCVD));
	inpRstS->value (editQSO->getField(RST_SENT));
	inpFreq->value (editQSO->getField(FREQ));
	inpMode->value (editQSO->getField(MODE));
	inpQth->value (editQSO->getField(QTH));
	inpQSLrcvddate->value (editQSO->getField(QSLRDATE));
	inpQSLsentdate->value (editQSO->getField(QSLSDATE));
	editQSO->getField(QSL_RCVD)[0] == 'R' ? 
		chkQSLR->set() : chkQSLR->clear();
	editQSO->getField(QSL_SENT)[0] == 'S' ?
		chkQSLS->set() : chkQSLS->clear();
	inpComment->value (editQSO->getField(COMMENT));
	editGroup->show();
}

void cb_browser (Fl_Widget *w, void *data )
{
	Table *table = (Table *)w;
	editNbr = atoi(table->valueAt(-1,7));
	EditRecord (editNbr);  
}

void loadBrowser()
{
	cQsoRec *rec;
	char sNbr[4];
	wBrowser->clear();
	if (qsodb.nbrRecs() == 0)
		return;
	for( int i = 0; i < qsodb.nbrRecs(); i++ ) {
		rec = qsodb.getRec (i);
		sprintf(sNbr,"%d",i);
		wBrowser->addRow (8,
			rec->getField(QSO_DATE),
			rec->getField(TIME_ON),
			rec->getField(CALL),
			rec->getField(NAME),
			rec->getField(FREQ),
			rec->getField(MODE),
			rec->getField(QTH),
			sNbr);
	}
	wBrowser->LastRow ();
	char szRecs[6];
	sprintf(szRecs,"%5d", qsodb.nbrRecs());
	txtNbrRecs->value(szRecs);
}


