#ifndef QSO_DB
#define QSO_DB

#include <iostream.h>
#include <fstream.h>
//#include <istream>
//#include <ostream>
//#include <fstream>

#include <stdlib.h>
#include <ctype.h>

#include "adif_def.h"
//#include "myprofile.h"

#ifndef TRUE
#define TRUE 1
#undef FALSE
#define FALSE 0
#endif

enum COMPMODE {COMPTIME, COMPDATE, COMPCALL, COMPMODE};

class cQsoRec {

friend int compareCalls (const cQsoRec &, const cQsoRec &);
friend int compareDates (const cQsoRec &, const cQsoRec &);
friend int compareTimes (const cQsoRec &, const cQsoRec &);
friend int compareModes (const cQsoRec &, const cQsoRec &);
friend ostream &operator<<( ostream &, const cQsoRec &);
friend istream &operator>>( istream &, cQsoRec & );

private:
  char *qsofield[NUMFIELDS];
public:
  cQsoRec ();
  ~cQsoRec ();
  void putField (int, const char *);
  void addtoField (int, const char *);
  char *getField (int);
  void trimFields();
  void clearRec ();
  int  validRec();
// operator overloads
  const cQsoRec &operator=(const cQsoRec &);
  bool operator==(const cQsoRec &) const;
  bool operator<(const cQsoRec &) const;
  bool operator!=(const cQsoRec &right) const {
    return !( *this == right);
  }
  bool operator<=(const cQsoRec &right) const {
    if (*this < right || *this == right)
      return TRUE;
    return FALSE;
  }
  bool operator>(const cQsoRec &right) const {
    return !(*this <= right);
  }  
};

class cQsoDb {
private:
  cQsoRec * qsorec;
  int maxrecs;
  int nbrrecs;
  int dirty;
public:
  cQsoDb ();
  ~cQsoDb ();
  void deleteRecs();
  void clearDatabase();
  void isdirty(int n) {dirty = n;}
  int  isdirty() {return dirty;}
  void qsoNewRec (cQsoRec *);
  void qsoDelRec (int);
  void qsoUpdRec (int, cQsoRec *);
  int qsoFindRec (cQsoRec *);
  cQsoRec *getRec (int n) {return &qsorec[n];};
  int nbrRecs () {return nbrrecs;};
  bool qsoIsValidFile(char *);
  int qsoReadFile (char *);
  int qsoWriteFile (char *);
  void SortByDate();
  void SortByCall ();
  void SortByMode ();
};

#endif
