#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 1993, 1994, 1998, 2003, 2004 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test long input line handling
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

fail()
{
	set +x
	echo FAILED test of long input line handling 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# look for mangled output lines
#
cat > test.in << 'fubar'
	trace(("gen_plosive(phone = %s, segdur = %d, prev_phone = %s, next_phone = %s)\n{\n"/*}*/, phonemes_name(phone), segdur, phonemes_name(prev_phone), phonemes_name(next_phone)));
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
FILE A: test.in
FILE B: test.in
TOTALS: 0 inserted  0 deleted  1 matched
            trace(("gen_plosive(phone = %s, segdur = %d, prev_phone = %s, next_phone = %s)\n{\n"/*}*/, phonemes_name(phone), segdur, phonemes_name(prev_phone), phonemes_name(next_phone)));
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -w test.in test.in -o test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
