/*
 *  IRIX $B%5%&%s%I=hM}(B
 */

/*
 *  Copyright (c) 1994 Ken, SHIBATA
 *
 *  $BK\%=%U%H%&%'%"$N%=!<%9$d%P%$%J%j$r:FG[I[$9$k>l9g$O!"<!$N>r7o$r=e<i$7$F(B
 *  $B2<$5$$!#(B
 *
 *  1. $BK\%=%U%H%&%'%"$rF~<j$7$?J}$K$O!"(BX11$BHG(B Emi Clock $B$N;HMQ8"$H!"Bh;0<T(B
 *     $B$X$N:FG[I[8"$,G'$a$i$l$^$9!#$?$@$7!":FG[I[$K4X$7$F$O!"F~<j;~$N%*%j(B
 *     $B%8%J%k$N$^$^2~JQ$;$:$K9T$&$3$H$,>r7o$G$9!#(B
 *  2. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$G2~JQ$7$FG[I[$9$k$3(B
 *     $B$H$O$G$-$^$;$s!#(B
 *  3. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$GFs<!MxMQ$9$k$3$H$O(B
 *     $B$G$-$^$;$s!#(B
 *  4. $BK\%=%U%H%&%'%"$r%7%9%F%`$K%P%s%I%k$7$?$j!"%7%9%F%`$NDI2C%Q%C%1!<%8(B
 *     $B$H$7$FBh;0<T$K:FG[I[$7$?$j$9$k>l9g$O!";vA0$KCx:n8"<T$K5v2D$,I,MW$G(B
 *     $B$9!#(B
 *  5. $BK\%=%U%H%&%'%"$r>&MQ$K;HMQ$9$k>l9g(B($B6bA,E*Mx1W$rF@$k>l9g(B)$B$O!";vA0$K(B
 *     $BCx:n8"<T$K5v2D$,I,MW$G$9!#$3$N>l9g!"4pK\E*$KM-=~$H$J$j$^$9!#(B
 *  6. $BK\%=%U%H%&%'%"$rMxMQ$9$k$3$H$K$h$C$FH/@8$7$?$$$+$J$kB;32$b!"Cx:n8"(B
 *     $B<T$OIi$o$J$$$b$N$H$7$^$9!#$3$l$K9g0U$G$-$J$$>l9g$O!";HMQ8"$,$J$$$b(B
 *     $B$N$H$7$^$9!#(B
 *  7. $B!H(BEmi Clock$B!I$N>&I8$*$h$SK\%=%U%H%&%'%"$N2hA|$d%G%6%$%s$K4X$9$kCx:n(B
 *     $B8"$O!"(BMotosoft $B$3$H!HK\(B $B=SLi!I;a$,M-$7$^$9!#(B
 *  8. $B!H(BEmi Clock$B!I$N>&I8$*$h$S2hA|$d%G%6%$%s$O!"(BX11$BHG(B Emi Clock $B3+H/$N$?(B
 *     $B$a!"(BMotosoft $B$h$j!H8E>l(B $B@59T!I$X8D?ME*$K%i%$%;%s%96!M?$5$l$F$^$9!#(B
 *     $BBh;0<T$XFs<!%i%$%;%s%96!M?$9$k$3$H$OG'$a$i$l$F$*$j$^$;$s!#(B
 *  9. Motosoft $B$H8E>l$KL5CG$G!"K\%=%U%H%&%'%"$N2hA|%G!<%?$rFs<!MxMQ$9$k$3(B
 *     $B$H$r6X;_$7$^$9!#(B
 * 10. $B$3$3$K5-=R$7$?0J30$N8"Mx$K$D$$$F$O!"F|K\9q$NCx:n8"K!$K$h$k$b$N$H$7(B
 *     $B$^$9!#(B
 */


/* $BDj?t(B */
#define	HAS_SOUND_CODE		/* $B%5%&%s%I4X78$N%3!<%I$OM-8z!*(B */

/* RCS ID */
rcsId(audioId, "$Id: audio.c,v 1.2 1999/09/02 14:34:37 koba Exp $")


/*
 *  $B%5%&%s%I4D6-$N=i4|2=(B
 */
static void
    S_SoundEnvInit()
{
    /* $B2?$b$7$J$$(B */
}

/*
 *  $B%5%&%s%I%G%P%$%9$NB8:_H=Dj(B
 */
static Boolean
    S_IsSoundAvailable()
{
    int flag = False;
    inventory_t *inv;
    
    while( (inv = getinvent()) != NULL )
	if (inv->inv_class == INV_AUDIO) {
	    flag = True;
	    break;
	}
    endinvent();
    
    return(flag);
}

/*
 *  $B%5%&%s%I:F@8(B
 */
static int
    S_PlaySound(filename)
char	*filename;
{
    int ret;
    SoundCacheBuffer localcache;

    if((ret = S_CacheSound(filename, &localcache)) != SOUND_NO_ERROR)
	return(ret);
    if((ret = S_PlayCacheSound(&localcache)) != SOUND_NO_ERROR)
	return(ret);
    S_FreeCacheSound(&localcache);
    return(SOUND_NO_ERROR);
}

/*
 *  $B%5%&%s%I$N%-%c%C%7%e2=2DG=!?IT2DG=H=Dj(B
 */
static Boolean
    S_IsSoundCacheAvailable()
{
    return(True);
}


/*
 *  $B%5%&%s%I$N%-%c%C%7%e2=(B
 */
static int
    S_CacheSound(filename, c_buff)
char		*filename;
SoundCacheBuffer	*c_buff;
{
    
    int i;
    int fd;			/* input file descriptor */
    AFfilehandle audio_file;
    long samp_type;
    long bits_per_samp;		/* sample resolution */
    int total_samp_bytes;
    int total_frames;   
    int bytes_per_samp;		/* sample width */
    int bytes_per_buf;		/* bytes / sample buffer */
    
    /* audio file $B$N%*!<%W%s(B */
    if ((fd = open(filename, O_RDONLY)) < 0 ) {
	return(SOUND_FILE_INVALID);
    }

    if(AFidentifyfd(fd) < 0 ) {
	close(fd);
	return(SOUND_FILE_INVALID);
    }
    if(( audio_file = AFopenfd(fd, "r", AF_NULL_FILESETUP))
       == AF_NULL_FILEHANDLE) {
	close(fd);
	return(SOUND_FILE_INVALID);
    }
    /* $B%U%!%$%k$+$i$N(B frame size $B$NFI$_9~$_(B */
    c_buff->f_size = AFgetchannels(audio_file, AF_DEFAULT_TRACK);
    if((c_buff->f_size!=1)
     &&(c_buff->f_size!=2)
     &&(c_buff->f_size!=4)){
	AFclosefile(audio_file);
	close(fd);
	return  (SOUND_FILE_INVALID);
    }
    /* sample rate $B$N<hF@(B */
    c_buff->rate = AFgetrate(audio_file, AF_DEFAULT_TRACK);
    
    /* sample resolustion $B$N<hF@(B */
    AFgetsampfmt(audio_file, AF_DEFAULT_TRACK, &samp_type, &bits_per_samp);
    
    /* ALwritesamps $B$G$NFI$_9~$_%5%$%:$N7hDj(B */
    if (bits_per_samp <= 8) {
	bytes_per_samp = 1;
	c_buff->wordsize  = AL_SAMPLE_8;
    } else if (bits_per_samp <= 16) {
	bytes_per_samp = 2;
	c_buff->wordsize  = AL_SAMPLE_16;
    } else if (bits_per_samp <= 24) {
	bytes_per_samp = 4;
	c_buff->wordsize  = AL_SAMPLE_24;
    } else {
	AFclosefile(audio_file);
	close(fd);
	return(-1);
    }
    /* $B#1%P%C%U%!%5%$%:$N<hF@(B */
    c_buff->frames = ((long)(c_buff->rate)+1)/2;
    
    c_buff->samples = c_buff->frames * c_buff->f_size;
    bytes_per_buf = c_buff->samples * bytes_per_samp;
    
    /* $BFI$_9~$_2s?t$N<hF@(B */
    total_frames    =  AFgetframecnt(audio_file, AF_DEFAULT_TRACK);
    if (total_frames > 0) {
	total_samp_bytes = 
	    total_frames * c_buff->f_size * bytes_per_samp;
	c_buff->num_bufs         = total_samp_bytes / bytes_per_buf;
	c_buff->l_frames  = (total_samp_bytes % bytes_per_buf)
	    / bytes_per_samp / c_buff->f_size;
    } else {
	AFclosefile(audio_file);
	close(fd);
	return(-1);
    }
    /* $BF,$K%7!<%/(B */
    AFseekframe(audio_file, AF_DEFAULT_TRACK, 0);
    
    /* $B%P%C%U%!$N3NJ]$H%G!<%?$NFI$_9~$_(B */
    c_buff->cache = (char **)XtMalloc( sizeof(char *) * (c_buff->num_bufs +1));
    for( i=0; i < c_buff->num_bufs; i++ ){
	c_buff->cache[i] = XtMalloc(bytes_per_buf);
	AFreadframes(audio_file, AF_DEFAULT_TRACK, 
		     c_buff->cache[i], c_buff->frames);
    }
    c_buff->cache[c_buff->num_bufs] = XtMalloc(bytes_per_buf);
    AFreadframes(audio_file, AF_DEFAULT_TRACK, c_buff->cache[c_buff->num_bufs], 
		 c_buff->l_frames);
    
    AFclosefile(audio_file);
    close(fd);
    
    return(SOUND_NO_ERROR);
}


/*
 *  $B%-%c%C%7%e2=$5$l$?%5%&%s%I$N:F@8(B
 */
static int
    S_PlayCacheSound(c_buff)
SoundCacheBuffer	*c_buff;
{
    int i;
    ALport		audio_port;
    long pvbuf[4];
    ALconfig audio_port_config;
    
    /* $B1iAU;~$N%m%8%C%/(B */
    
    /* audio $B$,;HMQCf$+$I$&$+3NG'(B */
    pvbuf[0] = AL_OUTPUT_COUNT;
    pvbuf[2] = AL_MONITOR_CTL;
    if (ALgetparams(AL_DEFAULT_DEVICE, pvbuf, 4) < 0) {
	return (SOUND_OPEN_ERROR);
    }
    if ((pvbuf[1] != 0) || (pvbuf[3] != AL_MONITOR_OFF)) {
	return (SOUND_DEVICE_BUSY);
    }
    
    /* sample rate $B$N@_Dj(B */
    pvbuf[0] = AL_OUTPUT_RATE;
    pvbuf[1] = (long)(c_buff->rate);
    ALsetparams(AL_DEFAULT_DEVICE, pvbuf, 2);
    
    /* configure and open audio port */
    audio_port_config = ALnewconfig();
    ALsetwidth(audio_port_config, c_buff->wordsize);
    ALsetchannels(audio_port_config, c_buff->f_size);
    
    /* make the ring buffer large enough to hold 1 sec of audio samples */
    ALsetqueuesize(audio_port_config, c_buff->samples*2);
    audio_port = ALopenport("emiclock", "w", audio_port_config);
    if (audio_port == 0) {
	return(SOUND_OPEN_ERROR);
    }
    
    for (i=0; i<c_buff->num_bufs; i++)
    {
	ALwritesamps(audio_port, c_buff->cache[i],
		     c_buff->frames * c_buff->f_size);
    }
    ALwritesamps(audio_port, c_buff->cache[c_buff->num_bufs],
		 c_buff->l_frames * c_buff->f_size);
    
    while(ALgetfilled(audio_port) > 0) {
	sginap(1);
    }
    sginap(10);
    ALcloseport(audio_port);
    
    return(SOUND_NO_ERROR);
}


/*
 *  $B%-%c%C%7%e2=$5$l$?%5%&%s%I$N3+J|(B
 */
static void
    S_FreeCacheSound(c_buff)
SoundCacheBuffer	*c_buff;
{
    int i;
    
    for( i=0; i <= c_buff->num_bufs; i++ ){
	XtFree(c_buff->cache[i]);
    }
    XtFree((char *)(c_buff->cache));
}

/*
 *  $B%5%&%s%I4D6-$N8e;OKv(B
 */
static void
    S_SoundEnvDispose()
{
    /* $B2?$b$7$J$$(B */
}
