// SPDX-FileCopyrightText: 2019-2022 Connor McLaughlin <stenzek@gmail.com>
// SPDX-License-Identifier: (GPL-3.0 OR CC-BY-NC-ND-4.0)

#include "libcrypt_serials.h"

namespace LibcryptGameList {

static const char* LIBCRYPT_GAME_SERIALS[] = {
  "SLES-01226", // Actua Ice Hockey 2 (Europe)
  "SLES-01226", // Actua Ice Hockey 2 (Europe)
  "SLES-02563", // Anstoss - Premier Manager (Germany)
  "SCES-01564", // Ape Escape (Europe)
  "SCES-01564", // Ape Escape (Europe)
  "SCES-02028", // Ape Escape (France)
  "SCES-02029", // Ape Escape (Germany)
  "SCES-02030", // Ape Escape (Italy)
  "SCES-02031", // Ape Escape - La Invasion de los Monos (Spain)
  "SLES-03324", // Asterix - Mega Madness (Europe) (En,Fr,De,Es,It,Nl)
  "SCES-02366", // Barbie - Aventure Equestre (France)
  "SCES-02365", // Barbie - Race & Ride (Europe)
  "SCES-02367", // Barbie - Race & Ride (Germany)
  "SCES-02368", // Barbie - Race & Ride (Italy)
  "SCES-02369", // Barbie - Race & Ride (Spain)
  "SCES-02488", // Barbie - Sports Extreme (France)
  "SCES-02489", // Barbie - Super Sport (Germany)
  "SCES-02487", // Barbie - Super Sports (Europe)
  "SCES-02490", // Barbie - Super Sports (Italy)
  "SCES-02491", // Barbie - Super Sports (Spain)
  "SLES-02977", // BDFL Manager 2001 (Germany)
  "SLES-03605", // BDFL Manager 2002 (Germany)
  "SLES-02293", // Canal+ Premier Manager (Europe) (Fr,Es,It)
  "SLES-02766", // Cochons de Guerre, Les (France)
  "SCES-02834", // Crash Bash (Europe) (En,Fr,De,Es,It)
  "SCES-02834", // Crash Bash (Europe) (En,Fr,De,Es,It)
  "SCES-02105", // CTR - Crash Team Racing (Europe) (En,Fr,De,Es,It,Nl)
  "SCES-02105", // CTR - Crash Team Racing (Europe) (En,Fr,De,Es,It,Nl)
  "SCES-02105", // CTR - Crash Team Racing (Europe) (En,Fr,De,Es,It,Nl) (EDC)
  "SLES-02207", // Dino Crisis (Europe)
  "SLES-02208", // Dino Crisis (France)
  "SLES-02209", // Dino Crisis (Germany)
  "SLES-02210", // Dino Crisis (Italy)
  "SLES-02211", // Dino Crisis (Spain)
  "SCES-02004", // Disney Fais Ton Histoire! Mulan (France)
  "SCES-02006", // Disney Libro Animato Creativo - Mulan (Italy)
  "SCES-01516", // Disney Tarzan (France)
  "SCES-01518", // Disney Tarzan (Italy)
  "SCES-01519", // Disney Tarzan (Spain)
  "SLES-03189", // Disney's 102 Dalmatians - Puppies to the Rescue (Europe) (Rev 1)
  "SLES-03191", // Disney's 102 Dalmatians - Puppies to the Rescue (Europe) (Fr,De,Es,It,Nl)
  "SLES-03190", // Disney's 102 Dalmatians - Puppies to the Rescue (Scandinavia) (Sv,No,Da)
  "SCES-02007", // Disney's Aventura Interactiva - Mulan (Spain)
  "SCES-01695", // Disney's Mulan - Story Studio (Europe)
  "SCES-01431", // Disney's Tarzan (Europe)
  "SCES-02185", // Disney's Tarzan (Netherlands)
  "SCES-02264", // Disney's Verhalenstudio - Mulan (Netherlands)
  "SCES-02184", // Disneyn Tarzan (Finland)
  "SCES-02005", // Disneys Interaktive Abenteuer - Mulan (Germany)
  "SCES-02181", // Disneys Tarzan (Denmark)
  "SCES-01517", // Disneys Tarzan (Germany)
  "SCES-02182", // Disneys Tarzan (Sweden)
  "SLES-02538", // EA Sports Superbike 2000 (Europe) (En,Fr,De,Es,It,Sv)
  "SLES-01715", // Eagle One - Harrier Attack (Europe) (En,Fr,De,Es,It)
  "SLES-01715", // Eagle One - Harrier Attack (Europe) (En,Fr,De,Es,It)
  "SCES-01704", // Esto Es Futbol (Spain)
  "SLES-03061", // F.A. Premier League Football Manager 2001, The (Europe)
  "SLES-02722", // F1 2000 (Europe) (En,Fr,De,Nl)
  "SLES-02723", // F1 2000 (Europe) (En,Es,Sv,Da,Fi)
  "SLES-02724", // F1 2000 (Italy)
  "SLES-12965", // Final Fantasy IX (Europe) (Disc 2)
  "SLES-02965", // Final Fantasy IX (Europe) (Disc 1)
  "SLES-22965", // Final Fantasy IX (Europe) (Disc 3)
  "SLES-32965", // Final Fantasy IX (Europe) (Disc 4)
  "SLES-02966", // Final Fantasy IX (France) (Disc 1)
  "SLES-12966", // Final Fantasy IX (France) (Disc 2)
  "SLES-22966", // Final Fantasy IX (France) (Disc 3)
  "SLES-32966", // Final Fantasy IX (France) (Disc 4)
  "SLES-02967", // Final Fantasy IX (Germany) (Disc 1)
  "SLES-12967", // Final Fantasy IX (Germany) (Disc 2)
  "SLES-22967", // Final Fantasy IX (Germany) (Disc 3)
  "SLES-32967", // Final Fantasy IX (Germany) (Disc 4)
  "SLES-02968", // Final Fantasy IX (Italy) (Disc 1)
  "SLES-12968", // Final Fantasy IX (Italy) (Disc 2)
  "SLES-22968", // Final Fantasy IX (Italy) (Disc 3)
  "SLES-32968", // Final Fantasy IX (Italy) (Disc 4)
  "SLES-02969", // Final Fantasy IX (Spain) (Disc 1)
  "SLES-12969", // Final Fantasy IX (Spain) (Disc 2)
  "SLES-22969", // Final Fantasy IX (Spain) (Disc 3)
  "SLES-32969", // Final Fantasy IX (Spain) (Disc 4)
  "SCES-02080", // Final Fantasy VIII (Europe, Australia) (Disc 1)
  "SLES-02080", // Final Fantasy VIII (Europe, Australia) (Disc 1)
  "SCES-22080", // Final Fantasy VIII (Europe, Australia) (Disc 3)
  "SLES-22080", // Final Fantasy VIII (Europe, Australia) (Disc 3)
  "SCES-32080", // Final Fantasy VIII (Europe, Australia) (Disc 4)
  "SLES-32080", // Final Fantasy VIII (Europe, Australia) (Disc 4)
  "SCES-12080", // Final Fantasy VIII (Europe, Australia) (Disc 2)
  "SLES-12080", // Final Fantasy VIII (Europe, Australia) (Disc 2)
  "SLES-02081", // Final Fantasy VIII (France) (Disc 1)
  "SLES-12081", // Final Fantasy VIII (France) (Disc 2)
  "SLES-22081", // Final Fantasy VIII (France) (Disc 3)
  "SLES-32081", // Final Fantasy VIII (France) (Disc 4)
  "SLES-02082", // Final Fantasy VIII (Germany) (Disc 1)
  "SLES-12082", // Final Fantasy VIII (Germany) (Disc 2)
  "SLES-22082", // Final Fantasy VIII (Germany) (Disc 3)
  "SLES-32082", // Final Fantasy VIII (Germany) (Disc 4)
  "SLES-02083", // Final Fantasy VIII (Italy) (Disc 1)
  "SLES-12083", // Final Fantasy VIII (Italy) (Disc 2)
  "SLES-22083", // Final Fantasy VIII (Italy) (Disc 3)
  "SLES-32083", // Final Fantasy VIII (Italy) (Disc 4)
  "SLES-02084", // Final Fantasy VIII (Spain) (Disc 1)
  "SLES-12084", // Final Fantasy VIII (Spain) (Disc 2)
  "SLES-22084", // Final Fantasy VIII (Spain) (Disc 3)
  "SLES-32084", // Final Fantasy VIII (Spain) (Disc 4)
  "SLES-02978", // Football Manager Campionato 2001 (Italy)
  "SLES-03606", // Football Manager Campionato 2002 (Italy)
  "SCED-01979", // Formula One '99 (Europe) (En,Fr,De,It) (Beta)
  "SCES-02222", // Formula One 99 (Europe) (En,Es,Fi)
  "SCES-01979", // Formula One 99 (Europe) (En,Fr,De,It)
  "SLES-02767", // Frontschweine (Germany)
  "SCES-01702", // Fussball Live (Germany)
  "SLES-03062", // Fussball Manager 2001 (Germany)
  "SLES-02328", // Galerians (Europe) (Disc 1)
  "SLES-12328", // Galerians (Europe) (Disc 2)
  "SLES-22328", // Galerians (Europe) (Disc 3)
  "SLES-02329", // Galerians (France) (Disc 1)
  "SLES-12329", // Galerians (France) (Disc 2)
  "SLES-22329", // Galerians (France) (Disc 3)
  "SLES-02330", // Galerians (Germany) (Disc 1)
  "SLES-12330", // Galerians (Germany) (Disc 2)
  "SLES-22330", // Galerians (Germany) (Disc 3)
  "SLES-01241", // Gekido - Urban Fighters (Europe) (En,Fr,De,Es,It)
  "SLES-01241", // Gekido - Urban Fighters (Europe) (En,Fr,De,Es,It)
  "SLES-01041", // Hogs of War (Europe)
  "SLES-01041", // Hogs of War (Europe)
  "SLES-02769", // Hogs of War - Nati per Soffritto (Italy)
  "SLES-03489", // Italian Job, The (Europe)
  "SLES-03489", // Italian Job, The (Europe)
  "SLES-03626", // Italian Job, The (Europe) (Fr,De,Es)
  "SLES-03648", // Italian Job, The (Italy)
  "SCES-01444", // Jackie Chan Stuntmaster (Europe)
  "SLES-01362", // Le Mans 24 Hours (Europe) (En,Fr,De,Es,It,Pt)
  "SLES-01362", // Le Mans 24 Hours (Europe) (En,Fr,De,Es,It,Pt)
  "SLES-01301", // Legacy of Kain - Soul Reaver (Europe)
  "SLES-01301", // Legacy of Kain - Soul Reaver (Europe)
  "SLES-02024", // Legacy of Kain - Soul Reaver (France)
  "SLES-02025", // Legacy of Kain - Soul Reaver (Germany)
  "SLES-02027", // Legacy of Kain - Soul Reaver (Italy)
  "SLES-02026", // Legacy of Kain - Soul Reaver (Spain)
  "SLES-02975", // LMA Manager 2001 (Europe)
  "SLES-03603", // LMA Manager 2002 (Europe)
  "SLES-03530", // Lucky Luke - Western Fever (Europe) (En,Fr,De,Es,It,Nl)
  "SLES-02402", // Manager de Liga (Spain) (Beta)
  "SLES-02979", // Manager de Liga 2001 (Spain)
  "SLES-03607", // Manager de Liga 2002 (Spain)
  "SLES-02768", // Marranos en Guerra (Spain)
  "SCES-00311", // MediEvil (Europe)
  "SCES-01492", // MediEvil (France)
  "SCES-01493", // MediEvil (Germany)
  "SCES-01494", // MediEvil (Italy)
  "SCES-01494", // MediEvil (Italy)
  "SCES-01495", // MediEvil (Spain)
  "SCES-02545", // MediEvil 2 (Europe) (Es,It,Pt)
  "SCES-02545", // MediEvil 2 (Europe) (Es,It,Pt)
  "SCES-02544", // MediEvil 2 (Europe) (En,Fr,De)
  "SCES-02544", // MediEvil 2 (Europe) (En,Fr,De)
  "SCES-02546", // MediEvil 2 (Russia)
  "SLES-03519", // Men in Black - The Series - Crashdown (Europe)
  "SLES-03519", // Men in Black - The Series - Crashdown (Europe)
  "SLES-03520", // Men in Black - The Series - Crashdown (France)
  "SLES-03520", // Men in Black - The Series - Crashdown (France)
  "SLES-03521", // Men in Black - The Series - Crashdown (Germany)
  "SLES-03522", // Men in Black - The Series - Crashdown (Italy)
  "SLES-03522", // Men in Black - The Series - Crashdown (Italy)
  "SLES-03523", // Men in Black - The Series - Crashdown (Spain)
  "SLES-02395", // Michelin Rally Masters - Race of Champions (Europe) (Fr,Es,It)
  "SLES-01545", // Michelin Rally Masters - Race of Champions (Europe) (En,De,Sv)
  "SLES-02839", // Mike Tyson Boxing (Europe) (En,Fr,De,Es,It)
  "SLES-01906", // Mission - Impossible (Europe) (En,Fr,De,Es,It)
  "SLES-02830", // MoHo (Europe) (En,Fr,De,Es,It)
  "SCES-01701", // Monde des Bleus, Le - Le Jeu Officiel de l'Equipe de France (France)
  "SLES-02086", // N-Gen Racing (Europe) (En,Fr,De,Es,It)
  "SLES-02086", // N-Gen Racing (Europe) (En,Fr,De,Es,It)
  "SLES-02700", // Need for Speed - Porsche 2000 (Europe) (Fr,Es,It)
  "SLES-02689", // Need for Speed - Porsche 2000 (Europe) (En,De,Sv)
  "SLES-02689", // Need for Speed - Porsche 2000 (Europe) (En,De,Sv)
  "SLES-02558", // Parasite Eve II (Europe) (Disc 1)
  "SLES-12558", // Parasite Eve II (Europe) (Disc 2)
  "SLES-12559", // Parasite Eve II (France) (Disc 2)
  "SLES-02559", // Parasite Eve II (France) (Disc 1)
  "SLES-02560", // Parasite Eve II (Germany) (Disc 1)
  "SLES-12560", // Parasite Eve II (Germany) (Disc 2)
  "SLES-02562", // Parasite Eve II (Italy) (Disc 1)
  "SLES-12562", // Parasite Eve II (Italy) (Disc 2)
  "SLES-02561", // Parasite Eve II (Spain) (Disc 1)
  "SLES-12561", // Parasite Eve II (Spain) (Disc 2)
  "SLES-02061", // PGA European Tour Golf (Europe) (En,De)
  "SLES-02396", // PGA European Tour Golf (Europe) (Fr,Es,It)
  "SLES-02396", // PGA European Tour Golf (Europe) (Fr,Es,It) (Alt)
  "SLES-02292", // Premier Manager 2000 (Europe)
  "SLES-00017", // Prince Naseem Boxing (Europe) (En,Fr,De,Es,It)
  "SLES-01943", // Radikal Bikers (Europe) (En,Fr,De,Es,It)
  "SLES-01943", // Radikal Bikers (Europe) (En,Fr,De,Es,It)
  "SLES-02824", // RC Revenge (Europe) (En,Fr,De,Es)
  "SLES-02529", // Resident Evil 3 - Nemesis (Europe)
  "SLES-02530", // Resident Evil 3 - Nemesis (France)
  "SLES-02531", // Resident Evil 3 - Nemesis (Germany)
  "SLES-02533", // Resident Evil 3 - Nemesis (Italy)
  "SLES-02698", // Resident Evil 3 - Nemesis (Ireland)
  "SLES-02532", // Resident Evil 3 - Nemesis (Spain)
  "SLES-02976", // Roger Lemerre - La Selection des Champions (France)
  "SLES-03604", // Roger Lemerre - La Selection des Champions 2002 (France)
  "SLES-02681", // Ronaldo V-Football (Europe) (De,Es,It,Pt)
  "SLES-00995", // Ronaldo V-Football (Europe) (En,Fr,Nl,Sv)
  "SLES-02112", // SaGa Frontier 2 (Europe)
  "SLES-02113", // SaGa Frontier 2 (France)
  "SLES-02118", // SaGa Frontier 2 (Germany)
  "SLES-02763", // SnoCross Championship Racing (Europe) (En,Fr,De,Es,It)
  "SCES-02290", // Space Debris (Europe)
  "SCES-02430", // Space Debris (France)
  "SCES-02431", // Space Debris (Germany)
  "SCES-02432", // Space Debris (Italy)
  "SCES-02433", // Space Debris (Spain)
  "SCES-01763", // Speed Freaks (Europe)
  "SCES-02104", // Spyro 2 - Gateway to Glimmer (Europe) (En,Fr,De,Es,It)
  "SCES-02835", // Spyro - Year of the Dragon (Europe) (En,Fr,De,Es,It) (Rev 1)
  "SCES-02835", // Spyro - Year of the Dragon (Europe) (En,Fr,De,Es,It)
  "SLES-02862", // Sydney 2000 (Australia)
  "SLES-02857", // Sydney 2000 (Europe)
  "SLES-02858", // Sydney 2000 (France)
  "SLES-02859", // Sydney 2000 (Germany)
  "SLES-02860", // Sydney 2000 (Italy)
  "SLES-02861", // Sydney 2000 (Spain)
  "SLES-03245", // TechnoMage - De Terugkeer der Eeuwigheid (Netherlands)
  "SLES-02831", // TechnoMage - Die Rueckkehr der Ewigkeit (Germany)
  "SLES-03244", // Technomage - El Retorno de la Eternidad (Spain)
  "SLES-03242", // TechnoMage - En Quete de L'Eternite (France)
  "SLES-03241", // TechnoMage - Return of Eternity (Europe)
  "SLES-03243", // TechnoMage - Ritorno all'Eternita (Italy)
  "SLES-02688", // Theme Park World (Europe) (En,Fr,De,Es,It,Nl,Sv)
  "SLES-02688", // Theme Park World (Europe) (En,Fr,De,Es,It,Nl,Sv)
  "SCES-01882", // This Is Football (Europe) (Fr,Nl)
  "SCES-01700", // This Is Football (Europe)
  "SCES-01703", // This Is Football (Italy)
  "SLES-02572", // TOCA World Touring Cars (Europe) (En,Fr,De)
  "SLES-02572", // TOCA World Touring Cars (Europe) (En,Fr,De)
  "SLES-02573", // TOCA World Touring Cars (Europe) (Es,It)
  "SLES-02704", // UEFA Euro 2000 (Europe)
  "SLES-02705", // UEFA Euro 2000 (France)
  "SLES-02706", // UEFA Euro 2000 (Germany)
  "SLES-02707", // UEFA Euro 2000 (Italy)
  "SLES-02708", // UEFA Euro 2000 (Spain)
  "SLES-01733", // UEFA Striker (Europe) (En,Fr,De,Es,It,Nl)
  "SLES-02071", // Urban Chaos (Europe) (En,Es,It)
  "SLES-02071", // Urban Chaos (Europe) (En,Es,It)
  "SLES-02354", // Urban Chaos (France)
  "SLES-02355", // Urban Chaos (Germany)
  "SLES-02355", // Urban Chaos (Germany)
  "SLES-01907", // V-Rally - Championship Edition 2 (Europe) (En,Fr,De)
  "SLES-01907", // V-Rally - Championship Edition 2 (Europe) (En,Fr,De)
  "SLES-01907", // V-Rally - Championship Edition 2 (Europe) (En,Fr,De)
  "SLES-02754", // Vagrant Story (Europe)
  "SLES-02755", // Vagrant Story (France)
  "SLES-02756", // Vagrant Story (Germany)
  "SLES-02733", // Walt Disney World Quest - Magical Racing Tour (Europe) (En,Fr,De,Es,It,Nl,Sv,No,Da)
  "SLES-02733", // Walt Disney World Quest - Magical Racing Tour (Europe) (En,Fr,De,Es,It,Nl,Sv,No,Da)
  "SCES-01909", // Wip3out (Europe) (En,Fr,De,Es,It)
};

bool IsLibcryptGameCode(const std::string_view& serial)
{
  for (const char* compare_serial : LIBCRYPT_GAME_SERIALS)
  {
    if (serial == compare_serial)
      return true;
  }

  return false;
}

} // namespace LibcryptGameList