/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : waveshap.h
|
| Object      : DSPKitWaveShaper
|
| Description : DSPKitWaveShaper
|
| (c) Richard Kent 1996
|
| $Id: waveshap.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_WAVESHAPER_H_
#define _DSPKIT_WAVESHAPER_H_

#include "processo.h"
#include "dpreader.h"
#include "dist.h"

class DSPKitWaveShaper : public DSPKitProcessor
{
  public:

    DSPKitWaveShaper ();
    ~DSPKitWaveShaper ();
    int setInputAndBuffer (DSPKitProcessor *ip,DSPKitDPReader *bip);
    int setInputAndBuffer (DSPKitProcessor *ip,DSPKitDistortion *bip);
    int getSample (double &outputSample);

  protected:

    int   size;
    double *buffer;
    double maxValue;
    double minValue;
    double range;
};

inline DSPKitWaveShaper::DSPKitWaveShaper ()
{
  buffer = 0;
  size   = 0;
}

inline DSPKitWaveShaper::~DSPKitWaveShaper ()
{
  if (buffer) delete [] buffer;
}

#endif

/***************************************************************************/
