/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : delayint.h
|
| Object      : DSPKitDelayInt
|
| Description : DSPKitDelayInt
|
| (c) Richard Kent 1996
|
| $Id: delayint.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_DELAYINT_H_
#define _DSPKIT_DELAYINT_H_

#include "processo.h"

class DSPKitDelayInt : public DSPKitProcessor
{
  public:

    DSPKitDelayInt ();
    ~DSPKitDelayInt ();
    int setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    int setInputAndDelayTime (DSPKitProcessor *ip,double dt,int feedback);
    int setModInput (DSPKitProcessor *ip);
    int getSample (double &outputSample);

  protected:

    double getDelayOutput (int currentSampleIndex);
    
    DSPKitProcessor *modInput;
    double          delayTime;
    double          *buffer;
    int            bufSize;
    int            currentSampleIndex;
    int            lastSampleIndex;
    int            haveSamples;
    int            endOfInput;
};

#endif

/***************************************************************************/
