/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : delay.h
|
| Object      : DSPKitDelay
|
| Description : DSPKitDelay
|
| (c) Richard Kent 1996
|
| $Id: delay.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_DELAY_H_
#define _DSPKIT_DELAY_H_

#include "processo.h"

class DSPKitDelay : public DSPKitProcessor
{
  public:

    DSPKitDelay ();
    ~DSPKitDelay ();
    int setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    int getSample (double &outputSample);

  protected:

    double delayTime;
    double *buffer;
    int   bufSize;
    int   oldestSampleIndex;
    int   lastSampleIndex;
    int   haveSamples;
    int   endOfInput;
};

#endif

/***************************************************************************/
