/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : compress.cc
|
| Object      : DSPKitCompressor
|
| Description : DSPKitCompressor
|
| (c) Richard Kent 1996
|
| $Id: compress.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char compress_cc [] = "$Id: compress.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "compress.h"

DSPKitCompressor::DSPKitCompressor ()
{
  ratio = 1.0;
}

void DSPKitCompressor::setRatio (double r)
{
  if (r <= 0.0)
    r = 0.0001;
    
  ratio = r;
}

void DSPKitCompressor::scaleBuffer ()
{
  double scale;
  double scale1;
  double scale2;
  double scaleIncrement;
  int   i;
  
  i = writeIndex;

  if (absMax1 <= threshold && absMax2 <= threshold) return;

  if (absMax1 > threshold)
    scale1 = ((absMax1 - threshold) / ratio + threshold) / absMax1;
  else
    scale1 = 1.0;

  if (absMax2 > threshold)
    scale2 = ((absMax2 - threshold) / ratio + threshold) / absMax2;
  else
    scale2 = 1.0;

  scaleIncrement = (scale2 - scale1) / inputBufSize;

  scale = scale1;
  
  while (i != processIndex)
  {
    sampleBuffer [i] *= scale;
    i++;
    i %= bufSize;
    if (i == 0) scale += scaleIncrement;
  }
}

/***************************************************************************/
