/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : butterwo.cc
|
| Object      : DSPKitButterworthFilter
|
| Description : DSPKitButterworthFilter
|
| (c) Richard Kent 1996
|
| $Id: butterwo.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char butterwo_cc [] = "$Id: butterwo.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "butterwo.h"

int DSPKitButterworthFilter::setInput (DSPKitProcessor *ip)
{
  DSPKitProcessor::setInput (ip);
  chBuf.x [0] = 0.0;
  chBuf.x [1] = 0.0;
  chBuf.y [0] = 0.0;
  chBuf.y [1] = 0.0;
  return 1;
}

int DSPKitButterworthFilter::getSample (double &outputSample)
{
  double inputSample;
  if (!input->getSample (inputSample)) return 0;

  outputSample =
    a [0] * inputSample +
    a [1] * chBuf.x [0] +
    a [2] * chBuf.x [1] -
    b [0] * chBuf.y [0] -
    b [1] * chBuf.y [1];

  chBuf.x [1] = chBuf.x [0];
  chBuf.x [0] = inputSample;
  chBuf.y [1] = chBuf.y [0];
  chBuf.y [0] = outputSample;

  return 1;
}

/***************************************************************************/
