/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPResample.h
|
| Object      : None
|
| Description : Prototypes for the DPResample functions
|
| (c) Richard Kent 1996
|
| $Id: DPResample.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DPResample_h
#define _DPResample_h

#include <math.h>
#include <stdlib.h>
#include "DPSample.h"

int resample (
  DPSample *sample,
  DPSample *newSample,
  int      chan,
  int      R,
  int      N,
  int      Nw,
  int      D,
  int      I,
  double   P,
  double   synt);

void makewindows (
  double A [],
  double S [],
  int    Nw,
  int    N,
  int    I);

int shiftin (
  DPSample *sample,
  int     channel,
  double   A [],
  int      N,
  int      D,
  int      initialise);

void fold (
  double I [],
  double W [],
  int    Nw,
  double O [],
  int    N,
  int    n);

int convert (
  double S [],
  double C [],
  int    N2,
  int    D,
  int    R,
  int    initialise,
  int    remove);

int oscbank (
  double C [],
  int    N,
  int    R,
  int    I,
  double O [],
  double P,
  double synt,
  int    initialise,
  int    remove);

int unconvert (
  double C [],
  double S [],
  int    N2,
  int    I,
  int    R,
  int    initialise,
  int    remove);

void overlapadd (
  double I [],
  int    N,
  double W [],
  double O [],
  int    Nw,
  int    n);

void shiftout (
  DPSample *newSample,
  int      channel,
  double   A [],
  int      N,
  int      I,
  int      n,
  int      initialise);

void rfft (
  double x [],
  int    N,
  int    forward);

void cfft (
  double x [],
  int    NC,
  int    forward );

void bitreverse (
  double x [],
  int    N);

#endif // _DPResample_h

/***************************************************************************/
