/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_macros.h
|
| Object      : None
|
| Description : Macro handler header file
|
| (c) Richard Kent 1997
|
| $Id: DPTich_macros.h,v 1.1 2003/09/10 00:06:24 rk Exp $
|
****************************************************************************/

#ifndef _DPTich_macros_h
#define _DPTich_macros_h

#include "forms.h"
#include "DPSample.h"
#include "DPTich_prefs.h"

#define MACROSNAME         ".DAP.macros"
#define MACROCOMMANDLENGTH 256
#define MACRONAMELENGTH    128
#define MAXMACROS          32

#define MACROCURRENTBUFFER 1
#define MACROALLBUFFERS    2
#define MACRORAWMODE       1
#define MACROTEXTMODE      2
#define MACROTEMPAIFFMODE  3
#define MACROSAVEAIFFMODE  4
#define MACROINTERLEAVED   1
#define MACROSEPARATED     2
#define MACROBUFFERINPUT   1
#define MACRORANGEINPUT    2
#define MACROEITHERINPUT   3
#define MACRONONEINPUT     4
#define MACROBUFFEROUTPUT  1
#define MACRODIALOGOUTPUT  2
#define MACRONONEOUTPUT    3
#define MACROBYTEFORMAT    1
#define MACROSHORTFORMAT   2
#define MACROLONG24FORMAT  3
#define MACROLONG32FORMAT  4
#define MACROFLOATFORMAT   5
#define MACRODOUBLEFORMAT  6
#define MACROSIGNED        1
#define MACROUNSIGNED      2
#define MACRODEFENDIAN     1
#define MACROBIGENDIAN     2
#define MACROLITTLEENDIAN  3

typedef struct
{
  char name [MACRONAMELENGTH];
  int bufferMode;
  int processMode;
  int channelMode;
  int input;
  int output;
  int dataFormat;
  int dataSigned;
  int endian;
  char command [MACROCOMMANDLENGTH];
} macroType;

extern macroType macro [MAXMACROS];
extern int numberMacros;
extern int currentMacro;

int loadMacros ();
int saveMacros ();
void defaultMacros (void);
void updateMacroForm (void);
int findMacro (const char *name);
char *executeMacro (const char *name);
char *executeOneMacro (int macroNumber,int bufferNumber);
char *executeSingleMacro (int macroNumber,int bufferNumber);
void macroexecBrowserDbl_cb (FL_OBJECT *ob,long data);
int findNonSpace (const char *name);
int closeMacroOutputForm (FL_FORM *form,void *data);

inline signed int limitIValue (int value,int min,int max);
inline unsigned int limitUIValue (unsigned int value,unsigned int min,unsigned int max);
inline float limitFValue (float value,float min,float max);
inline double limitDValue (double value,double min,double max);

/*---------------------------------------------------------------------------
| FUNCTION limitValue
---------------------------------------------------------------------------*/

signed int limitIValue (int value,int min,int max)
{
  if (value < min) return min;
  if (value > max) return max;
  return value;
}

unsigned int limitUIValue (unsigned int value,unsigned int min,unsigned int max)
{
  if (value < min) return min;
  if (value > max) return max;
  return value;
}

float limitFValue (float value,float min,float max)
{
  if (value < min) return min;
  if (value > max) return max;
  return value;
}

double limitDValue (double value,double min,double max)
{
  if (value < min) return min;
  if (value > max) return max;
  return value;
}

#endif // _DPTich_macros_h

/***************************************************************************/
