/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPSampleXforms.h
|
| Object      : Xforms sample
|
| Description : Xforms sample object header file
|
| (c) Richard Kent 1996
|
| $Id: DPSampleXforms.h,v 1.1 2003/09/10 00:06:24 rk Exp $
|
****************************************************************************/

#ifndef _DPSample_Xforms_h
#define _DPSample_Xforms_h

#include "DPTich_main.h"

#define FL_SAMPLE        2001
#define FL_NORMAL_SAMPLE 0
#define BORDERX          20
#define BORDERY          20
#define AXISSPACE        20
#define AXISTICKS        2
#define STEREOGAP        10
#define QUADROGAP        5
#define MONOGAP          10
#define TEMPDIRLEN       256
#define DEVICELEN        256
#ifdef LINUX
#define AXISTEXTSIZE     9
#else
#define AXISTEXTSIZE     7
#endif


extern FL_OBJECT *fl_create_sample (
  int type,
  FL_Coord x,
  FL_Coord y, 
  FL_Coord w,
  FL_Coord h,
  const char *label);

extern FL_OBJECT *fl_add_sample (
  int type,
  FL_Coord x,
  FL_Coord y, 
  FL_Coord w,
  FL_Coord h,
  const char *label);

extern DPSample *fl_get_sample (FL_OBJECT *ob);
extern void fl_set_sample (FL_OBJECT *ob,DPSample *newSample);
extern int fl_get_sample_scroll (FL_OBJECT *ob);
extern void fl_set_sample_scroll (FL_OBJECT *ob,int newScroll);
extern int fl_get_sample_axis (FL_OBJECT *ob);
extern void fl_set_sample_axis (FL_OBJECT *ob,int newScroll);
extern int fl_get_sample_edit (FL_OBJECT *ob);
extern void fl_set_sample_edit (FL_OBJECT *ob,int newEdit);
extern int fl_get_sample_frames (FL_OBJECT *ob);
extern void fl_set_sample_frames (FL_OBJECT *ob,int newFrames);
extern int fl_get_sample_freehand (FL_OBJECT *ob);
extern void fl_set_sample_freehand (FL_OBJECT *ob,int newFreehand);
extern int fl_get_sample_drawmode (FL_OBJECT *ob);
extern void fl_set_sample_drawmode (FL_OBJECT *ob,int newDrawmode);
extern int fl_get_sample_drawaccuracy (FL_OBJECT *ob);
extern void fl_set_sample_drawaccuracy (FL_OBJECT *ob,int newDrawaccuracy);
extern int fl_get_sample_undomode (FL_OBJECT *ob);
extern void fl_set_sample_undomode (FL_OBJECT *ob,int newUndomode);
extern int fl_get_sample_autowindows (FL_OBJECT *ob);
extern void fl_set_sample_autowindows (FL_OBJECT *ob,int newAutowindows);
extern int fl_get_sample_autoglobals (FL_OBJECT *ob);
extern void fl_set_sample_autoglobals (FL_OBJECT *ob,int newAutoglobals);
extern int fl_get_sample_autoeditmode (FL_OBJECT *ob);
extern void fl_set_sample_autoeditmode (FL_OBJECT *ob,int newAutoeditmode);
extern int fl_get_sample_soxcompatible (FL_OBJECT *ob);
extern void fl_set_sample_soxcompatible (FL_OBJECT *ob,int newSoxcompatible);
extern int fl_get_sample_tooltips (FL_OBJECT *ob);
extern void fl_set_sample_tooltips (FL_OBJECT *ob,int newTooltips);
extern int fl_get_sample_rangealt (FL_OBJECT *ob);
extern void fl_set_sample_rangealt (FL_OBJECT *ob,int newRangealt);
extern int fl_get_sample_rangecross (FL_OBJECT *ob);
extern void fl_set_sample_rangecross (FL_OBJECT *ob,int newRangecross);
extern const char *fl_get_sample_tempdir (FL_OBJECT *ob);
extern void fl_set_sample_tempdir (FL_OBJECT *ob,const char *newTempdir);
extern int fl_get_sample_vertscroll (FL_OBJECT *ob);
extern void fl_set_sample_vertscroll (FL_OBJECT *ob,int newVertScroll);
extern int fl_get_sample_inputtextsize (FL_OBJECT *ob);
extern void fl_set_sample_inputtextsize (FL_OBJECT *ob,int newInputtextsize);
extern int fl_get_sample_borderwidth (FL_OBJECT *ob);
extern void fl_set_sample_borderwidth (FL_OBJECT *ob,int newBorderwidth);
extern int fl_get_sample_basicwavs (FL_OBJECT *ob);
extern void fl_set_sample_basicwavs (FL_OBJECT *ob,int newBasicwavs);
extern const char *fl_get_sample_audio_device (FL_OBJECT *ob);
extern void fl_set_sample_audio_device (FL_OBJECT *ob,const char *newAudioDevice);
extern const char *fl_get_sample_mixer_device (FL_OBJECT *ob);
extern void fl_set_sample_mixer_device (FL_OBJECT *ob,const char *newMixerDevice);

int handle_sample (
  FL_OBJECT * ob,
  int event,
  FL_Coord mx,
  FL_Coord my,
  int key,
  void *xev);

#endif //_DPSample_Xforms_h

/***************************************************************************/
