/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : macros.h
|
| Object      : None
|
| Description : Macro routines for linux replacement code
|
| (c) Richard Kent 1997
|
| $Id: macros.h,v 1.1 2003/09/10 00:06:24 rk Exp $
|
****************************************************************************/

#ifndef _macros_h
#define _macros_h

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef DIRECT_FILE
typedef	int FHandle;
#else
typedef FILE *FHandle;
#endif

#ifndef FALSE
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE (1)
#endif

#define fail(message)        \
{                            \
  fprintf (stderr,message);  \
  return AF_NULL_FILEHANDLE; \
} 

#define alert(message)       \
{                            \
  fprintf (stderr,message);  \
} 

#define message(message)     \
{                            \
  fprintf (stderr,message);  \
} 

#define aiffError            \
{                            \
  done  = TRUE;              \
  error = TRUE;              \
  break;                     \
}

void setEndian (int newEndian);
void setBigEndian (int newBigEndian);
int getBigEndian (void);

int mRead (FHandle file,void *buf,int count);
int mReadF (FILE *file,void *buf,int count);
int uiRead (FHandle file,unsigned int *ui);
int uiReadF (FILE *file,unsigned int *ui);
int iRead (FHandle file,int *i);
int iReadF (FILE *file,int *i);
int usRead (FHandle file,unsigned short *us);
int usReadF (FILE *file,unsigned short *us);
int sRead (FHandle file,short *s);
int sReadF (FILE *file,short *s);
int ucRead (FHandle file,unsigned char *uc);
int ucReadF (FILE *file,unsigned char *uc);
int cRead (FHandle file,signed char *c);;
int cReadF (FILE *file,signed char *c);;
int fRead (FHandle file,float *f);
int fReadF (FILE *file,float *f);
int dRead (FHandle file,double *d);
int dReadF (FILE *file,double *d);
int efRead (FHandle file,float *d);
int efReadF (FILE *file,float *d);
int edRead (FHandle file,double *d);
int edReadF (FILE *file,double *d);
int idRead (FHandle file,char *c);
int idReadF (FILE *file,char *c);
int pstringRead (FHandle file,char **c);
int pstringReadF (FILE *file,char **c);
int mWrite (FHandle file,void *buf,int count);
int mWriteF (FILE *file,void *buf,int count);
int uiWrite (FHandle file,unsigned int ui);
int uiWriteF (FILE *file,unsigned int ui);
int iWrite (FHandle file,int i);
int iWriteF (FILE *file,int i);
int usWrite (FHandle file,unsigned short us);
int usWriteF (FILE *file,unsigned short us);
int sWrite (FHandle file,short s);
int sWriteF (FILE *file,short s);
int ucWrite (FHandle file,unsigned char uc);
int ucWriteF (FILE *file,unsigned char uc);
int cWrite (FHandle file,signed char c);
int cWriteF (FILE *file,signed char c);
int fWrite (FHandle file,float f);
int fWriteF (FILE *file,float f);
int dWrite (FHandle file,double d);
int dWriteF (FILE *file,double d);
int efWrite (FHandle file,float d);
int efWriteF (FILE *file,float d);
int edWrite (FHandle file,double d);
int edWriteF (FILE *file,double d);
int idWrite (FHandle file,char *c);
int idWriteF (FILE *file,char *c);
int pstringWrite (FHandle file,char *c);
int pstringWriteF (FILE *file,char *c);
FHandle mOpenRead (const char *filename);
FILE *mOpenReadF (const char *filename);
FHandle mOpenWrite (const char *filename);
FILE *mOpenWriteF (const char *filename);
int mCheckFile (FHandle file);
int mCheckFileF (FILE *file);
int mClose (FHandle file);
int mCloseF (FILE *file);
int mSeek (FHandle file,int offset,int where);
int mSeekF (FILE *file,int offset,int where);
int mTell (FHandle file);
int mTellF (FILE *file);
int mEof (FHandle file);
int mEofF (FILE *file);
int mFlush (FHandle file);
int mFlushF (FILE *file);
int mStat (FHandle file,struct stat *buf);
int mStatF (FILE *file,struct stat *buf);

void swapbytes_string (char *buffer,int n);
unsigned int swapbytes_uint (unsigned int ul);
int swapbytes_int (int l);
unsigned short swapbytes_ushort (unsigned short us);
short swapbytes_short (short s);
unsigned int swapbytes_uint (unsigned int ui);
int swapbytes_int (int i);
double swapbytes_double (double d);

#define uiread(into)                    \
{                                       \
  if (!uiRead (file,&uitemp)) aiffError \
  into = uitemp;                        \
}

#define iread(into)                     \
{                                       \
  if (!iRead (file,&itemp)) aiffError   \
  into = itemp;                         \
}

#define usread(into)                    \
{                                       \
  if (!usRead (file,&ustemp)) aiffError \
  into = ustemp;                        \
}

#define sread(into)                     \
{                                       \
  if (!sRead (file,&stemp)) aiffError   \
  into = stemp;                         \
}

#define ucread(into)                    \
{                                       \
  if (!ucRead (file,&uctemp)) aiffError \
  into = uctemp;                        \
}

#define cread(into)                     \
{                                       \
  if (!cRead (file,&ctemp)) aiffError   \
  into = ctemp;                         \
}

#define edread(into)                    \
{                                       \
  if (!edRead (file,&dtemp)) aiffError  \
  into = dtemp;                         \
}

#define idread(into)                    \
{                                       \
  if (!idRead (file,idtemp)) aiffError  \
  strncpy (into,idtemp,4);              \
}

#define pstringread(into)               \
{                                       \
  if (!pstringRead (file,&tempstring))  \
  {                                     \
    if (tempstring) free (tempstring);  \
    tempstring = 0;                     \
    aiffError                           \
  }                                     \
  into = tempstring;                    \
}

#define uiwrite(into)                   \
{                                       \
  uitemp = into;                        \
  if (!(bytes=uiWrite (file,uitemp)))   \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define iwrite(into)                    \
{                                       \
  itemp = into;                         \
  if (!(bytes=iWrite (file,itemp)))     \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define uswrite(into)                   \
{                                       \
  ustemp = into;                        \
  if (!(bytes=usWrite (file,ustemp)))   \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define swrite(into)                    \
{                                       \
  stemp = into;                         \
  if (!(bytes=sWrite (file,stemp)))     \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define ucwrite(into)                   \
{                                       \
  uctemp = into;                        \
  if (!(bytes=ucWrite (file,uctemp)))   \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define cwrite(into)                    \
{                                       \
  ctemp = into;                         \
  if (!(bytes=cWrite (file,ctemp)))     \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define edwrite(into)                   \
{                                       \
  dtemp = into;                         \
  if (!(bytes=edWrite (file,dtemp)))    \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define idwrite(into)                   \
{                                       \
  strncpy (idtemp,into,4);              \
  if (!(bytes=idWrite (file,idtemp)))   \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define pstringwrite(into)              \
{                                       \
  tempstring = into;                    \
  if (!(bytes=pstringWrite              \
    (file,tempstring)))                 \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define uiupdate(into)                  \
{                                       \
  uitemp = into;                        \
  if (!uiWrite (file,uitemp))           \
    return -1;                          \
}

#define iupdate(into)                   \
{                                       \
  itemp = into;                         \
  if (!iWrite (file,itemp))             \
    return -1;                          \
}

#define usupdate(into)                  \
{                                       \
  ustemp = into;                        \
  if (!usWrite (file,ustemp))           \
    return -1;                          \
}

#define supdate(into)                   \
{                                       \
  stemp = into;                         \
  if (!sWrite (file,stemp))             \
    return -1;                          \
}

#define ucupdate(into)                  \
{                                       \
  uctemp = into;                        \
  if (!ucWrite (file,uctemp))           \
    return -1;                          \
}

#define cupdate(into)                   \
{                                       \
  ctemp = into;                         \
  if (!cWrite (file,ctemp))             \
    return -1;                          \
}

#define edupdate(into)                  \
{                                       \
  dtemp = into;                         \
  if (!edWrite (file,dtemp))            \
    return -1;                          \
}

#define idupdate(into)                  \
{                                       \
  strncpy (idtemp,into,4);              \
  if (!idWrite (file,idtemp))           \
    return -1;                          \
}

#define pstringupdate(into)             \
{                                       \
  tempString = into;                    \
  if (!pstringWrite (file,tempString))  \
    return -1;                          \
}

#ifdef __cplusplus
}
#endif

#endif // _macros_h

/***************************************************************************/
