/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : audiofile.h
|
| Object      : None
|
| Description : Audiofile replacement code for linux
|
| (c) Richard Kent 1997
|
| $Id: audiofile.h,v 1.1 2003/09/10 00:06:24 rk Exp $
|
****************************************************************************/

#ifndef _audiofile_h
#define _audiofile_h

//#define AMIGA

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <fcntl.h>
#include <unistd.h>
#include "macros.h"
#include "ieee.h"

#ifdef __cplusplus
extern "C"
{
#endif

#define MAX32   4294967296LL
#define MAX32_1 4294967295U
#define MAX31   2147483648U
#define MAX31_1 2147483647
#define MAX24   16777216
#define MAX24_1 16777215
#define MAX23   8388608
#define MAX23_1 8388607
#define MAX16   65536
#define MAX16_1 65535
#define MAX15   32768
#define MAX15_1 32767
#define MAX8    256
#define MAX8_1  255
#define MAX7    128
#define MAX7_1  127

typedef struct
{
  unsigned int timeStamp;
  int marker;
  unsigned short count;
  char *text;
} commentType;

typedef struct
{
  int id;
  char *name;
  int position;
} markType;

typedef struct
{
  int id;
  int midibasenote;
  int midihinote;
  int midihivelocity;
  int midilonote;
  int midilovelocity;
  int numcentsdetune;
  int numdbsgain;
  int susloopid;
  int relloopid;
} instType;

typedef struct
{
  int id;
  int mode;
  int start;
  int end;
} loopType;

typedef struct
{
  int id;
  int type;
  int size;
  int current;
  char *data;
} miscType;

typedef struct
{
  int channels;
  int dataFormat;
  int signedData;
  int endian;
} rawType;

typedef struct
{
  int sampleFormat;
  rawType rawDetails;
  int filefmt;
  unsigned int version;
  int audiotrack;
  double rate;
  int sampfmt;
  int width;
  int channels;
  int compression;
  int aesdatapresent;
  unsigned char aesdata [24];
  int framecount;
  int marks;
  markType *mark;
  int insts;
  instType *inst;
  int loops;
  loopType *loop;
  int miscs;
  miscType *misc;
} aiffType;

typedef struct
{
  int mode;
  FHandle file;
  int actualBytes;
  int actualFrames;
  int ssndStart;
  aiffType aiff;
} aiffHandle;

typedef aiffType *AFfilesetup;
typedef aiffHandle *AFfilehandle;
typedef void (*AFerrfunc) (long,const char *);

#define AF_NULL_FILESETUP                       0
#define AF_NULL_FILEHANDLE                      0
#define AF_DEFAULT_TRACK                        1001
#define AF_DEFAULT_INST                         2001
#define AF_SAMPFMT_TWOSCOMP                     401
#define AF_FILE_UNSUPPORTED                     -2
#define AF_FILE_UNKNOWN                         -1
#define AF_FILE_AIFFC                           1
#define AF_FILE_AIFF                            2
#define AF_LOOP_MODE_NOLOOP                     0
#define AF_LOOP_MODE_FORW                       1
#define AF_LOOP_MODE_FORWBAKW                   2
#define AF_INST_MIDI_BASENOTE                   301   
#define AF_INST_NUMCENTS_DETUNE                 302   
#define AF_INST_MIDI_LONOTE                     303
#define AF_INST_MIDI_HINOTE                     304
#define AF_INST_MIDI_LOVELOCITY                 305
#define AF_INST_MIDI_HIVELOCITY                 306
#define AF_INST_NUMDBS_GAIN                     307
#define AF_INST_SUSLOOPID                       308
#define AF_INST_RELLOOPID                       309
#define AF_MISC_AIFF_COPY                       201
#define AF_MISC_AIFF_AUTH                       202
#define AF_MISC_AIFF_NAME                       203
#define AF_MISC_AIFF_ANNO                       204
#define AF_MISC_AIFF_APPL                       205
#define AF_MISC_AIFF_MIDI                       206
#define AF_MISC_AIFF_UNRECOGNIZED               0
#define AF_COMPRESSION_UNKNOWN                  -1
#define AF_COMPRESSION_NONE                     0
#define AF_COMPRESSION_G722                     501
#define AF_COMPRESSION_G711_ULAW                502
#define AF_COMPRESSION_G711_ALAW                503
#define AF_COMPRESSION_APPLE_ACE2               504
#define AF_COMPRESSION_APPLE_ACE8               505
#define AF_COMPRESSION_APPLE_MAC3               506
#define AF_COMPRESSION_APPLE_MAC6               507
#define AF_COMPRESSION_AWARE_MPEG               515 
#define AF_COMPRESSION_AWARE_MULTIRATE          516
#ifndef AMIGA
#define AF_COMPRESSION_AWARE_DEFAULT_MPEG_I	    508
#define AF_COMPRESSION_AWARE_DEFAULT_MPEG_II	509
#endif
#define AF_COMPRESSION_AWARE_DEFAULT_MULTIRATE	513
#define AF_COMPRESSION_AWARE_DEFAULT_LOSSLESS	514

#ifdef LINUX
#define AU_LICENSE_AWARE_MPEG_ENCODER           1
#define AU_LICENSE_AWARE_MPEG_DECODER           2
#define AU_LICENSE_AWARE_MULTIRATE_ENCODER      3
#define AU_LICENSE_AWARE_MULTIRATE_DECODER      4
#define AU_LICENSE_OK                           0
#define AU_LICENSE_ERR                          -1
#define AU_BAD_PRODUCT                          -2
#define AU_PVTYPE_int                          1
#define AU_PVTYPE_DOUBLE                        2
#define AU_PVTYPE_PTR                           3
#define AU_NULL_PVLIST                          0
#endif

#define AIFCVersion1                            0xA2805140

#define READONLY                                0
#define WRITEONLY                               1

#ifndef TRUE
#define TRUE  1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* Non-standard AF defines for different data types */

/* Sample format */

#define AF_FORMAT_AIFF                          0
#define AF_FORMAT_WAV                           1
#define AF_FORMAT_RAW                           2

/* Raw data formats */

#define AF_BYTE_FORMAT                          0
#define AF_SHORT_FORMAT                         1
#define AF_LONG24_FORMAT                        2
#define AF_LONG32_FORMAT                        3
#define AF_FLOAT_FORMAT                         4
#define AF_DOUBLE_FORMAT                        5

#define AF_SIGNED_FORMAT                        0
#define AF_UNSIGNED_FORMAT                      1

#define AF_DEF_ENDIAN_FORMAT                    0
#define AF_BIG_ENDIAN_FORMAT                    1
#define AF_LITTLE_ENDIAN_FORMAT                 2

void AFsetsampleformat (AFfilesetup setup, int sampleFormat);
int AFgetsampleformat (AFfilesetup setup);
void AFsetrawchannels (AFfilesetup setup, int channels);
int AFgetrawchannels (AFfilesetup setup);
void AFsetrawdataformat (AFfilesetup setup, int dataFormat);
int AFgetrawdataformat (AFfilesetup setup);
void AFsetrawsigneddata (AFfilesetup setup, int signedData);
int AFgetrawsigneddata (AFfilesetup setup);
void AFsetrawendian (AFfilesetup setup, int bigEndian);
int AFgetrawendian (AFfilesetup setup);

AFerrfunc AFseterrorhandler (AFerrfunc efunc);
AFfilesetup AFnewfilesetup (void);
void AFfreefilesetup (AFfilesetup setup);
void AFinitfilefmt (AFfilesetup setup,int fmt);
void AFinitrate (AFfilesetup setup,int trackid,double rate);
void AFinitsampfmt (AFfilesetup setup,int trackid,int fmt,int width);
void AFinitchannels (AFfilesetup setup,int trackid,int channels);
void AFinitaeschanneldata (AFfilesetup setup,int trackid);
void AFsetaeschanneldata (
  AFfilehandle file,
  int trackid,
  unsigned char buf [24]);
void AFinitcompression (AFfilesetup setup,int trackid,int compression);
void AFinitmarkids (
  AFfilesetup setup,
  int trackid,
  long *markids,
  int nmarks);
void AFinitmarkname (
  AFfilesetup setup,
  int trackid,
  int markid,
  const char *name);
void AFinitinstids (AFfilesetup setup,long *instids,int ninsts);
void AFinitloopids (AFfilesetup setup,int instid,long *loopids,int nloops);
void AFinitmiscids (AFfilesetup setup,long *miscids,int nmiscs);
void AFinitmisctype (AFfilesetup setup,int miscid,int type);
void AFinitmiscsize (AFfilesetup setup,int miscid,int size);
int AUchecklicense (int product,int *errorval,char **message);

AFfilehandle AFopenfile (
  const char *name,
  const char *mode,
  AFfilesetup setup);
AFfilehandle AFopenfd (FHandle file,const char *mode,AFfilesetup setup);
AFfilehandle AFreadAIFF (FHandle file);
AFfilehandle AFwriteAIFF (FHandle file,AFfilesetup setup);

FHandle AFgetfd (AFfilehandle handle);
int AFclosefile (AFfilehandle handle);
int AFclosefileAIFF (AFfilehandle handle);
int AFgetfilefmt (AFfilehandle handle,long *version);
int AFidentifyfd (FHandle fd);
double AFgetrate (AFfilehandle handle,int trackid);
void AFgetsampfmt (
  AFfilehandle handle,
  int trackid,
  long *sampfmt,
  long *width);
int AFgetchannels (AFfilehandle handle,int trackid); 
int AFgetaeschanneldata (
  AFfilehandle handle,
  int trackid,
  unsigned char buf [24]);
int AFgetcompression (AFfilehandle handle,int trackid);
char *AFgetcompressionname (AFfilehandle handle,int trackid);
int AFgetframecnt (AFfilehandle handle,int trackid);
int AFgetmarkids (AFfilehandle handle,int trackid,long *markids);
char *AFgetmarkname (AFfilehandle handle,int trackid,int markid);
int AFgetmarkpos (AFfilehandle handle,int trackid,int markid);
void AFsetmarkpos (
  AFfilehandle handle,
  int trackid,
  int markid,
  int markpos);
int AFgetinstids (AFfilehandle handle,long *instids);
int AFgetinstparamint (AFfilehandle handle,int instid,int param);
void AFsetinstparamint (
  AFfilehandle handle,
  int instid,
  int param,
  int value);
int AFgetloopids (AFfilehandle handle,long *loopids);
int AFgetloopmode (AFfilehandle handle,int instid,int loopid);
void AFsetloopmode (AFfilehandle handle,int instid,int loopid,int mode);
int AFgetloopstart (AFfilehandle handle,int instid,int loopid);
void AFsetloopstart (
  AFfilehandle handle,
  int instid,
  int loopid,
  int markid);
int AFgetloopend (AFfilehandle handle,int instid,int loopid);
void AFsetloopend (AFfilehandle handle,int instid,int loopid,int markid);
int AFgetmiscids (AFfilehandle handle,long *miscids);
int AFgetmisctype (AFfilehandle handle,int miscid);
int AFgetmiscsize (AFfilehandle handle,int miscid);
int AFreadmisc (AFfilehandle handle,int miscid,void *buf,int nbytes);
int AFwritemisc (AFfilehandle handle,int miscid,void *buf,int nbytes);
void AFseekmisc (AFfilehandle handle,int miscid,int offset);
int AFreadframes (
  AFfilehandle handle,
  int trackid,
  void *frames,
  int count);
int AFreadframesAIFF (
  AFfilehandle handle,
  int trackid,
  void *frames,
  int count);
int AFwriteframes (
  AFfilehandle handle,
  int trackid,
  void *frames,
  int count);
int AFwriteframesAIFF (
  AFfilehandle handle,
  int trackid,
  void *frames,
  int count);
int AFseekframe (AFfilehandle handle,int trackid,int offset);
int AFgettrackids (AFfilehandle handle,long *trackids);

void initialiseMiscs (AFfilehandle handle);
void initialiseSetup (AFfilesetup setup);
void blankSetup (AFfilesetup setup);
void copySetup (AFfilesetup from,AFfilesetup to);
void freeSetup (AFfilesetup setup);

/* Unused defines */

#define AF_AWARE_PARAM_LAYER                    530000
#define AF_AWARE_LAYER_I                        530001
#define AF_AWARE_LAYER_II                       530002
#define AF_AWARE_PARAM_CHANNEL_POLICY           510000
#define AF_AWARE_JOINT_STEREO                   510001
#define AF_AWARE_STEREO                         510002
#define AF_AWARE_INDEPENDENT                    510003
#define AF_AWARE_PARAM_BITRATE_TARGET           511000
#define AF_AWARE_PARAM_CONST_QUAL_NMR           514000
#define AF_AWARE_PARAM_BITRATE_POLICY           517000
#define AF_AWARE_FIXED_RATE                     517001
#define AF_AWARE_CONST_QUAL                     517002
#define AF_AWARE_LOSSLESS                       517003
#define AF_BAD_NOT_IMPLEMENTED                  0
#define AF_BAD_FILEHANDLE                       1
#define AF_BAD_OPEN                             3
#define AF_BAD_CLOSE                            4
#define AF_BAD_READ                             5  
#define AF_BAD_WRITE                            6  
#define AF_BAD_LSEEK                            7  
#define AF_BAD_NO_FILEHANDLE                    8  
#define AF_BAD_ACCMODE                          10 
#define AF_BAD_NOWRITEACC                       11 
#define AF_BAD_NOREADACC                        12 
#define AF_BAD_FILEFMT                          13 
#define AF_BAD_RATE                             14 
#define AF_BAD_CHANNELS                         15 
#define AF_BAD_SAMPCNT                          16 
#define AF_BAD_WIDTH                            17 
#define AF_BAD_SEEKMODE                         18 
#define AF_BAD_NO_LOOPDATA                      19 
#define AF_BAD_MALLOC                           20 
#define AF_BAD_LOOPID                           21
#define AF_BAD_SAMPFMT                          22 
#define AF_BAD_FILESETUP                        23 
#define AF_BAD_TRACKID                          24 
#define AF_BAD_NUMTRACKS                        25 
#define AF_BAD_NO_FILESETUP                     26 
#define AF_BAD_LOOPMODE                         27 
#define AF_BAD_INSTID                           28 
#define AF_BAD_NUMLOOPS                         29 
#define AF_BAD_NUMMARKS                         30 
#define AF_BAD_MARKID                           31 
#define AF_BAD_MARKPOS                          32 
#define AF_BAD_NUMINSTS                         33 
#define AF_BAD_NOAESDATA                        34 
#define AF_BAD_MISCID                           35
#define AF_BAD_NUMMISC                          36
#define AF_BAD_MISCSIZE                         37
#define AF_BAD_MISCTYPE                         38
#define AF_BAD_MISCSEEK                         39
#define AF_BAD_STRLEN                           40 
#define AF_BAD_RATECONV                         45
#define AF_BAD_SYNCFILE                         46
#define AF_BAD_CODEC_CONFIG                     47 
#define AF_BAD_CODEC_STATE                      48 
#define AF_BAD_CODEC_LICENSE                    49 
#define AF_BAD_CODEC_TYPE                       50 
#define AF_BAD_COMPRESSION                      AF_BAD_CODEC_CONFIG
#define AF_BAD_COMPTYPE                         AF_BAD_CODEC_TYPE
#define AF_BAD_AIFF_HEADER                      108  
#define AF_BAD_AIFF_FORM                        109  
#define AF_BAD_AIFF_SSND                        110  
#define AF_BAD_AIFF_CHUNKID                     111  
#define AF_BAD_AIFF_COMM                        112  
#define AF_BAD_AIFF_INST                        113  
#define AF_BAD_AIFF_MARK                        114  
#define AF_BAD_AIFF_SKIP                        115  
#define AF_BAD_AIFF_LOOPMODE                    116  

/* Unimplemented code

typedef struct
{
} audioList;

typedef audioList *AUpvlist;

int AFsyncfile (AFfilehandle handle);
void AFinittrackids (AFfilesetup setup,long *trackids,int ntracks);
void AFsetlooptrack (AFfilehandle handle,int inst,int loopid,int trackid);
int AFgetlooptrack (AFfilehandle handle,int inst,int loopid);
void AFinitcompressionparams (
  AFfilesetup setup,
  int trackid,
  int compression,
  AUpvlist pvlist,
  int numitems);
void AFgetcompressionparams (
  AFfilehandle handle,
  int trackid,
  long *compression,
  AUpvlist pvlist,
  int numitems);
AUpvlist AUpvnew (int maxitems);
int AUpvgetmaxitems (AUpvlist pvlist);
int AUpvfree (AUpvlist pvlist);
int AUpvsetparam (AUpvlist pvlist,int item,int param);
int AUpvsetvaltype (AUpvlist pvlist,int item,int type);
int AUpvsetval (AUpvlist pvlist,int item,void *val);
int AUpvgetparam (AUpvlist pvlist,int item,int *param);
int AUpvgetvaltype (AUpvlist pvlist,int item,int *type);
int AUpvgetval (AUpvlist pvlist,int item,void *val);

*/

#ifdef __cplusplus
}
#endif

#endif // _audiofile_h

/***************************************************************************/
