/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : waveshap.cc
|
| Object      : DSPKitWaveShaper
|
| Description : DSPKitWaveShaper
|
| (c) Richard Kent 1996
|
| $Id: waveshap.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char waveshap_cc [] = "$Id: waveshap.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "waveshap.h"

int DSPKitWaveShaper::setInputAndBuffer
  (DSPKitProcessor *ip,DSPKitDPReader *bip)
{
  double bufSample;
  int i;

  DSPKitProcessor::setInput (ip);
  bip->setOutput (this);
  size = bip->getSampleCount ();
  buffer = new double [size];
  if (!buffer) return -1;
  for (i=0; i<size; i++) buffer [i] = 0.0;

  minValue = 0.0;
  maxValue = 0.0;

  for (i=0; bip->getSample (bufSample) && i<size; i++)
  {
    buffer [i] = bufSample;
    if (bufSample < minValue) minValue = bufSample;
    else if (bufSample > maxValue) maxValue = bufSample;
  }
  range = maxValue - minValue;
  return 0;
}

int DSPKitWaveShaper::setInputAndBuffer
  (DSPKitProcessor *ip,DSPKitDistortion *bip)
{
  double bufSample;
  int i;

  DSPKitProcessor::setInput (ip);
  bip->setOutput (this);
  size = bip->getSampleCount ();
  buffer = new double [size];
  if (!buffer) return -1;
  for (i=0; i<size; i++) buffer [i] = 0.0;

  minValue = 0.0;
  maxValue = 0.0;

  for (i=0; bip->getSample (bufSample) && i<size; i++)
  {
    buffer [i] = bufSample;
    if (bufSample < minValue) minValue = bufSample;
    else if (bufSample > maxValue) maxValue = bufSample;
  }
  range = maxValue - minValue;
  return 0;
}
    
int DSPKitWaveShaper::getSample (double &outputSample)
{
  double inputSample;

  if (!input->getSample (inputSample)) return 0;

  if (inputSample <= minValue)
  {
    outputSample = minValue;
    return 1;
  }
  else if (inputSample >= maxValue)
  {
    outputSample = maxValue;
    return 1;
  }

  double scaledSample = (inputSample - minValue) * size / range;
  int index1         = (int) scaledSample;
  double remainder    = scaledSample - index1;
  int index2         = index1 + 1;
  
  if (index1 < 0)
  {
    index1    = 0;
    remainder = 0.0;
    index2    = index1;
  }
  else if (index1 >= size)
  {
    index1    = size - 1;
    remainder = 0.0;
    index2    = index1;
  }

  outputSample =
    buffer [index1] + remainder * (buffer [index2] - buffer [index1]);

  return 1;
}

/***************************************************************************/
