/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : sum.cc
|
| Object      : DSPKitSum
|
| Description : DSPKitSum
|
| (c) Richard Kent 1996
|
| $Id: sum.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char sum_cc [] = "$Id: sum.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "sum.h"

int DSPKitSum::setInput (DSPKitProcessor *ip)
{
  if (DSPKitProcessor::setInput (ip) != 0) return -1;
  inputList [0] = input;
  inputCount = 1;
  return 0;
}

int DSPKitSum::addInput (DSPKitProcessor *ip)
{
  ip->setOutput(this);
  if (inputCount >= SUMMAXINPUTS) return -1;
  inputList [inputCount++] = ip;
  return 0;
}

int DSPKitSum::getSample (double &outputSample)
{
  int   i;
  int   ok;
  double inputSample;

  outputSample = 0.0;

  for (i=0,ok=0; i<inputCount; i++)
  {
    if (inputList [i]->getSample (inputSample))
    {
      outputSample += inputSample;
      ok = 1;
    }
  }

  return ok;
}

/***************************************************************************/
