/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : processo.h
|
| Object      : DSPKitProcessor
|
| Description : DSPKitProcessor
|
| (c) Richard Kent 1996
|
| $Id: processo.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_PROCESSOR_H_
#define _DSPKIT_PROCESSOR_H_

#include <iostream>
#include <time.h>
#include <math.h>

class DSPKitProcessor
{
  public:

    DSPKitProcessor();
    virtual ~DSPKitProcessor ();
    virtual int setInput (DSPKitProcessor *ip);
    virtual void setOutput (DSPKitProcessor *op);
    virtual DSPKitProcessor *getInput () const;
    virtual DSPKitProcessor *getOutput () const;
    virtual double getSamplingRate () const;
    virtual int getSample (double &outputSample);

  protected:

    DSPKitProcessor *input;
    DSPKitProcessor *output;
    double inputSamplingRate;
};

inline DSPKitProcessor::~DSPKitProcessor ()
{
}

inline void DSPKitProcessor::setOutput (DSPKitProcessor *op)
{
  output = op;
}

inline DSPKitProcessor *DSPKitProcessor::getInput () const
{
  return input;
}

inline DSPKitProcessor *DSPKitProcessor::getOutput () const
{
  return output;
}

inline double DSPKitProcessor::getSamplingRate () const
{
  return inputSamplingRate;
}

inline int DSPKitProcessor::getSample (double &outputSample)
{
  return input->getSample (outputSample);
}

#endif

/***************************************************************************/
