/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : mux.cc
|
| Object      : DSPKitMux
|
| Description : DSPKitMux
|
| (c) Richard Kent 1996
|
| $Id: mux.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char mux_cc [] = "$Id: mux.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "mux.h"

int DSPKitMux::setInput (DSPKitProcessor *ip)
{
  if (DSPKitProcessor::setInput (ip) != 0) return -1;
  outputCount = 0;
  outputIndex = 0;
  endOfInput  = 0;
  inputSample = 0.0;
  return 0;
}

void DSPKitMux::setOutput (DSPKitProcessor *op)
{
  DSPKitProcessor::setOutput(op);
  outputCount++;
}

int DSPKitMux::getSample (double &outputSample)
{
  if (outputIndex >= outputCount) outputIndex = 0;
  if (outputIndex++ == 0)
  {
    if (input->getSample (inputSample) == 0)
    {
      endOfInput = 1;
      return 0;
    }
  }

  if (endOfInput) return 0;
  outputSample = inputSample;
  return 1;
}

/***************************************************************************/
