/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : fbdelay.cc
|
| Object      : DSPKitFBDelay
|
| Description : DSPKitFBDelay
|
| (c) Richard Kent 1996
|
| $Id: fbdelay.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char fbdelay_cc [] = "$Id: fbdelay.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "fbdelay.h"

DSPKitFBDelay::DSPKitFBDelay ()
{
  buffer = 0;
}

DSPKitFBDelay::~DSPKitFBDelay ()
{
  if (buffer) delete [] buffer; 
}

int DSPKitFBDelay::setInputAndDelayTime (DSPKitProcessor *ip,double dt)
{
  DSPKitProcessor::setInput (ip);
  delayTime = dt;
  bufSize   = (int)(delayTime * inputSamplingRate) - 1;

  if (bufSize < 0)
  {
    bufSize = 0;
  }
  if (bufSize > 0)
  {
    if ((buffer = new double [bufSize]) == 0) return -1;
    for (int i=0; i<bufSize; i++) buffer [i] = 0;
  }

  oldestSampleIndex = 0;
  lastSampleIndex   = 0;
  haveSamples       = 0;
  endOfInput        = 0;
  return 0;
}

int DSPKitFBDelay::getSample (double &outputSample)
{
  double inputSample;

  if (!bufSize)
  {
    if (input->getSample (outputSample)) return 1;
    return 0;
  }

  if (endOfInput)
  {
    input->getSample (inputSample); // for feedback loops
    if (oldestSampleIndex == lastSampleIndex) return 0;
    outputSample = buffer [oldestSampleIndex++];
    oldestSampleIndex %= bufSize;
    return 1;
  } 

  if (input->getSample (inputSample) == 0)
  {
    endOfInput = 1;
    if (!haveSamples) return 0;
    outputSample = buffer [oldestSampleIndex++];
    oldestSampleIndex %= bufSize;
    return 1;
  } 

  haveSamples = 1;
  outputSample = buffer [oldestSampleIndex];
  buffer [oldestSampleIndex++] = inputSample;
  oldestSampleIndex %= bufSize;
  lastSampleIndex = oldestSampleIndex;
  return 1;
}

/***************************************************************************/
