/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dist.cc
|
| Object      : DSPKitDistortion
|
| Description : DSPKitDistortion
|
| (c) Richard Kent 1996
|
| $Id: dist.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char dist_cc [] = "$Id: dist.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "dist.h"

// 16 bit arrays ranging from -32768 to +32767 - first value is length

int valve [] =
{
#include "valve.h"
};

int tube [] =
{
#include "tube.h"
};

int DSPKitDistortion::setType (int newType)
{
  i    = 1;
  type = newType;
  return 1;
}

int DSPKitDistortion::getSampleCount ()
{
  switch (type)
  {
    case 0 :
      return valve [0];
    
    case 1 :
      return tube [0];
    
    default :
      return 0;
  }
}

int DSPKitDistortion::getSample (double &outputSample)
{
  // type 0 = valve
  // type 1 = tube
  
  switch (type)
  {
    case 0 :
      outputSample = valve [i++] / 32768.0;
      if (i > valve [0]) i = 1;
      break;
    
    case 1 :
      outputSample = tube [i++] / 32768.0;
      if (i > tube [0]) i = 1;
      break;
    
    default :
      return 0;
  }
  return 1;
}

/***************************************************************************/
