/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : comblowp.cc
|
| Object      : DSPKitCombLowPass
|
| Description : DSPKitCombLowPass
|
| (c) Richard Kent 1996
|
| $Id: comblowp.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char comblowp_cc [] = "$Id: comblowp.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "comblowp.h"

DSPKitCombLowPass::DSPKitCombLowPass ()
{
  reverbTime = 2.0;
  delayTime  = 0.0;
  g          = 0.83;
  g1         = 0.46;
  g2         = g * (1.0 - g1);
}

int DSPKitCombLowPass::setInputAndDelayTime
  (DSPKitProcessor *ip,double dt)
{
  delayTime = dt;   
  feedback.setInput (ip);
  feedback.setFeedbackTime (0.0);
  delay.setInputAndDelayTime (&feedback,delayTime);
  mux.setInput (&delay);
  lpf.setInput (&mux);
  lpf.setG (g1);
  amp.setInput (&lpf);
  amp.setGain (g2);
  feedback.setFeedbackInput (&amp);
  return DSPKitProcessor::setInput (&mux);
}

void DSPKitCombLowPass::setG (double newG)
{
  if (newG <= 0.0)
    g = 0.00001;
  else if (newG >= 1.0)
    g = 0.99999;
  else
    g = newG;

  reverbTime = 0.2 / (1.0 - g); 
  feedback.setFeedbackTime (reverbTime);
  updateGains ();
}
    
void DSPKitCombLowPass::setG1 (double newG1)
{
  if (newG1 <= 0.0)
    g1 = 0.00001;
  else if (newG1 >= 1.0)
    g1 = 0.99999;
  else
    g1 = newG1;

  updateGains ();
}

void DSPKitCombLowPass::setReverbTime (double rt)
{
  if (rt <= 0.0)
    rt = 0.0001;
    
  reverbTime = rt;
  g = 1.0 - 0.2 / reverbTime;
  feedback.setFeedbackTime (reverbTime);
  updateGains ();
}

void DSPKitCombLowPass::updateGains ()
{
  g2 = g * (1.0 - g1);
  lpf.setG (g1);
  amp.setGain (g2);
}

/***************************************************************************/
