/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : combint.cc
|
| Object      : DSPKitCombInt
|
| Description : DSPKitCombInt
|
| (c) Richard Kent 1996
|
| $Id: combint.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char combint_cc [] = "$Id: combint.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "combint.h"

int DSPKitCombInt::setInputAndDelayTime (DSPKitProcessor *ip,double dt)
{
  delayTime = dt;   
  feedback.setInput (ip);
  feedback.setFeedbackTime (0.0);
  fbdelay.setInputAndDelayTime (&feedback,delayTime,1);
  mux.setInput (&fbdelay);
  amp.setInput (&mux);
  feedback.setFeedbackInput (&amp);
  return DSPKitProcessor::setInput (&mux);
}

int DSPKitCombInt::setModInput (DSPKitProcessor *mip)
{
  return fbdelay.setModInput (mip);
}

void DSPKitCombInt::setReverbTime (double rt)
{
  reverbTime = rt;
  g = pow (0.001,delayTime / reverbTime);
  feedback.setFeedbackTime (reverbTime);
  amp.setGain (g);
}

void DSPKitCombInt::setG (double newG)
{
  if (newG <= 0.0)
    g = 0.00001;
  else if (newG >= 1.0)
    g = 0.99999;
  else
    g = newG;

  reverbTime = 3.0 * delayTime / log10 (1.0 / g);
  feedback.setFeedbackTime (reverbTime);
  amp.setGain (g);
}

/***************************************************************************/

