/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : allpassn.h
|
| Object      : DSPKitAllPassNetwork
|
| Description : DSPKitAllPassNetwork
|
| (c) Richard Kent 1996
|
| $Id: allpassn.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_ALLPASSNETWORK_H_
#define _DSPKIT_ALLPASSNETWORK_H_

#include "processo.h"
#include "feedback.h"
#include "mux.h"
#include "sum.h"
#include "amp.h"
#include "fbdelay.h"

class DSPKitAllPassNetwork : public DSPKitProcessor
{
  public:

    DSPKitAllPassNetwork ();
    int setInputAndDelayTime (DSPKitProcessor *ip, double dt);
    void setG (double newG);
    void setReverbTime (double rt);
    double getReverbTime () const;
    double getDelayTime () const;
    double getG () const;

  protected:

    double         reverbTime;
    double         delayTime;
    double         g;
    DSPKitFeedback feedback;
    DSPKitSum      sum;
    DSPKitFBDelay  delay;
    DSPKitAmp      amp1;
    DSPKitAmp      amp2;
    DSPKitAmp      amp3;
    DSPKitMux      mux1;
    DSPKitMux      mux2;
};

inline double DSPKitAllPassNetwork::getReverbTime () const
{
  return reverbTime;
}

inline double DSPKitAllPassNetwork::getDelayTime () const
{
  return delayTime;
}

inline double DSPKitAllPassNetwork::getG () const
{
  return g;
}

#endif

/***************************************************************************/
