/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPMixPlay.h
|
| Object      : None
|
| Description : Prototypes for the mix play operations
|
| (c) Richard Kent 1996
|
| $Id: DPMixPlay.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DPMixPlay_h
#define _DPMixPlay_h

#include "DPSample.h"

#define MIXCHANNELS 8

// Typedef for playlist entry

typedef struct {
  DPSample *sample;
  int      bufferNo;
  double   vol;
  double   pan;
  double   volL; // For efficiency
  double   volR; // For efficiency
  int      frame;
  int      release;
  int      inc;
} playEntry;

// Playlist is global

extern playEntry    playList [MIXCHANNELS];
extern double       mixplayMasterVol;
extern double       mixplayMasterPan;
extern double       mixplayMasterVolL; // For efficiency
extern double       mixplayMasterVolR; // For efficiency
extern int          DPMixPlayStop;
extern AFfilehandle mixfile;

char *mixPlay ();

#endif // _DPMixPlay_h

/***************************************************************************/
