#! /usr/bin/python
"""
**Thrasher Randomness test script**
"""
#==============================================================
# Thrasher Randomness test script
#
# Author: Bryan Mongeau <bryan@eevolved.com>
#
# This code is public domain. enjoy.
#
# Resource intensive but effective analysis of the
# distribution matrices of PRNGs.
#
# PRNGs should score poorly in short test durations.
# Patterns emerge when the tests are conducted for
# extended periods of time. A good PRNG should possess
# a divergence index that is ever-diminishing with
# longer test times.
#
# Basically, the closer to zero over time, the better.
#
# You can edit the script easily to test different PRNGs
# with different seed schemes. Just scroll down and see.
#==============================================================

from math import sqrt
import sys,array, whrandom, time
from entropy.entropy import CSPRNG

# Utility function for Standard Deviation
def meanstdv(x):
  n, std, mean = len(x), 0, 0
  for a in x:
   mean = mean + a
   mean = mean / float(n)
  for a in x:
   std = std + (a - mean)**2
   std = sqrt(std / float(n-1))
  return mean, std


testtime=0
try:
 testtime = int(sys.argv[1])
except:
 pass

if not testtime or testtime < 1:

  print
  print "============================================="
  print " Thrasher: Head-to-head randomness analysis"
  print " V^V^V^V^V of Pseudo Random Number Generators"
  print "============================================="
  print " usage: $ python thrasher.py [secs]  "
  print "        ###############################"
  print "        # [secs] is the test duration  "
  print "        # ex: $ python thrasher.py 3600"
  print "        # will run for 1 hour."
  print "        # The longer, the better."
  print "        # Turn it on then goto sleep"
  print "        ###############################"
  print

else:

  endTime = time.time() + testtime
  totPasses = 0
  predict1 = 0.0
  predict2 = 0.0

  # Initialize test vectors
  l = []
  for x in range(256):
    l.append(0)
  vec1 = array.array('i',l)
  vec2 = array.array('i',l)


  prng1 = whrandom.whrandom()
  prng2 = CSPRNG()

  prng1name = "Whrandom"
  prng2name = "CSPRNG"

  # barf
  print
  print "============================================="
  print " Thrasher: Head-to-head randomness analysis"
  print " V^V^V^V^V of Pseudo Random Number Generators"
  print "============================================="
  print " "+prng1name, " VS.", prng2name
  print
  print " Beginning Thrashing...                      "
  print " Thrashing ends on", time.strftime("%x at %H:%M %Ss.",time.localtime(endTime))
  print " You can bail anytime with CTRL C "
  print "============================================="
  print


  # Here we go
  try:

    while time.time() < endTime:

      seed=int(time.time())%255 # Seed for this pass

      # First Pass Seeds
      prng1.seed(seed,1,1)
      prng2.tStir(4,8,x=seed,y=1,z=1)

      # Get 32 bytes from prng1
      rnd1=[]
      for t in range(32):
        rnd1.append(prng1.randint(0,255))

      # Get 32 bytes from prng2
      rnd2 = prng2.getBytes()

      # Increment Statistics
      for r in range(32):
        vec1[rnd1[r]] += 1
        vec2[ord(rnd2[r])] += 1

      # Now reseed for predictability test
      prng1.seed(seed,1,1)
      prng2.tStir(4,8,x=seed,y=1,z=1)


      # Get 32 bytes from pnrg1
      rnd1t = []
      for t in range(32):
        rnd1t.append(prng1.randint(0,255))

      # Get 64 bytes from prng2
      rnd2t = prng2.getBytes()

      # And test
      if rnd1 == rnd1t:
        predict1+=1;
      if rnd2 == rnd2t:
        predict2+=1;

      totPasses+=1

  except:
    print " Bailing!"

  print " Thrashing Complete:"
  print

  # Average out the vectors
  avg = totPasses / 256
  for x in range(256):
    vec1[x] -= avg
    vec2[x] -= avg

  # Calculate means and standard deviations
  m1, m2, sd1, sd2=0.0,0.0,0.0,0.0
  m1, sd1 = meanstdv(vec1.tolist())
  m2, sd2 = meanstdv(vec2.tolist())

  print " -", prng1name, "has a mean", str(m1)[:10], "divergent from"
  print "   a truly random distribution of numbers."
  print "   Standard deviation of", str(sd1)[:10]
  if totPasses > 0:
    print "   Predictability :", str(predict1/totPasses*100)[:10], "%"
  print
  print " -", prng2name, "has a mean", str(m2)[:10], "divergent from"
  print "   a truly random distribution of numbers."
  print "   Standard deviation of", str(sd2)[:10]
  if totPasses > 0:
    print "   Predictability :", str(predict2/totPasses*100)[:10], "%"
  print
  print " ", totPasses*64*4, "random bytes were generated."
  print "============================================="
  print














