#! /usr/bin/python

"""
<b># AES test driver</b>
"""

from aes.aes import aes
import time

# World's most secure key
key = 'a'*32
a = aes(key)

t = time.time()
totLen=0
print
print "======================================================="
print "Encrypting/Decrypting with standard keys in ECB mode..."
print "======================================================="
for x in range(3000):
 text = str(x%9) * int(x+1)
 totLen += len(text)
 encoded = a.encrypt(text)
 decoded = a.decrypt(encoded)
 if decoded != text:
   print "anomaly at iteration", x

print "time elapsed:    ", time.time() - t
print "bytes processed: ", totLen
print "throughput:      ", totLen / (time.time()-t), "bytes/sec"
print


t = time.time()
totLen=0
print "====================================================="
print "Encrypting/Decrypting with hashed keys in ECB mode..."
print "====================================================="
for x in range(2000):
 text = str(x%9) * int(x+1)
 totLen += len(text)
 encoded = a.lazyEncrypt('AAAAA', text)
 decoded = a.lazyDecrypt('AAAAA', encoded)
 if decoded != text:
   print "anomaly at iteration", x

print "time elapsed:    ", time.time() - t
print "bytes processed: ", totLen
print "throughput:      ", totLen / (time.time()-t), "bytes/sec"
print


#Switch to CBC mode

del a
a = aes(key,"CBC","123456")

t = time.time()
totLen=0
print
print "======================================================="
print "Encrypting/Decrypting with standard keys in CBC mode..."
print "======================================================="
for x in range(3000):
 text =  str(x%9) * int(x+1)
 totLen += len(text)
 encoded = a.encrypt(text)
 decoded = a.decrypt(encoded)
 if decoded != text:
   print "anomaly at iteration", x

print "time elapsed:    ", time.time() - t
print "bytes processed: ", totLen
print "throughput:      ", totLen / (time.time()-t), "bytes/sec"
print



t = time.time()
totLen=0
print "====================================================="
print "Encrypting/Decrypting with hashed keys in CBC mode..."
print "====================================================="
for x in range(2000):
 text = str(x%9) * int(x+1)
 totLen += len(text)
 encoded = a.lazyEncrypt('AAAAA', text)
 decoded = a.lazyDecrypt('AAAAA', encoded)
 if decoded != text:
   print "anomaly at iteration", x

print "time elapsed:    ", time.time() - t
print "bytes processed: ", totLen
print "throughput:      ", totLen / (time.time()-t), "bytes/sec"
print


