// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

package networkconnectivitypb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The other routing cases.
type PolicyBasedRoute_OtherRoutes int32

const (
	// Default value.
	PolicyBasedRoute_OTHER_ROUTES_UNSPECIFIED PolicyBasedRoute_OtherRoutes = 0
	// Use the routes from the default routing tables (system-generated routes,
	// custom routes, peering route) to determine the next hop. This will
	// effectively exclude matching packets being applied on other PBRs with a
	// lower priority.
	PolicyBasedRoute_DEFAULT_ROUTING PolicyBasedRoute_OtherRoutes = 1
)

// Enum value maps for PolicyBasedRoute_OtherRoutes.
var (
	PolicyBasedRoute_OtherRoutes_name = map[int32]string{
		0: "OTHER_ROUTES_UNSPECIFIED",
		1: "DEFAULT_ROUTING",
	}
	PolicyBasedRoute_OtherRoutes_value = map[string]int32{
		"OTHER_ROUTES_UNSPECIFIED": 0,
		"DEFAULT_ROUTING":          1,
	}
)

func (x PolicyBasedRoute_OtherRoutes) Enum() *PolicyBasedRoute_OtherRoutes {
	p := new(PolicyBasedRoute_OtherRoutes)
	*p = x
	return p
}

func (x PolicyBasedRoute_OtherRoutes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PolicyBasedRoute_OtherRoutes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_enumTypes[0].Descriptor()
}

func (PolicyBasedRoute_OtherRoutes) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_enumTypes[0]
}

func (x PolicyBasedRoute_OtherRoutes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PolicyBasedRoute_OtherRoutes.Descriptor instead.
func (PolicyBasedRoute_OtherRoutes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{0, 0}
}

// The internet protocol version.
type PolicyBasedRoute_Filter_ProtocolVersion int32

const (
	// Default value.
	PolicyBasedRoute_Filter_PROTOCOL_VERSION_UNSPECIFIED PolicyBasedRoute_Filter_ProtocolVersion = 0
	// The PBR is for IPv4 internet protocol traffic.
	PolicyBasedRoute_Filter_IPV4 PolicyBasedRoute_Filter_ProtocolVersion = 1
)

// Enum value maps for PolicyBasedRoute_Filter_ProtocolVersion.
var (
	PolicyBasedRoute_Filter_ProtocolVersion_name = map[int32]string{
		0: "PROTOCOL_VERSION_UNSPECIFIED",
		1: "IPV4",
	}
	PolicyBasedRoute_Filter_ProtocolVersion_value = map[string]int32{
		"PROTOCOL_VERSION_UNSPECIFIED": 0,
		"IPV4":                         1,
	}
)

func (x PolicyBasedRoute_Filter_ProtocolVersion) Enum() *PolicyBasedRoute_Filter_ProtocolVersion {
	p := new(PolicyBasedRoute_Filter_ProtocolVersion)
	*p = x
	return p
}

func (x PolicyBasedRoute_Filter_ProtocolVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PolicyBasedRoute_Filter_ProtocolVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_enumTypes[1].Descriptor()
}

func (PolicyBasedRoute_Filter_ProtocolVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_enumTypes[1]
}

func (x PolicyBasedRoute_Filter_ProtocolVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PolicyBasedRoute_Filter_ProtocolVersion.Descriptor instead.
func (PolicyBasedRoute_Filter_ProtocolVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{0, 2, 0}
}

// Warning code for Policy Based Routing. Expect to add values in the
// future.
type PolicyBasedRoute_Warnings_Code int32

const (
	// Default value.
	PolicyBasedRoute_Warnings_WARNING_UNSPECIFIED PolicyBasedRoute_Warnings_Code = 0
	// The policy based route is not active and functioning. Common causes are
	// the dependent network was deleted or the resource project was turned
	// off.
	PolicyBasedRoute_Warnings_RESOURCE_NOT_ACTIVE PolicyBasedRoute_Warnings_Code = 1
	// The policy based route is being modified (e.g. created/deleted) at this
	// time.
	PolicyBasedRoute_Warnings_RESOURCE_BEING_MODIFIED PolicyBasedRoute_Warnings_Code = 2
)

// Enum value maps for PolicyBasedRoute_Warnings_Code.
var (
	PolicyBasedRoute_Warnings_Code_name = map[int32]string{
		0: "WARNING_UNSPECIFIED",
		1: "RESOURCE_NOT_ACTIVE",
		2: "RESOURCE_BEING_MODIFIED",
	}
	PolicyBasedRoute_Warnings_Code_value = map[string]int32{
		"WARNING_UNSPECIFIED":     0,
		"RESOURCE_NOT_ACTIVE":     1,
		"RESOURCE_BEING_MODIFIED": 2,
	}
)

func (x PolicyBasedRoute_Warnings_Code) Enum() *PolicyBasedRoute_Warnings_Code {
	p := new(PolicyBasedRoute_Warnings_Code)
	*p = x
	return p
}

func (x PolicyBasedRoute_Warnings_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PolicyBasedRoute_Warnings_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_enumTypes[2].Descriptor()
}

func (PolicyBasedRoute_Warnings_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_enumTypes[2]
}

func (x PolicyBasedRoute_Warnings_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PolicyBasedRoute_Warnings_Code.Descriptor instead.
func (PolicyBasedRoute_Warnings_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{0, 3, 0}
}

// Policy Based Routes (PBR) are more powerful routes that allows GCP customers
// to route their L4 network traffic based on not just destination IP, but also
// source IP, protocol and more. A PBR always take precedence when it conflicts
// with other types of routes.
// Next id: 22
type PolicyBasedRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target specifies network endpoints to which this policy based route applies
	// to. If none of the target is specified, the PBR will be installed on all
	// network endpoints (e.g. VMs, VPNs, and Interconnects) in the VPC.
	//
	// Types that are assignable to Target:
	//
	//	*PolicyBasedRoute_VirtualMachine_
	//	*PolicyBasedRoute_InterconnectAttachment_
	Target isPolicyBasedRoute_Target `protobuf_oneof:"target"`
	// Types that are assignable to NextHop:
	//
	//	*PolicyBasedRoute_NextHopIlbIp
	//	*PolicyBasedRoute_NextHopOtherRoutes
	NextHop isPolicyBasedRoute_NextHop `protobuf_oneof:"next_hop"`
	// Immutable. A unique name of the resource in the form of
	// `projects/{project_number}/locations/global/PolicyBasedRoutes/{policy_based_route_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when the PolicyBasedRoute was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the PolicyBasedRoute was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. An optional description of this resource. Provide this field when
	// you create the resource.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Fully-qualified URL of the network that this route applies to.
	// e.g. projects/my-project/global/networks/my-network.
	Network string `protobuf:"bytes,6,opt,name=network,proto3" json:"network,omitempty"`
	// Required. The filter to match L4 traffic.
	Filter *PolicyBasedRoute_Filter `protobuf:"bytes,10,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The priority of this policy based route. Priority is used to
	// break ties in cases where there are more than one matching policy based
	// routes found. In cases where multiple policy based routes are matched, the
	// one with the lowest-numbered priority value wins. The default value is
	// 1000. The priority value must be from 1 to 65535, inclusive.
	Priority int32 `protobuf:"varint,11,opt,name=priority,proto3" json:"priority,omitempty"`
	// Output only. If potential misconfigurations are detected for this route,
	// this field will be populated with warning messages.
	Warnings []*PolicyBasedRoute_Warnings `protobuf:"bytes,14,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// Output only. Server-defined fully-qualified URL for this resource.
	SelfLink string `protobuf:"bytes,15,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Output only. Type of this resource. Always
	// networkconnectivity#policyBasedRoute for Policy Based Route resources.
	Kind string `protobuf:"bytes,16,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *PolicyBasedRoute) Reset() {
	*x = PolicyBasedRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyBasedRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyBasedRoute) ProtoMessage() {}

func (x *PolicyBasedRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyBasedRoute.ProtoReflect.Descriptor instead.
func (*PolicyBasedRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{0}
}

func (m *PolicyBasedRoute) GetTarget() isPolicyBasedRoute_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *PolicyBasedRoute) GetVirtualMachine() *PolicyBasedRoute_VirtualMachine {
	if x, ok := x.GetTarget().(*PolicyBasedRoute_VirtualMachine_); ok {
		return x.VirtualMachine
	}
	return nil
}

func (x *PolicyBasedRoute) GetInterconnectAttachment() *PolicyBasedRoute_InterconnectAttachment {
	if x, ok := x.GetTarget().(*PolicyBasedRoute_InterconnectAttachment_); ok {
		return x.InterconnectAttachment
	}
	return nil
}

func (m *PolicyBasedRoute) GetNextHop() isPolicyBasedRoute_NextHop {
	if m != nil {
		return m.NextHop
	}
	return nil
}

func (x *PolicyBasedRoute) GetNextHopIlbIp() string {
	if x, ok := x.GetNextHop().(*PolicyBasedRoute_NextHopIlbIp); ok {
		return x.NextHopIlbIp
	}
	return ""
}

func (x *PolicyBasedRoute) GetNextHopOtherRoutes() PolicyBasedRoute_OtherRoutes {
	if x, ok := x.GetNextHop().(*PolicyBasedRoute_NextHopOtherRoutes); ok {
		return x.NextHopOtherRoutes
	}
	return PolicyBasedRoute_OTHER_ROUTES_UNSPECIFIED
}

func (x *PolicyBasedRoute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PolicyBasedRoute) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PolicyBasedRoute) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PolicyBasedRoute) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PolicyBasedRoute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PolicyBasedRoute) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *PolicyBasedRoute) GetFilter() *PolicyBasedRoute_Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *PolicyBasedRoute) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *PolicyBasedRoute) GetWarnings() []*PolicyBasedRoute_Warnings {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *PolicyBasedRoute) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *PolicyBasedRoute) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

type isPolicyBasedRoute_Target interface {
	isPolicyBasedRoute_Target()
}

type PolicyBasedRoute_VirtualMachine_ struct {
	// Optional. VM instances to which this policy based route applies to.
	VirtualMachine *PolicyBasedRoute_VirtualMachine `protobuf:"bytes,18,opt,name=virtual_machine,json=virtualMachine,proto3,oneof"`
}

type PolicyBasedRoute_InterconnectAttachment_ struct {
	// Optional. The interconnect attachments to which this route applies to.
	InterconnectAttachment *PolicyBasedRoute_InterconnectAttachment `protobuf:"bytes,9,opt,name=interconnect_attachment,json=interconnectAttachment,proto3,oneof"`
}

func (*PolicyBasedRoute_VirtualMachine_) isPolicyBasedRoute_Target() {}

func (*PolicyBasedRoute_InterconnectAttachment_) isPolicyBasedRoute_Target() {}

type isPolicyBasedRoute_NextHop interface {
	isPolicyBasedRoute_NextHop()
}

type PolicyBasedRoute_NextHopIlbIp struct {
	// Optional. The IP of a global access enabled L4 ILB that should be the
	// next hop to handle matching packets. For this version, only
	// next_hop_ilb_ip is supported.
	NextHopIlbIp string `protobuf:"bytes,12,opt,name=next_hop_ilb_ip,json=nextHopIlbIp,proto3,oneof"`
}

type PolicyBasedRoute_NextHopOtherRoutes struct {
	// Optional. Other routes that will be referenced to determine the next hop
	// of the packet.
	NextHopOtherRoutes PolicyBasedRoute_OtherRoutes `protobuf:"varint,21,opt,name=next_hop_other_routes,json=nextHopOtherRoutes,proto3,enum=google.cloud.networkconnectivity.v1.PolicyBasedRoute_OtherRoutes,oneof"`
}

func (*PolicyBasedRoute_NextHopIlbIp) isPolicyBasedRoute_NextHop() {}

func (*PolicyBasedRoute_NextHopOtherRoutes) isPolicyBasedRoute_NextHop() {}

// Request for [PolicyBasedRouting.ListPolicyBasedRoutes][] method.
type ListPolicyBasedRoutesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results per page that should be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters the results listed in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListPolicyBasedRoutesRequest) Reset() {
	*x = ListPolicyBasedRoutesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPolicyBasedRoutesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPolicyBasedRoutesRequest) ProtoMessage() {}

func (x *ListPolicyBasedRoutesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPolicyBasedRoutesRequest.ProtoReflect.Descriptor instead.
func (*ListPolicyBasedRoutesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{1}
}

func (x *ListPolicyBasedRoutesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPolicyBasedRoutesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPolicyBasedRoutesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPolicyBasedRoutesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPolicyBasedRoutesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for [PolicyBasedRouting.ListPolicyBasedRoutes][] method.
type ListPolicyBasedRoutesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Policy based routes to be returned.
	PolicyBasedRoutes []*PolicyBasedRoute `protobuf:"bytes,1,rep,name=policy_based_routes,json=policyBasedRoutes,proto3" json:"policy_based_routes,omitempty"`
	// The next pagination token in the List response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListPolicyBasedRoutesResponse) Reset() {
	*x = ListPolicyBasedRoutesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPolicyBasedRoutesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPolicyBasedRoutesResponse) ProtoMessage() {}

func (x *ListPolicyBasedRoutesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPolicyBasedRoutesResponse.ProtoReflect.Descriptor instead.
func (*ListPolicyBasedRoutesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{2}
}

func (x *ListPolicyBasedRoutesResponse) GetPolicyBasedRoutes() []*PolicyBasedRoute {
	if x != nil {
		return x.PolicyBasedRoutes
	}
	return nil
}

func (x *ListPolicyBasedRoutesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPolicyBasedRoutesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for [PolicyBasedRouting.GetPolicyBasedRoute][] method.
type GetPolicyBasedRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the PolicyBasedRoute resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPolicyBasedRouteRequest) Reset() {
	*x = GetPolicyBasedRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPolicyBasedRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPolicyBasedRouteRequest) ProtoMessage() {}

func (x *GetPolicyBasedRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPolicyBasedRouteRequest.ProtoReflect.Descriptor instead.
func (*GetPolicyBasedRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{3}
}

func (x *GetPolicyBasedRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [PolicyBasedRouting.CreatePolicyBasedRoute][] method.
type CreatePolicyBasedRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name of the PolicyBasedRoute.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Unique id for the Policy Based Route to create.
	PolicyBasedRouteId string `protobuf:"bytes,2,opt,name=policy_based_route_id,json=policyBasedRouteId,proto3" json:"policy_based_route_id,omitempty"`
	// Required. Initial values for a new Policy Based Route.
	PolicyBasedRoute *PolicyBasedRoute `protobuf:"bytes,3,opt,name=policy_based_route,json=policyBasedRoute,proto3" json:"policy_based_route,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreatePolicyBasedRouteRequest) Reset() {
	*x = CreatePolicyBasedRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePolicyBasedRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePolicyBasedRouteRequest) ProtoMessage() {}

func (x *CreatePolicyBasedRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePolicyBasedRouteRequest.ProtoReflect.Descriptor instead.
func (*CreatePolicyBasedRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{4}
}

func (x *CreatePolicyBasedRouteRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePolicyBasedRouteRequest) GetPolicyBasedRouteId() string {
	if x != nil {
		return x.PolicyBasedRouteId
	}
	return ""
}

func (x *CreatePolicyBasedRouteRequest) GetPolicyBasedRoute() *PolicyBasedRoute {
	if x != nil {
		return x.PolicyBasedRoute
	}
	return nil
}

func (x *CreatePolicyBasedRouteRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for [PolicyBasedRouting.DeletePolicyBasedRoute][] method.
type DeletePolicyBasedRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the PolicyBasedRoute resource to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeletePolicyBasedRouteRequest) Reset() {
	*x = DeletePolicyBasedRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePolicyBasedRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePolicyBasedRouteRequest) ProtoMessage() {}

func (x *DeletePolicyBasedRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePolicyBasedRouteRequest.ProtoReflect.Descriptor instead.
func (*DeletePolicyBasedRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{5}
}

func (x *DeletePolicyBasedRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePolicyBasedRouteRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// VM instances to which this policy based route applies to.
type PolicyBasedRoute_VirtualMachine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of VM instance tags to which this policy based route
	// applies to. VM instances that have ANY of tags specified here will
	// install this PBR.
	Tags []string `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *PolicyBasedRoute_VirtualMachine) Reset() {
	*x = PolicyBasedRoute_VirtualMachine{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyBasedRoute_VirtualMachine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyBasedRoute_VirtualMachine) ProtoMessage() {}

func (x *PolicyBasedRoute_VirtualMachine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyBasedRoute_VirtualMachine.ProtoReflect.Descriptor instead.
func (*PolicyBasedRoute_VirtualMachine) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PolicyBasedRoute_VirtualMachine) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// InterconnectAttachment to which this route applies to.
type PolicyBasedRoute_InterconnectAttachment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Cloud region to install this policy based route on interconnect
	// attachment. Use `all` to install it on all interconnect attachments.
	Region string `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *PolicyBasedRoute_InterconnectAttachment) Reset() {
	*x = PolicyBasedRoute_InterconnectAttachment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyBasedRoute_InterconnectAttachment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyBasedRoute_InterconnectAttachment) ProtoMessage() {}

func (x *PolicyBasedRoute_InterconnectAttachment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyBasedRoute_InterconnectAttachment.ProtoReflect.Descriptor instead.
func (*PolicyBasedRoute_InterconnectAttachment) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{0, 1}
}

func (x *PolicyBasedRoute_InterconnectAttachment) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// Filter matches L4 traffic.
type PolicyBasedRoute_Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The IP protocol that this policy based route applies to. Valid
	// values are 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
	IpProtocol string `protobuf:"bytes,1,opt,name=ip_protocol,json=ipProtocol,proto3" json:"ip_protocol,omitempty"`
	// Optional. The source IP range of outgoing packets that this policy based
	// route applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
	SrcRange string `protobuf:"bytes,2,opt,name=src_range,json=srcRange,proto3" json:"src_range,omitempty"`
	// Optional. The destination IP range of outgoing packets that this policy
	// based route applies to. Default is "0.0.0.0/0" if protocol version is
	// IPv4.
	DestRange string `protobuf:"bytes,3,opt,name=dest_range,json=destRange,proto3" json:"dest_range,omitempty"`
	// Required. Internet protocol versions this policy based route applies to.
	// For this version, only IPV4 is supported.
	ProtocolVersion PolicyBasedRoute_Filter_ProtocolVersion `protobuf:"varint,6,opt,name=protocol_version,json=protocolVersion,proto3,enum=google.cloud.networkconnectivity.v1.PolicyBasedRoute_Filter_ProtocolVersion" json:"protocol_version,omitempty"`
}

func (x *PolicyBasedRoute_Filter) Reset() {
	*x = PolicyBasedRoute_Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyBasedRoute_Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyBasedRoute_Filter) ProtoMessage() {}

func (x *PolicyBasedRoute_Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyBasedRoute_Filter.ProtoReflect.Descriptor instead.
func (*PolicyBasedRoute_Filter) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{0, 2}
}

func (x *PolicyBasedRoute_Filter) GetIpProtocol() string {
	if x != nil {
		return x.IpProtocol
	}
	return ""
}

func (x *PolicyBasedRoute_Filter) GetSrcRange() string {
	if x != nil {
		return x.SrcRange
	}
	return ""
}

func (x *PolicyBasedRoute_Filter) GetDestRange() string {
	if x != nil {
		return x.DestRange
	}
	return ""
}

func (x *PolicyBasedRoute_Filter) GetProtocolVersion() PolicyBasedRoute_Filter_ProtocolVersion {
	if x != nil {
		return x.ProtocolVersion
	}
	return PolicyBasedRoute_Filter_PROTOCOL_VERSION_UNSPECIFIED
}

// Informational warning message.
type PolicyBasedRoute_Warnings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A warning code, if applicable.
	Code PolicyBasedRoute_Warnings_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.networkconnectivity.v1.PolicyBasedRoute_Warnings_Code" json:"code,omitempty"`
	// Output only. Metadata about this warning in key: value format. The key
	// should provides more detail on the warning being returned. For example,
	// for warnings where there are no results in a list request for a
	// particular zone, this key might be scope and the key value might be the
	// zone name. Other examples might be a key indicating a deprecated resource
	// and a suggested replacement.
	Data map[string]string `protobuf:"bytes,2,rep,name=data,proto3" json:"data,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. A human-readable description of the warning code.
	WarningMessage string `protobuf:"bytes,3,opt,name=warning_message,json=warningMessage,proto3" json:"warning_message,omitempty"`
}

func (x *PolicyBasedRoute_Warnings) Reset() {
	*x = PolicyBasedRoute_Warnings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyBasedRoute_Warnings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyBasedRoute_Warnings) ProtoMessage() {}

func (x *PolicyBasedRoute_Warnings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyBasedRoute_Warnings.ProtoReflect.Descriptor instead.
func (*PolicyBasedRoute_Warnings) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP(), []int{0, 3}
}

func (x *PolicyBasedRoute_Warnings) GetCode() PolicyBasedRoute_Warnings_Code {
	if x != nil {
		return x.Code
	}
	return PolicyBasedRoute_Warnings_WARNING_UNSPECIFIED
}

func (x *PolicyBasedRoute_Warnings) GetData() map[string]string {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *PolicyBasedRoute_Warnings) GetWarningMessage() string {
	if x != nil {
		return x.WarningMessage
	}
	return ""
}

var File_google_cloud_networkconnectivity_v1_policy_based_routing_proto protoreflect.FileDescriptor

var file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x61, 0x73,
	0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf8, 0x10,
	0x0a, 0x10, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x12, 0x74, 0x0a, 0x0f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61,
	0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x12, 0x8c, 0x01, 0x0a, 0x17, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x16, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x68, 0x6f, 0x70, 0x5f, 0x69, 0x6c, 0x62, 0x5f, 0x69, 0x70, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0c, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70,
	0x49, 0x6c, 0x62, 0x49, 0x70, 0x12, 0x7b, 0x0a, 0x15, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f,
	0x70, 0x5f, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4f, 0x74, 0x68, 0x65,
	0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x12,
	0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x59, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65,
	0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x59, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f,
	0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x5f, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61,
	0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x20, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69,
	0x6e, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0x29, 0x0a, 0x0e, 0x56,
	0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x1a, 0x35, 0x0a, 0x16, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x1a, 0xb1, 0x02,
	0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x70, 0x5f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x69, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x20,
	0x0a, 0x09, 0x73, 0x72, 0x63, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x72, 0x63, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x64, 0x65, 0x73, 0x74, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x7c, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f,
	0x4c, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x50, 0x56, 0x34, 0x10,
	0x01, 0x1a, 0x89, 0x03, 0x0a, 0x08, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5c,
	0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x2e, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6f, 0x64,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x61, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x2e, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x2c, 0x0a, 0x0f, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x77,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x37, 0x0a,
	0x09, 0x44, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x55, 0x0a, 0x04, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x17,
	0x0a, 0x13, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01,
	0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x42, 0x45, 0x49,
	0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x02, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x40, 0x0a, 0x0b, 0x4f, 0x74, 0x68, 0x65,
	0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x18, 0x4f, 0x54, 0x48, 0x45, 0x52,
	0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54,
	0x5f, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x3a, 0x85, 0x01, 0xea, 0x41, 0x81,
	0x01, 0x0a, 0x33, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65,
	0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x4a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x0a, 0x0a, 0x08,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x22, 0xd0, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd0, 0x01, 0x0a, 0x1d,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a,
	0x13, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x52, 0x11, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x6d,
	0x0a, 0x1a, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x35, 0x0a, 0x33, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73,
	0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa8, 0x02,
	0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61,
	0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x36, 0x0a, 0x15, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x61, 0x73,
	0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61,
	0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x64, 0x12, 0x68, 0x0a, 0x12, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x94, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35,
	0x0a, 0x33, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x32,
	0xe3, 0x08, 0x0a, 0x19, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xeb, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65,
	0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12,
	0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0xd8, 0x01, 0x0a, 0x13,
	0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x22, 0x49, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61,
	0x6c, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xae, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb0, 0x01, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x12, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x22, 0x3a, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65,
	0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0xf3, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x76, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3c, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x61, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x56, 0xca,
	0x41, 0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x94, 0x02, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x42, 0x17, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x73, 0x65, 0x64, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x70,
	0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x70, 0x62, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x23,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescOnce sync.Once
	file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescData = file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDesc
)

func file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescGZIP() []byte {
	file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescData)
	})
	return file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDescData
}

var file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_goTypes = []any{
	(PolicyBasedRoute_OtherRoutes)(0),               // 0: google.cloud.networkconnectivity.v1.PolicyBasedRoute.OtherRoutes
	(PolicyBasedRoute_Filter_ProtocolVersion)(0),    // 1: google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion
	(PolicyBasedRoute_Warnings_Code)(0),             // 2: google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code
	(*PolicyBasedRoute)(nil),                        // 3: google.cloud.networkconnectivity.v1.PolicyBasedRoute
	(*ListPolicyBasedRoutesRequest)(nil),            // 4: google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesRequest
	(*ListPolicyBasedRoutesResponse)(nil),           // 5: google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesResponse
	(*GetPolicyBasedRouteRequest)(nil),              // 6: google.cloud.networkconnectivity.v1.GetPolicyBasedRouteRequest
	(*CreatePolicyBasedRouteRequest)(nil),           // 7: google.cloud.networkconnectivity.v1.CreatePolicyBasedRouteRequest
	(*DeletePolicyBasedRouteRequest)(nil),           // 8: google.cloud.networkconnectivity.v1.DeletePolicyBasedRouteRequest
	(*PolicyBasedRoute_VirtualMachine)(nil),         // 9: google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
	(*PolicyBasedRoute_InterconnectAttachment)(nil), // 10: google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
	(*PolicyBasedRoute_Filter)(nil),                 // 11: google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter
	(*PolicyBasedRoute_Warnings)(nil),               // 12: google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
	nil,                                             // 13: google.cloud.networkconnectivity.v1.PolicyBasedRoute.LabelsEntry
	nil,                                             // 14: google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.DataEntry
	(*timestamppb.Timestamp)(nil),                   // 15: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),                 // 16: google.longrunning.Operation
}
var file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_depIdxs = []int32{
	9,  // 0: google.cloud.networkconnectivity.v1.PolicyBasedRoute.virtual_machine:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
	10, // 1: google.cloud.networkconnectivity.v1.PolicyBasedRoute.interconnect_attachment:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
	0,  // 2: google.cloud.networkconnectivity.v1.PolicyBasedRoute.next_hop_other_routes:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute.OtherRoutes
	15, // 3: google.cloud.networkconnectivity.v1.PolicyBasedRoute.create_time:type_name -> google.protobuf.Timestamp
	15, // 4: google.cloud.networkconnectivity.v1.PolicyBasedRoute.update_time:type_name -> google.protobuf.Timestamp
	13, // 5: google.cloud.networkconnectivity.v1.PolicyBasedRoute.labels:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute.LabelsEntry
	11, // 6: google.cloud.networkconnectivity.v1.PolicyBasedRoute.filter:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter
	12, // 7: google.cloud.networkconnectivity.v1.PolicyBasedRoute.warnings:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
	3,  // 8: google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesResponse.policy_based_routes:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute
	3,  // 9: google.cloud.networkconnectivity.v1.CreatePolicyBasedRouteRequest.policy_based_route:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute
	1,  // 10: google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.protocol_version:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion
	2,  // 11: google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.code:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code
	14, // 12: google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.data:type_name -> google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.DataEntry
	4,  // 13: google.cloud.networkconnectivity.v1.PolicyBasedRoutingService.ListPolicyBasedRoutes:input_type -> google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesRequest
	6,  // 14: google.cloud.networkconnectivity.v1.PolicyBasedRoutingService.GetPolicyBasedRoute:input_type -> google.cloud.networkconnectivity.v1.GetPolicyBasedRouteRequest
	7,  // 15: google.cloud.networkconnectivity.v1.PolicyBasedRoutingService.CreatePolicyBasedRoute:input_type -> google.cloud.networkconnectivity.v1.CreatePolicyBasedRouteRequest
	8,  // 16: google.cloud.networkconnectivity.v1.PolicyBasedRoutingService.DeletePolicyBasedRoute:input_type -> google.cloud.networkconnectivity.v1.DeletePolicyBasedRouteRequest
	5,  // 17: google.cloud.networkconnectivity.v1.PolicyBasedRoutingService.ListPolicyBasedRoutes:output_type -> google.cloud.networkconnectivity.v1.ListPolicyBasedRoutesResponse
	3,  // 18: google.cloud.networkconnectivity.v1.PolicyBasedRoutingService.GetPolicyBasedRoute:output_type -> google.cloud.networkconnectivity.v1.PolicyBasedRoute
	16, // 19: google.cloud.networkconnectivity.v1.PolicyBasedRoutingService.CreatePolicyBasedRoute:output_type -> google.longrunning.Operation
	16, // 20: google.cloud.networkconnectivity.v1.PolicyBasedRoutingService.DeletePolicyBasedRoute:output_type -> google.longrunning.Operation
	17, // [17:21] is the sub-list for method output_type
	13, // [13:17] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_init() }
func file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_init() {
	if File_google_cloud_networkconnectivity_v1_policy_based_routing_proto != nil {
		return
	}
	file_google_cloud_networkconnectivity_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*PolicyBasedRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ListPolicyBasedRoutesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListPolicyBasedRoutesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*GetPolicyBasedRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*CreatePolicyBasedRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*DeletePolicyBasedRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*PolicyBasedRoute_VirtualMachine); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*PolicyBasedRoute_InterconnectAttachment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*PolicyBasedRoute_Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*PolicyBasedRoute_Warnings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes[0].OneofWrappers = []any{
		(*PolicyBasedRoute_VirtualMachine_)(nil),
		(*PolicyBasedRoute_InterconnectAttachment_)(nil),
		(*PolicyBasedRoute_NextHopIlbIp)(nil),
		(*PolicyBasedRoute_NextHopOtherRoutes)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_msgTypes,
	}.Build()
	File_google_cloud_networkconnectivity_v1_policy_based_routing_proto = out.File
	file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_rawDesc = nil
	file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_goTypes = nil
	file_google_cloud_networkconnectivity_v1_policy_based_routing_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PolicyBasedRoutingServiceClient is the client API for PolicyBasedRoutingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PolicyBasedRoutingServiceClient interface {
	// Lists PolicyBasedRoutes in a given project and location.
	ListPolicyBasedRoutes(ctx context.Context, in *ListPolicyBasedRoutesRequest, opts ...grpc.CallOption) (*ListPolicyBasedRoutesResponse, error)
	// Gets details of a single PolicyBasedRoute.
	GetPolicyBasedRoute(ctx context.Context, in *GetPolicyBasedRouteRequest, opts ...grpc.CallOption) (*PolicyBasedRoute, error)
	// Creates a new PolicyBasedRoute in a given project and location.
	CreatePolicyBasedRoute(ctx context.Context, in *CreatePolicyBasedRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single PolicyBasedRoute.
	DeletePolicyBasedRoute(ctx context.Context, in *DeletePolicyBasedRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type policyBasedRoutingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyBasedRoutingServiceClient(cc grpc.ClientConnInterface) PolicyBasedRoutingServiceClient {
	return &policyBasedRoutingServiceClient{cc}
}

func (c *policyBasedRoutingServiceClient) ListPolicyBasedRoutes(ctx context.Context, in *ListPolicyBasedRoutesRequest, opts ...grpc.CallOption) (*ListPolicyBasedRoutesResponse, error) {
	out := new(ListPolicyBasedRoutesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/ListPolicyBasedRoutes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBasedRoutingServiceClient) GetPolicyBasedRoute(ctx context.Context, in *GetPolicyBasedRouteRequest, opts ...grpc.CallOption) (*PolicyBasedRoute, error) {
	out := new(PolicyBasedRoute)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/GetPolicyBasedRoute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBasedRoutingServiceClient) CreatePolicyBasedRoute(ctx context.Context, in *CreatePolicyBasedRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/CreatePolicyBasedRoute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBasedRoutingServiceClient) DeletePolicyBasedRoute(ctx context.Context, in *DeletePolicyBasedRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/DeletePolicyBasedRoute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyBasedRoutingServiceServer is the server API for PolicyBasedRoutingService service.
type PolicyBasedRoutingServiceServer interface {
	// Lists PolicyBasedRoutes in a given project and location.
	ListPolicyBasedRoutes(context.Context, *ListPolicyBasedRoutesRequest) (*ListPolicyBasedRoutesResponse, error)
	// Gets details of a single PolicyBasedRoute.
	GetPolicyBasedRoute(context.Context, *GetPolicyBasedRouteRequest) (*PolicyBasedRoute, error)
	// Creates a new PolicyBasedRoute in a given project and location.
	CreatePolicyBasedRoute(context.Context, *CreatePolicyBasedRouteRequest) (*longrunningpb.Operation, error)
	// Deletes a single PolicyBasedRoute.
	DeletePolicyBasedRoute(context.Context, *DeletePolicyBasedRouteRequest) (*longrunningpb.Operation, error)
}

// UnimplementedPolicyBasedRoutingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPolicyBasedRoutingServiceServer struct {
}

func (*UnimplementedPolicyBasedRoutingServiceServer) ListPolicyBasedRoutes(context.Context, *ListPolicyBasedRoutesRequest) (*ListPolicyBasedRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPolicyBasedRoutes not implemented")
}
func (*UnimplementedPolicyBasedRoutingServiceServer) GetPolicyBasedRoute(context.Context, *GetPolicyBasedRouteRequest) (*PolicyBasedRoute, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicyBasedRoute not implemented")
}
func (*UnimplementedPolicyBasedRoutingServiceServer) CreatePolicyBasedRoute(context.Context, *CreatePolicyBasedRouteRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePolicyBasedRoute not implemented")
}
func (*UnimplementedPolicyBasedRoutingServiceServer) DeletePolicyBasedRoute(context.Context, *DeletePolicyBasedRouteRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePolicyBasedRoute not implemented")
}

func RegisterPolicyBasedRoutingServiceServer(s *grpc.Server, srv PolicyBasedRoutingServiceServer) {
	s.RegisterService(&_PolicyBasedRoutingService_serviceDesc, srv)
}

func _PolicyBasedRoutingService_ListPolicyBasedRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPolicyBasedRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBasedRoutingServiceServer).ListPolicyBasedRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/ListPolicyBasedRoutes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBasedRoutingServiceServer).ListPolicyBasedRoutes(ctx, req.(*ListPolicyBasedRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBasedRoutingService_GetPolicyBasedRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyBasedRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBasedRoutingServiceServer).GetPolicyBasedRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/GetPolicyBasedRoute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBasedRoutingServiceServer).GetPolicyBasedRoute(ctx, req.(*GetPolicyBasedRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBasedRoutingService_CreatePolicyBasedRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePolicyBasedRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBasedRoutingServiceServer).CreatePolicyBasedRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/CreatePolicyBasedRoute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBasedRoutingServiceServer).CreatePolicyBasedRoute(ctx, req.(*CreatePolicyBasedRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBasedRoutingService_DeletePolicyBasedRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePolicyBasedRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBasedRoutingServiceServer).DeletePolicyBasedRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/DeletePolicyBasedRoute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBasedRoutingServiceServer).DeletePolicyBasedRoute(ctx, req.(*DeletePolicyBasedRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PolicyBasedRoutingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.PolicyBasedRoutingService",
	HandlerType: (*PolicyBasedRoutingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPolicyBasedRoutes",
			Handler:    _PolicyBasedRoutingService_ListPolicyBasedRoutes_Handler,
		},
		{
			MethodName: "GetPolicyBasedRoute",
			Handler:    _PolicyBasedRoutingService_GetPolicyBasedRoute_Handler,
		},
		{
			MethodName: "CreatePolicyBasedRoute",
			Handler:    _PolicyBasedRoutingService_CreatePolicyBasedRoute_Handler,
		},
		{
			MethodName: "DeletePolicyBasedRoute",
			Handler:    _PolicyBasedRoutingService_DeletePolicyBasedRoute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/policy_based_routing.proto",
}
