#include <sys/stat.h>
#include "error.h"
#include "pathexec.h"
#include "prot.h"
#include "stralloc.h"
#include "openreadclose.h"
#include "env.h"

#include "global.h"
#include "md5.h"

#include "auto_maildir.h"
#include "auto_password.h"
#include "auto_patrn.h"

#include <pwd.h>
static struct passwd *pw;

static char up[513];
static int uplen;

static stralloc stored = {0};
static stralloc pwfile = {0};

static char *hextable = "0123456789abcdef";

void cleanup()
{
  int i;
  for (i = 0;i < sizeof(up);++i) up[i] = 0;
  for (i = 0;i < stored.len;++i) stored.s[i] = 0;
}

void die(int x)
{
  cleanup();
  _exit(x);
}

main(int argc,char **argv)
{
  char *login;
  char *dash;
  char *ext;
  char *password;
  char *timestamp;
  struct stat st;
  int r;
  int i;

  MD5_CTX context;
  unsigned char digest[16];
  char encrypted[16*2+1];
  char *s;
 
  if (!argv[1]) _exit(2);
  dash = env_get("DASH");
 
  uplen = 0;
  for (;;) {
    do
      r = read(3,up + uplen,sizeof(up) - uplen);
    while ((r == -1) && (errno == error_intr));
    if (r == -1) _exit(111);
    if (r == 0) break;
    uplen += r;
    if (uplen >= sizeof(up)) _exit(1);
  }
  close(3);

  i = 0;
  if (i >= uplen) _exit(2);
  login = up + i;
  while (up[i++]) if (i >= uplen) _exit(2);
  password = up + i;
  if (i >= uplen) _exit(2);
  while (up[i++]) if (i >= uplen) _exit(2);
  timestamp = up + i;
  if (i >= uplen) _exit(2);
  while (up[i++]) if (i >= uplen) _exit(2);

  i = 0;
  ext = login + str_len(login);
  for (;;) {
    pw = getpwnam(login);
    if (pw) break;
    if (errno == error_txtbsy) die(111);
    do {--ext;} while (ext != login && *ext != '-');
    if (ext == login) die(1);
    if (i) login[i] = '-';
    i = ext - login;
    login[i] = 0;
    ++ext;
  }
  if (chdir(pw->pw_dir) == -1) die(111);

  if (!stralloc_copys(&pwfile, auto_maildir)) die(111);
  if (dash && *ext) {
    if (!stralloc_cats(&pwfile, dash)) die(111);
    if (!stralloc_cats(&pwfile, ext)) die(111);
  }
  if (!stralloc_append(&pwfile, "/")) die(111);
  if (!stralloc_cats(&pwfile, auto_password)) die(111);
  if (!stralloc_0(&pwfile)) die(111);
  if (stat(pwfile.s,&st) == -1) die(1);
  if (st.st_uid != pw->pw_uid) die(1);
  if (st.st_mode & auto_patrn) die(111);
  if (openreadclose(pwfile.s,&stored,32) != 1) die(111);
  if (!stralloc_0(&stored)) die(111);
  stored.s[str_chr(stored.s,'\n')] = 0;

  MD5Init(&context);
  MD5Update(&context, timestamp, str_len(timestamp));
  MD5Update(&context, stored.s, str_len(stored.s));
  MD5Final(digest, &context);
  s = encrypted;
  for (i = 0; i < sizeof(digest); ++i) {
    *s = hextable[digest[i]/16]; ++s;
    *s = hextable[digest[i]%16]; ++s;
  }
  *s = '\0';
 
  if (strcmp(password,encrypted)) die(1);
 
  if (prot_gid((int) pw->pw_gid) == -1) die(1);
  if (prot_uid((int) pw->pw_uid) == -1) die(1);

  if (!pathexec_env("USER",pw->pw_name)) die(111);
  if (!pathexec_env("EXT",ext)) die(111);
  if (!pathexec_env("HOME",pw->pw_dir)) die(111);
  if (!pathexec_env("SHELL",pw->pw_shell)) die(111);
  cleanup();
  pathexec(argv + 1);
  _exit(111);
}
