/* Structures. */

typedef struct link {
	struct link	*l_forw;
	struct link	*l_back;
	void		*l_data;
} link_t;


typedef struct link_head {
	link_t	lh_list;
	link_t	*lh_cur;
	int	lh_count;
	int	(*lh_comp)(void *, void *);
	void	(*lh_free)(void *);
	void	(*lh_hfree)(void *);
	void	*lh_data;
} lhead_t;


/* Preprocessor definitions. */

#define list_count(lh)		((lh)->lh_count)
#define list_empty(lh)		((lh)->lh_count == 0)
#define list_rewind(lh)		((lh)->lh_cur = (link_t *)(lh))
#define list_rewound(lh)	((lh)->lh_cur == (link_t *)(lh))
#define list_cur(lh)		((lh)->lh_cur)
#define list_next(lh)		((lh)->lh_cur->l_forw)
#define list_last(lh)		((lh)->lh_cur->l_back)
#define list_forw(lh)		((lh)->lh_cur = (lh)->lh_cur->l_forw)
#define list_back(lh)		((lh)->lh_cur = (lh)->lh_cur->l_back)
#define list_first(lh)		((lh)->lh_list.l_forw)


/* External prototypes. */

lhead_t *list_init(void *, int (*)(void *, void *), void (*)(void *),
    void (*)(void *));

link_t *list_find(lhead_t *, void *);
link_t *list_add_cur(lhead_t *, void *);
link_t *list_add_forw(lhead_t *, void *);
link_t *list_add_back(lhead_t *, void *);

void list_free(lhead_t *);
void list_delete(lhead_t *, link_t *);
