/*
 * Copyright (c) 2005 Jacob Meuser <jakemsr@jakemsr.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: bsdav_ringbuf.c,v 1.4 2005/11/20 00:35:16 jakemsr Exp $
 */

#include "includes.h"

#include <err.h>
#include <stdlib.h>
#include <string.h>

#include "bsdav.h"


int
bsdav_init_ringbuf(struct bsdav_ringbuf *rb, size_t size)
{
int	 i;

	rb->buf_in = -1;
	rb->bufs_off = 0;
	rb->buf_out = 0;

	if ((rb->bufs = calloc(rb->num_bufs,
	    sizeof(struct bsdav_rb_buf))) == NULL) {
		warn("init_ringbuf: rb->bufs");
		return(1);
	}

	for (i = 0; i < rb->num_bufs; i++) {
		if ((rb->bufs[i].buf = malloc(size)) == NULL) {
			warn("init_ringbuf: rb->bufs[%d].buf", i);
			return(1);
		}
		rb->bufs[i].size = 0;
	}
	return(0);
}


void
bsdav_free_ringbuf(struct bsdav_ringbuf *rb)
{
int	 i;

	if (rb->bufs == NULL)
		return;

	for (i = 0; i < rb->num_bufs; i++) {
		if (rb->bufs[i].buf != NULL)
			free(rb->bufs[i].buf);
		rb->bufs[i].buf = NULL;
	}

	if (rb->bufs != NULL)
		free(rb->bufs);
	rb->bufs = NULL;
}


int
bsdav_rb_buf_in(struct bsdav_ringbuf *rb, uint8_t *buf, size_t size, struct timeval ts)
{
	rb->buf_in++;
	if (rb->buf_in >= rb->num_bufs)
		rb->buf_in -= rb->num_bufs;

	memcpy(rb->bufs[rb->buf_in].buf, buf, size);
	memcpy(&rb->bufs[rb->buf_in].ts, &ts, sizeof(struct timeval));
	rb->bufs[rb->buf_in].size = size;

	rb->bufs_off++;

	return(0);
}
