# Generate HTML tags

# Copyright (c) 2008-2020 Andreas Gustafsson.  All rights reserved.
# Please refer to the file COPYRIGHT for detailed copyright information.

import collections
from xml.sax.saxutils import quoteattr, escape

def tag(name, *args):
    if len(args) and isinstance(args[0], collections.abc.Mapping):
        attrs = args[0]
        args = args[1:]
    else:
        attrs = { }
    btag="<" + name + ''.join([' ' + k + '=' + quoteattr(attrs[k])
                               for k in list(attrs.keys())])
    if len(args):
        return btag + '>' + ''.join(args) + '</' + name + '>'
    else:
        return btag + ' />'

def def_tag(name):
    def tmp(*args):
        return tag(name, *args)
    globals()[name] = tmp

def def_tags(names):
    for n in names:
        def_tag(n)

def_tags('a b body br div form h1 h2 h3 h4 head html i img input label li '
         'meta object option p script select span style table textarea td '
         'title th tr tt ul'.split(' '))
