/* Report bits currently available from /dev/random. */

#ifndef lint
static char vcid[] = "$Revision: 1.3 $";
#endif /* lint */

/* Author:   Peter Hendrickson <pdh@wiredyne.com>
 *
 * License:  This code is in the public domain.  Any of this code may be
 *           freely reproduced or adapted, even without mentioning the
 *           source.
 *
 * Warranty: IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR
 *           DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 *           DAMAGES ARISING OUT OF THE USE OF THIS CODE, EVEN IF THE
 *           AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *           THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 *           INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *           MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE
 *           CODE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THERE
 *           IS NO OBLIGATION WHATSOEVER TO PROVIDE MAINTENANCE,
 *           SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <fcntl.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/rnd.h>

#define RANDOM "/dev/random"

main()
{
  int fd, result;
  u_int32_t entropy;

  fd = open(RANDOM, O_RDONLY);
  if( fd == -1 ) {
    fprintf(stderr, "Could not open device %s for reading.\n", RANDOM);
    perror("");
    exit(1);
  }

  result = ioctl( fd, RNDGETENTCNT, &entropy );
  if( result == -1 ) {
    fprintf(stderr, "call to ioctl() failed.\n");
    perror("");
    exit(2);
  }

  close(fd);

  printf("%ld\n", (long) entropy);
}
