/* pda_f2c_dnfftb.f -- translated by f2c (version 19941113).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include <fftw.h>
typedef FFTW_REAL real;

/* The work array should have size at least 6*MAXDIM+15 (for FFTPACK). Here, MAXDIM
   is the size of the largest array dimension. (Is initialized internally in
   dnfftf. 
   
   istat is an error code returned (error if not zero). */

/* Subroutine */ int pda_f2c_dnfftb(int *ndim, int *dim, real *x, 
	real *y, real *work, int *istat)
{
    /* System generated locals */
    int i1, i2, i3;

    /* Builtin functions */
    double sqrt(double);

    /* Local variables */
    static int cart[21], step, i, j, k, m, n, v, v0;
    extern /* Subroutine */ int pda_f2c_dcfftb(int *, real *, 
	    real *);
    static int iw;
    extern /* Subroutine */ int pda_f2c_dcffti(int *, real *);
    static real fac;
    static int inc, iwn;

/* + */
/*  Name: */
/*     PDA_F2C_DNFFTB */
/*  Purpose: */
/*     Take the backward FFT of an N-dimensional complex array. */
/*  Language: */
/*     Starlink Fortran 77 */
/*  Invocation: */
/*     CALL PDA_F2C_DNFFTB( NDIM, DIM, X, Y, WORK, ISTAT ) */
/*  Description: */
/*     The supplied Fourier co-efficients in X and Y are replaced by the 
*/
/*     corresponding spatial data obtained by doing an inverse Fourier */
/*     transform. See the forward FFT routine PDA_F2C_DNFFTF for more details.
 */
/*  Arguments: */
/*     NDIM = INTEGER (Given) */
/*        The number of dimensions. This should be no more than 20. */
/*     DIM( NDIM ) = INTEGER (Given) */
/*        The size of each dimension. */
/*     X( * ) = DOUBLE PRECISION (Given and Returned) */
/*        Supplied holding the double parts of the Fourier co-efficients. */
/*        Returned holding the double parts of the spatial data. The array 
*/
/*        should have the number of elements implied by NDIM and DIM. */
/*     Y( * ) = DOUBLE PRECISION (Given and Returned) */
/*       Supplied holding the imaginary parts of the Fourier co-efficients
.*/
/*       Returned holding the imaginary parts of the spatial data. The arr
ay*/
/*        should have the number of elements implied by NDIM and DIM. */
/*     WORK( * ) = DOUBLE PRECISION (Given and Returned) */
/*        A work array. This should have at least ( 6*DimMax + 15 ) */
/*        elements where DimMax is the maximum of the values supplied in 
*/
/*        DIM. */
/*     ISTAT = INTEGER (Returned) */
/*        If the value of NDIM is greater than 20 or less than 1, then */
/*        ISTAT is returned equal to 1, and the values in X and Y are */
/*        left unchanged. Otherwise, ISTAT is returned equal to 0. */
/*  Authors: */
/*     DSB: David Berry (STARLINK) */
/*     {enter_new_authors_here} */
/*  History: */
/*     21-FEB-1995 (DSB): */
/*        Original version. */
/*     {enter_changes_here} */
/*  Bugs: */
/*     {note_any_bugs_here} */
/* - */
/*  Type Definitions: */
/*  Arguments Given: */
/* No implicit typing */
/*  Arguments Given and Returned: */
/*  Arguments Returned: */
/*  Local Constants: */
/* Max number of dimensions */
/*  Local Variables: */
/* Current Cartesian pixel indices */
/* Index of current dimension */
/* Vector increment to next row element */
/* Index into the work array */
/* Index of first free work array element */
/* Row counter */
/* Pixel index on current axis */
/* Size of current dimension */
/* Total no. of pixels */
/* Vector step to start of next row */
/* Vector address */
/* Vector address of start of current row */
/* . */
/*  Check that the supplied number of dimensions is not too high, and */
/*  not too low. Return 1 for the status variable and abort otherwise. */
/* Normalisation factor */
    /* Parameter adjustments */
    --dim;
    --x;
    --y;
    --work;

    /* Function Body */
    if (*ndim > 20 || *ndim <= 0) {
	*istat = 1;
/*  If the number of dimensions is ok, return 0 for the status value a
nd */
/*  continue. */
    } else {
	*istat = 0;
/*  Find the total number of pixels. */
	n = 1;
	i1 = *ndim;
	for (i = 1; i <= i1; ++i) {
	    n *= dim[i];
	}
/*  The first dimension can be processed using a faster algorithm */
/*  because the elements to be processed occupy adjacent elements in t
he */
/*  supplied array. Set up the step (in vector address) between the */
/*  start of each row, and initialise the vector address of the start 
of */
/*  the first row. */
	m = dim[1];
	v0 = 1;
/*  Initialise the FFT work array for the current dimension. Save the 
*/
/*  index of the next un-used element of the work array. */
	pda_f2c_dcffti(&m, &work[1]);
	iwn = (m << 2) + 16;
/*  Store the factor which will normalise the Fourier co-efficients */
/* returned by this routine (i.e. so that a call to PDA_F2C_DNFFTB followe
d by a*/
/*  call to PDA_F2C_DNFFTB will result in no change to the data). */
	fac = 1. / sqrt((double) n);
/*  Loop round copying each row. */
	i1 = n / m;
	for (j = 1; j <= i1; ++j) {
/*  Copy this row into the unused part of the work array. */
	    iw = iwn;
	    v = v0;
	    i2 = m;
	    for (k = 1; k <= i2; ++k) {
		work[iw] = x[v];
		work[iw + 1] = y[v];
		iw += 2;
		++v;
	    }
/*  Take the FFT of it. */
	    pda_f2c_dcfftb(&m, &work[iwn], &work[1]);
/*  Copy it back to the supplied arrays, normalising it in the pro
cess. */
	    iw = iwn;
	    v = v0;
	    i2 = m;
	    for (k = 1; k <= i2; ++k) {
		x[v] = work[iw] * fac;
		y[v] = work[iw + 1] * fac;
		iw += 2;
		++v;
	    }
/*  Increment the vector address of the start of the next row. */
	    v0 += m;
	}
/*  Now set up the increment between adjacent elements of "rows" paral
lel */
/*  to the second dimension. */
	inc = dim[1];
/*  Process the remaining dimensions. Store the durrent dimensions. */
	i1 = *ndim;
	for (i = 2; i <= i1; ++i) {
	    m = dim[i];
/*  Initialise the co-ordinates (vector and Cartesian) of the firs
t */
/*  element of the first row. */
	    v0 = 1;
	    i2 = *ndim;
	    for (j = 1; j <= i2; ++j) {
		cart[j - 1] = 1;
	    }
/*  Initialise the FFT work array for this dimension, and save the
 index */
/*  of the next un-used element in the work array. */
	    pda_f2c_dcffti(&m, &work[1]);
	    iwn = (m << 2) + 16;
/*  Store the step (in vector address) between the end of one "row
" and */
/*  the start of the next. */
	    step = inc * (m - 1);
/*  Loop round each "row" parallel to the current dimensions. */
	    i2 = n / m;
	    for (j = 1; j <= i2; ++j) {
/*  Copy the current "row" into the work space. */
		v = v0;
		iw = iwn;
		i3 = m;
		for (k = 1; k <= i3; ++k) {
		    work[iw] = x[v];
		    work[iw + 1] = y[v];
		    v += inc;
		    iw += 2;
		}
/*  Take the FFT of the current "row". */
		pda_f2c_dcfftb(&m, &work[iwn], &work[1]);
/*  Copy the FFT of the current "row" back into the supplied a
rray. */
		v = v0;
		iw = iwn;
		i3 = m;
		for (k = 1; k <= i3; ++k) {
		    x[v] = work[iw];
		    y[v] = work[iw + 1];
		    v += inc;
		    iw += 2;
		}
/*  Increment the co-ordinates of the start of the current "ro
w". */
		++v0;
		k = 1;
		++cart[0];
/*  If the upper pixel index bound for the current dimension h
as been */
/*  exceeded, reset the pixel index to 1 and increment the nex
t */
/*  dimension. If the next dimension is the dimension currentl
y being */
/*  transformed, skip over it so that it stays at 1 (but incre
ment the */
/*  vector address to account for the skip). */
		while(cart[k - 1] > dim[k]) {
		    cart[k - 1] = 1;
		    ++k;
		    if (k == i) {
			++k;
			v0 += step;
		    }
		    ++cart[k - 1];
		}
	    }
/*  Store the increment in vector address between adjacent element
s of */
/*  the next "row". */
	    inc *= m;
	}
    }
    return 0;
} /* pda_f2c_dnfftb */

