#include <math.h>

#include "fxtaux.h"


/* define to use trig recurrence: */
/* (and possibly lose some precision, see below) */
/* #define TRIG_REC   */
/* NO speed gain on my machine ! */

/* define type to use in trig recursion: */
/* no precision loss with 'long double' */
#define  TFLOAT  long double


#if defined TEST_REC
#include <stdio.h>
#endif


void 
fht0(FFTW_REAL *f, int ldn)
  /* assumes that f[n/2]...f[n-1] are zero */
{
    FFTW_REAL *fi,*fn,*gi;
    int n,k;

    if(ldn<=1)
    {
        if(ldn==1)  f[1]=f[0]; 
        return;
    }

    n=(1<<ldn);

    scramble0(f,n);

    k=ldn&1;

    if (k==0)    /* ldn is multiple of 2  => n is a power of 4 */
    {
        for (fi=f,fn=f+n; fi<fn; fi+=4)
        {
            sumdiff2(fi[0],fi[2]);

            fi[3] = fi[2];
	    fi[1] = fi[0];
        }
    }
    else          /* k==1,  ldn is no multiple of 2  => n is no power of 4 */
    {
        for (fi=f,fn=f+n; fi<fn; fi+=8)
        {
            FFTW_REAL f0,f1,s1,s2,f2,f3;

            sumdiff4(fi[0],fi[2],f0,f1);

            s1 = fi[4]; 
            s2 = fi[6]; 

            sumdiff4(fi[4],fi[6],f2,f3);

            sumdiff4(f0,f2,fi[0],fi[4]);
            sumdiff4(f1,f3,fi[2],fi[6]);

            s2     *= SQRT2;
            s1     *= SQRT2;

            sumdiff4(f0,s1,fi[1],fi[5]);
            sumdiff4(f1,s2,fi[3],fi[7]);
        }
    }

    if (n<16)  return;

    {
    int k4;

    do
    {
        int k1,k2,k3,kx;

        k  += 2;
        k1  = 1  << k;
        k2  = k1 << 1;
        k4  = k2 << 1;
        k3  = k2 + k1;
        kx  = k1 >> 1;
        fi  = f;
        gi  = fi + kx;
        fn  = f + n;

        do
        {
            FFTW_REAL f0,f1,f2,f3;

            sumdiff4(fi[0],fi[k1],f0,f1);
            sumdiff4(fi[k2],fi[k3],f2,f3);

            sumdiff4(f0,f2,fi[0],fi[k2]);
            sumdiff4(f1,f3,fi[k1],fi[k3]);

            sumdiff4(gi[0],gi[k1],f0,f1);
            f3      = SQRT2  * gi[k3];
            f2      = SQRT2  * gi[k2];

            sumdiff4(f0,f2,gi[0],gi[k2]);
            sumdiff4(f1,f3,gi[k1],gi[k3]);

            gi     += k4;
            fi     += k4;
        }
        while (fi<fn);

        {
	FFTW_REAL tt=3.14159265358979323846264338327/4/kx;

#if defined TRIG_REC
	TFLOAT s1,c1,be;
        TFLOAT al=sin(0.5*tt);
        al *= (2.0*al);
        be=sin(tt);
        s1=0.0;
        c1=1.0;
#else
	double s1,c1;
#endif


	int i;
        for(i=1; i<kx; i++)
        {
	    FFTW_REAL c2,s2;

#if defined TRIG_REC
	    TFLOAT c2,s2;
            c1-=(al*(tt=c1)+be*s1);
            s1-=(al*s1-be*tt);
#else
            SINCOS(c1,s1,tt*i);

#endif

            csqr4(c1,s1,c2,s2);

            fn = f +n;
            fi = f +i;
            gi = f +k1-i;

            do
            {
                FFTW_REAL a,b,g0,f0,f1,g1,f2,g2,f3,g3;

                cmult6(s2,c2,fi[k1],gi[k1],b,a);
                sumdiff4(fi[0],a,f0,f1);
                sumdiff4(gi[0],b,g0,g1);

                cmult6(s2,c2,fi[k3],gi[k3],b,a);
                sumdiff4(fi[k2],a,f2,f3);
                sumdiff4(gi[k2],b,g2,g3);

                cmult6(s1,c1,f2,g3,b,a);
                sumdiff4(f0,a,fi[0],fi[k2]);
                sumdiff4(g1,b,gi[k1],gi[k3]);

                cmult6(c1,s1,g2,f3,b,a);
                sumdiff4(g0,a,gi[0],gi[k2]);
                sumdiff4(f1,b,fi[k1],fi[k3]);

                gi     += k4;
                fi     += k4;
            }
            while (fi<fn);

        }
	}
    }
    while (k4<n);
    }

}
/* ===================== end FHT0 =====================*/
