
#include "fxt.h"
#include "fxtaux.h"


void 
fht_fft(FFTW_REAL *real, FFTW_REAL *imag, int ldn, int is)
{
    int n;

    n=(1<<ldn);

    if(is<0)
    {   
	int i,j,k;
	k=n/2;
	for (i=1,j=n-1; i<k; i++,j--)
	{
	    FFTW_REAL q,r,s,t;

            sumdiff4(real[i],real[j],q,r);
            sumdiff4(imag[i],imag[j],s,t);
	    
            sumdiff4_05(q,t,real[i],real[j]);
            sumdiff4_05(s,r,imag[j],imag[i]);
	}
    
	fht(real,ldn);
	fht(imag,ldn);
    }
    else
    {
      int i,j,k;
        fht(real,ldn);
        fht(imag,ldn);
    
	k=n/2;
	for (i=1,j=n-1; i<k; i++,j--)
	{
	    FFTW_REAL q,r,s,t;

            sumdiff4(real[i],real[j],q,r);
            sumdiff4(imag[i],imag[j],s,t);

            sumdiff4_05(q,t,real[j],real[i]);
            sumdiff4_05(s,r,imag[i],imag[j]);
	}
    }   
}
/* ========================= end FHT_FFT =================== */


void 
fht_fft0(FFTW_REAL *real, FFTW_REAL *imag, int ldn, int is)
{
    int n;

    n=(1<<ldn);

    if(is<0)
    {   
	int i,j,k;
	k=n/2;
	for (i=1,j=n-1; i<k; i++,j--)
	{
	    /*
	    FFTW_REAL q,r,s,t;

            sumdiff4(real[i],0,q,r);
            sumdiff4(imag[i],0,s,t);
	    
            sumdiff4_05(q,t,real[i],real[j]);
            sumdiff4_05(s,r,imag[j],imag[i]);
	    */
            sumdiff4_05(real[i],imag[i],imag[j],real[j]);

            imag[i]=-real[j];
            real[i]= imag[j];
	}
    
	fht(real,ldn);
	fht(imag,ldn);
    }
    else 
    {
      int i,j,k;
        fht0(real,ldn);
      	fht0(imag,ldn);
    
	k=n/2;
	for (i=1,j=n-1; i<k; i++,j--)
	{
	    FFTW_REAL q,r,s,t;

            sumdiff4(real[i],real[j],q,r);
            sumdiff4(imag[i],imag[j],s,t);

            sumdiff4_05(q,t,real[j],real[i]);
            sumdiff4_05(s,r,imag[i],imag[j]);
	}
    }   
}
/* ========================= end FHT_FFT0 =================== */
