/* NAPACK.fft.f -- translated by f2c (version 19941113).
*/

#include <math.h>

#include <fftw.h>
typedef FFTW_REAL real;
typedef double doublereal;
typedef int integer;
typedef struct { real r, i; } complex;

void c_exp(complex *r, complex *z)
{
	double expx;

	expx = exp(z->r);
	r->r = expx * cos(z->i);
	r->i = expx * sin(z->i);
}

/* ====================================================================== */
/* NIST Guide to Available Math Software. */
/* Fullsource for module FFT from package NAPACK. */
/* Retrieved from NETLIB on Fri Mar 14 18:19:01 1997. */
/* ====================================================================== */

/*      ________________________________________________________ */
/*     |                                                        | */
/*     |               THE FAST FOURIER TRANSFORM               | */
/*     |             NEW A SUB I = SUM FROM J=1 TO N            | */
/*     |    EXP(2*PI*SQRT(-1)/N)**((I-1)*(J-1)) OLD A SUB J     | */
/*     |                                                        | */
/*     |    INPUT:                                              | */
/*     |                                                        | */
/*     |         A     --COEFFICIENTS                           | */
/*     |                                                        | */
/*     |         N     --NUMBER OF COEFFICIENTS                 | */
/*     |                                                        | */
/*     |    OUTPUT:                                             | */
/*     |                                                        | */
/*     |         A     --TRANSFORMED COEFFICIENTS               | */
/*     |                                                        | */
/*     |    BUILTIN FUNCTIONS: ACOS,CEXP,CMPLX                  | */
/*     |________________________________________________________| */

/* Subroutine */ int napack_fft(complex *a, integer *n, complex *w)
{
    /* Initialized data */

    static integer p[25] = { 2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,
	    61,67,71,73,79,83,89,97 };
    static integer np = 25;

    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5;
    doublereal d__1;
    complex q__1, q__2, q__3, q__4;

    /* Local variables */
    static integer d, e, f, g, h, i, j, k, l, m, o;
    static complex s, t, u, v;

    /* Parameter adjustments */
    --w;
    --a;

    /* Function Body */
    m = *n;
    f = 0;
    d__1 = acos(-1.f) * 2.f / *n;
    q__1.r = 0.f, q__1.i = d__1;
    u.r = q__1.r, u.i = q__1.i;
/*     -------------------------------------------------- */
/*     |*** SOME COMPILERS USE ARCOS INSTEAD OF ACOS ***| */
/*     -------------------------------------------------- */
L10:
    if (m == 1) {
	goto L900;
    }
    i__1 = np;
    for (i = 1; i <= i__1; ++i) {
/* L20: */
	if (m / p[i - 1] * p[i - 1] == m) {
	    goto L30;
	}
    }
    l = m;
    goto L40;
L30:
    l = p[i - 1];
L40:
    o = m;
    m /= l;
    d__1 = (doublereal) m;
    q__2.r = d__1 * u.r, q__2.i = d__1 * u.i;
    c_exp(&q__1, &q__2);
    v.r = q__1.r, v.i = q__1.i;
    s.r = 1.f, s.i = 0.f;
    h = 0;
    if (f == 1) {
	goto L470;
    }
    if (l == 2) {
	goto L50;
    }
    if (l == 3) {
	goto L170;
    }
    goto L290;
L50:
    switch (m) {
	case 1:  goto L150;
	case 2:  goto L130;
	case 3:  goto L110;
	case 4:  goto L90;
    }
L60:
    j = -h;
L70:
    i = h + 1;
    h += m;
    e = j + m;
    i__1 = h;
    for (k = i; k <= i__1; ++k) {
/* L80: */
	i__2 = k;
	i__3 = j + k;
	i__4 = e + k;
	q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i 
		+ s.i * a[i__4].r;
	q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
	w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    }
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L70;
    }
    if (h < *n) {
	goto L60;
    }
    f = 1;
    goto L10;
L90:
    j = -h;
L100:
    ++h;
    e = j + m;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    ++h;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    ++h;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    ++h;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L100;
    }
    if (h < *n) {
	goto L90;
    }
    f = 1;
    goto L10;
L110:
    j = -h;
L120:
    ++h;
    e = j + m;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    ++h;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    ++h;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L120;
    }
    if (h < *n) {
	goto L110;
    }
    f = 1;
    goto L10;
L130:
    j = -h;
L140:
    ++h;
    e = j + m;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    ++h;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L140;
    }
    if (h < *n) {
	goto L130;
    }
    f = 1;
    goto L10;
L150:
    j = -h;
L160:
    ++h;
    e = j + m;
    i__2 = h;
    i__3 = j + h;
    i__4 = e + h;
    q__2.r = s.r * a[i__4].r - s.i * a[i__4].i, q__2.i = s.r * a[i__4].i + 
	    s.i * a[i__4].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    w[i__2].r = q__1.r, w[i__2].i = q__1.i;
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L160;
    }
    if (h < *n) {
	goto L150;
    }
    f = 1;
    goto L10;
L170:
    switch (m) {
	case 1:  goto L270;
	case 2:  goto L250;
	case 3:  goto L230;
	case 4:  goto L210;
    }
L180:
    j = -h;
L190:
    i = h + 1;
    h += m;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__2 = h;
    for (k = i; k <= i__2; ++k) {
/* L200: */
	i__3 = k;
	i__4 = j + k;
	i__1 = e + k;
	q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i 
		+ s.i * a[i__1].r;
	q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
	i__5 = d + k;
	q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i 
		+ t.i * a[i__5].r;
	q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
	w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    }
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L190;
    }
    if (h < *n) {
	goto L180;
    }
    f = 1;
    goto L10;
L210:
    j = -h;
L220:
    ++h;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    ++h;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    ++h;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    ++h;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L220;
    }
    if (h < *n) {
	goto L210;
    }
    f = 1;
    goto L10;
L230:
    j = -h;
L240:
    ++h;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    ++h;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    ++h;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L240;
    }
    if (h < *n) {
	goto L230;
    }
    f = 1;
    goto L10;
L250:
    j = -h;
L260:
    ++h;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    ++h;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L260;
    }
    if (h < *n) {
	goto L250;
    }
    f = 1;
    goto L10;
L270:
    j = -h;
L280:
    ++h;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__3 = h;
    i__4 = j + h;
    i__1 = e + h;
    q__3.r = s.r * a[i__1].r - s.i * a[i__1].i, q__3.i = s.r * a[i__1].i + 
	    s.i * a[i__1].r;
    q__2.r = a[i__4].r + q__3.r, q__2.i = a[i__4].i + q__3.i;
    i__5 = d + h;
    q__4.r = t.r * a[i__5].r - t.i * a[i__5].i, q__4.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L280;
    }
    if (h < *n) {
	goto L270;
    }
    f = 1;
    goto L10;
L290:
    switch (m) {
	case 1:  goto L440;
	case 2:  goto L410;
	case 3:  goto L380;
	case 4:  goto L350;
    }
L300:
    j = -h;
L310:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    h += m;
    g = j + o;
    i__3 = h;
    for (k = i; k <= i__3; ++k) {
/* L320: */
	i__4 = k;
	w[i__4].r = 0.f, w[i__4].i = 0.f;
    }
L330:
    i__4 = h;
    for (k = i; k <= i__4; ++k) {
/* L340: */
	i__3 = k;
	i__1 = k;
	i__5 = j + k;
	q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i 
		+ t.i * a[i__5].r;
	q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
	w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    }
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L330;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L310;
    }
    if (h < *n) {
	goto L300;
    }
    f = 1;
    goto L10;
L350:
    j = -h;
L360:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    e = i + 1;
    d = e + 1;
    h += m;
    g = j + o;
    i__3 = i;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
    i__3 = e;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
    i__3 = d;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
    i__3 = h;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
L370:
    i__3 = i;
    i__1 = i;
    i__5 = j + i;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    i__3 = e;
    i__1 = e;
    i__5 = j + e;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    i__3 = d;
    i__1 = d;
    i__5 = j + d;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    i__3 = h;
    i__1 = h;
    i__5 = j + h;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L370;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L360;
    }
    if (h < *n) {
	goto L350;
    }
    f = 1;
    goto L10;
L380:
    j = -h;
L390:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    e = i + 1;
    h += m;
    g = j + o;
    i__3 = i;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
    i__3 = e;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
    i__3 = h;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
L400:
    i__3 = i;
    i__1 = i;
    i__5 = j + i;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    i__3 = e;
    i__1 = e;
    i__5 = j + e;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    i__3 = h;
    i__1 = h;
    i__5 = j + h;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L400;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L390;
    }
    if (h < *n) {
	goto L380;
    }
    f = 1;
    goto L10;
L410:
    j = -h;
L420:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    h += m;
    g = j + o;
    i__3 = i;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
    i__3 = h;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
L430:
    i__3 = i;
    i__1 = i;
    i__5 = j + i;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    i__3 = h;
    i__1 = h;
    i__5 = j + h;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L430;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L420;
    }
    if (h < *n) {
	goto L410;
    }
    f = 1;
    goto L10;
L440:
    j = -h;
L450:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    h += m;
    g = j + o;
    i__3 = i;
    w[i__3].r = 0.f, w[i__3].i = 0.f;
L460:
    i__3 = i;
    i__1 = i;
    i__5 = j + i;
    q__2.r = t.r * a[i__5].r - t.i * a[i__5].i, q__2.i = t.r * a[i__5].i + 
	    t.i * a[i__5].r;
    q__1.r = w[i__1].r + q__2.r, q__1.i = w[i__1].i + q__2.i;
    w[i__3].r = q__1.r, w[i__3].i = q__1.i;
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L460;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L450;
    }
    if (h < *n) {
	goto L440;
    }
    f = 1;
    goto L10;
L470:
    if (l == 2) {
	goto L480;
    }
    if (l == 3) {
	goto L600;
    }
    goto L720;
L480:
    switch (m) {
	case 1:  goto L580;
	case 2:  goto L560;
	case 3:  goto L540;
	case 4:  goto L520;
    }
L490:
    j = -h;
L500:
    i = h + 1;
    h += m;
    e = j + m;
    i__3 = h;
    for (k = i; k <= i__3; ++k) {
/* L510: */
	i__1 = k;
	i__5 = j + k;
	i__4 = e + k;
	q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i 
		+ s.i * w[i__4].r;
	q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
	a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    }
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L500;
    }
    if (h < *n) {
	goto L490;
    }
    f = 0;
    goto L10;
L520:
    j = -h;
L530:
    ++h;
    e = j + m;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    ++h;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    ++h;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    ++h;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L530;
    }
    if (h < *n) {
	goto L520;
    }
    f = 0;
    goto L10;
L540:
    j = -h;
L550:
    ++h;
    e = j + m;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    ++h;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    ++h;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L550;
    }
    if (h < *n) {
	goto L540;
    }
    f = 0;
    goto L10;
L560:
    j = -h;
L570:
    ++h;
    e = j + m;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    ++h;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L570;
    }
    if (h < *n) {
	goto L560;
    }
    f = 0;
    goto L10;
L580:
    j = -h;
L590:
    ++h;
    e = j + m;
    i__1 = h;
    i__5 = j + h;
    i__4 = e + h;
    q__2.r = s.r * w[i__4].r - s.i * w[i__4].i, q__2.i = s.r * w[i__4].i + 
	    s.i * w[i__4].r;
    q__1.r = w[i__5].r + q__2.r, q__1.i = w[i__5].i + q__2.i;
    a[i__1].r = q__1.r, a[i__1].i = q__1.i;
    j = e;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L590;
    }
    if (h < *n) {
	goto L580;
    }
    f = 0;
    goto L10;
L600:
    switch (m) {
	case 1:  goto L700;
	case 2:  goto L680;
	case 3:  goto L660;
	case 4:  goto L640;
    }
L610:
    j = -h;
L620:
    i = h + 1;
    h += m;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__1 = h;
    for (k = i; k <= i__1; ++k) {
/* L630: */
	i__5 = k;
	i__4 = j + k;
	i__3 = e + k;
	q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i 
		+ s.i * w[i__3].r;
	q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
	i__2 = d + k;
	q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i 
		+ t.i * w[i__2].r;
	q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
	a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    }
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L620;
    }
    if (h < *n) {
	goto L610;
    }
    f = 0;
    goto L10;
L640:
    j = -h;
L650:
    ++h;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    ++h;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    ++h;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    ++h;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L650;
    }
    if (h < *n) {
	goto L640;
    }
    f = 0;
    goto L10;
L660:
    j = -h;
L670:
    ++h;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    ++h;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    ++h;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L670;
    }
    if (h < *n) {
	goto L660;
    }
    f = 0;
    goto L10;
L680:
    j = -h;
L690:
    ++h;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    ++h;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L690;
    }
    if (h < *n) {
	goto L680;
    }
    f = 0;
    goto L10;
L700:
    j = -h;
L710:
    ++h;
    e = j + m;
    d = e + m;
    q__1.r = s.r * s.r - s.i * s.i, q__1.i = s.r * s.i + s.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    i__5 = h;
    i__4 = j + h;
    i__3 = e + h;
    q__3.r = s.r * w[i__3].r - s.i * w[i__3].i, q__3.i = s.r * w[i__3].i + 
	    s.i * w[i__3].r;
    q__2.r = w[i__4].r + q__3.r, q__2.i = w[i__4].i + q__3.i;
    i__2 = d + h;
    q__4.r = t.r * w[i__2].r - t.i * w[i__2].i, q__4.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = q__2.r + q__4.r, q__1.i = q__2.i + q__4.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    j = d;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L710;
    }
    if (h < *n) {
	goto L700;
    }
    f = 0;
    goto L10;
L720:
    switch (m) {
	case 1:  goto L870;
	case 2:  goto L840;
	case 3:  goto L810;
	case 4:  goto L780;
    }
L730:
    j = -h;
L740:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    h += m;
    g = j + o;
    i__5 = h;
    for (k = i; k <= i__5; ++k) {
/* L750: */
	i__4 = k;
	a[i__4].r = 0.f, a[i__4].i = 0.f;
    }
L760:
    i__4 = h;
    for (k = i; k <= i__4; ++k) {
/* L770: */
	i__5 = k;
	i__3 = k;
	i__2 = j + k;
	q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i 
		+ t.i * w[i__2].r;
	q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
	a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    }
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L760;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L740;
    }
    if (h < *n) {
	goto L730;
    }
    f = 0;
    goto L10;
L780:
    j = -h;
L790:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    e = i + 1;
    d = e + 1;
    h += m;
    g = j + o;
    i__5 = i;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
    i__5 = e;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
    i__5 = d;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
    i__5 = h;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
L800:
    i__5 = i;
    i__3 = i;
    i__2 = j + i;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    i__5 = e;
    i__3 = e;
    i__2 = j + e;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    i__5 = d;
    i__3 = d;
    i__2 = j + d;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    i__5 = h;
    i__3 = h;
    i__2 = j + h;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L800;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L790;
    }
    if (h < *n) {
	goto L780;
    }
    f = 0;
    goto L10;
L810:
    j = -h;
L820:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    e = i + 1;
    h += m;
    g = j + o;
    i__5 = i;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
    i__5 = e;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
    i__5 = h;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
L830:
    i__5 = i;
    i__3 = i;
    i__2 = j + i;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    i__5 = e;
    i__3 = e;
    i__2 = j + e;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    i__5 = h;
    i__3 = h;
    i__2 = j + h;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L830;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L820;
    }
    if (h < *n) {
	goto L810;
    }
    f = 0;
    goto L10;
L840:
    j = -h;
L850:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    h += m;
    g = j + o;
    i__5 = i;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
    i__5 = h;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
L860:
    i__5 = i;
    i__3 = i;
    i__2 = j + i;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    i__5 = h;
    i__3 = h;
    i__2 = j + h;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L860;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L850;
    }
    if (h < *n) {
	goto L840;
    }
    f = 0;
    goto L10;
L870:
    j = -h;
L880:
    t.r = 1.f, t.i = 0.f;
    i = h + 1;
    h += m;
    g = j + o;
    i__5 = i;
    a[i__5].r = 0.f, a[i__5].i = 0.f;
L890:
    i__5 = i;
    i__3 = i;
    i__2 = j + i;
    q__2.r = t.r * w[i__2].r - t.i * w[i__2].i, q__2.i = t.r * w[i__2].i + 
	    t.i * w[i__2].r;
    q__1.r = a[i__3].r + q__2.r, q__1.i = a[i__3].i + q__2.i;
    a[i__5].r = q__1.r, a[i__5].i = q__1.i;
    q__1.r = t.r * s.r - t.i * s.i, q__1.i = t.r * s.i + t.i * s.r;
    t.r = q__1.r, t.i = q__1.i;
    j += m;
    if (j < g) {
	goto L890;
    }
    j -= m;
    q__1.r = s.r * v.r - s.i * v.i, q__1.i = s.r * v.i + s.i * v.r;
    s.r = q__1.r, s.i = q__1.i;
    if (j + h < *n) {
	goto L880;
    }
    if (h < *n) {
	goto L870;
    }
    f = 0;
    goto L10;
L900:
    if (f == 0) {
	return 0;
    }
    i__5 = *n;
    for (i = 1; i <= i__5; ++i) {
/* L910: */
	i__3 = i;
	i__2 = i;
	a[i__3].r = w[i__2].r, a[i__3].i = w[i__2].i;
    }
    return 0;
} /* fft_ */

