      SUBROUTINE MFFTA8(C,FAC)
*
*   PURPOSE:
*       ELEMENTARY GENTLEMAN-SANDE RADIX-2 STEP APPLIED TO A VECTOR-OF-
*       2-VECTORS-OF-COMPLEX [IMS,NM [IVS,NV [IES,NE]]], OPTIMIZED FOR
*       SMALL NE MATRICES.
*       SEE REF.[1] FOR NOTATIONS.
*       THIS ROUTINE CAN BE USED ONLY BY ROUTINE MFFTDM, WHICH CONTROLS
*       ITS OPERATION THROUGH COMMON MFFTPA.
*
*   DUMMY ARGUMENTS :
*
*   C   ARRAY BEING FOURIER  TRANSFORMED
*   FAC PHASE FACTORS, PREPARED BY MFFTP; NOT MODIFIED IN OUTPUT
*
      COMMON /MFFTPA/  IMS,IVS,IES,NM,NV,NE,MX,LX,MLIM,MSTEP,LLIM,LSTEP,
     $ NUSTEP,IVLIM,ILIM,MD2LIM,LD2LIM
      INTEGER NUSTEP
      COMPLEX C(0:NUSTEP-1,0:1),FAC(0:*),T0
*
      IF (MX.NE.1) THEN
*
      DO 200 LAM=0,LLIM,LSTEP
        DO 150 IV=LAM,LAM+IVLIM,IVS
          IMUF=0
          DO 100 IMU=IV,IV+ILIM
            T0=C(IMU,0)
            C(IMU,0)=T0+C(IMU,1)
            C(IMU,1)=(T0-C(IMU,1))*FAC(IMUF)
            IMUF=IMUF+1
100       CONTINUE
150      CONTINUE
200   CONTINUE
*
      ELSE
        DO 400 LAM=0,LLIM,LSTEP
          DO 350 IV=LAM,LAM+IVLIM,IVS
            DO 300 IMU=IV,IV+ILIM
            T0=C(IMU,0)
            C(IMU,0)=T0+C(IMU,1)
            C(IMU,1)=T0-C(IMU,1)
 300        CONTINUE
 350      CONTINUE
 400    CONTINUE
      ENDIF
*
      END
