/* fft-TOMS.f -- translated by f2c (version 19941113).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

typedef double real;
typedef double doublereal;
typedef int integer;
typedef struct { real r, i; } complex;

extern void c_exp(complex *r, complex *z); /* I defined in in the NAPACK file */

void r_cnjg(complex *r, complex *z)
{
r->r = z->r;
r->i = - z->i;
}

/* Common Block Declarations */

struct {
    integer mexa[4], ndim, isgn, idir;
    real scal;
    integer ibex, icex, ipak;
} mfarg_;

#define mfarg_1 mfarg_

struct {
    real dima[4], tdm1, rdm1, fblk, tblk, rblk, rcor, size;
} mfval_;

#define mfval_1 mfval_

struct {
    integer ndma[4], ntd1, nrd1, nfbk, ntbk, nrbk, nrcr, nsze;
} mfint_;

#define mfint_1 mfint_

real *rmas;

/* Table of constant values */

static integer c__99 = 99;
static integer c__2 = 2;
static integer c__0 = 0;
static integer c__1 = 1;
static integer c_n1 = -1;
static real c_b21 = 2.f;

/* ====================================================================== */
/* NIST Guide to Available Math Software. */
/* Fullsource for module 545 from package TOMS. */
/* Retrieved from NETLIB on Fri Mar 14 18:40:22 1997. */
/* ====================================================================== */

/*     THIS SET OF PROGRAM AND SUBROUTINE UNITS IS TO SUPPORT */

/*       'AN OPTIMIZED MASS STORAGE FFT',  BY DONALD FRASER */

/*           REVISION DATE: JULY 1978 (MINOR REV JUNE 79). */

/*     THE SET INCLUDES A UNIVERSAL TEST DRIVER PROGRAM, WHICH SIMULATES */
/*  MASS STORE THROUGH A FORTRAN ARRAY, SAMPLE PROGRAMS AND I/O */
/*  SUBROUTINES FOR CONTROL DATA 6000 AND CYBER COMPUTERS AND FOR */
/*  DEC PDP 11 MINICOMPUTERS. */

/*     I/O SUBROUTINES FOR OTHER SYSTEMS SHOULD BE EASILY CONSTRUCTED */
/*  FROM THE EXAMPLES AND WITH REFERENCE TO THE FORMAL PAPER. */
/*  BUT CARE SHOULD BE TAKEN WITH SOME FUSSY COMPILERS SINCE FFT */
/*  SUBROUTINES ASSIGN EITHER TYPE REAL OR TYPE COMPLEX TO THE SAME */
/*  ARRAY AS IT IS PASSED AS A FORMAL PARAMETER.  NOTE THAT COMPLEX */
/*  DATA IS ASSUMED TO BE STORED  REAL/IMAG/REAL/IMAG... IN BOTH */
/*  MASS STORE AND CORE STORE. */

/*     THE PROGRAM UNITS APPEAR IN THE FOLLOWING ORDER: */

/*         FIRST, THE FFT SUBROUTINE SET: */
/*  1  RMFFT        OPTIMIZED MASS STORAGE FFT (REAL DATA OR REAL RESULT) */
/*  2  CMFFT        CALLED BY 1, OR MASS STORAGE FFT (ALL COMPLEX DATA) */
/*  3  MFCOMP       IN-CORE FFT */
/*  4  MFSORT       MASS STORE SORTING */
/*  5  MFREV        IN-CORE SORTING OR WHOLE BLOCK SORTING */
/*  6  MFLOAD       LOADING/UNLOADING CORE STORE */
/*  7  MFINDX       BLOCK INDEXING ALGORITHM (VIRTUAL PERMUTATION) */
/*  8  MFSUM        MEXA() EXPONENT SUMMATIONS */
/*  9  MFRCMP       REAL-COMPLEX UNSCRAMBLING/SCRAMBLING */
/* 10  MFRLOD       LOADING/UNLOADING CORE STORE FOR MFRCMP */
/* 11  MFPAR        HELPER ROUTINE (NOT ESSENTIAL, BUT RECOMMENDED) */
/* 12  DMPERM       MASS STORE DIMENSION SHIFTING (BONUS SUBROUTINE) */

/* Subroutine */ int rmfft_(integer *mexa, integer *ndim, integer *isgn, 
	integer *idir, real *scal, complex *bufa, integer *ibex, integer *
	icex, integer *ipak)
{
    static integer b;
    extern /* Subroutine */ int cmfft_(integer *, integer *, integer *, 
	    integer *, real *, complex *, integer *, integer *);
    extern integer mfsum_(integer *, integer *, integer *);
    static integer mh;
    extern /* Subroutine */ int mfrcmp_(integer *, integer *, integer *, 
	    integer *, integer *, complex *, integer *, integer *);


/* REAL-TO-COMPLEX FFT (OR VICE-VERSA) OF MULTI-DIMENSD MASS STORE ARRAY 
*/
/*  (FRASER, ACM TOMS - 1978/79, AND J.ACM, V.23,N.2, APRIL 76, PP. 298-3 
*/
/*  MASS STORE ARRAY IS EITHER REAL OR COMPLEX DATA (SEE NOTE BELOW) */

/*  NOTE WELL THAT TYPE COMPLEX DATA MUST EXIST AS ALTERNATING */
/*  REAL/IMAG/REAL/IMAG... ELEMENTS, BOTH IN MASS STORE AND IN FORTRAN */
/*  WORKING ARRAY BUFA;  IN THIS FFT, DIFFERENT SUBROUTINES WILL SET */
/*  DIFFERENT TYPE (REAL OR COMPLEX) FOR ARRAY BUFA. */

/* MEXA(J) LIST OF DIMENSION SIZE EXPONS (BASE 2), ADJACENT VARIABLES FIR 
*/
/* NDIM IS NUMBER OF EXPONENTS IN LIST AND THUS THE NUMBER OF DIMENSIONS 
*/
/*  SUM TO NDIM OF MEXA(J) = M, WHERE 2**M IS EFFECT SIZE OF MASS STORE A 
*/
/*     THUS, 2**M PACKED REAL VALUES, */
/*     OR,   2**M COMPLEX VALUES, IF COMPLEX RESULT WITH IPAK=1 (SEE BELO 
*/
/* RMFFT ALWAYS REVERSES DIMENSION ORDER AND MEXA LIST (TRANSPOSED, IF 2 
*/

/* ISGN GIVES SIGN OF COMPLEX EXPONENT OF TRANSFORM (+ OR -), AND */
/* IDIR DETERMINES DIRECTION OF TRANSFORM, THUS: */
/*     IDIR=-1,  REAL-TO-COMPLEX */
/*     IDIR=+1,  COMPLEX-TO-REAL */
/* SCAL IS REAL MULTIPLIER OF RESULT (EG. SET SCAL=1. FWD, 1./2**M INV) */

/* BUFA IS CORE STORE WORKING ARRAY BASE ADDRESS (SEE NOTE ABOVE) */
/* IBEX, ICEX ARE BLOCK AND CORE SIZE EXPONENTS, THUS */
/*  2**IBEX IS NUMBER OF REAL ELEMENTS IN MASS STORE BLOCK */
/*  2**ICEX IS NUMBER OF REAL ELEMENTS IN CORE STORE BUFA */

/* IPAK IS ARRAY PACKING DETERMINATOR, THUS: */
/*  IPAK=+1 EXPANDS COMPLEX ARRAY TO FULL REDUNDANCY (SAME AS SUBRTN CMFF 
*/
/*  IPAK=0  COMPUTES COMPLEX ARRAY OF JUST OVER HALF SIZE (COMMON METHOD) 
*/
/*  IPAK=-1 HOLDS COMPLEX ARRAY AT EXACTLY HALF SIZE (2**(M-1) CMPLX ELMT 
*/

/* MASS STORE ARRAY MUST BE OPEN FOR ACCESS BY USER SUBRTNS MFREAD/MFWRIT 
*/
/*  EG. SUBRTN MFREAD(BUFA,NB,JB) AND MFWRIT(BUFA,NB,JB) TRANSFER ONE */
/*  BLOCK, INDEX JB, BETWEEN MASS STORE AND CORE STORE BUFA, NB REALS */
/*  (1.LE.JB.LE.2**(M-IBEX) IF REAL, OR 2**(M-IBEX+1) IF CMPLX AND IPAK=1 
*/


    /* Parameter adjustments */
    --bufa;
    --mexa;

    /* Function Body */
    mh = mfsum_(&mexa[1], ndim, &c__99) - 1;
    b = *ibex - 1;
    if (*idir > 0) {
	goto L10;
    }

/* BELOW, REAL-TO-COMPLEX TRANSFORM */
    --mexa[1];
    cmfft_(&mexa[1], ndim, isgn, idir, scal, &bufa[1], ibex, icex);
    mfrcmp_(&mexa[1], ndim, isgn, idir, ipak, &bufa[1], &b, &mh);
    ++mexa[*ndim];
    return 0;

/* BELOW, COMPLEX-TO-REAL TRANSFORM */
L10:
    --mexa[*ndim];
    mfrcmp_(&mexa[1], ndim, isgn, idir, ipak, &bufa[1], &b, &mh);
    cmfft_(&mexa[1], ndim, isgn, idir, scal, &bufa[1], ibex, icex);
    ++mexa[1];
    return 0;

} /* rmfft_ */

/* Subroutine */ int cmfft_(integer *mexa, integer *ndim, integer *isgn, 
	integer *idir, real *scal, complex *bufa, integer *ibex, integer *
	icex)
{
    /* Initialized data */

    static integer lset = 1;
    static integer lread = 1;
    static integer lwrit = 2;

    /* System generated locals */
    integer i__1, i__2, i__3;
    complex q__1;

    /* Local variables */
    static integer iflg, ipas, idum, mpas, npas, b, c, j, m, mreal;
    extern integer mfsum_(integer *, integer *, integer *);
    static integer ig, nc, ih;
    extern /* Subroutine */ int mfload_(integer *, real *, integer *, integer 
	    *, integer *), mfcomp_(integer *, integer *, integer *, complex *,
	     integer *, integer *, integer *, integer *, integer *);
    extern integer mfindx_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int mfsort_(real *, integer *, integer *, integer 
	    *, integer *, integer *);


/* COMPLEX FFT OF MULTI-DIMENSD MASS STORE ARRAY, CALLED BY USER OR RMFFT 
*/
/*  FOR COMMENTS, SEE SUBRTN RMFFT; ARGUMNTS HAVE SAME MEANING EXCEPT FOR 
*/
/*  IDIR=+1 OR -1, ARRAY ALWAYS COMPLEX, DIMENSION ORDER REVERSED */
/*  WHILE IDIR=0, DIMENSION ORDER (AND MEXA LIST) ARE NOT REVERSED */

    /* Parameter adjustments */
    --bufa;
    --mexa;

    /* Function Body */

    m = mfsum_(&mexa[1], ndim, &c__99);
    mreal = m + 1;
    b = *ibex - 1;
    c = *icex - 1;
    nc = (1 << c) /* was: pow_ii(&c__2, &c) */;
    ipas = 0;
    mpas = m - c;
    npas = c - b;
/* MOST EFFICIENT USE OF CORE STORE - TRIES TO DO C-B PASSES PER LOAD */
    idum = mfindx_(&lset, &b, &m, &m, &npas);
/* DUMMY CALL TO MFINDX TO SPECIFY VIRTUAL (B.'S'.M)**(C-B) PERMUTATION */

/* FIRST, PIECE-MEAL ATTACK ON FFT COMPUTATION FOLLOWS */
L10:
    if (mpas <= 0) {
	goto L40;
    }
    if (mpas < npas) {
	npas = mpas;
    }
L20:
    mfload_(&lread, (real*)&bufa[1], ibex, icex, &iflg);
/* LOAD CORE WORKING SPACE WITH 2**(C-B) BLOCKS ACCORDING TO MFINDX */
    if (iflg < 0) {
	goto L30;
    }
    mfcomp_(&mexa[1], ndim, isgn, &bufa[1], &b, &c, &m, &npas, &ipas);
/* DO MODIFIED IN-CORE FFT, REQUIRING NPAS PASSES STARTING WITH IPAS */
    mfload_(&lwrit, (real*)&bufa[1], ibex, icex, &iflg);
/* UNLOAD CORE AREA, WRITING BLOCKS BACK IN-PLACE TO MASS STORE */
    goto L20;
L30:
    ipas += npas;
    mpas -= npas;
    goto L10;
/* END OF FIRST PART */

/* SPECIFY BLOCKS TO BE READ IN NEXT PART IN TRUE ORDER (NO PERM) */
L40:
    idum = mfindx_(&lset, &b, &m, &m, &c__0);
/* FINAL, CONCLUDING ATTACK ON FFT COMPUTATION FOLLOWS */
L50:
    mfload_(&lread, (real*)&bufa[1], ibex, icex, &iflg);
    if (iflg < 0) {
	goto L80;
    }
    mfcomp_(&mexa[1], ndim, isgn, &bufa[1], &c, &c, &m, &c, &ipas);
/* DO FINAL, C-PASS IN-CORE FFT OF EACH CORE-LOAD */
    if (*scal == 1.f) {
	goto L70;
    }
    i__1 = nc;
    for (j = 1; j <= i__1; ++j) {
/* L60: */
	i__2 = j;
	i__3 = j;
	q__1.r = *scal * bufa[i__3].r, q__1.i = *scal * bufa[i__3].i;
	bufa[i__2].r = q__1.r, bufa[i__2].i = q__1.i;
    }
L70:
    mfload_(&lwrit, (real*)&bufa[1], ibex, icex, &iflg);
    goto L50;

/* BELOW, SORT ARRAY (FULL BIT-REVERSAL AND DIMEN REVERSAL IF IDIR.NE.0) 
*/
L80:
    if (*idir == 0) {
	goto L90;
    }
    mfsort_((real*)&bufa[1], ibex, icex, &c__1, &mreal, &mreal);
    m = mfsum_(&mexa[1], ndim, &c_n1);
/* DO FULL BIT-REVERSAL OF M BITS (AND REVERSE MEXA LIST) */
    return 0;

/* BELOW, REVERSE BITS OF EACH DIMEN SEPARATELY (NO DIMEN REVERSAL) */
L90:
    ih = 1;
    i__2 = *ndim;
    for (j = 1; j <= i__2; ++j) {
	ig = ih;
	ih += mexa[j];
/* L100: */
	mfsort_((real*)&bufa[1], ibex, icex, &ig, &ih, &mreal);
    }
    return 0;

} /* cmfft_ */

/* Subroutine */ int mfcomp_(integer *mexa, integer *ndim, integer *isgn, 
	complex *bufa, integer *b, integer *c, integer *m, integer *npas, 
	integer *ipas)
{
    /* Initialized data */

    static integer lindx = 0;
    static integer lrest = 4;
    static real pi = 3.141592653589793f;

    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6, i__7, i__8, i__9, i__10, 
	    i__11;
    doublereal d__1;
    complex q__1, q__2;

    /* Builtin functions */
    void c_exp(complex *, complex *);

    /* Local variables */
    static integer imod, jpas, kpas, span, item, idum;
    static complex temp;
    static integer nclr, mexp, step, nrpt;
    static complex d;
    static integer j, k, kdiff;
    static complex w;
    static integer kpeff;
    static real andwm, pimod;
    static integer indwm;
    extern integer mfsum_(integer *, integer *, integer *);
    static integer i1, i2, i3, i4;
    static real pimod2;
    static integer nb, nc;
    extern integer mfindx_(integer *, integer *, integer *, integer *, 
	    integer *);


/* MODIFIED, IN-CORE FFT OF 2**C ELEMENTS, NPAS PASSES STARTING WITH IPAS 
*/
/*  MEXA, NDIM, ISGN ,BUFA AND M HAVE SAME MEANING AS IN RMFFT COMMENTS */
/*  B,C EQUIVALENT TO IBEX,ICEX EXCEPT HERE REFER TO NUM COMPLEX ELMTS */
/*  (2**C CMPLX ELMTS IN CORE STORE BUFA, IN BLOCKS OF 2**B CMPLX ELMTS) 
*/

/* FFT W PHASE FACTOR COMPUTED RECURSIVELY EXCEPT ON BLOCK BOUNDS */
/*  MULTIDIMEN FFT ACHIEVED BY REPEATING W SEQUENCES */

    /* Parameter adjustments */
    --bufa;
    --mexa;

    /* Function Body */

    i__1 = 1 - *m;
    pimod = pi * ((real) (1 << i__1)) /* was: pow_ri(&c_b21, &i__1) */;
    if (*isgn < 0) {
	pimod = -(doublereal)pimod;
    }
    nc = (1 << *c) /* was: pow_ii(&c__2, c) */;

/* BELOW, NPAS COMPUTATION PASSES WHILE DATA IN-CORE */
    i__1 = *npas;
    for (jpas = 1; jpas <= i__1; ++jpas) {
	kpas = *ipas + jpas - 1;
/* KPAS IS GLOBAL COMPUTING PASS NUMBER (JPAS-1 IS LOCAL) */
	kdiff = *m - mfsum_(&mexa[1], ndim, &kpas);
	kpeff = kpas + kdiff;
/* KPEFF IS EFFECTIVE GLOBAL PASS FOR MULTIDIMEN. FFT W GENERATION */
	d__1 = pimod * ((real) (1 << kpeff)) /* was: pow_ri(&c_b21, &kpeff) */;
	q__2.r = 0.f, q__2.i = d__1;
	c_exp(&q__1, &q__2);
	d.r = q__1.r, d.i = q__1.i;
/* D IS USED FOR RECURSIVE MODIFICATION OF W PHASE FACTOR */

	item = *c - jpas;
	span = (1 << item) /* was: pow_ii(&c__2, &item) */;
	step = span << 1;
/* SPAN SEPARATES VALUES IN FFT KERNEL, STEP TO NEXT PAIR, SAME W */

	if (*b < item) {
	    item = *b;
	}
	nb = (1 << item) /* was: pow_ii(&c__2, &item) */;
	if (item > kdiff) {
	    item = kdiff;
	}
	nrpt = (1 << item) /* was: pow_ii(&c__2, &item) */;
/* NRPT COUNTS REPETITION OF W FOR MULTIDIMEN. FFT */

	i__2 = *m - *b - kpas - 1;
	imod = (1 << i__2) /* was: pow_ii(&c__2, &i__2) */;
	if (imod <= 1) {
	    goto L20;
	}
	idum = mfindx_(&lrest, &c__0, &c__0, &c__0, &c__0);
	mexp = kpeff;
	item = kdiff - *b;
	if (item > 0) {
	    goto L10;
	}
	mexp = *b + kpas;
	item = 0;
L10:
	nclr = (1 << item) /* was: pow_ii(&c__2, &item) */;
	pimod2 = pimod * ((real) (1 << mexp)) /* was: pow_ri(&c_b21, &mexp) */;
/* IMOD AND NCLR ARE USED TO COMPUTE W WITHOUT EXCEEDING SMALL INTEGER
 */

/* BELOW, START OF ONE PASS THROUGH CORE, NOTING BLOCK BOUNDARIES */
L20:
	i__2 = span;
	i__3 = nb;
	for (i1 = 1; i__3 < 0 ? i1 >= i__2 : i1 <= i__2; i1 += i__3) {
	    w.r = 1.f, w.i = 0.f;
	    if (imod <= 1) {
		goto L30;
	    }
	    indwm = (mfindx_(&lindx, &c__0, &c__0, &c__0, &c__0) - 1) % imod /
		     nclr;
	    andwm = (real) indwm;
	    d__1 = pimod2 * andwm;
	    q__2.r = 0.f, q__2.i = d__1;
	    c_exp(&q__1, &q__2);
	    w.r = q__1.r, w.i = q__1.i;
/* NEW W COMPUTED DIRECTLY AT BEGINNING OF NEW BLOCK AREA */

/* BELOW, COMPUTATIONS WITHIN EACH BLOCK OF 2**B CMPLX ELMTS */
L30:
	    i__4 = nb;
	    i__5 = nrpt;
	    for (i2 = 1; i__5 < 0 ? i2 >= i__4 : i2 <= i__4; i2 += i__5) {

/* BELOW, REPETITION OF SAME W DUE TO MULTIDIMEN FFT */
		i__6 = nrpt;
		for (i3 = 1; i3 <= i__6; ++i3) {
		    i4 = i1 + i2 + i3 - 2;

/* BELOW, STEPPING THOUGH INDICES HAVING SAME W IN ONE DIM
EN FFT */
		    i__7 = nc;
		    i__8 = step;
		    for (j = i4; i__8 < 0 ? j >= i__7 : j <= i__7; j += i__8) 
			    {
			k = j + span;
			i__9 = j;
			i__10 = k;
			q__2.r = bufa[i__9].r - bufa[i__10].r, q__2.i = bufa[
				i__9].i - bufa[i__10].i;
			q__1.r = q__2.r * w.r - q__2.i * w.i, q__1.i = q__2.r 
				* w.i + q__2.i * w.r;
			temp.r = q__1.r, temp.i = q__1.i;
			i__9 = j;
			i__10 = j;
			i__11 = k;
			q__1.r = bufa[i__10].r + bufa[i__11].r, q__1.i = bufa[
				i__10].i + bufa[i__11].i;
			bufa[i__9].r = q__1.r, bufa[i__9].i = q__1.i;
/* L40: */
			i__9 = k;
			bufa[i__9].r = temp.r, bufa[i__9].i = temp.i;
		    }
		}
/* FFT 2-POINT KERNEL ARITHMETIC (ALGORITHM BIT-REVERSAL FOLLO
WS COMPUT) */

		q__1.r = w.r * d.r - w.i * d.i, q__1.i = w.r * d.i + w.i * 
			d.r;
		w.r = q__1.r, w.i = q__1.i;
/* RECURSIVE MODIFICATION OF W WITHIN BLOCK BOUNDARIES */
/* L50: */
	    }
	}
    }
    return 0;

} /* mfcomp_ */

/* Subroutine */ int mfsort_(real *bufa, integer *ibex, integer *icex, 
	integer *ig, integer *ih, integer *m)
{
    /* Initialized data */

    static integer lset = 1;
    static integer lperm = 2;
    static integer lread = 1;
    static integer lwrit = 2;

    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Local variables */
    static integer iflg, ipas, idum, mpas, npas, igcor;
    extern /* Subroutine */ int mfrev_(real *, integer *, integer *, integer *
	    , integer *), mfload_(integer *, real *, integer *, integer *, 
	    integer *);
    extern integer mfindx_(integer *, integer *, integer *, integer *, 
	    integer *);


/* BIT-REVERSED PERMUTATION (IG.'R'.IH) OF MASS STORE REAL ARRAY */
/*  REVERSES IH-IG BITS IN INDEX (M-1,...,IH-1,...,IG,...,0) */
/*  NOTE THAT THIS IS MORE GENERAL THAN THE FULL M-BIT REVERSAL */
/*  OF REFERENCE (FRASER, J.ACM, V.23, N.2, APR. 76, P. 306), */
/*  BUT ALGORITHM IS LOGICALLY THE SAME, WITH ALTERED BIT LIMITS. */
/* BUFA,IBEX,ICEX AND M HAVE SAME MEANING AS IN COMMENTS IN RMFFT */
/*  (BLOCKS 2**IBEX, CORE BUFA 2**ICEX, TOTAL 2**M, ALL REAL) */

    /* Parameter adjustments */
    --bufa;

    /* Function Body */

    idum = mfindx_(&lset, ibex, m, m, &c__0);
/* DUMMY CALL TO INITIALISE MFINDX (INITIALLY UNPERMUTED ARRAY) */
    if (*ih - *ig <= 1) {
	return 0;
    }
    if (*ig >= *ibex) {
	goto L50;
    }
    if (*ih <= *icex) {
	goto L60;
    }
/* CHECK FOR SPECIAL CASES, REQUIRING SIMPLER TREATMENT */

/* BELOW, MIXED PERMUTATION OF BOTH ELEMENTS AND BLOCKS */
    ipas = 0;
    npas = *icex - *ibex;
/* MOST EFFIENT USE OF CORE STORE - TRIES TO DO ICEX-IBEX PASSES PER LOAD 
*/
    mpas = *ih - *ibex;
    if (*ibex - *ig < mpas) {
	mpas = *ibex - *ig;
    }

/* BELOW, FIRST VIRTUAL 'S' PERMUTATIONS */
L10:
    if (mpas <= 0) {
	goto L40;
    }
    if (mpas < npas) {
	npas = mpas;
    }
    igcor = *ig + ipas;
    if (igcor > *ibex - 1 && igcor > *ibex + npas - 1) {
	goto L30;
    }
    if (ipas == 0 && igcor > *ibex + npas - 1) {
	goto L30;
    }
/* BYPASS UNNECESSARY CORE LOAD IF TRIVIAL CASES */
    idum = mfindx_(&lperm, ibex, ih, m, &npas);
/* DUMMY CALL TO MFINDX TO SPECIFY VIRTUAL (IBEX.S.IH)**NPAS PERM */

/* BELOW, LOAD CORE ACCORDING TO VIRTUAL PERMUTATION AND PERM ELMTS */
L20:
    mfload_(&lread, &bufa[1], ibex, icex, &iflg);
    if (iflg < 0) {
	goto L30;
    }
    if (ipas != 0) {
	mfrev_(&bufa[1], &igcor, ibex, icex, &c_n1);
    }
    i__1 = *ibex + npas;
    mfrev_(&bufa[1], &igcor, &i__1, icex, &c_n1);
/* CARRY OUT IN-CORE, SYMMETRIC R PERMS. (ONE ONLY ON FIRST PASS) */
    mfload_(&lwrit, &bufa[1], ibex, icex, &iflg);
/* UNLOAD CORE AREA, WRITING BLOCKS BACK IN-PLACE TO MASS STORE */
    goto L20;

L30:
    ipas += npas;
    mpas -= npas;
    goto L10;
/* END OF FIRST PART */

/* BELOW, FINAL 'R' PERM. OF BLOCKS IN MASS STORE, IF (IH-2*IBEX+IG).GT.1 
*/
L40:
    i__1 = *ih - (*ibex << 1) + *ig;
    i__2 = *m - *ibex;
    mfrev_(&bufa[1], &c__0, &i__1, &i__2, ibex);
    return 0;

/* BELOW, PERMUTATION OF BLOCKS ONLY REQUIRED */
L50:
    i__1 = *ig - *ibex;
    i__2 = *ih - *ibex;
    i__3 = *m - *ibex;
    mfrev_(&bufa[1], &i__1, &i__2, &i__3, ibex);
    return 0;

/* BELOW, PERMUTATION OF ELEMENTS IN CORE ONLY REQUIRED */
L60:
    mfload_(&lread, &bufa[1], ibex, icex, &iflg);
    if (iflg < 0) {
	return 0;
    }
    mfrev_(&bufa[1], ig, ih, icex, &c_n1);
    mfload_(&lwrit, &bufa[1], ibex, icex, &iflg);
    goto L60;

} /* mfsort_ */

/* Subroutine */ int mfrev_(real *bufa, integer *ig, integer *ih, integer *m, 
	integer *ibex)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4;

    /* Builtin functions */

    /* Local variables */
    static integer ngdb, nhhf, ifof, ifor, irof;
    static real temp;
    static integer irev, nrev, j, ifofa[3], irofa[3], npars, i1, i2, nb, ng, 
	    nh, nm;
    extern /* Subroutine */ int mfread_(real *, integer *, integer *);
    static integer nb1;
    extern /* Subroutine */ int mfwrit_(real *, integer *, integer *);
    static integer ihg, ira[16], jof, nra[16], nof, in2f, in3f, in2r, in3r;


/* BIT-REVERSED PERMUTATION OF RANDOMLY ADDRESSABLE ELEMENTS */
/*  REVERSES IH-IG BITS IN INDEX (M-1,...,IH-1,...,IG,...,0) */
/*  (GENERAL PERM IG.'R'.IH, FRASER, J.ACM, V.23, N.2, APR 1976, P. 300) 
*/
/* IF IBEX.LT.0, SORTS 2**M REAL ELMTS IN CORE BUFA, */
/* IF IBEX.GE.0, SORTS BLOCKS IN MASS STORE */
/* (2**IBEX REAL ELMTS PER BLOCK AND 2**M BLOCKS IN SECOND CASE) */

/*  THE ALGORITHM MAINTAINS A SET OF 'REVERSED' INTEGERS IN ARRAY IRA() */
/*  OF INCREASING NUMBER OF BITS, UP TO 2 LESS THAN (IH-IG) BITS. */
/*  INCREMENTING A REVERSED INTEGER THEN REQUIRES THE ALTERNATE */
/*  ADDITION OF NRA() TO IRA(), OR REPLACEMENT BY THE NEXT LOWER */
/*  INCREMENTED REVERSED INTEGER IN THE HIERARCHY, RECURSIVELY. */
/*  THIS IN ITSELF IS FAST, AS RECURSION DEPTHS ARE ON AVERAGE SMALL. */
/*  BUT, IN ADDITION, ONLY QUARTER LENGTH SERIES ARE GENERATED (-2 BITS) 
*/
/*  AND THE FULL LENGTH DERIVED BY SCALING BY 2 AND ADDING OFFSETS. */
/*  IN THIS FINAL STAGE, ONLY VALID SWAP PAIRS ARE GENERATED (1 OR 3 EACH 
*/

/*  WITHIN THE INNER LOOPS, GROUPS OF 2**IG ELMTS ARE MOVED TOGETHER */
/*  WHILE THIS IS REPEATED OVER 2**(M-IH) PARTS OF THE ARRAY, */
/*  CORRESPONDING TO THE UNPERMUTED BITS M TO IH AND IG-1 TO 0. */


    /* Parameter adjustments */
    --bufa;

    /* Function Body */
    ihg = *ih - *ig - 3;
    if (ihg <= -2) {
	return 0;
    }
/* NO PERMUTATION REQUIRED */

    nb = (1 << *ibex) /* was: pow_ii(&c__2, ibex) */;
    nb1 = nb + 1;
    ng = (1 << *ig) /* was: pow_ii(&c__2, ig) */;
    ngdb = ng << 1;
    nh = (1 << *ih) /* was: pow_ii(&c__2, ih) */;
    nhhf = nh / 2;
/* NG IS MOVEMENT GROUP SIZE, NH IS PERMUTATION REPLICATION SIZE */
    nm = (1 << *m) /* was: pow_ii(&c__2, m) */;
    npars = nm - nh + 1;
    nrev = nh / 4;

    i__1 = ihg;
    for (j = 1; j <= i__1; ++j) {
	ira[j - 1] = 0;
	nrev /= 2;
/* L10: */
	nra[j - 1] = nrev;
    }
/* REVERSED INTEGER RECURSION SETS INITIALISED */

    nrev = nh / 4;
    ifofa[0] = ng - 1;
    irofa[0] = nh / 2 - 1;
    ifofa[1] = -1;
    irofa[1] = -1;
    ifofa[2] = nh / 2 + ng - 1;
    irofa[2] = nh / 2 + ng - 1;
/* THREE PAIRS OF OFFSETS TO CONVERT QUARTER TO FULL LENGTH SERIES */

    ifor = 0;
    irev = 0;

/* BELOW, GENERATE INDEX PAIRS AND SWAP (IREV IS 'TOP' OF IRA() SET) */
L20:
    nof = 3;
    if (ifor >= irev) {
	nof = 1;
    }
/* SELECTS ONCE-ONLY SWAP PAIRS (EITHER 1 OR 3 PAIRS) */
    i__1 = nof;
    for (jof = 1; jof <= i__1; ++jof) {
	ifof = ifofa[jof - 1];
	irof = irofa[jof - 1];
	i__2 = ng;
	for (i1 = 1; i1 <= i__2; ++i1) {
/* REPETITION OVER GROUP OR SUPER ELEMENT OF NG ACTUAL ELEMENTS */
	    in2f = ifor + ifof + i1;
	    in2r = irev + irof + i1;
	    i__3 = npars;
	    i__4 = nh;
	    for (i2 = 1; i__4 < 0 ? i2 >= i__3 : i2 <= i__3; i2 += i__4) {
/* REPETITION OF SAME PERMUTATION OVER ARRAY PARTS */
		in3f = in2f + i2;
		in3r = in2r + i2;
		if (*ibex >= 0) {
		    goto L30;
		}

/* BELOW, IN-CORE ELEMENT SORTING */
		temp = bufa[in3r];
		bufa[in3r] = bufa[in3f];
		bufa[in3f] = temp;
		goto L40;

/* BELOW, SORTING WHOLE BLOCKS IN MASS STORE */
L30:
		mfread_(&bufa[1], &nb, &in3f);
		mfread_(&bufa[nb1], &nb, &in3r);
		mfwrit_(&bufa[1], &nb, &in3r);
		mfwrit_(&bufa[nb1], &nb, &in3f);

L40:
		;
	    }
	}
    }
/* END OF INNER, REPETITION LOOPS */

    ifor += ngdb;
/* INCREMENT FORWARD QUARTER-LENGTH INTEGER (ALREADY SCALED BY NG*2) */
    if (ifor >= nhhf) {
	return 0;
    }
/* RETURN FORM SUBROUTINE */

    if (irev >= nrev) {
	goto L50;
    }
/* TEST FOR ALTERNATE METHODS OF REVERSE-INCREMENTING (SIMPLE BELOW) */
/* NOTE THAT REVERSE QUARTER-LENGTH INTEGER IS ALREADY SCALED BY NG*2 */

    irev += nrev;
    goto L20;

/* ALTERNATE RECURSIVE ALTERATION TO QUARTER-LENGTH REVERSED SERIES */
L50:
    i__4 = ihg;
    for (j = 1; j <= i__4; ++j) {
	if (ira[j - 1] < nra[j - 1]) {
	    goto L70;
	}
/* L60: */
    }

/* BELOW, SIMPLE INCREMENT OF REVERSE INTEGER, LOWER IN HIERARCHY */
L70:
    ira[j - 1] += nra[j - 1];
    irev = ira[j - 1];
L80:
    if (j == 1) {
	goto L20;
    }
    --j;
    ira[j - 1] = irev;
    goto L80;

} /* mfrev_ */

/* Subroutine */ int mfload_(integer *load, real *bufa, integer *ibex, 
	integer *icex, integer *iflg)
{
    /* Initialized data */

    static integer lindx = 0;
    static integer lhold = 3;
    static integer lrest = 4;

    /* System generated locals */
    integer i__1;

    /* Builtin functions */

    /* Local variables */
    static integer idum, j, k, jb, nb;
    extern /* Subroutine */ int mfread_(real *, integer *, integer *);
    extern integer mfindx_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int mfwrit_(real *, integer *, integer *);
    static integer ncb;


/* LOADS, UNLOADS CORE STORE ARRAY BUFA, 2**ICEX REALS, 2**IBEX PER BLOCK 
*/
/*  RETURNS IFLG=+1 NORMALLY, IFLG=-1 WHEN FINISHED ONE PASS OF MASS STOR 
*/
/* BLOCKS INDEXED ACCORDING TO VIRTUAL PERMUTATION FUNCTION MFINDX */
/* LOAD=1 (LREAD) READS BLOCKS FROM MASS STORE INTO CORE STORE BUFA */
/* LOAD=2 (LWRIT) WRITES BLOCKS BACK IN-PLACE TO MASS STORE */

    /* Parameter adjustments */
    --bufa;

    /* Function Body */

    nb = (1 << *ibex) /* was: pow_ii(&c__2, ibex) */;
    i__1 = *icex - *ibex;
    ncb = (1 << i__1) /* was: pow_ii(&c__2, &i__1) */;
    if (*load == 2) {
	goto L30;
    }
    *iflg = 1;
    idum = mfindx_(&lhold, &c__0, &c__0, &c__0, &c__0);
/* HOLDS CURRENT MFINDX VALUE FOR ENTRY 2 AND SUBRTN MFCOMP */
    i__1 = ncb;
    for (j = 1; j <= i__1; ++j) {
	k = (j - 1) * nb;
	jb = mfindx_(&lindx, &c__0, &c__0, &c__0, &c__0);
	if (jb < 0) {
	    goto L20;
	}
	mfread_(&bufa[k + 1], &nb, &jb);
/* READS BLOCK WITH NEXT VIRTUAL MFINDX INDEX */
/* L10: */
    }
    return 0;
L20:
    *iflg = -1;
    return 0;

L30:
    idum = mfindx_(&lrest, &c__0, &c__0, &c__0, &c__0);
/* RESETS MFINDX TO START OF IN-PLACE BLOCK */
    i__1 = ncb;
    for (j = 1; j <= i__1; ++j) {
	k = (j - 1) * nb;
	jb = mfindx_(&lindx, &c__0, &c__0, &c__0, &c__0);
	mfwrit_(&bufa[k + 1], &nb, &jb);
/* WRITES BLOCK WITH NEXT VIRTUAL MFINDX INDEX (REPEAT MFREAD SEQUENCE
) */
/* L40: */
    }
    return 0;

} /* mfload_ */

integer mfindx_(integer *lspec, integer *b, integer *h, integer *m, integer *
	n)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Builtin functions */

    /* Local variables */
    static integer joff, jofh, jayh, nrpt, iperm, nperm, istep, nrpth, ihb, 
	    nhb, nmb, jay, kay;


/* VIRTUAL 'S' PERMUTATION (FRASER, J.ACM, V.23, N.2, APR. 76, P.303) */
/*  CYCLIC SHIFTS H-B BITS IN INDEX (M-1,...,H-1,...,B,...,0) */
/* COMPUTES NEXT INDEX FOR SEQUENTIAL CORE LOAD, PERM (B.'S'.H)**N */
/* BLOCK SIZE EXPON B, MASS STORE EXPON M (0.LE.B.LE.H.LE.M) */
/* N IS EFFECTIVE NUMBER OF LEFT SHIFTS PER I/O PASS (-N RIGHT SHIFTS) */

/* NOTE VARIABLE NAMES AS FOLLOWS: */
/*     IPERM IS 'P' OF ALGORITHM */
/*     NPERM=N (ARGUMENT) IS 'N' OF ALGORITHM */
/*     ISTEP IS 'Q**P' OF ALGORITHM */
/*     JAY AND KAY ARE 'J' AND 'K' OF ALGORITHM */
/* NOTE UPPER BOUND H INSTEAD OF M, REQUIRING 2**(M-H) REPEATS */

/* LSPEC=0 (LINDX) RETURNS MFINDX FOR INDEX (B,H,M,N DUMMIES HERE) */
/* LSPEC=1 (LSET) SETS IPERM=0 (UNPERMED), ENTERS B,H,M,N PARAMS */
/* LSPEC=2 (LPERM) CHANGES THE B,H,M,N PARAMETERS */
/* LSPEC=3 (LHOLD) HOLDS CURRENT INDEXING STATE (B,H,M,N DUMMIES HERE) */
/* LSPEC=4 (LREST) RESTORES STATE TO LAST LHOLD (B,H,M,N DUMMIES HERE) */


    if (*lspec == 1) {
	goto L100;
    }
    if (*lspec == 2) {
	goto L200;
    }
    if (*lspec == 3) {
	goto L300;
    }
    if (*lspec == 4) {
	goto L400;
    }

/* L10: */
    if (istep != 0) {
	goto L20;
    }
/* BELOW, PRECEDES FIRST MFINDX OF A PASS */
    if (nperm > 0) {
	iperm = (iperm - nperm) % ihb;
    }
    if (iperm < 0) {
	iperm = ihb + iperm;
    }
    istep = (1 << iperm) /* was: pow_ii(&c__2, &iperm) */;

/* 20 BELOW, NORMAL GENERATION OF NEXT MFINDX */
L20:
    ret_val = jay + joff;
    if (ret_val > nmb) {
	goto L40;
    }
    kay = jay + istep;
    jay = kay % nhb;
    if (kay >= nhb) {
	++jay;
    }
    --nrpt;
    if (nrpt > 0) {
	return ret_val;
    }

/* NRPT,JOFF REQUIRED TO REPEAT SEQUENCE ON 2**(M-H) PARTS OF ARRAY */
    joff += nhb;
L30:
    nrpt = nhb;
    jay = 0;
    return ret_val;

/* 40 BELOW, END OF ONE PASS, PARS RESET, IPERM ALTERED IF INVERSE */
L40:
    if (nperm < 0) {
	iperm = (iperm - nperm) % ihb;
    }
    ret_val = -1;
L50:
    joff = 1;
    istep = 0;
    goto L30;

/* LSPEC=1 (LSET) SETS IPERM=0 (UNPERMED), ENTERS B,H,M,N PARAMS */
L100:
    iperm = 0;

/* LSPEC=2 (LPERM) CHANGES THE B,H,M,N PARAMETERS (DUMMIES ELSEWHERE) */
L200:
    ihb = *h - *b;
    nperm = *n;
    nhb = (1 << ihb) /* was: pow_ii(&c__2, &ihb) */;
    i__1 = *m - *b;
    nmb = (1 << i__1) /* was: pow_ii(&c__2, &i__1) */;
    ret_val = iperm;
    goto L50;

/* LSPEC=3 (LHOLD) HOLDS CURRENT MFINDX INDEXING PARAMETERS */
L300:
    jayh = jay;
    jofh = joff;
    nrpth = nrpt;
L310:
    ret_val = iperm;
    return ret_val;

/* LSPEC=4 (LREST) RESTORES PARAMETERS TO INDEX MFINDX AT LAST LHOLD */
L400:
    jay = jayh;
    joff = jofh;
    nrpt = nrpth;
    goto L310;

} /* mfindx_ */

integer mfsum_(integer *mexa, integer *ndim, integer *mlim)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */
    static integer mtem, i, j, k, ndimh;


/* SCANS MEXA LIST IN REVERSE ORDER, RETURNING (MFSUM.JUST GT.MLIM) */
/*  (IF MLIM LARGE ENOUGH, RETURNS M TOTAL FOR NDIM VALUES) */
/*  (IF MLIM NEGATIVE, RETURNS M TOTAL, REVERSES ORDER OF MEXA LIST) */


    /* Parameter adjustments */
    --mexa;

    /* Function Body */
    ret_val = 0;
    if (*ndim <= 0) {
	return ret_val;
    }

    i__1 = *ndim;
    for (j = 1; j <= i__1; ++j) {
	i = *ndim + 1 - j;
	ret_val += mexa[i];
	if (*mlim >= 0 && *mlim < ret_val) {
	    return ret_val;
	}
/* L10: */
    }
    if (*mlim >= 0) {
	return ret_val;
    }

/* BELOW, REVERSE ORDER OF MEXA LIST */
    ndimh = *ndim / 2;
    i__1 = ndimh;
    for (j = 1; j <= i__1; ++j) {
	k = *ndim + 1 - j;
	mtem = mexa[j];
	mexa[j] = mexa[k];
/* L20: */
	mexa[k] = mtem;
    }
    return ret_val;

} /* mfsum_ */

/* Subroutine */ int mfrcmp_(integer *mexa, integer *ndim, integer *isgn, 
	integer *idir, integer *ipak, complex *bufa, integer *b, integer *m)
{
    /* Initialized data */

    static real pi = 3.141592653589793f;
    static integer lower = 1;
    static integer luppr = 2;
    static integer lclr = -1;

    /* System generated locals */
    integer i__1, i__2;
    doublereal d__1, d__2;
    complex q__1, q__2, q__3;

    /* Builtin functions */

    /* Local variables */
    static integer nbdb, jbof, iflg, idim, jaya[4];
    static complex atem, btem;
    static integer kaya[4], jwka[4], kwka[4], iwfg, kinc, numd, ncnt;
    static complex temp;
    static integer nbpd1, numd1;
    static complex d;
    static integer j, k, iarea, kbinc;
    static complex w;
    static integer jbmax, j1, k1, j2, j3, k3, k2, jb, kb, nb, jj, kk, nblcnt, 
	    newblk;
    extern /* Subroutine */ int mfrlod_(integer *, integer *, complex *, 
	    integer *, integer *, integer *, integer *, integer *, integer *);
    static integer iexpnd, iof, jay, kay, max__, mex1;


/* UNSCRAMBLES REAL-TO-COMPLEX FFT OR VICE-VERSA, CALLED BY SUBRTN RMFFT 
*/
/*  MOST ARGUMENTS HAVE SAME MEANING AS IN RMFFT COMMENTS */
/*  BUT 2**B COMPLEX ELMTS IN MASS STORE BLOCK, */
/*  USES (2**B)*4 CMPLX IN BUFA, 'LOWER', 'UPPER' PLUS EXPANSION AREAS */
/*  TOTAL MASS STORE ARRAY SIZE OF 2**M COMPLEX ELMTS. */

/* JAYA,KAYA,JWKA,KWKA ALLOW UP TO 4 DIMENSIONS - INCREASE IF REQUIRED */
    /* Parameter adjustments */
    --bufa;
    --mexa;

    /* Function Body */

    i__1 = *ndim;
    for (idim = 1; idim <= i__1; ++idim) {
	jaya[idim - 1] = 0;
	kaya[idim - 1] = 0;
/* L10: */
    }
/* MULTIDIMEN. CONJUGATE-SYMMETRIC INDICES ZEROED */

    iexpnd = 1;
    nb = (1 << *b) /* was: pow_ii(&c__2, b) */;
    nbdb = nb << 1;
    i__1 = *m - *b;
    jbof = (1 << i__1) /* was: pow_ii(&c__2, &i__1) */;
    max__ = *m - *b - mexa[*ndim];
    if (*idir * *ipak < 0) {
	max__ = *m - *b;
    }
    jbmax = (1 << max__) /* was: pow_ii(&c__2, &max__) */;
    if (max__ < 0) {
	jbmax = 1;
    }
    if (*ipak < 0) {
	jbmax = 0;
    }
/* JBMAX IS MAXIMUM BLOCK INDEX REQUIRED (DEPENDS ON IPAK) */

    iwfg = 0;
    w.r = 1.f, w.i = 0.f;
    i__1 = -mexa[*ndim];
    d__1 = pi * ((real) (1 << i__1)) /* was: pow_ri(&c_b21, &i__1) */;
    q__2.r = 0.f, q__2.i = d__1;
    c_exp(&q__1, &q__2);
    d.r = q__1.r, d.i = q__1.i;
    if (*isgn < 0) {
	r_cnjg(&q__1, &d);
	d.r = q__1.r, d.i = q__1.i;
    }
/* W IS COMPLEX PHASE FACTOR, D IS RECURSIVE MODIFIER OF W */

L20:
    jay = 0;
    kay = 0;
    idim = *ndim;
L30:
    if (idim == 1) {
	goto L40;
    }
    numd = 1 << mexa[idim]; /* was: pow_ii(&c__2, &mexa[idim]); */
    jwka[idim - 1] = jay;
    kwka[idim - 1] = kay;
    jay = jay * numd + jaya[idim - 1];
    kay = kay * numd + kaya[idim - 1];
    --idim;
    goto L30;
/* CONJUGATE-SYMMETRIC BASE INDICES COMPUTED FROM MULTIDIMEN. SET */

L40:
    mex1 = mexa[1];
/* 2**MEX1 IS NUMBER OF VALUES ADJACENT IN FIRST DIMENSION */
    iflg = -1;
    if (mex1 <= *b) {
	goto L140;
    }

/* BELOW, FIRST DIMEN. GREATER THAN BLOCK SIZE, MULTIPLE BLOCKS */
    i__1 = mex1 - *b;
    nbpd1 = (1 << i__1) /* was: pow_ii(&c__2, &i__1) */;
    nblcnt = nbpd1;
    kinc = nb;
    kbinc = nblcnt - 1;
    if (jay == kay) {
	nblcnt /= 2;
    }
    jb = jay * nbpd1 + 1;
    kb = kay * nbpd1 + 1;
/* JB AND KB ARE BLOCK INDEX PAIRS CONTAINING CONJUGATE ELEMENTS */
    j1 = 0;
    k1 = 0;

L50:
    ncnt = nb + 1;
L60:
    mfrlod_(&lower, &iof, &bufa[1], &nb, &jb, &jbmax, &jbof, idir, &ncnt);
/* LOWER BLOCK LOADED */
    if (jb > jbmax) {
	iexpnd = -1;
    }
    j2 = j1 + iof;
    ++jb;
    j3 = 0;
    k3 = 0;
    newblk = ncnt - nb;
    if (iflg >= 0) {
	goto L80;
    }

L70:
    mfrlod_(&luppr, &iof, &bufa[1], &nb, &kb, &jbmax, &jbof, idir, &iflg);
/* UPPER BLOCK LOADED */
    ++iflg;
    k2 = k1 + iof;
    kb += kbinc;
/* FIRST TIME, UPPER BLOCK STEPS HIGH, FOLLOWING STEPS SMALL NEGATIVE */
    kbinc = -1;

L80:
    j = j2 + j3;
    k = k2 + k3;
/* J AND K INDEX CONJUGATE-SYMMETRIC PAIRS IN CORE */
    jj = j + nbdb;
    kk = k + nbdb;
    if (*idir > 0) {
	goto L180;
    }

/* BELOW, UNSCRAMBLING FOR REAL-TO-COMPLEX FFT */
    i__1 = j;
    r_cnjg(&q__3, &bufa[k]);
    q__2.r = bufa[i__1].r + q__3.r, q__2.i = bufa[i__1].i + q__3.i;
    q__1.r = q__2.r * .5f, q__1.i = q__2.i * .5f;
    temp.r = q__1.r, temp.i = q__1.i;
    i__1 = k;
    r_cnjg(&q__2, &bufa[j]);
    q__1.r = bufa[i__1].r - q__2.r, q__1.i = bufa[i__1].i - q__2.i;
    btem.r = q__1.r, btem.i = q__1.i;
    d__1 = btem.i;
    d__2 = btem.r;
    q__3.r = d__1, q__3.i = d__2;
    q__2.r = q__3.r * .5f, q__2.i = q__3.i * .5f;
    q__1.r = q__2.r * w.r - q__2.i * w.i, q__1.i = q__2.r * w.i + q__2.i * 
	    w.r;
    btem.r = q__1.r, btem.i = q__1.i;
    q__1.r = temp.r + btem.r, q__1.i = temp.i + btem.i;
    atem.r = q__1.r, atem.i = q__1.i;
    q__1.r = temp.r - btem.r, q__1.i = temp.i - btem.i;
    btem.r = q__1.r, btem.i = q__1.i;
    i__1 = j;
    bufa[i__1].r = atem.r, bufa[i__1].i = atem.i;
    if (iexpnd > 0) {
	i__1 = jj;
	bufa[i__1].r = btem.r, bufa[i__1].i = btem.i;
    }
    if (iwfg == 0) {
	goto L150;
    }
    i__1 = k;
    r_cnjg(&q__1, &btem);
    bufa[i__1].r = q__1.r, bufa[i__1].i = q__1.i;
    if (iexpnd > 0) {
	i__1 = kk;
	r_cnjg(&q__1, &atem);
	bufa[i__1].r = q__1.r, bufa[i__1].i = q__1.i;
    }

L90:
    ++j3;
    k3 = kinc - j3;
/* IN-CORE INDEX PAIRS STEPPED IN OPPOSING DIRECTIONS */
    if (idim != *ndim) {
	goto L95;
    }
    iwfg = 1;
    q__1.r = w.r * d.r - w.i * d.i, q__1.i = w.r * d.i + w.i * d.r;
    w.r = q__1.r, w.i = q__1.i;
/* RECURSIVE MODIFICATION OF W IF UNIDIMEN. TRANSFORM */
L95:
    --ncnt;
    if (ncnt <= 0) {
	goto L100;
    }
/* ENTER RECURSION ROUTINE IF OPERATION COMPLETE IN CURRENT DIMEN */
    if (j3 == 1) {
	goto L70;
    }
    if (ncnt > newblk) {
	goto L80;
    }
/* END OF INNER LOOP (NOTE SPECIAL CASE WHEN J3=1 ABOVE) */

/* BELOW, MAY REQUIRE TO READ NEW BLOCKS */
    --nblcnt;
    if (nblcnt > 0) {
	goto L50;
    }
    if (jay == kay) {
	goto L60;
    }
/* JAY.EQ.KAY NEEDS SYMMETRICAL MIDDLE, OTHERWISE CURRENT DIMEN COMPLT */

/* 100 BELOW, RECURSION TO COMPUTE MULTIDIMEN. CONJUGATE-SYMMETRY */
L100:
    jaya[idim - 1] = 0;
    kaya[idim - 1] = 0;
    ++idim;
    if (idim > *ndim) {
	goto L120;
    }
    numd = 1 << mexa[idim]; /* was: pow_ii(&c__2, &mexa[idim]); */
    if (numd <= 1) {
	goto L120;
    }
    if (idim != *ndim) {
	goto L105;
    }
    iwfg = 1;
    q__1.r = w.r * d.r - w.i * d.i, q__1.i = w.r * d.i + w.i * d.r;
    w.r = q__1.r, w.i = q__1.i;
/* RECURSIVE MODIFICATION OF W IF MULTIDIMEN. FFT */
L105:
    if (jaya[idim - 1] == 0) {
	goto L110;
    }
    if (jwka[idim - 1] * numd + jaya[idim - 1] == kwka[idim - 1] * numd + 
	    kaya[idim - 1]) {
	goto L100;
    }
    if (kaya[idim - 1] == 1) {
	goto L100;
    }

L110:
    ++jaya[idim - 1];
    kaya[idim - 1] = numd - jaya[idim - 1];
/* RECURSIVE STEPPING OF MULTIDIMEN. CONJUGATE-SYMMETRIC INDEX PAIRS */
    goto L20;

/* BELOW, OPERATION COMPLETE, TIDY UP AND RETURN FROM SUBROUTINE */
L120:
    for (iarea = 1; iarea <= 2; ++iarea) {
	mfrlod_(&iarea, &iof, &bufa[1], &nb, &lclr, &jbmax, &jbof, idir, &
		iflg);
/* DUMMY CALL TO MFRLOD TO WRITE ANY UNWRITTEN BLOCKS TO MASS STORE */
/* L130: */
    }
    return 0;
/* RETURN FROM SUBROUTINE */


/* 140 BELOW, FIRST DIMEN. LESS THAN BLOCK SIZE, INDEX PAIRS ALL IN-CORE 
*/
L140:
    numd1 = (1 << mex1) /* was: pow_ii(&c__2, &mex1) */;
    nbpd1 = nb / numd1;
    ncnt = numd1;
    kinc = ncnt;
    kbinc = 0;
    if (jay == kay) {
	ncnt = ncnt / 2 + 1;
    }
    jb = jay / nbpd1 + 1;
    kb = kay / nbpd1 + 1;
/* JB AND KB ARE BLOCK INDEX PAIRS CONTAINING CONJUGATE ELEMENTS */
    j1 = (jay - (jb - 1) * nbpd1) * numd1;
    k1 = (kay - (kb - 1) * nbpd1) * numd1;
    goto L60;

/* 150 BELOW, UNSCRAMBLING WITH W0 (IWFG=0) MUST BE TREATED DIFFERENTLY */
L150:
    if (iexpnd < 0) {
	goto L160;
    }
/* BELOW, ARRAY EXPANSION (EITHER IPAK=+1 OR IPAK=0 AND STILL REDUNDANT) 
*/
    i__1 = k;
    r_cnjg(&q__1, &atem);
    bufa[i__1].r = q__1.r, bufa[i__1].i = q__1.i;
    i__1 = kk;
    r_cnjg(&q__1, &btem);
    bufa[i__1].r = q__1.r, bufa[i__1].i = q__1.i;
    goto L90;
/* 160 BELOW, NO ARRAY EXPANSION (EITHER IPAK=-1 OR IPAK=0 NOT REDUNDANT) 
*/
L160:
    if (j == k) {
	goto L170;
    }
    i__1 = k;
    r_cnjg(&q__1, &btem);
    bufa[i__1].r = q__1.r, bufa[i__1].i = q__1.i;
    goto L90;
/* 170 BELOW, SPECIAL CASE IF IPAK=-1 AND ELEMENTS ARE SAME */
L170:
    i__1 = j;
    d__1 = atem.r;
    d__2 = btem.r;
    q__1.r = d__1, q__1.i = d__2;
    bufa[i__1].r = q__1.r, bufa[i__1].i = q__1.i;
    goto L90;

/* 180 BELOW, SCRAMBLING FOR COMPLEX-TO-REAL FFT */
L180:
    if (iwfg == 0) {
	goto L200;
    }
    r_cnjg(&q__1, &bufa[k]);
    btem.r = q__1.r, btem.i = q__1.i;
L190:
    i__1 = j;
    q__1.r = bufa[i__1].r + btem.r, q__1.i = bufa[i__1].i + btem.i;
    atem.r = q__1.r, atem.i = q__1.i;
    i__1 = j;
    q__2.r = bufa[i__1].r - btem.r, q__2.i = bufa[i__1].i - btem.i;
    q__1.r = q__2.r * w.r - q__2.i * w.i, q__1.i = q__2.r * w.i + q__2.i * 
	    w.r;
    btem.r = q__1.r, btem.i = q__1.i;
    d__1 = btem.i;
    d__2 = btem.r;
    q__1.r = d__1, q__1.i = d__2;
    btem.r = q__1.r, btem.i = q__1.i;
    i__1 = j;
    r_cnjg(&q__2, &btem);
    q__1.r = atem.r - q__2.r, q__1.i = atem.i - q__2.i;
    bufa[i__1].r = q__1.r, bufa[i__1].i = q__1.i;
    i__1 = k;
    r_cnjg(&q__2, &atem);
    q__1.r = q__2.r + btem.r, q__1.i = q__2.i + btem.i;
    bufa[i__1].r = q__1.r, bufa[i__1].i = q__1.i;
    goto L90;

/* 200 BELOW, SCRAMBLING WITH W0 (IWFG=0) MUST BE TREATED DIFFERENTLY */
L200:
    if (iexpnd < 0) {
	goto L210;
    }
    i__1 = jj;
    btem.r = bufa[i__1].r, btem.i = bufa[i__1].i;
    goto L190;

/* 210 BELOW, NO REDUNDANCY (EITHER IPAK=-1 OR IPAK=0 OR 1 NOT REDUND) */
L210:
    if (j == k) {
	goto L220;
    }
    r_cnjg(&q__1, &bufa[k]);
    btem.r = q__1.r, btem.i = q__1.i;
    goto L190;

/* 220 BELOW, SPECIAL CASE IF IPAK=-1 AND ELEMENTS ARE SAME */
L220:
    d__1 = bufa[j].i;
    q__1.r = d__1, q__1.i = 0.f;
    btem.r = q__1.r, btem.i = q__1.i;
    i__1 = j;
    i__2 = j;
    d__1 = bufa[i__2].r;
    q__1.r = d__1, q__1.i = 0.f;
    bufa[i__1].r = q__1.r, bufa[i__1].i = q__1.i;
    goto L190;

} /* mfrcmp_ */

/* Subroutine */ int mfrlod_(integer *iarea, integer *iof, complex *bufa, 
	integer *nb, integer *jb, integer *jbmax, integer *jbof, integer *
	idir, integer *ncnt)
{
    /* Initialized data */

    static integer jbarea[2] = { -1,-1 };
    static integer nparf = 5;

    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer nbdb, i, jbpfa[5], iofdb, ncpfa[5], nchld, nclow, ncarea[2]
	    ;
    extern /* Subroutine */ int mfread_();
    static integer iexist;
    extern /* Subroutine */ int mfwrit_();


/* LOADS, UNLOADS CORE STORE ARRAY BUFA, FOR REAL FFT UNSCRAMBLING ROUTIN 
*/
/*  BLOCK SIZE NB CMPLX, BLOCK NUMBER JB (JB=-1 DOES FINAL TIDY O/P) */
/*  JBMAX IS MAX BLOCK INDX FOR EXPANSN, JBOF OFFSET TO EXPANDING BLOCKS 
*/
/*  IDIR=-1 DIRECTION REAL/CMPLX, +1 CMPLX/REAL */
/* IAREA=1 (LOWER) OR 2 (UPPER) OF TWO AREAS IN LOGICAL UNSCRAMBLING */
/*  NOTE THAT BLOCK NORMALLY PHYSICALLY LOADED IN THESE AREAS, */
/*  BUT, IF BLOCK ALREADY RESIDENT, MAY BE IN DIFFERENT AREA, SO */
/* IOF RETURNED AS ACTUAL OFFSET IN BUFA TO LOADED BLOCK. */
/*  USES (2**B)*4 CMPLX IN BUFA, 'LOWER', 'UPPER' PLUS EXPANSION AREAS */
/*  RETURNS IOF AS BUFFER OFFSET TO AREA (MAY NOT BE SAME, IF BLOCK RESID 
*/

/* NCNT IS COUNT OF ELEMENTS TO BE ACCESSED IN THIS LOAD, TO ALLOW */
/*  NOTE TO BE TAKEN OF ANY PARTLY FILLED BLOCKS DURING EXPANSION, */
/*  PREVENTING THE READING OF 'NON-EXISTENT' BLOCKS. */
/* LISTS JBPFA(), NCPFA() OF SIZE NPARF HOLD THIS INFORMATION, DEFAULTS */
/*  TO ALL-READ IF EXCEEDED, BUT INCREASE NPARF ETC, IF PROBLEM. */

    /* Parameter adjustments */
    --bufa;

    /* Function Body */

    if (jbarea[0] >= 0) {
	goto L20;
    }
/* JBAREA() HOLDS INDEX OF BLOCK LOADED IN AREA 1 OR 2 (FIRST TIME -1 BEL 
*/

    iexist = -1;
    i__1 = nparf;
    for (i = 1; i <= i__1; ++i) {
/* L10: */
	jbpfa[i - 1] = -1;
    }
/* PRE-CLEARS PARTLY FILLED BLOCK LIST (ONCE BLOCK FILLED, ALSO CLEARED) 
*/

L20:
    nbdb = *nb << 1;
    if (*jb < 0) {
	goto L50;
    }
    if (*iarea == 2) {
	goto L30;
    }
    nclow = *ncnt;
    if (*ncnt % 2 != 0) {
	nclow = nclow - 1 << 1;
    }
L30:
    nchld = nclow;
    if (*iarea == 2) {
	nchld = nclow - 1;
    }
    if (*ncnt < 0) {
	nchld = 1;
    }
/* NCHLD IS THE NUMBER OF ELEMENTS TO BE ACCESSED IN CURRENT READ */

    for (i = 1; i <= 2; ++i) {
	if (*jb == jbarea[i - 1]) {
	    goto L140;
	}
/* L40: */
    }
/* TEST DONE TO SEE IF REQUIRED BLOCK ALREADY IN CORE (TRIVIAL IF SO) */

/* OTHERWISE BELOW, FIRST WRITE OUT RESIDENT BLOCK, THEN READ IN NEW */
L50:
    *iof = (*iarea - 1) * *nb + 1;
/* IOF IS BASE OFFSET OF CORE AREA WHERE BLOCK IS TO BE FOUND */
    iofdb = *iof + nbdb;
    if (jbarea[*iarea - 1] < 0) {
	goto L90;
    }
    mfwrit_(&bufa[*iof], &nbdb, &jbarea[*iarea - 1]);
/* WRITE OUT BLOCK BEFORE READING NEW BLOCK */
    if (*idir > 0) {
	goto L90;
    }
    if (jbarea[*iarea - 1] > *jbmax) {
	goto L90;
    }
    if (ncarea[*iarea - 1] >= *nb) {
	goto L80;
    }

/* BELOW, IF LAST BLOCK ONLY PART-FILLED, INDEX, ELMTS ACCESSED NOTED */
    i__1 = nparf;
    for (i = 1; i <= i__1; ++i) {
	if (jbpfa[i - 1] < 0) {
	    goto L70;
	}
/* L60: */
    }
/* NO ROOM IN LISTS, DEFAULTS TO ALL READ */
    i = nparf;
    iexist = i;
L70:
    jbpfa[i - 1] = jbarea[*iarea - 1];
    ncpfa[i - 1] = ncarea[*iarea - 1];

L80:
    i__1 = *jbof + jbarea[*iarea - 1];
    mfwrit_(&bufa[iofdb], &nbdb, &i__1);
/* SIMILARLY, WRITE OUT BLOCK PAIR IF EXPANDING */

/* BELOW, READ BLOCK NOTING BLOCK INDX (READ EXPANDED, IF PART FILLED) */
L90:
    jbarea[*iarea - 1] = *jb;
    if (*jb < 0) {
	goto L130;
    }
    mfread_(&bufa[*iof], &nbdb, jb);
/* READ REQUIRED BLOCK AND NOTE ACCESS COUNT */
    ncarea[*iarea - 1] = nchld;
    if (*jb > *jbmax) {
	goto L130;
    }
    if (*idir > 0) {
	goto L120;
    }

/* BELOW, EXPANSION - DOES BLOCK EXIST TO READ */
    i__1 = nparf;
    for (i = 1; i <= i__1; ++i) {
	if (*jb == jbpfa[i - 1]) {
	    goto L110;
	}
/* L100: */
    }
    if (iexist < 0) {
	goto L130;
    }
L110:
    jbpfa[i - 1] = -1;
    ncarea[*iarea - 1] = ncpfa[i - 1] + nchld;
/* IF BLOCK TO BE READ WAS ONLY PART FILLED, THEN IT EXISTS TO READ */
L120:
    i__1 = *jbof + *jb;
    mfread_(&bufa[iofdb], &nbdb, &i__1);
/* READ EXPANDED BLOCK IF REQUIRED */

L130:
    return 0;
/* RETURN FROM SUBROUTINE */

/* BELOW, TRIVIAL CASE - BLOCK ALREADY LOADED */
L140:
    *iof = (i - 1) * *nb + 1;
/* IOF IS BASE OFFSET OF CORE AREA WHERE BLOCK IS TO BE FOUND */
    if (i != *iarea) {
	goto L150;
    }
    ncarea[i - 1] += nchld;
/* INCREASE ACCESS COUNT IF CURRENT IAREA MATCHES ORIGINAL IAREA */
L150:
    return 0;

} /* mfrlod_ */

integer mfpar_(integer *irmf, integer *icomp)
{
    /* Initialized data */

    static real fixmax = 32767.f;
    static integer nmax = 4;

    /* System generated locals */
    integer ret_val, i__1;

    /* Builtin functions */
    double log(doublereal);

    /* Local variables */
    static integer idim, item;
    static real fsiz;
    static integer i, m;
#define val ((real *)&mfval_1)
#define int__ ((integer *)&mfint_1)
    static real alg2, fadd;


/*  HELPER ROUTINE TO CROSS-COMPUTE MASS STORE FFT FILE PARAMETERS */
/*  PARAMETERS ARE HELD AND COMPUTED IN 3 COMMON AREAS (SEE BELOW) */
/*  MFPAR RETURNS 0 NORMALLY, -1 IF NOT ALL MFINT CORRECT, +1 IBEX ERROR 
*/

/*  COMMON/MFARG/ HOLDS ARGUMENTS AS USED IN FFT CALLS, AS FOLLOWS: */
/*  VARIABLE NAMES HAVE SAME MEANING AS COMMENTS, SUBROUTINE RMFFT */
/*     MEXA() HOLDS EXPONENTS FOR UP TO 4 DIMENSIONS (R/T ZEROS EXCESS) */
/*     NDIM NUM DIMENS, IBEX,ICEX BLOCK AND CORE EXPONS, IPAK RMFFT PACKI 
*/
/*     ISGN,IDIR,SCAL ARE IGNORED HERE, BUT INCLUDED FOR COMPLETENESS */

/*  COMMON/MFVAL/,/MFINT/ RETURN COMPUTED VALUES, USEFUL FOR FILE ACCESS 
*/
/*     NDMA(4),DIMA(4) HOLD DIMENSION SIZES CORRESPONDING TO MEXA() */
/*     (EG. NDMA(1)=DIMA(1)=2.**MEXA(1), ETC. AND =1. BEYOND NDIM) */

/*     NTD1,TDM1  IS CURRENT TOTAL NUM OF 'RECDS' OF SIZE NRD1,RDM1 */
/*     NRD1,RDM1  IS NUM OF REALS IN CURRENT FIRST DIMENSION */
/*     (USEFUL FOR ACCESSING DATA BY MFREAD/MFWRIT, NRD1,RDM1 REALS, */
/*      ASSUMING THAT MFREAD/MFWRIT CAN HANDLE 'RECDS' OF DIFFERENT SIZES 
*/

/*     NFBK,FBLK  IS MAXIMUM FILE SIZE OF 'RECDS' OF SIZE NRBK,RBLK */
/*     NTBK,TBLK  IS CURRENT TOTAL NUM OF 'RECDS' OF SIZE NRBK,RBLK */
/*     NRBK,RBLK  IS NUM OF REALS IN FFT WORKING BLOCK (2**IBEX REALS) */
/*     (GIVES MAX AND CURRENT FILE SIZE AND ACCESS BY FFT ROUTINES, */
/*   NFBK.GT.NTBK ONLY WITH PACKED REAL DATA WHEN EXPANDING, IPAK=0 OR 1) 
*/

/*     NRCR,RCOR  IS NUM OF REALS IN FFT WORKING CORE  (2**ICEX REALS) */
/*     NSZE=SIZE=2.**M, WHICH IS THE EFFECTIVE TOTAL SIZE OF TRANSFORM, */
/*        WHERE M IS SUM TO NDIM OF MEXA() (SEE RMFFT COMMENTS) */

/*  NOTE THAT ALL /MFARG/ ARE INTGS (EXCEPT SCAL), ALL /MFVAL/ REALS */
/*  (/MFINT/ IS INTEGER CONVERSION OF /MFVAL/, ANY VALUE OF MFINT */
/*   IS SET -1 IF TOO LARGE, BY FIXMAX, AND MFPAR RETURNED -1 AS FLAG, */
/*   FIXMAX SET BY DATA STATEMENT TO 32767. HERE, BUT ALTER TO SUIT) */

/* ROUTINE ARGUMENTS HAVE THE FOLLOWING EFFECT: */
/*  IRMF=-1, DATA IS PACKED REAL, +1 DATA IS COMPLEX, ROUTINE RMFFT, */
/*  IRMF=0,  DATA IS COMPLEX, ROUTINE CMFFT */

/*  ICOMP=0, COMPUTES VALUES IN /MFVAL/ FROM VALUES GIVEN IN /MFARG/ */
/*  ICOMP=1 , REVERSE COMPUTES EXPONENTS IN /MFARG/ FROM /MFVAL/ */
/*     (DIMA(),RBLK,RCOR GIVEN INSTEAD OF MEXA(),IBEX,ICEX) */

/*  NOTE, ROUTINE FORCES ICEX, IBEX TO CORRECT RANGE, MFPAR=+1 IF CANNOT 
*/



    ret_val = 0;
    if (*icomp == 0) {
	goto L20;
    }
    alg2 = log(2.f);
    mfarg_1.ibex = (integer) (log(mfval_1.rblk) / alg2 + .5f);
    mfarg_1.icex = (integer) (log(mfval_1.rcor) / alg2 + .5f);

    i__1 = mfarg_1.ndim;
    for (i = 1; i <= i__1; ++i) {
/* L10: */
	mfarg_1.mexa[i - 1] = (integer) (log(mfval_1.dima[i - 1]) / alg2 + 
		.5f);
    }

L20:
    m = 0;
    i__1 = nmax;
    for (i = 1; i <= i__1; ++i) {
	if (i > mfarg_1.ndim) {
	    mfarg_1.mexa[i - 1] = 0;
	}
	m += mfarg_1.mexa[i - 1];
/* L30: */
	mfval_1.dima[i - 1] = 1 << mfarg_1.mexa[i - 1]; /* was: pow_ri(&c_b21, &mfarg_1.mexa[i - 1]); */
    }
    mfval_1.size = ((real) (1 << m)) /* was: pow_ri(&c_b21, &m) */;

    if (*irmf == 0) {
	goto L90;
    }
    if (mfarg_1.icex > m) {
	mfarg_1.icex = m;
    }
    if (mfarg_1.ibex > mfarg_1.icex - 2) {
	mfarg_1.ibex = mfarg_1.icex - 2;
    }
    if (mfarg_1.ibex < 2) {
	ret_val = 1;
    }
/* FORCES ICEX.NGT.M AND IBEX.NGT.ICEX-2, OR MFPAR=1 (IRMF=+/- 1) */

L40:
    mfval_1.rblk = ((real) (1 << mfarg_1.ibex)) /* was: pow_ri(&c_b21, &mfarg_1.ibex) */;
    mfval_1.rcor = ((real) (1 << mfarg_1.icex)) /* was: pow_ri(&c_b21, &mfarg_1.icex) */;

    fadd = mfval_1.size;
    if (*irmf == 0 || mfarg_1.ipak > 0) {
	goto L50;
    }
/* FADD IS ADDITIONAL FILE SIZE IN REALS, 'SIZE' IF CMFFT OR IPAK=1 */

    fadd = 0.f;
    if (mfarg_1.ipak < 0) {
	goto L50;
    }
/* IPAK=-1 REQUIRES NO FILE EXPANSION */

    idim = mfarg_1.ndim;
    if (*irmf < 0) {
	idim = 1;
    }
    fadd = mfval_1.size * 2.f / mfval_1.dima[idim - 1];
/* FADD COMPUTED FOR PARTICULAR CASE OF IPAK=0, WHEN COMPLX */

L50:
    fsiz = mfval_1.size + fadd;
    item = (integer) (fsiz / mfval_1.rblk + .5f);
    if ((real) item * mfval_1.rblk + .5f < fsiz) {
	++item;
    }
    mfval_1.fblk = (real) item;
/* FBLK IS MAXIMUM NUMBER OF 'RECDS', SIZE RBLK, POSSIBLE */
    mfval_1.tblk = mfval_1.fblk;
    if (*irmf >= 0) {
	goto L60;
    }
/* GENERALLY TBLK=FBLK, BUT FOR PACKED REAL NOT SO, BELOW */
    fsiz = mfval_1.size;
    mfval_1.tblk = fsiz / mfval_1.rblk;

L60:
    mfval_1.tdm1 = 1.f;
    mfval_1.rdm1 = fsiz;
    if (mfarg_1.ndim == 1) {
	goto L70;
    }
/* JOB COMPLETED IF NDIM=1 */

    mfval_1.rdm1 = mfval_1.dima[0];
    if (*irmf >= 0) {
	mfval_1.rdm1 *= 2.f;
    }
    mfval_1.tdm1 = fsiz / mfval_1.rdm1;
/* OTHERWISE COMPUTE TDM1 AS NUMBER OF 'RECDS', SIZE RDM1 REALS */

L70:
    for (i = 1; i <= 11; ++i) {
	int__[i - 1] = -1;
	if (val[i - 1] <= fixmax) {
	    int__[i - 1] = (integer) (val[i - 1] + .5f);
	}
	if (int__[i - 1] < 0 && ret_val == 0) {
	    ret_val = -1;
	}
/* L80: */
    }
/* CONVERT VALUES IN /MFVAL/ TO INTEGERS IN /MFINT/ (-1 IF TOO LARGE) */
    return ret_val;

L90:
    if (mfarg_1.icex > m + 1) {
	mfarg_1.icex = m + 1;
    }
    if (mfarg_1.ibex > mfarg_1.icex - 1) {
	mfarg_1.ibex = mfarg_1.icex - 1;
    }
    if (mfarg_1.ibex < 1) {
	ret_val = 1;
    }
    goto L40;
/*  FORCES ICEX.NGT.M+1 AND IBEX.NGT.ICEX-1, OR MFPAR=1 (IRMF=0) */

} /* mfpar_ */

#undef int__
#undef val


/* Subroutine */ int dmperm_(integer *mexa, integer *ndim, integer *nshft, 
	integer *irex, real *bufa, integer *ibex, integer *icex)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer j, m;
    extern integer mfsum_(integer *, integer *, integer *);
    static integer ig, ih, ns;
    extern /* Subroutine */ int mfsort_(real *, integer *, integer *, integer 
	    *, integer *, integer *);


/* SHIFTS ORDER OF DIMENSIONS OF REAL OR COMPLEX MASS STORE ARRAY */
/* NOTE, THIS IS NOT USED BY FFT SUBRTNS BUT IS INCLUDED FOR COMPLETENESS 
*/
/*  (FRASER, ACM TOMS - 1978/79, AND J.ACM, V.23,N.2, APRIL 76, PP. 298-3 
*/

/* MEXA(J) LIST OF DIMENSION SIZE EXPONS (BASE 2), ADJACENT VARIABLES FIR 
*/
/* NDIM IS NUMBER OF EXPONENTS IN LIST AND THUS THE NUMBER OF DIMENSIONS 
*/
/*  SUM TO NDIM: MEXA(J)=M, WHERE 2**M IS SIZE OF MASS STORE ARRAY (SEE B 
*/
/* NSHFT IS DIMENSION SHIFT COUNT, THUS: */
/*  NSHFT=0,  NO SHIFT OR CHANGE OCCURS */
/*  NSHFT=1,2 ETC., FIRST TO NEXT DIMENSION, CIRC NSHFT PLACE SHIFT (MOD 
*/
/*  NSHFT=-1, REVERSES THE ORDER OF DIMENSIONS */
/* IREX=0 REAL, 1 COMPLEX (THAT IS, MOVEMENT GROUP IS 2**IREX REALS, */
/*    AND TOTAL MASS STORE SIZE IS 2**(M+IREX) REAL ELEMENTS) */


    /* Parameter adjustments */
    --bufa;
    --mexa;

    /* Function Body */
    ns = *nshft % *ndim;
    if (ns == 0) {
	return 0;
    }
    m = mfsum_(&mexa[1], ndim, &c_n1) + *irex;
/* FINDS M TOTAL AND REVERSES MEXA LIST */
    mfsort_(&bufa[1], ibex, icex, irex, &m, &m);
/* INITIAL OVERALL BIT-REVERSAL M BITS ABOVE IREX BITS */
    if (*nshft < 0) {
	goto L10;
    }

/* BELOW, REVERSAL OF TWO PARTS, TO FORM REQUIRED SHIFT */
    ih = mfsum_(&mexa[1], &ns, &c_n1) + *irex;
    mfsort_(&bufa[1], ibex, icex, irex, &ih, &m);
/* REVERSE LOWER PART OF MEXA LIST AND LOWER PART OF ARRAY BITS */
    mfsort_(&bufa[1], ibex, icex, &ih, &m, &m);
/* SEPARATELY REVERSE UPPER PART OF ARRAY BITS */
    i__1 = *ndim - ns;
    ih = mfsum_(&mexa[*nshft + 1], &i__1, &c_n1);
/* REVERSE UPPER PART OF MEXA LIST */
    return 0;
/* RETURN FROM SUBROUTINE AFTER CYCLIC SHIFTS */

/* BELOW, SEPARATELY REVERSE OVER EACH DIMENSION (DIMEN REVERSAL) */
L10:
    ih = *irex;
    i__1 = *ndim;
    for (j = 1; j <= i__1; ++j) {
	ig = ih;
	ih += mexa[j];
/* L20: */
	mfsort_(&bufa[1], ibex, icex, &ig, &ih, &m);
    }
    return 0;

} /* dmperm_ */

/* Subroutine */ int mfread_(real *bufa, integer *nb, integer *jb)
{
    /* Local variables */
    static integer i, k, iof;


/* DUMMY SUBROUTINE TO SIMULATE RANDOM ACCESS MASS STORE READ */
/* READ BLOCK, INDEX JB, FROM MASS STORE TO BUFA, NB REAL VALUES */
/* COMMON ARRAY RMAS SIMULATES MASS STORE ARRAY */


    /* Parameter adjustments */
    --bufa;

    /* Function Body */
    iof = (*jb - 1) * *nb;
    for (i = 1; i <= *nb; ++i) {
	k = iof + i;
/* L10: */
	bufa[i] = rmas[k - 1];
    }
    return 0;

} /* mfread_ */

/* Subroutine */ int mfwrit_(real *bufa, integer *nb, integer *jb)
{
    /* Local variables */
    static integer i, k, iof;


/* DUMMY SUBROUTINE TO SIMULATE RANDOM ACCESS MASS STORE WRITE */
/* WRITE BLOCK, INDEX JB, FORM BUFA TO MASS STORE, NB REAL VALUES */
/* COMMON ARRAY RMAS SIMULATES MASS STORE ARRAY */


    /* Parameter adjustments */
    --bufa;

    /* Function Body */
    iof = (*jb - 1) * *nb;
    for (i = 1; i <= *nb; ++i) {
	k = iof + i;
/* L10: */
	rmas[k - 1] = bufa[i];
    }
    return 0;

} /* mfwrit_ */

